/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.retriever;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class TestRetrieverBuilder
extends RetrieverBuilder {
    public static final String NAME = "test";
    public static final ParseField TEST_FIELD = new ParseField("test", new String[0]);
    public static final SearchPlugin.RetrieverSpec<TestRetrieverBuilder> TEST_SPEC = new SearchPlugin.RetrieverSpec(TEST_FIELD, TestRetrieverBuilder::fromXContent);
    public static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    public static final ConstructingObjectParser<TestRetrieverBuilder, RetrieverParserContext> PARSER = new ConstructingObjectParser("test", args -> new TestRetrieverBuilder((String)args[0]));
    private final String value;

    public static TestRetrieverBuilder createRandomTestRetrieverBuilder() {
        return new TestRetrieverBuilder(ESTestCase.randomAlphaOfLengthBetween(5, 10));
    }

    public static TestRetrieverBuilder fromXContent(XContentParser parser, RetrieverParserContext context) {
        return (TestRetrieverBuilder)((Object)PARSER.apply(parser, (Object)context));
    }

    public TestRetrieverBuilder(String value) {
        this.value = value;
    }

    public void extractToSearchSourceBuilder(SearchSourceBuilder searchSourceBuilder, boolean compoundUsed) {
        throw new UnsupportedOperationException("only used for parsing tests");
    }

    public String getName() {
        return NAME;
    }

    public void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(VALUE_FIELD.getPreferredName(), this.value);
    }

    public boolean doEquals(Object o) {
        TestRetrieverBuilder that = (TestRetrieverBuilder)((Object)o);
        return Objects.equals(this.value, that.value);
    }

    public int doHashCode() {
        return Objects.hash(this.value);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), VALUE_FIELD);
    }
}

