/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry;

import java.util.function.Supplier;
import org.elasticsearch.telemetry.InstrumentType;
import org.elasticsearch.telemetry.MetricRecorder;
import org.elasticsearch.telemetry.RecordingInstruments;
import org.elasticsearch.telemetry.metric.DoubleAsyncCounter;
import org.elasticsearch.telemetry.metric.DoubleCounter;
import org.elasticsearch.telemetry.metric.DoubleGauge;
import org.elasticsearch.telemetry.metric.DoubleHistogram;
import org.elasticsearch.telemetry.metric.DoubleUpDownCounter;
import org.elasticsearch.telemetry.metric.DoubleWithAttributes;
import org.elasticsearch.telemetry.metric.Instrument;
import org.elasticsearch.telemetry.metric.LongAsyncCounter;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.LongGauge;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.LongUpDownCounter;
import org.elasticsearch.telemetry.metric.LongWithAttributes;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class RecordingMeterRegistry
implements MeterRegistry {
    protected final MetricRecorder<Instrument> recorder = new MetricRecorder();

    public MetricRecorder<Instrument> getRecorder() {
        return this.recorder;
    }

    public DoubleCounter registerDoubleCounter(String name, String description, String unit) {
        DoubleCounter instrument = this.buildDoubleCounter(name, description, unit);
        this.recorder.register((Instrument)instrument, InstrumentType.fromInstrument((Instrument)instrument), name, description, unit);
        return instrument;
    }

    public DoubleCounter getDoubleCounter(String name) {
        return (DoubleCounter)this.recorder.getInstrument(InstrumentType.DOUBLE_COUNTER, name);
    }

    protected DoubleCounter buildDoubleCounter(String name, String description, String unit) {
        return new RecordingInstruments.RecordingDoubleCounter(name, this.recorder);
    }

    public DoubleUpDownCounter registerDoubleUpDownCounter(String name, String description, String unit) {
        DoubleUpDownCounter instrument = this.buildDoubleUpDownCounter(name, description, unit);
        this.recorder.register((Instrument)instrument, InstrumentType.fromInstrument((Instrument)instrument), name, description, unit);
        return instrument;
    }

    public DoubleUpDownCounter getDoubleUpDownCounter(String name) {
        return (DoubleUpDownCounter)this.recorder.getInstrument(InstrumentType.DOUBLE_UP_DOWN_COUNTER, name);
    }

    protected DoubleUpDownCounter buildDoubleUpDownCounter(String name, String description, String unit) {
        return new RecordingInstruments.RecordingDoubleUpDownCounter(name, this.recorder);
    }

    public DoubleGauge registerDoubleGauge(String name, String description, String unit, Supplier<DoubleWithAttributes> observer) {
        DoubleGauge instrument = this.buildDoubleGauge(name, description, unit, observer);
        this.recorder.register((Instrument)instrument, InstrumentType.fromInstrument((Instrument)instrument), name, description, unit);
        return instrument;
    }

    public DoubleGauge getDoubleGauge(String name) {
        return (DoubleGauge)this.recorder.getInstrument(InstrumentType.DOUBLE_GAUGE, name);
    }

    protected DoubleGauge buildDoubleGauge(String name, String description, String unit, Supplier<DoubleWithAttributes> observer) {
        return new RecordingInstruments.RecordingDoubleGauge(name, observer, this.recorder);
    }

    public DoubleHistogram registerDoubleHistogram(String name, String description, String unit) {
        DoubleHistogram instrument = this.buildDoubleHistogram(name, description, unit);
        this.recorder.register((Instrument)instrument, InstrumentType.fromInstrument((Instrument)instrument), name, description, unit);
        return instrument;
    }

    public DoubleHistogram getDoubleHistogram(String name) {
        return (DoubleHistogram)this.recorder.getInstrument(InstrumentType.DOUBLE_HISTOGRAM, name);
    }

    protected DoubleHistogram buildDoubleHistogram(String name, String description, String unit) {
        return new RecordingInstruments.RecordingDoubleHistogram(name, this.recorder);
    }

    public LongCounter registerLongCounter(String name, String description, String unit) {
        LongCounter instrument = this.buildLongCounter(name, description, unit);
        this.recorder.register((Instrument)instrument, InstrumentType.fromInstrument((Instrument)instrument), name, description, unit);
        return instrument;
    }

    public LongAsyncCounter registerLongAsyncCounter(String name, String description, String unit, Supplier<LongWithAttributes> observer) {
        RecordingInstruments.RecordingAsyncLongCounter instrument = new RecordingInstruments.RecordingAsyncLongCounter(name, observer, this.recorder);
        this.recorder.register(instrument, InstrumentType.fromInstrument(instrument), name, description, unit);
        return instrument;
    }

    public LongAsyncCounter getLongAsyncCounter(String name) {
        return (LongAsyncCounter)this.recorder.getInstrument(InstrumentType.LONG_ASYNC_COUNTER, name);
    }

    public DoubleAsyncCounter registerDoubleAsyncCounter(String name, String description, String unit, Supplier<DoubleWithAttributes> observer) {
        RecordingInstruments.RecordingAsyncDoubleCounter instrument = new RecordingInstruments.RecordingAsyncDoubleCounter(name, observer, this.recorder);
        this.recorder.register(instrument, InstrumentType.fromInstrument(instrument), name, description, unit);
        return instrument;
    }

    public DoubleAsyncCounter getDoubleAsyncCounter(String name) {
        return (DoubleAsyncCounter)this.recorder.getInstrument(InstrumentType.DOUBLE_ASYNC_COUNTER, name);
    }

    public LongCounter getLongCounter(String name) {
        return (LongCounter)this.recorder.getInstrument(InstrumentType.LONG_COUNTER, name);
    }

    protected LongCounter buildLongCounter(String name, String description, String unit) {
        return new RecordingInstruments.RecordingLongCounter(name, this.recorder);
    }

    public LongUpDownCounter registerLongUpDownCounter(String name, String description, String unit) {
        LongUpDownCounter instrument = this.buildLongUpDownCounter(name, description, unit);
        this.recorder.register((Instrument)instrument, InstrumentType.fromInstrument((Instrument)instrument), name, description, unit);
        return instrument;
    }

    public LongUpDownCounter getLongUpDownCounter(String name) {
        return (LongUpDownCounter)this.recorder.getInstrument(InstrumentType.LONG_UP_DOWN_COUNTER, name);
    }

    protected LongUpDownCounter buildLongUpDownCounter(String name, String description, String unit) {
        return new RecordingInstruments.RecordingLongUpDownCounter(name, this.recorder);
    }

    public LongGauge registerLongGauge(String name, String description, String unit, Supplier<LongWithAttributes> observer) {
        LongGauge instrument = this.buildLongGauge(name, description, unit, observer);
        this.recorder.register((Instrument)instrument, InstrumentType.fromInstrument((Instrument)instrument), name, description, unit);
        return instrument;
    }

    public LongGauge getLongGauge(String name) {
        return (LongGauge)this.recorder.getInstrument(InstrumentType.LONG_GAUGE, name);
    }

    protected LongGauge buildLongGauge(String name, String description, String unit, Supplier<LongWithAttributes> observer) {
        return new RecordingInstruments.RecordingLongGauge(name, observer, this.recorder);
    }

    public LongHistogram registerLongHistogram(String name, String description, String unit) {
        LongHistogram instrument = this.buildLongHistogram(name, description, unit);
        this.recorder.register((Instrument)instrument, InstrumentType.fromInstrument((Instrument)instrument), name, description, unit);
        return instrument;
    }

    public LongHistogram getLongHistogram(String name) {
        return (LongHistogram)this.recorder.getInstrument(InstrumentType.LONG_HISTOGRAM, name);
    }

    protected LongHistogram buildLongHistogram(String name, String description, String unit) {
        return new RecordingInstruments.RecordingLongHistogram(name, this.recorder);
    }
}

