/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BaseBroadcastResponse;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.test.AbstractXContentTestCase;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class AbstractBroadcastResponseTestCase<T extends BroadcastResponse>
extends AbstractXContentTestCase<T> {
    private static final ParseField _SHARDS_FIELD = new ParseField("_shards", new String[0]);
    private static final ParseField TOTAL_FIELD = new ParseField("total", new String[0]);
    private static final ParseField SUCCESSFUL_FIELD = new ParseField("successful", new String[0]);
    private static final ParseField FAILED_FIELD = new ParseField("failed", new String[0]);
    private static final ParseField FAILURES_FIELD = new ParseField("failures", new String[0]);

    public static <T extends BaseBroadcastResponse> void declareBroadcastFields(ConstructingObjectParser<T, Void> PARSER) {
        ConstructingObjectParser shardsParser = new ConstructingObjectParser("_shards", true, arg -> new BaseBroadcastResponse(((Integer)arg[0]).intValue(), ((Integer)arg[1]).intValue(), ((Integer)arg[2]).intValue(), (List)arg[3]));
        shardsParser.declareInt(ConstructingObjectParser.constructorArg(), TOTAL_FIELD);
        shardsParser.declareInt(ConstructingObjectParser.constructorArg(), SUCCESSFUL_FIELD);
        shardsParser.declareInt(ConstructingObjectParser.constructorArg(), FAILED_FIELD);
        shardsParser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DefaultShardOperationFailedException.fromXContent((XContentParser)p), FAILURES_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (ContextParser)shardsParser, _SHARDS_FIELD);
    }

    @Override
    protected T createTestInstance() {
        int totalShards = AbstractBroadcastResponseTestCase.randomIntBetween(1, 10);
        ArrayList<DefaultShardOperationFailedException> failures = null;
        int successfulShards = AbstractBroadcastResponseTestCase.randomInt(totalShards);
        int failedShards = totalShards - successfulShards;
        if (failedShards > 0) {
            failures = new ArrayList<DefaultShardOperationFailedException>();
            for (int i = 0; i < failedShards; ++i) {
                ElasticsearchException exception = new ElasticsearchException("exception message " + i, new Object[0]);
                String index = AbstractBroadcastResponseTestCase.randomAlphaOfLengthBetween(3, 10);
                exception.setIndex(new Index(index, "_na_"));
                exception.setShard(new ShardId(index, "_na_", i));
                if (AbstractBroadcastResponseTestCase.randomBoolean()) {
                    failures.add(new DefaultShardOperationFailedException(exception));
                    continue;
                }
                failures.add(new DefaultShardOperationFailedException(index, i, (Throwable)new Exception("exception message " + i)));
            }
        }
        return this.createTestInstance(totalShards, successfulShards, failedShards, failures);
    }

    protected abstract T createTestInstance(int var1, int var2, int var3, List<DefaultShardOperationFailedException> var4);

    @Override
    protected void assertEqualInstances(T response, T parsedResponse) {
        AbstractBroadcastResponseTestCase.assertThat(response.getTotalShards(), CoreMatchers.equalTo((Object)parsedResponse.getTotalShards()));
        AbstractBroadcastResponseTestCase.assertThat(response.getSuccessfulShards(), CoreMatchers.equalTo((Object)parsedResponse.getSuccessfulShards()));
        AbstractBroadcastResponseTestCase.assertThat(response.getFailedShards(), CoreMatchers.equalTo((Object)parsedResponse.getFailedShards()));
        DefaultShardOperationFailedException[] originalFailures = response.getShardFailures();
        DefaultShardOperationFailedException[] parsedFailures = parsedResponse.getShardFailures();
        AbstractBroadcastResponseTestCase.assertThat(originalFailures.length, CoreMatchers.equalTo((Object)parsedFailures.length));
        for (int i = 0; i < originalFailures.length; ++i) {
            AbstractBroadcastResponseTestCase.assertThat(originalFailures[i].index(), CoreMatchers.equalTo((Object)parsedFailures[i].index()));
            AbstractBroadcastResponseTestCase.assertThat(originalFailures[i].shardId(), CoreMatchers.equalTo((Object)parsedFailures[i].shardId()));
            AbstractBroadcastResponseTestCase.assertThat(originalFailures[i].status(), CoreMatchers.equalTo((Object)parsedFailures[i].status()));
            AbstractBroadcastResponseTestCase.assertThat(parsedFailures[i].getCause().getMessage(), CoreMatchers.containsString((String)originalFailures[i].getCause().getMessage()));
        }
    }

    @Override
    protected boolean supportsUnknownFields() {
        return true;
    }

    @Override
    protected boolean assertToXContentEquivalence() {
        return false;
    }

    public void testFailuresDeduplication() throws IOException {
        BroadcastResponse parsedResponse;
        ArrayList<DefaultShardOperationFailedException> failures = new ArrayList<DefaultShardOperationFailedException>();
        Index index = new Index("test", "_na_");
        ElasticsearchException exception1 = new ElasticsearchException("foo", (Throwable)new IllegalArgumentException("bar"), new Object[0]);
        exception1.setIndex(index);
        exception1.setShard(new ShardId(index, 0));
        ElasticsearchException exception2 = new ElasticsearchException("foo", (Throwable)new IllegalArgumentException("bar"), new Object[0]);
        exception2.setIndex(index);
        exception2.setShard(new ShardId(index, 1));
        ElasticsearchException exception3 = new ElasticsearchException("fizz", (Throwable)new IllegalStateException("buzz"), new Object[0]);
        exception3.setIndex(index);
        exception3.setShard(new ShardId(index, 2));
        failures.add(new DefaultShardOperationFailedException(exception1));
        failures.add(new DefaultShardOperationFailedException(exception2));
        failures.add(new DefaultShardOperationFailedException(exception3));
        T response = this.createTestInstance(10, 7, 3, failures);
        boolean humanReadable = AbstractBroadcastResponseTestCase.randomBoolean();
        XContentType xContentType = AbstractBroadcastResponseTestCase.randomFrom(XContentType.values());
        BytesReference bytesReference = this.toShuffledXContent((ToXContent)response, xContentType, ToXContent.EMPTY_PARAMS, humanReadable, new String[0]);
        try (XContentParser parser = this.createParser(xContentType.xContent(), bytesReference);){
            parsedResponse = (BroadcastResponse)this.doParseInstance(parser);
            AbstractBroadcastResponseTestCase.assertNull((Object)parser.nextToken());
        }
        AbstractBroadcastResponseTestCase.assertThat(parsedResponse.getShardFailures().length, CoreMatchers.equalTo((Object)2));
        DefaultShardOperationFailedException[] parsedFailures = parsedResponse.getShardFailures();
        AbstractBroadcastResponseTestCase.assertThat(parsedFailures[0].index(), CoreMatchers.equalTo((Object)"test"));
        AbstractBroadcastResponseTestCase.assertThat(parsedFailures[0].shardId(), CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)0), CoreMatchers.equalTo((Object)1)}));
        AbstractBroadcastResponseTestCase.assertThat(parsedFailures[0].status(), CoreMatchers.equalTo((Object)RestStatus.INTERNAL_SERVER_ERROR));
        AbstractBroadcastResponseTestCase.assertThat(parsedFailures[0].getCause().getMessage(), CoreMatchers.containsString((String)"foo"));
        AbstractBroadcastResponseTestCase.assertThat(parsedFailures[1].index(), CoreMatchers.equalTo((Object)"test"));
        AbstractBroadcastResponseTestCase.assertThat(parsedFailures[1].shardId(), CoreMatchers.equalTo((Object)2));
        AbstractBroadcastResponseTestCase.assertThat(parsedFailures[1].status(), CoreMatchers.equalTo((Object)RestStatus.INTERNAL_SERVER_ERROR));
        AbstractBroadcastResponseTestCase.assertThat(parsedFailures[1].getCause().getMessage(), CoreMatchers.containsString((String)"fizz"));
    }

    public void testToXContent() throws IOException {
        T response = this.createTestInstance(10, 10, 0, null);
        String output = Strings.toString(response);
        AbstractBroadcastResponseTestCase.assertEquals((Object)"{\"_shards\":{\"total\":10,\"successful\":10,\"failed\":0}}", (Object)output);
    }
}

