/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Arrays;
import java.util.HashSet;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;

public class IndexSettingsModule
extends AbstractModule {
    private final Index index;
    private final Settings settings;

    public IndexSettingsModule(Index index, Settings settings) {
        this.settings = settings;
        this.index = index;
    }

    protected void configure() {
        this.bind(IndexSettings.class).toInstance((Object)IndexSettingsModule.newIndexSettings(this.index, this.settings, new Setting[0]));
    }

    public static IndexSettings newIndexSettings(String index, Settings settings, Setting<?> ... setting) {
        return IndexSettingsModule.newIndexSettings(new Index(index, settings.get("index.uuid", "_na_")), settings, setting);
    }

    public static IndexSettings newIndexSettings(Index index, Settings settings, Setting<?> ... setting) {
        return IndexSettingsModule.newIndexSettings(index, settings, Settings.EMPTY, setting);
    }

    public static IndexSettings newIndexSettings(Index index, Settings indexSetting, Settings nodeSettings, Setting<?> ... setting) {
        Settings build = Settings.builder().put("index.version.created", (VersionId)IndexVersion.current()).put("index.number_of_replicas", 1).put("index.number_of_shards", 1).put(indexSetting).build();
        IndexMetadata metadata = IndexMetadata.builder((String)index.getName()).system(((Boolean)IndexSettings.INDEX_FAST_REFRESH_SETTING.get(indexSetting)).booleanValue()).settings(build).build();
        HashSet settingSet = new HashSet(IndexScopedSettings.BUILT_IN_INDEX_SETTINGS);
        if (setting.length > 0) {
            settingSet.addAll(Arrays.asList(setting));
        }
        return new IndexSettings(metadata, nodeSettings, new IndexScopedSettings(Settings.EMPTY, settingSet));
    }

    public static IndexSettings newIndexSettings(Index index, Settings settings, IndexScopedSettings indexScopedSettings) {
        Settings build = Settings.builder().put("index.version.created", (VersionId)IndexVersion.current()).put("index.number_of_replicas", 1).put("index.number_of_shards", 1).put(settings).build();
        IndexMetadata metadata = IndexMetadata.builder((String)index.getName()).system(((Boolean)IndexSettings.INDEX_FAST_REFRESH_SETTING.get(settings)).booleanValue()).settings(build).build();
        return new IndexSettings(metadata, Settings.EMPTY, indexScopedSettings);
    }

    public static IndexSettings newIndexSettings(IndexMetadata indexMetadata, Setting<?> ... setting) {
        HashSet settingSet = new HashSet(IndexScopedSettings.BUILT_IN_INDEX_SETTINGS);
        if (setting.length > 0) {
            settingSet.addAll(Arrays.asList(setting));
        }
        return new IndexSettings(indexMetadata, Settings.EMPTY, new IndexScopedSettings(Settings.EMPTY, settingSet));
    }
}

