/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.Version;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.features.FeatureData;
import org.elasticsearch.features.FeatureSpecification;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.test.rest.RestTestLegacyFeatures;
import org.elasticsearch.test.rest.TestFeatureService;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;

class ESRestTestFeatureService
implements TestFeatureService {
    private static final Pattern VERSION_FEATURE_PATTERN = Pattern.compile("gte_v(\\d+\\.\\d+\\.\\d+)");
    private final Set<String> allSupportedFeatures;
    private final Set<String> knownHistoricalFeatureNames;
    private final Version version;

    ESRestTestFeatureService(List<FeatureSpecification> featureSpecs, Collection<Version> nodeVersions, Set<String> clusterStateFeatures) {
        ArrayList<FeatureSpecification> specs = new ArrayList<FeatureSpecification>(featureSpecs);
        specs.add(new RestTestLegacyFeatures());
        if (MetadataHolder.HISTORICAL_FEATURES != null) {
            specs.add(MetadataHolder.HISTORICAL_FEATURES);
        }
        FeatureData featureData = FeatureData.createFromSpecifications(specs);
        assert (featureData.getNodeFeatures().isEmpty()) : Strings.format((String)"Only historical features can be injected via ESRestTestCase#additionalTestOnlyHistoricalFeatures(), rejecting %s", (Object[])new Object[]{featureData.getNodeFeatures().keySet()});
        this.knownHistoricalFeatureNames = (Set)featureData.getHistoricalFeatures().lastEntry().getValue();
        this.version = nodeVersions.stream().min(Comparator.naturalOrder()).orElse(Version.CURRENT);
        this.allSupportedFeatures = Sets.union(clusterStateFeatures, (Set)((Set)featureData.getHistoricalFeatures().floorEntry(this.version).getValue()));
    }

    public static boolean hasFeatureMetadata() {
        return MetadataHolder.HISTORICAL_FEATURES != null;
    }

    @Override
    public boolean clusterHasFeature(String featureId) {
        if (this.allSupportedFeatures.contains(featureId)) {
            return true;
        }
        if (MetadataHolder.FEATURE_NAMES.contains(featureId) || this.knownHistoricalFeatureNames.contains(featureId)) {
            return false;
        }
        Matcher matcher = VERSION_FEATURE_PATTERN.matcher(featureId);
        if (matcher.matches()) {
            Version extractedVersion = Version.fromString((String)matcher.group(1));
            return this.version.onOrAfter((VersionId)extractedVersion);
        }
        if (ESRestTestFeatureService.hasFeatureMetadata()) {
            throw new IllegalArgumentException(Strings.format((String)"Unknown feature %s: check the respective FeatureSpecification is provided both in module-info.java as well as in META-INF/services and verify the module is loaded during tests.", (Object[])new Object[]{featureId}));
        }
        return false;
    }

    private static class MetadataHolder {
        private static final FeatureSpecification HISTORICAL_FEATURES;
        private static final Set<String> FEATURE_NAMES;

        private MetadataHolder() {
        }

        @SuppressForbidden(reason="File#pathSeparator has not equivalent in java.nio.file")
        private static void loadFeatureMetadata(String metadataPath, BiConsumer<String, Object> consumer) {
            String[] metadataFiles;
            for (String metadataFile : metadataFiles = metadataPath.split(File.pathSeparator)) {
                try (InputStream in = Files.newInputStream(PathUtils.get((String)metadataFile, (String[])new String[0]), new OpenOption[0]);
                     XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, in);){
                    parser.map().forEach(consumer);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        static {
            String metadataPath = System.getProperty("tests.features.metadata.path");
            if (metadataPath == null) {
                FEATURE_NAMES = Collections.emptySet();
                HISTORICAL_FEATURES = null;
            } else {
                HashSet featureNames = new HashSet();
                HashMap historicalFeatures = new HashMap();
                MetadataHolder.loadFeatureMetadata(metadataPath, (key, value) -> {
                    if (key.equals("historical_features") && value instanceof Map) {
                        Map map = (Map)value;
                        for (Map.Entry entry : map.entrySet()) {
                            historicalFeatures.put(new NodeFeature((String)entry.getKey()), Version.fromString((String)((String)entry.getValue())));
                        }
                    }
                    if (key.equals("feature_names") && value instanceof Collection) {
                        Collection collection = (Collection)value;
                        for (Map.Entry entry : collection) {
                            featureNames.add((String)((Object)entry));
                        }
                    }
                });
                FEATURE_NAMES = Collections.unmodifiableSet(featureNames);
                final Map unmodifiableHistoricalFeatures = Collections.unmodifiableMap(historicalFeatures);
                HISTORICAL_FEATURES = new FeatureSpecification(){

                    public Map<NodeFeature, Version> getHistoricalFeatures() {
                        return unmodifiableHistoricalFeatures;
                    }
                };
            }
        }
    }
}

