/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.storedscripts;

import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.TransportPutStoredScriptAction;
import org.elasticsearch.action.support.master.IsAcknowledgedSupplier;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.xcontent.XContentType;

public class StoredScriptIntegTestUtils {
    private StoredScriptIntegTestUtils() {
    }

    public static void putJsonStoredScript(String id, String jsonContent) {
        StoredScriptIntegTestUtils.putJsonStoredScript(id, (BytesReference)new BytesArray(jsonContent));
    }

    public static void putJsonStoredScript(String id, BytesReference jsonContent) {
        ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)ESIntegTestCase.safeExecute(TransportPutStoredScriptAction.TYPE, (ActionRequest)new PutStoredScriptRequest(ESTestCase.TEST_REQUEST_TIMEOUT, ESTestCase.TEST_REQUEST_TIMEOUT).id(id).content(jsonContent, XContentType.JSON)));
    }
}

