/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.mapper.MapperTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.xcontent.XContentBuilder;

public class KeywordFieldSyntheticSourceSupport
implements MapperTestCase.SyntheticSourceSupport {
    private final Integer ignoreAbove;
    private final boolean allIgnored;
    private final boolean store;
    private final boolean docValues;
    private final String nullValue;

    KeywordFieldSyntheticSourceSupport(Integer ignoreAbove, boolean store, String nullValue, boolean useFallbackSyntheticSource) {
        this.ignoreAbove = ignoreAbove;
        this.allIgnored = ignoreAbove != null && LuceneTestCase.rarely();
        this.store = store;
        this.nullValue = nullValue;
        this.docValues = !useFallbackSyntheticSource || ESTestCase.randomBoolean();
    }

    @Override
    public boolean preservesExactSource() {
        return !this.store && !this.docValues;
    }

    @Override
    public MapperTestCase.SyntheticSourceExample example(int maxValues) {
        return this.example(maxValues, false);
    }

    public MapperTestCase.SyntheticSourceExample example(int maxValues, boolean loadBlockFromSource) {
        List<String> out;
        if (ESTestCase.randomBoolean()) {
            Tuple<String, String> v2 = this.generateValue();
            Object sourceValue = this.preservesExactSource() ? v2.v1() : v2.v2();
            Object loadBlock = v2.v2();
            if (!loadBlockFromSource && this.ignoreAbove != null && ((String)v2.v2()).length() > this.ignoreAbove) {
                loadBlock = null;
            }
            return new MapperTestCase.SyntheticSourceExample(v2.v1(), sourceValue, loadBlock, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::mapping));
        }
        List<Tuple> values = ESTestCase.randomList(1, maxValues, this::generateValue);
        List<String> in = values.stream().map(Tuple::v1).toList();
        ArrayList validValues = new ArrayList();
        ArrayList ignoredValues = new ArrayList();
        values.stream().map(Tuple::v2).forEach(v -> {
            if (this.ignoreAbove != null && v.length() > this.ignoreAbove) {
                ignoredValues.add(v);
            } else {
                validValues.add(v);
            }
        });
        List outputFromDocValues = new HashSet(validValues).stream().sorted().collect(Collectors.toList());
        if (this.preservesExactSource()) {
            out = in;
        } else {
            List<Object> validValuesInCorrectOrder = this.store ? validValues : outputFromDocValues;
            List syntheticSourceOutputList = Stream.concat(validValuesInCorrectOrder.stream(), ignoredValues.stream()).toList();
            List<Object> list = out = syntheticSourceOutputList.size() == 1 ? syntheticSourceOutputList.get(0) : syntheticSourceOutputList;
        }
        List<Object> loadBlock = loadBlockFromSource ? in.stream().filter(Objects::nonNull).toList() : (this.docValues ? List.copyOf(outputFromDocValues) : List.copyOf(validValues));
        List<String> loadBlockResult = loadBlock.size() == 1 ? loadBlock.get(0) : loadBlock;
        return new MapperTestCase.SyntheticSourceExample(in, out, loadBlockResult, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::mapping));
    }

    private Tuple<String, String> generateValue() {
        if (this.nullValue != null && ESTestCase.randomBoolean()) {
            return Tuple.tuple(null, (Object)this.nullValue);
        }
        int length = 5;
        if (this.ignoreAbove != null && (this.allIgnored || ESTestCase.randomBoolean())) {
            length = this.ignoreAbove + 5;
        }
        String v = ESTestCase.randomAlphaOfLength(length);
        return Tuple.tuple((Object)v, (Object)v);
    }

    private void mapping(XContentBuilder b) throws IOException {
        b.field("type", "keyword");
        if (this.nullValue != null) {
            b.field("null_value", this.nullValue);
        }
        if (this.ignoreAbove != null) {
            b.field("ignore_above", this.ignoreAbove);
        }
        if (this.store) {
            b.field("store", true);
        }
        if (!this.docValues) {
            b.field("doc_values", false);
        }
    }

    @Override
    public List<MapperTestCase.SyntheticSourceInvalidExample> invalidExample() throws IOException {
        return List.of();
    }
}

