/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.Directory;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.UnsafePlainActionFuture;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeUtils;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingHelper;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.TestShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.index.CloseUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.MapperTestUtils;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.query.DisabledQueryCache;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.index.engine.DocIdSeqNoAndSource;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.EngineTestCase;
import org.elasticsearch.index.engine.InternalEngineFactory;
import org.elasticsearch.index.mapper.MapperMetrics;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.seqno.RetentionLeaseSyncer;
import org.elasticsearch.index.shard.GlobalCheckpointSyncer;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardLongFieldRange;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.breaker.CircuitBreakerMetrics;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.indices.recovery.AsyncRecoveryTarget;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoverySourceHandler;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.indices.recovery.RecoveryTargetHandler;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.indices.recovery.plan.PeerOnlyRecoveryPlannerService;
import org.elasticsearch.indices.recovery.plan.RecoveryPlannerService;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotIndexCommit;
import org.elasticsearch.repositories.SnapshotShardContext;
import org.elasticsearch.repositories.blobstore.ESBlobStoreRepositoryIntegTestCase;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.test.DummyShardLock;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.TestThreadPool;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public abstract class IndexShardTestCase
extends ESTestCase {
    public static final IndexEventListener EMPTY_EVENT_LISTENER = new IndexEventListener(){};
    public static final GlobalCheckpointSyncer NOOP_GCP_SYNCER = shardId -> {};
    private static final AtomicBoolean failOnShardFailures = new AtomicBoolean(true);
    private static final Consumer<IndexShard.ShardFailure> DEFAULT_SHARD_FAILURE_HANDLER = failure -> {
        if (failOnShardFailures.get()) {
            throw new AssertionError(failure.reason(), failure.cause());
        }
    };
    protected static final PeerRecoveryTargetService.RecoveryListener recoveryListener = new PeerRecoveryTargetService.RecoveryListener(){

        public void onRecoveryDone(RecoveryState state, ShardLongFieldRange timestampMillisFieldRange, ShardLongFieldRange eventIngestedMillisFieldRange) {
        }

        public void onRecoveryFailure(RecoveryFailedException e, boolean sendShardFailure) {
            throw new AssertionError(e);
        }
    };
    protected ThreadPool threadPool;
    protected Executor writeExecutor;
    protected long primaryTerm;
    protected static AtomicLong currentClusterStateVersion = new AtomicLong();

    public static void addMockCloseImplementation(IndexShard shard) throws IOException {
        ((IndexShard)Mockito.doAnswer(invocation -> {
            ActionListener listener = (ActionListener)invocation.getArgument(3);
            listener.onResponse(null);
            return null;
        }).when((Object)shard)).close((String)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (Executor)ArgumentMatchers.any(), (ActionListener)ArgumentMatchers.any());
    }

    public void setUp() throws Exception {
        super.setUp();
        this.threadPool = this.setUpThreadPool();
        this.writeExecutor = this.threadPool.executor("write");
        this.primaryTerm = IndexShardTestCase.randomIntBetween(1, 100);
        this.failOnShardFailures();
    }

    protected ThreadPool setUpThreadPool() {
        return new TestThreadPool(((Object)((Object)this)).getClass().getName(), this.threadPoolSettings(), new ExecutorBuilder[0]);
    }

    public void tearDown() throws Exception {
        try {
            this.tearDownThreadPool();
        }
        finally {
            super.tearDown();
        }
    }

    protected void tearDownThreadPool() {
        ThreadPool.terminate((ThreadPool)this.threadPool, (long)30L, (TimeUnit)TimeUnit.SECONDS);
    }

    protected void allowShardFailures() {
        failOnShardFailures.set(false);
    }

    protected void failOnShardFailures() {
        failOnShardFailures.set(true);
    }

    public Settings threadPoolSettings() {
        return Settings.EMPTY;
    }

    protected Store createStore(IndexSettings indexSettings, ShardPath shardPath) throws IOException {
        return this.createStore(shardPath.getShardId(), indexSettings, (Directory)IndexShardTestCase.newFSDirectory((Path)shardPath.resolveIndex()));
    }

    protected Store createStore(ShardId shardId, IndexSettings indexSettings, Directory directory) throws IOException {
        return new Store(shardId, indexSettings, directory, (ShardLock)new DummyShardLock(shardId));
    }

    protected IndexShard newShard(boolean primary) throws IOException {
        return this.newShard(primary, Settings.EMPTY);
    }

    protected IndexShard newShard(boolean primary, Settings settings) throws IOException {
        return this.newShard(primary, settings, (EngineFactory)new InternalEngineFactory(), new IndexingOperationListener[0]);
    }

    protected IndexShard newShard(boolean primary, Settings settings, EngineFactory engineFactory, IndexingOperationListener ... listeners) throws IOException {
        return this.newShard(primary, new ShardId("index", "_na_", 0), settings, engineFactory, listeners);
    }

    protected IndexShard newShard(boolean primary, ShardId shardId, Settings settings, EngineFactory engineFactory, IndexingOperationListener ... listeners) throws IOException {
        RecoverySource.EmptyStoreRecoverySource recoverySource = primary ? RecoverySource.EmptyStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE;
        ShardRouting shardRouting = TestShardRouting.shardRoutingBuilder(shardId, IndexShardTestCase.randomAlphaOfLength(10), primary, ShardRoutingState.INITIALIZING).withRecoverySource((RecoverySource)recoverySource).build();
        return this.newShard(shardRouting, settings, engineFactory, listeners);
    }

    protected IndexShard newShard(ShardRouting shardRouting, IndexingOperationListener ... listeners) throws IOException {
        return this.newShard(shardRouting, Settings.EMPTY, listeners);
    }

    protected IndexShard newShard(ShardRouting shardRouting, Settings settings, IndexingOperationListener ... listeners) throws IOException {
        return this.newShard(shardRouting, settings, (EngineFactory)new InternalEngineFactory(), listeners);
    }

    protected IndexShard newShard(ShardRouting shardRouting, Settings settings, EngineFactory engineFactory, IndexingOperationListener ... listeners) throws IOException {
        assert (shardRouting.initializing()) : shardRouting;
        Settings indexSettings = IndexShardTestCase.indexSettings(1, 0).put("index.version.created", (VersionId)IndexVersion.current()).put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.getKey(), IndexShardTestCase.randomBoolean() ? (Long)IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.get(Settings.EMPTY) : (long)IndexShardTestCase.between(0, 1000)).put(settings).build();
        IndexMetadata.Builder metadata = IndexMetadata.builder((String)shardRouting.getIndexName()).settings(indexSettings).primaryTerm(0, this.primaryTerm).putMapping("{ \"properties\": {} }");
        return this.newShard(shardRouting, metadata.build(), null, engineFactory, NOOP_GCP_SYNCER, RetentionLeaseSyncer.EMPTY, listeners);
    }

    protected IndexShard newShard(ShardId shardId, boolean primary, IndexingOperationListener ... listeners) throws IOException {
        ShardRouting shardRouting = TestShardRouting.shardRoutingBuilder(shardId, IndexShardTestCase.randomAlphaOfLength(5), primary, ShardRoutingState.INITIALIZING).withRecoverySource((RecoverySource)(primary ? RecoverySource.EmptyStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE)).build();
        return this.newShard(shardRouting, Settings.EMPTY, (EngineFactory)new InternalEngineFactory(), listeners);
    }

    protected IndexShard newShard(ShardId shardId, boolean primary, String nodeId, IndexMetadata indexMetadata, @Nullable CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper) throws IOException {
        return this.newShard(shardId, primary, nodeId, indexMetadata, readerWrapper, NOOP_GCP_SYNCER);
    }

    protected IndexShard newShard(ShardId shardId, boolean primary, String nodeId, IndexMetadata indexMetadata, @Nullable CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper, GlobalCheckpointSyncer globalCheckpointSyncer) throws IOException {
        ShardRouting shardRouting = TestShardRouting.shardRoutingBuilder(shardId, nodeId, primary, ShardRoutingState.INITIALIZING).withRecoverySource((RecoverySource)(primary ? RecoverySource.EmptyStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE)).build();
        return this.newShard(shardRouting, indexMetadata, readerWrapper, (EngineFactory)new InternalEngineFactory(), globalCheckpointSyncer, RetentionLeaseSyncer.EMPTY, new IndexingOperationListener[0]);
    }

    protected IndexShard newShard(ShardRouting routing, IndexMetadata indexMetadata, @Nullable CheckedFunction<DirectoryReader, DirectoryReader, IOException> indexReaderWrapper, EngineFactory engineFactory, IndexingOperationListener ... listeners) throws IOException {
        return this.newShard(routing, indexMetadata, indexReaderWrapper, engineFactory, NOOP_GCP_SYNCER, RetentionLeaseSyncer.EMPTY, listeners);
    }

    protected IndexShard newShard(ShardRouting routing, IndexMetadata indexMetadata, @Nullable CheckedFunction<DirectoryReader, DirectoryReader, IOException> indexReaderWrapper, @Nullable EngineFactory engineFactory, GlobalCheckpointSyncer globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, IndexingOperationListener ... listeners) throws IOException {
        ShardId shardId = routing.shardId();
        NodeEnvironment.DataPath dataPath = new NodeEnvironment.DataPath(IndexShardTestCase.createTempDir());
        ShardPath shardPath = new ShardPath(false, dataPath.resolve(shardId), dataPath.resolve(shardId), shardId);
        return this.newShard(routing, shardPath, indexMetadata, null, indexReaderWrapper, engineFactory, globalCheckpointSyncer, retentionLeaseSyncer, EMPTY_EVENT_LISTENER, listeners);
    }

    protected IndexShard newShard(ShardRouting routing, ShardPath shardPath, IndexMetadata indexMetadata, @Nullable CheckedFunction<IndexSettings, Store, IOException> storeProvider, @Nullable CheckedFunction<DirectoryReader, DirectoryReader, IOException> indexReaderWrapper, @Nullable EngineFactory engineFactory, GlobalCheckpointSyncer globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, IndexEventListener indexEventListener, IndexingOperationListener ... listeners) throws IOException {
        return this.newShard(routing, shardPath, indexMetadata, storeProvider, indexReaderWrapper, engineFactory, globalCheckpointSyncer, retentionLeaseSyncer, indexEventListener, System::nanoTime, listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexShard newShard(ShardRouting routing, ShardPath shardPath, IndexMetadata indexMetadata, @Nullable CheckedFunction<IndexSettings, Store, IOException> storeProvider, @Nullable CheckedFunction<DirectoryReader, DirectoryReader, IOException> indexReaderWrapper, @Nullable EngineFactory engineFactory, GlobalCheckpointSyncer globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, IndexEventListener indexEventListener, LongSupplier relativeTimeSupplier, IndexingOperationListener ... listeners) throws IOException {
        IndexShard indexShard;
        Settings nodeSettings = Settings.builder().put("node.name", routing.currentNodeId()).build();
        IndexSettings indexSettings = new IndexSettings(indexMetadata, nodeSettings);
        if (storeProvider == null) {
            storeProvider = is -> this.createStore((IndexSettings)is, shardPath);
        }
        Store store = (Store)storeProvider.apply((Object)indexSettings);
        if (indexReaderWrapper == null && IndexShardTestCase.randomBoolean()) {
            indexReaderWrapper = EngineTestCase.randomReaderWrapper();
        }
        boolean success = false;
        try {
            IndexCache indexCache = new IndexCache((QueryCache)DisabledQueryCache.INSTANCE, null);
            MapperService mapperService = MapperTestUtils.newMapperService(this.xContentRegistry(), IndexShardTestCase.createTempDir(), indexSettings.getSettings(), routing.getIndexName());
            mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
            SimilarityService similarityService = new SimilarityService(indexSettings, null, Collections.emptyMap());
            Engine.Warmer warmer = IndexShardTestCase.createTestWarmer(indexSettings);
            ClusterSettings clusterSettings = new ClusterSettings(nodeSettings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS);
            HierarchyCircuitBreakerService breakerService = new HierarchyCircuitBreakerService(CircuitBreakerMetrics.NOOP, nodeSettings, Collections.emptyList(), clusterSettings);
            indexShard = new IndexShard(routing, indexSettings, shardPath, store, () -> null, indexCache, mapperService, similarityService, engineFactory, indexEventListener, indexReaderWrapper, this.threadPool, BigArrays.NON_RECYCLING_INSTANCE, warmer, Collections.emptyList(), Arrays.asList(listeners), globalCheckpointSyncer, retentionLeaseSyncer, (CircuitBreakerService)breakerService, IndexModule.DEFAULT_SNAPSHOT_COMMIT_SUPPLIER, relativeTimeSupplier, null, MapperMetrics.NOOP);
            indexShard.addShardFailureCallback(DEFAULT_SHARD_FAILURE_HANDLER);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.close((Closeable)store);
            }
        }
        return indexShard;
    }

    protected IndexShard reinitShard(IndexShard current, IndexingOperationListener ... listeners) throws IOException {
        ShardRouting shardRouting;
        return this.reinitShard(current, ShardRoutingHelper.initWithSameId(shardRouting, (RecoverySource)((shardRouting = current.routingEntry()).primary() ? RecoverySource.ExistingStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE)), listeners);
    }

    protected IndexShard reinitShard(IndexShard current, ShardRouting routing, IndexingOperationListener ... listeners) throws IOException {
        return this.reinitShard(current, routing, current.indexSettings.getIndexMetadata(), current.engineFactory, listeners);
    }

    protected IndexShard reinitShard(IndexShard current, ShardRouting routing, IndexMetadata indexMetadata, EngineFactory engineFactory, IndexingOperationListener ... listeners) throws IOException {
        this.closeShards(current);
        return this.newShard(routing, current.shardPath(), indexMetadata, null, null, engineFactory, current.getGlobalCheckpointSyncer(), current.getRetentionLeaseSyncer(), EMPTY_EVENT_LISTENER, listeners);
    }

    protected IndexShard newStartedShard() throws IOException {
        return this.newStartedShard(IndexShardTestCase.randomBoolean());
    }

    protected IndexShard newStartedShard(Settings settings) throws IOException {
        return this.newStartedShard(IndexShardTestCase.randomBoolean(), settings, (EngineFactory)new InternalEngineFactory(), new IndexingOperationListener[0]);
    }

    protected IndexShard newStartedShard(boolean primary) throws IOException {
        return this.newStartedShard(primary, Settings.EMPTY, (EngineFactory)new InternalEngineFactory(), new IndexingOperationListener[0]);
    }

    protected IndexShard newStartedShard(boolean primary, Settings settings, IndexingOperationListener ... listeners) throws IOException {
        return this.newStartedShard(primary, settings, (EngineFactory)new InternalEngineFactory(), listeners);
    }

    protected IndexShard newStartedShard(boolean primary, Settings settings, EngineFactory engineFactory, IndexingOperationListener ... listeners) throws IOException {
        return this.newStartedShard((CheckedFunction<Boolean, IndexShard, IOException>)((CheckedFunction)p -> this.newShard((boolean)p, settings, engineFactory, listeners)), primary);
    }

    protected IndexShard newStartedShard(CheckedFunction<Boolean, IndexShard, IOException> shardFunction, boolean primary) throws IOException {
        IndexShard shard = (IndexShard)shardFunction.apply((Object)primary);
        if (primary) {
            this.recoverShardFromStore(shard);
            IndexShardTestCase.assertThat(shard.getMaxSeqNoOfUpdatesOrDeletes(), Matchers.equalTo((Object)shard.seqNoStats().getMaxSeqNo()));
        } else {
            this.recoveryEmptyReplica(shard, true);
        }
        return shard;
    }

    protected void closeShards(IndexShard ... shards) throws IOException {
        this.closeShards(Arrays.asList(shards));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeShard(IndexShard shard, boolean assertConsistencyBetweenTranslogAndLucene) throws IOException {
        try {
            Engine engine;
            if (assertConsistencyBetweenTranslogAndLucene) {
                IndexShardTestCase.assertConsistentHistoryBetweenTranslogAndLucene(shard);
            }
            if ((engine = shard.getEngineOrNull()) != null) {
                EngineTestCase.assertAtMostOneLuceneDocumentPerSequenceNumber(engine);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{() -> IndexShardTestCase.closeShardNoCheck(shard), shard.store()});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{() -> IndexShardTestCase.closeShardNoCheck(shard), shard.store()});
    }

    protected void closeShards(Iterable<IndexShard> shards) throws IOException {
        for (IndexShard shard : shards) {
            if (shard == null) continue;
            this.closeShard(shard, true);
        }
    }

    public static void closeShardNoCheck(IndexShard indexShard, boolean flushEngine) throws IOException {
        CloseUtils.executeDirectly(l -> indexShard.close("IndexShardTestCase#closeShardNoCheck", flushEngine, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE, l));
    }

    public static void closeShardNoCheck(IndexShard indexShard) throws IOException {
        IndexShardTestCase.closeShardNoCheck(indexShard, false);
    }

    public static void flushAndCloseShardNoCheck(IndexShard indexShard) throws IOException {
        IndexShardTestCase.closeShardNoCheck(indexShard, true);
    }

    protected void recoverShardFromStore(IndexShard primary) throws IOException {
        primary.markAsRecovering("store", new RecoveryState(primary.routingEntry(), this.getFakeDiscoNode(primary.routingEntry().currentNodeId()), null));
        IndexShardTestCase.recoverFromStore(primary);
        IndexShardTestCase.updateRoutingEntry(primary, ShardRoutingHelper.moveToStarted(primary.routingEntry()));
    }

    public static void updateRoutingEntry(IndexShard shard, ShardRouting shardRouting) throws IOException {
        Set inSyncIds = shardRouting.active() ? Collections.singleton(shardRouting.allocationId().getId()) : Collections.emptySet();
        IndexShardRoutingTable.Builder builder = new IndexShardRoutingTable.Builder(shardRouting.shardId());
        if (!shardRouting.primary()) {
            builder.addShard(TestShardRouting.newShardRouting(shardRouting.shardId(), "ignored", true, ShardRoutingState.STARTED));
        }
        IndexShardRoutingTable newRoutingTable = builder.addShard(shardRouting).build();
        shard.updateShardState(shardRouting, shard.getPendingPrimaryTerm(), null, currentClusterStateVersion.incrementAndGet(), inSyncIds, newRoutingTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoveryEmptyReplica(IndexShard replica, boolean startReplica) throws IOException {
        IndexShard primary = null;
        try {
            primary = this.newStartedShard((CheckedFunction<Boolean, IndexShard, IOException>)((CheckedFunction)p -> this.newShard((boolean)p, replica.routingEntry().shardId(), replica.indexSettings.getSettings(), (EngineFactory)new InternalEngineFactory(), new IndexingOperationListener[0])), true);
            this.recoverReplica(replica, primary, startReplica);
        }
        catch (Throwable throwable) {
            this.closeShards(primary);
            throw throwable;
        }
        this.closeShards(primary);
    }

    protected DiscoveryNode getFakeDiscoNode(String id) {
        return DiscoveryNodeUtils.create(id, id);
    }

    protected void recoverReplica(IndexShard replica, IndexShard primary, boolean startReplica) throws IOException {
        this.recoverReplica(replica, primary, (r, sourceNode) -> new RecoveryTarget(r, sourceNode, 0L, null, null, recoveryListener), true, startReplica);
    }

    protected void recoverReplica(IndexShard replica, IndexShard primary, BiFunction<IndexShard, DiscoveryNode, RecoveryTarget> targetSupplier, boolean markAsRecovering, boolean markAsStarted) throws IOException {
        IndexShardRoutingTable.Builder newRoutingTable = new IndexShardRoutingTable.Builder(replica.shardId());
        newRoutingTable.addShard(primary.routingEntry());
        if (!replica.routingEntry().isRelocationTarget()) {
            newRoutingTable.addShard(replica.routingEntry());
        }
        Set<String> inSyncIds = Collections.singleton(primary.routingEntry().allocationId().getId());
        IndexShardRoutingTable routingTable = newRoutingTable.build();
        this.recoverUnstartedReplica(replica, primary, targetSupplier, markAsRecovering, inSyncIds, routingTable);
        if (markAsStarted) {
            this.startReplicaAfterRecovery(replica, primary, inSyncIds, routingTable);
        }
    }

    protected final void recoverUnstartedReplica(IndexShard replica, IndexShard primary, BiFunction<IndexShard, DiscoveryNode, RecoveryTarget> targetSupplier, boolean markAsRecovering, Set<String> inSyncIds, IndexShardRoutingTable routingTable) throws IOException {
        DiscoveryNode pNode = this.getFakeDiscoNode(primary.routingEntry().currentNodeId());
        DiscoveryNode rNode = this.getFakeDiscoNode(replica.routingEntry().currentNodeId());
        if (markAsRecovering) {
            replica.markAsRecovering("remote", new RecoveryState(replica.routingEntry(), pNode, rNode));
        } else {
            IndexShardTestCase.assertEquals((Object)replica.state(), (Object)IndexShardState.RECOVERING);
        }
        replica.prepareForIndexRecovery();
        RecoveryTarget recoveryTarget = targetSupplier.apply(replica, pNode);
        long startingSeqNo = IndexShardTestCase.recoverLocallyUpToGlobalCheckpoint(recoveryTarget.indexShard());
        StartRecoveryRequest request = PeerRecoveryTargetService.getStartRecoveryRequest((Logger)this.logger, (DiscoveryNode)rNode, (RecoveryTarget)recoveryTarget, (long)startingSeqNo);
        int fileChunkSizeInBytes = Math.toIntExact(IndexShardTestCase.randomBoolean() ? RecoverySettings.DEFAULT_CHUNK_SIZE.getBytes() : (long)IndexShardTestCase.randomIntBetween(1, 0xA00000));
        RecoveryPlannerService recoveryPlannerService = PeerOnlyRecoveryPlannerService.INSTANCE;
        RecoverySourceHandler recovery = new RecoverySourceHandler(primary, (RecoveryTargetHandler)new AsyncRecoveryTarget((RecoveryTargetHandler)recoveryTarget, this.threadPool.generic()), this.threadPool, request, fileChunkSizeInBytes, IndexShardTestCase.between(1, 8), IndexShardTestCase.between(1, 8), IndexShardTestCase.between(1, 8), false, recoveryPlannerService);
        primary.updateShardState(primary.routingEntry(), primary.getPendingPrimaryTerm(), null, currentClusterStateVersion.incrementAndGet(), inSyncIds, routingTable);
        try {
            UnsafePlainActionFuture future = new UnsafePlainActionFuture(new String[]{"generic"});
            recovery.recoverToTarget((ActionListener)future);
            future.actionGet();
            recoveryTarget.markAsDone();
        }
        catch (Exception e) {
            recoveryTarget.fail(new RecoveryFailedException(request, (Throwable)e), false);
            throw e;
        }
    }

    protected void startReplicaAfterRecovery(IndexShard replica, IndexShard primary, Set<String> inSyncIds, IndexShardRoutingTable routingTable) throws IOException {
        ShardRouting initializingReplicaRouting = replica.routingEntry();
        IndexShardRoutingTable newRoutingTable = initializingReplicaRouting.isRelocationTarget() ? new IndexShardRoutingTable.Builder(routingTable).removeShard(primary.routingEntry()).addShard(replica.routingEntry()).build() : new IndexShardRoutingTable.Builder(routingTable).removeShard(initializingReplicaRouting).addShard(replica.routingEntry()).build();
        HashSet<String> inSyncIdsWithReplica = new HashSet<String>(inSyncIds);
        inSyncIdsWithReplica.add(replica.routingEntry().allocationId().getId());
        primary.updateShardState(primary.routingEntry(), primary.getPendingPrimaryTerm(), null, currentClusterStateVersion.incrementAndGet(), inSyncIdsWithReplica, newRoutingTable);
        replica.updateShardState(replica.routingEntry().moveToStarted(-1L), replica.getPendingPrimaryTerm(), null, currentClusterStateVersion.get(), inSyncIdsWithReplica, newRoutingTable);
    }

    protected void promoteReplica(IndexShard replica, Set<String> inSyncIds, IndexShardRoutingTable routingTable) throws IOException {
        IndexShardTestCase.assertThat(inSyncIds, Matchers.contains((Object[])new String[]{replica.routingEntry().allocationId().getId()}));
        ShardRouting routingEntry = TestShardRouting.shardRoutingBuilder(replica.routingEntry().shardId(), replica.routingEntry().currentNodeId(), true, ShardRoutingState.STARTED).withAllocationId(replica.routingEntry().allocationId()).build();
        IndexShardRoutingTable newRoutingTable = new IndexShardRoutingTable.Builder(routingTable).removeShard(routingTable.primaryShard()).removeShard(replica.routingEntry()).addShard(routingEntry).build();
        replica.updateShardState(routingEntry, replica.getPendingPrimaryTerm() + 1L, (is, listener) -> listener.onResponse((Object)new PrimaryReplicaSyncer.ResyncTask(1L, "type", "action", "desc", null, Collections.emptyMap())), currentClusterStateVersion.incrementAndGet(), inSyncIds, newRoutingTable);
    }

    public static Releasable getOperationPermit(IndexShard shard) {
        SubscribableListener listener = new SubscribableListener();
        if (shard.routingEntry().primary()) {
            shard.acquirePrimaryOperationPermit((ActionListener)listener, null);
        } else {
            shard.acquireReplicaOperationPermit(shard.getOperationPrimaryTerm(), -1L, -1L, (ActionListener)listener, null);
        }
        IndexShardTestCase.assertTrue((boolean)listener.isDone());
        return (Releasable)IndexShardTestCase.safeAwait(listener);
    }

    public static Set<String> getShardDocUIDs(IndexShard shard) throws IOException {
        return IndexShardTestCase.getDocIdAndSeqNos(shard).stream().map(DocIdSeqNoAndSource::id).collect(Collectors.toSet());
    }

    public static List<DocIdSeqNoAndSource> getDocIdAndSeqNos(IndexShard shard) throws IOException {
        return EngineTestCase.getDocIds(shard.getEngine(), true);
    }

    protected void assertDocCount(IndexShard shard, int docDount) throws IOException {
        IndexShardTestCase.assertThat(IndexShardTestCase.getShardDocUIDs(shard), Matchers.hasSize((int)docDount));
    }

    protected void assertDocs(IndexShard shard, String ... ids) throws IOException {
        Set<String> shardDocUIDs = IndexShardTestCase.getShardDocUIDs(shard);
        IndexShardTestCase.assertThat(shardDocUIDs, Matchers.contains((Object[])ids));
        IndexShardTestCase.assertThat(shardDocUIDs, Matchers.hasSize((int)ids.length));
    }

    public static void assertConsistentHistoryBetweenTranslogAndLucene(IndexShard shard) throws IOException {
        if (shard.state() != IndexShardState.POST_RECOVERY && shard.state() != IndexShardState.STARTED) {
            return;
        }
        Engine engine = shard.getEngineOrNull();
        if (engine != null) {
            EngineTestCase.assertConsistentHistoryBetweenTranslogAndLuceneIndex(engine);
        }
    }

    protected Engine.IndexResult indexDoc(IndexShard shard, String type, String id) throws IOException {
        return this.indexDoc(shard, type, id, "{}");
    }

    protected Engine.IndexResult indexDoc(IndexShard shard, String type, String id, String source) throws IOException {
        return this.indexDoc(shard, id, source, XContentType.JSON, null);
    }

    protected Engine.IndexResult indexDoc(IndexShard shard, String id, String source, XContentType xContentType, String routing) throws IOException {
        Engine.IndexResult result;
        long autoGeneratedTimestamp = -1L;
        if (Strings.isEmpty((CharSequence)id)) {
            id = UUIDs.base64UUID();
            autoGeneratedTimestamp = System.currentTimeMillis();
        }
        SourceToParse sourceToParse = new SourceToParse(id, (BytesReference)new BytesArray(source), xContentType, routing);
        if (shard.routingEntry().primary()) {
            result = shard.applyIndexOperationOnPrimary(-3L, VersionType.INTERNAL, sourceToParse, -2L, 0L, autoGeneratedTimestamp, false);
            if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                this.updateMappings(shard, IndexMetadata.builder((IndexMetadata)shard.indexSettings().getIndexMetadata()).putMapping(result.getRequiredMappingUpdate().toString()).build());
                result = shard.applyIndexOperationOnPrimary(-3L, VersionType.INTERNAL, sourceToParse, -2L, 0L, autoGeneratedTimestamp, false);
            }
            shard.sync();
            shard.updateLocalCheckpointForShard(shard.routingEntry().allocationId().getId(), shard.getLocalCheckpoint());
        } else {
            long seqNo = shard.seqNoStats().getMaxSeqNo() + 1L;
            shard.advanceMaxSeqNoOfUpdatesOrDeletes(seqNo);
            result = shard.applyIndexOperationOnReplica(seqNo, shard.getOperationPrimaryTerm(), 0L, autoGeneratedTimestamp, false, sourceToParse);
            shard.sync();
            if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                throw new TransportReplicationAction.RetryOnReplicaException(shard.shardId, "Mappings are not available on the replica yet, triggered update: " + result.getRequiredMappingUpdate());
            }
        }
        return result;
    }

    protected void updateMappings(IndexShard shard, IndexMetadata indexMetadata) {
        shard.mapperService().merge(indexMetadata, MapperService.MergeReason.MAPPING_UPDATE);
        shard.indexSettings().updateIndexMetadata(IndexMetadata.builder((IndexMetadata)indexMetadata).putMapping(new MappingMetadata(shard.mapperService().documentMapper())).build());
    }

    protected Engine.DeleteResult deleteDoc(IndexShard shard, String id) throws IOException {
        Engine.DeleteResult result;
        if (shard.routingEntry().primary()) {
            result = shard.applyDeleteOperationOnPrimary(-3L, id, VersionType.INTERNAL, -2L, 0L);
            shard.sync();
            shard.updateLocalCheckpointForShard(shard.routingEntry().allocationId().getId(), shard.getLocalCheckpoint());
        } else {
            long seqNo = shard.seqNoStats().getMaxSeqNo() + 1L;
            shard.advanceMaxSeqNoOfUpdatesOrDeletes(seqNo);
            result = shard.applyDeleteOperationOnReplica(seqNo, shard.getOperationPrimaryTerm(), 0L, id);
            shard.sync();
        }
        return result;
    }

    protected void flushShard(IndexShard shard) {
        this.flushShard(shard, false);
    }

    protected void flushShard(IndexShard shard, boolean force) {
        shard.flush(new FlushRequest(new String[]{shard.shardId().getIndexName()}).force(force));
    }

    public static boolean recoverFromStore(IndexShard newShard) {
        PlainActionFuture future = new PlainActionFuture();
        newShard.recoverFromStore((ActionListener)future);
        return (Boolean)future.actionGet();
    }

    protected void recoverShardFromSnapshot(IndexShard shard, Snapshot snapshot, Repository repository) {
        IndexVersion version = IndexVersion.current();
        ShardId shardId = shard.shardId();
        IndexId indexId = new IndexId(shardId.getIndex().getName(), shardId.getIndex().getUUID());
        DiscoveryNode node = this.getFakeDiscoNode(shard.routingEntry().currentNodeId());
        RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(UUIDs.randomBase64UUID(), snapshot, version, indexId);
        ShardRouting shardRouting = TestShardRouting.shardRoutingBuilder(shardId, node.getId(), true, ShardRoutingState.INITIALIZING).withRecoverySource((RecoverySource)recoverySource).build();
        shard.markAsRecovering("from snapshot", new RecoveryState(shardRouting, node, null));
        PlainActionFuture future = new PlainActionFuture();
        repository.restoreShard(shard.store(), snapshot.getSnapshotId(), indexId, shard.shardId(), shard.recoveryState(), (ActionListener)future);
        future.actionGet();
    }

    protected ShardGeneration snapshotShard(IndexShard shard, Snapshot snapshot, Repository repository) throws IOException {
        ShardGeneration shardGen;
        Index index = shard.shardId().getIndex();
        IndexId indexId = new IndexId(index.getName(), index.getUUID());
        IndexShardSnapshotStatus snapshotStatus = IndexShardSnapshotStatus.newInitializing((ShardGeneration)ESBlobStoreRepositoryIntegTestCase.getRepositoryData(repository).shardGenerations().getShardGen(indexId, shard.shardId().getId()));
        PlainActionFuture future = new PlainActionFuture();
        try (Engine.IndexCommitRef indexCommitRef = shard.acquireLastIndexCommit(true);){
            repository.snapshotShard(new SnapshotShardContext(shard.store(), shard.mapperService(), snapshot.getSnapshotId(), indexId, new SnapshotIndexCommit(indexCommitRef), null, snapshotStatus, IndexVersion.current(), IndexShardTestCase.randomMillisUpToYear9999(), (ActionListener)future));
            shardGen = ((ShardSnapshotResult)future.actionGet()).getGeneration();
        }
        IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.asCopy();
        IndexShardTestCase.assertEquals((Object)IndexShardSnapshotStatus.Stage.DONE, (Object)lastSnapshotStatus.getStage());
        IndexShardTestCase.assertEquals((long)shard.snapshotStoreMetadata().size(), (long)lastSnapshotStatus.getTotalFileCount());
        IndexShardTestCase.assertNull((Object)lastSnapshotStatus.getFailure());
        return shardGen;
    }

    public static Engine getEngine(IndexShard indexShard) {
        return indexShard.getEngine();
    }

    public static Translog getTranslog(IndexShard shard) {
        return EngineTestCase.getTranslog(IndexShardTestCase.getEngine(shard));
    }

    public static ReplicationTracker getReplicationTracker(IndexShard indexShard) {
        return indexShard.getReplicationTracker();
    }

    public static Engine.Warmer createTestWarmer(IndexSettings indexSettings) {
        return reader -> {
            if (IndexShardTestCase.randomBoolean()) {
                try {
                    EngineTestCase.assertAtMostOneLuceneDocumentPerSequenceNumber(indexSettings, (DirectoryReader)reader);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
        };
    }

    public static long recoverLocallyUpToGlobalCheckpoint(IndexShard indexShard) {
        return (Long)IndexShardTestCase.safeAwait(arg_0 -> ((IndexShard)indexShard).recoverLocallyUpToGlobalCheckpoint(arg_0));
    }
}

