/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.logsdb.datageneration.DataGeneratorSpecification;
import org.elasticsearch.logsdb.datageneration.fields.TopLevelObjectFieldDataGenerator;
import org.elasticsearch.xcontent.XContentBuilder;

public class DataGenerator {
    private final TopLevelObjectFieldDataGenerator topLevelGenerator;

    public DataGenerator(DataGeneratorSpecification specification) {
        this.topLevelGenerator = new TopLevelObjectFieldDataGenerator(specification);
    }

    public void writeMapping(XContentBuilder mapping) throws IOException {
        mapping.startObject().field("_doc");
        this.topLevelGenerator.mappingWriter(Map.of()).accept((Object)mapping);
        mapping.endObject();
    }

    public void writeMapping(XContentBuilder mapping, Map<String, Object> customMappingParameters) throws IOException {
        mapping.startObject().field("_doc");
        this.topLevelGenerator.mappingWriter(customMappingParameters).accept((Object)mapping);
        mapping.endObject();
    }

    public void generateDocument(XContentBuilder document) throws IOException {
        this.topLevelGenerator.fieldValueGenerator((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})).accept((Object)document);
    }

    public void generateDocument(XContentBuilder document, CheckedConsumer<XContentBuilder, IOException> customDocumentModifications) throws IOException {
        this.topLevelGenerator.fieldValueGenerator(customDocumentModifications).accept((Object)document);
    }
}

