/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration.datasource;

import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.logsdb.datageneration.FieldType;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceHandler;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.logsdb.datageneration.fields.DynamicMapping;
import org.elasticsearch.test.ESTestCase;

public class DefaultObjectGenerationHandler
implements DataSourceHandler {
    private static final Set<FieldType> EXCLUDED_FROM_DYNAMIC_MAPPING = Set.of(FieldType.UNSIGNED_LONG);

    @Override
    public DataSourceResponse.ChildFieldGenerator handle(final DataSourceRequest.ChildFieldGenerator request) {
        return new DataSourceResponse.ChildFieldGenerator(){

            @Override
            public int generateChildFieldCount() {
                return ESTestCase.randomIntBetween(0, request.specification().maxFieldCountPerLevel());
            }

            @Override
            public boolean generateDynamicSubObject() {
                return ESTestCase.randomDouble() <= 0.05;
            }

            @Override
            public boolean generateNestedSubObject() {
                return ESTestCase.randomDouble() <= 0.05;
            }

            @Override
            public boolean generateRegularSubObject() {
                return ESTestCase.randomDouble() <= 0.05;
            }

            @Override
            public String generateFieldName() {
                return ESTestCase.randomAlphaOfLengthBetween(1, 10);
            }
        };
    }

    @Override
    public DataSourceResponse.FieldTypeGenerator handle(DataSourceRequest.FieldTypeGenerator request) {
        Supplier<DataSourceResponse.FieldTypeGenerator.FieldTypeInfo> generator = switch (request.dynamicMapping()) {
            default -> throw new IncompatibleClassChangeError();
            case DynamicMapping.FORBIDDEN -> () -> DefaultObjectGenerationHandler.generateFieldTypeInfo(false);
            case DynamicMapping.FORCED -> () -> DefaultObjectGenerationHandler.generateFieldTypeInfo(true);
            case DynamicMapping.SUPPORTED -> () -> DefaultObjectGenerationHandler.generateFieldTypeInfo(ESTestCase.randomBoolean());
        };
        return new DataSourceResponse.FieldTypeGenerator(generator);
    }

    private static DataSourceResponse.FieldTypeGenerator.FieldTypeInfo generateFieldTypeInfo(boolean isDynamic) {
        Set<FieldType> excluded = isDynamic ? EXCLUDED_FROM_DYNAMIC_MAPPING : Set.of();
        FieldType fieldType = ESTestCase.randomValueOtherThanMany(excluded::contains, () -> ESTestCase.randomFrom(FieldType.values()));
        return new DataSourceResponse.FieldTypeGenerator.FieldTypeInfo(fieldType, isDynamic);
    }

    @Override
    public DataSourceResponse.ObjectArrayGenerator handle(DataSourceRequest.ObjectArrayGenerator request) {
        return new DataSourceResponse.ObjectArrayGenerator(() -> {
            if (ESTestCase.randomBoolean()) {
                return Optional.of(ESTestCase.randomIntBetween(0, 5));
            }
            return Optional.empty();
        });
    }
}

