/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration.fields;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.logsdb.datageneration.DataGeneratorSpecification;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.logsdb.datageneration.fields.DynamicMapping;

class Context {
    private final DataGeneratorSpecification specification;
    private final DataSourceResponse.ChildFieldGenerator childFieldGenerator;
    private final DataSourceResponse.ObjectArrayGenerator objectArrayGenerator;
    private final String path;
    private final int objectDepth;
    private final AtomicInteger nestedFieldsCount;
    private final Set<String> eligibleCopyToDestinations;
    private final DynamicMapping parentDynamicMapping;
    private final ObjectMapper.Subobjects currentSubobjectsConfig;

    Context(DataGeneratorSpecification specification, DynamicMapping parentDynamicMapping, ObjectMapper.Subobjects currentSubobjectsConfig) {
        this(specification, "", 0, new AtomicInteger(0), new HashSet<String>(), parentDynamicMapping, currentSubobjectsConfig);
    }

    private Context(DataGeneratorSpecification specification, String path, int objectDepth, AtomicInteger nestedFieldsCount, Set<String> eligibleCopyToDestinations, DynamicMapping parentDynamicMapping, ObjectMapper.Subobjects currentSubobjectsConfig) {
        this.specification = specification;
        this.childFieldGenerator = specification.dataSource().get(new DataSourceRequest.ChildFieldGenerator(specification));
        this.objectArrayGenerator = specification.dataSource().get(new DataSourceRequest.ObjectArrayGenerator());
        this.path = path;
        this.objectDepth = objectDepth;
        this.nestedFieldsCount = nestedFieldsCount;
        this.eligibleCopyToDestinations = eligibleCopyToDestinations;
        this.parentDynamicMapping = parentDynamicMapping;
        this.currentSubobjectsConfig = currentSubobjectsConfig;
    }

    public DataGeneratorSpecification specification() {
        return this.specification;
    }

    public DataSourceResponse.ChildFieldGenerator childFieldGenerator() {
        return this.childFieldGenerator;
    }

    public DataSourceResponse.FieldTypeGenerator fieldTypeGenerator(DynamicMapping dynamicMapping) {
        return this.specification.dataSource().get(new DataSourceRequest.FieldTypeGenerator(dynamicMapping));
    }

    public Context subObject(String name, DynamicMapping dynamicMapping, ObjectMapper.Subobjects subobjects) {
        return new Context(this.specification, this.pathToField(name), this.objectDepth + 1, this.nestedFieldsCount, this.eligibleCopyToDestinations, dynamicMapping, subobjects);
    }

    public Context nestedObject(String name, DynamicMapping dynamicMapping, ObjectMapper.Subobjects subobjects) {
        this.nestedFieldsCount.incrementAndGet();
        return new Context(this.specification, this.pathToField(name), this.objectDepth + 1, this.nestedFieldsCount, new HashSet<String>(), dynamicMapping, subobjects);
    }

    public boolean shouldAddDynamicObjectField(DynamicMapping dynamicMapping) {
        if (this.objectDepth >= this.specification.maxObjectDepth() || dynamicMapping == DynamicMapping.FORBIDDEN) {
            return false;
        }
        return this.childFieldGenerator.generateDynamicSubObject();
    }

    public boolean shouldAddObjectField() {
        if (this.objectDepth >= this.specification.maxObjectDepth() || this.parentDynamicMapping == DynamicMapping.FORCED) {
            return false;
        }
        return this.childFieldGenerator.generateRegularSubObject();
    }

    public boolean shouldAddNestedField(ObjectMapper.Subobjects subobjects) {
        if (this.objectDepth >= this.specification.maxObjectDepth() || this.nestedFieldsCount.get() >= this.specification.nestedFieldsLimit() || this.parentDynamicMapping == DynamicMapping.FORCED || subobjects == ObjectMapper.Subobjects.DISABLED) {
            return false;
        }
        return this.childFieldGenerator.generateNestedSubObject();
    }

    public Optional<Integer> generateObjectArray() {
        if (this.objectDepth == 0) {
            return Optional.empty();
        }
        return this.objectArrayGenerator.lengthGenerator().get();
    }

    public DynamicMapping determineDynamicMapping(Map<String, Object> mappingParameters) {
        if (this.parentDynamicMapping == DynamicMapping.FORCED) {
            return DynamicMapping.FORCED;
        }
        Object dynamicParameter = mappingParameters.get("dynamic");
        if (dynamicParameter == null) {
            return this.parentDynamicMapping;
        }
        return dynamicParameter.equals("strict") ? DynamicMapping.FORBIDDEN : DynamicMapping.SUPPORTED;
    }

    public ObjectMapper.Subobjects determineSubobjects(Map<String, Object> mappingParameters) {
        if (this.currentSubobjectsConfig == ObjectMapper.Subobjects.DISABLED) {
            return ObjectMapper.Subobjects.DISABLED;
        }
        return ObjectMapper.Subobjects.from((Object)mappingParameters.getOrDefault("subobjects", "true"));
    }

    public Set<String> getEligibleCopyToDestinations() {
        return this.eligibleCopyToDestinations;
    }

    public void markFieldAsEligibleForCopyTo(String field) {
        this.eligibleCopyToDestinations.add(this.pathToField(field));
    }

    private String pathToField(String field) {
        return this.path.isEmpty() ? field : this.path + "." + field;
    }

    public ObjectMapper.Subobjects getCurrentSubobjectsConfig() {
        return this.currentSubobjectsConfig;
    }
}

