/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration.fields;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.logsdb.datageneration.FieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.FieldType;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.logsdb.datageneration.fields.Context;
import org.elasticsearch.logsdb.datageneration.fields.DynamicMapping;
import org.elasticsearch.logsdb.datageneration.fields.NestedFieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.fields.ObjectFieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.fields.PredefinedField;
import org.elasticsearch.xcontent.XContentBuilder;

public class GenericSubObjectFieldDataGenerator {
    private final Context context;

    GenericSubObjectFieldDataGenerator(Context context) {
        this.context = context;
    }

    List<ChildField> generateChildFields(DynamicMapping dynamicMapping, ObjectMapper.Subobjects subobjects) {
        HashSet<String> existingFieldNames = new HashSet<String>();
        int childFieldsCount = this.context.childFieldGenerator().generateChildFieldCount();
        ArrayList<ChildField> result = new ArrayList<ChildField>(childFieldsCount);
        for (int i = 0; i < childFieldsCount; ++i) {
            String fieldName = this.generateFieldName(existingFieldNames);
            if (this.context.shouldAddDynamicObjectField(dynamicMapping)) {
                result.add(new ChildField(fieldName, new ObjectFieldDataGenerator(this.context.subObject(fieldName, DynamicMapping.FORCED, subobjects)), true));
                continue;
            }
            if (this.context.shouldAddObjectField()) {
                result.add(new ChildField(fieldName, new ObjectFieldDataGenerator(this.context.subObject(fieldName, dynamicMapping, subobjects)), false));
                continue;
            }
            if (this.context.shouldAddNestedField(subobjects)) {
                result.add(new ChildField(fieldName, new NestedFieldDataGenerator(this.context.nestedObject(fieldName, dynamicMapping, subobjects)), false));
                continue;
            }
            DataSourceResponse.FieldTypeGenerator.FieldTypeInfo fieldTypeInfo = this.context.fieldTypeGenerator(dynamicMapping).generator().get();
            if (fieldTypeInfo.fieldType() == FieldType.KEYWORD) {
                this.context.markFieldAsEligibleForCopyTo(fieldName);
            }
            DataSourceResponse.LeafMappingParametersGenerator mappingParametersGenerator = this.context.specification().dataSource().get(new DataSourceRequest.LeafMappingParametersGenerator(fieldName, fieldTypeInfo.fieldType(), this.context.getEligibleCopyToDestinations(), dynamicMapping));
            FieldDataGenerator generator = fieldTypeInfo.fieldType().generator(fieldName, this.context.specification().dataSource(), mappingParametersGenerator);
            result.add(new ChildField(fieldName, generator, fieldTypeInfo.dynamic()));
        }
        return result;
    }

    List<ChildField> generateChildFields(List<PredefinedField> predefinedFields) {
        return predefinedFields.stream().map(pf -> new ChildField(pf.name(), pf.generator(this.context.specification().dataSource()), false)).toList();
    }

    static void writeChildFieldsMapping(XContentBuilder mapping, List<ChildField> childFields) throws IOException {
        for (ChildField childField : childFields) {
            if (childField.dynamic()) continue;
            mapping.field(childField.fieldName);
            childField.generator.mappingWriter().accept((Object)mapping);
        }
    }

    static void writeObjectsData(XContentBuilder document, Context context, CheckedConsumer<XContentBuilder, IOException> objectWriter) throws IOException {
        Optional<Integer> optionalLength = context.generateObjectArray();
        if (optionalLength.isPresent()) {
            int size = optionalLength.get();
            document.startArray();
            for (int i = 0; i < size; ++i) {
                objectWriter.accept((Object)document);
            }
            document.endArray();
        } else {
            objectWriter.accept((Object)document);
        }
    }

    static void writeSingleObject(XContentBuilder document, Iterable<ChildField> childFields) throws IOException {
        document.startObject();
        GenericSubObjectFieldDataGenerator.writeChildFieldsData(document, childFields);
        document.endObject();
    }

    static void writeChildFieldsData(XContentBuilder document, Iterable<ChildField> childFields) throws IOException {
        for (ChildField childField : childFields) {
            document.field(childField.fieldName);
            childField.generator.fieldValueGenerator().accept((Object)document);
        }
    }

    private String generateFieldName(Set<String> existingFields) {
        String fieldName = this.context.childFieldGenerator().generateFieldName();
        while (existingFields.contains(fieldName)) {
            fieldName = this.context.childFieldGenerator().generateFieldName();
        }
        existingFields.add(fieldName);
        return fieldName;
    }

    record ChildField(String fieldName, FieldDataGenerator generator, boolean dynamic) {
    }
}

