/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration.fields;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.logsdb.datageneration.FieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.logsdb.datageneration.fields.Context;
import org.elasticsearch.logsdb.datageneration.fields.DynamicMapping;
import org.elasticsearch.logsdb.datageneration.fields.GenericSubObjectFieldDataGenerator;
import org.elasticsearch.xcontent.XContentBuilder;

public class NestedFieldDataGenerator
implements FieldDataGenerator {
    private final Context context;
    private final Map<String, Object> mappingParameters;
    private final List<GenericSubObjectFieldDataGenerator.ChildField> childFields;

    NestedFieldDataGenerator(Context context) {
        this.context = context;
        this.mappingParameters = context.specification().dataSource().get(new DataSourceRequest.ObjectMappingParametersGenerator(false, true, context.getCurrentSubobjectsConfig())).mappingGenerator().get();
        DynamicMapping dynamicMapping = context.determineDynamicMapping(this.mappingParameters);
        ObjectMapper.Subobjects subobjects = context.determineSubobjects(this.mappingParameters);
        GenericSubObjectFieldDataGenerator genericGenerator = new GenericSubObjectFieldDataGenerator(context);
        this.childFields = genericGenerator.generateChildFields(dynamicMapping, subobjects);
    }

    @Override
    public CheckedConsumer<XContentBuilder, IOException> mappingWriter() {
        return b -> {
            b.startObject();
            b.field("type", "nested");
            for (Map.Entry<String, Object> entry : this.mappingParameters.entrySet()) {
                b.field(entry.getKey(), entry.getValue());
            }
            b.startObject("properties");
            GenericSubObjectFieldDataGenerator.writeChildFieldsMapping(b, this.childFields);
            b.endObject();
            b.endObject();
        };
    }

    @Override
    public CheckedConsumer<XContentBuilder, IOException> fieldValueGenerator() {
        CheckedConsumer objectWriter = object -> GenericSubObjectFieldDataGenerator.writeSingleObject(object, this.childFields);
        return b -> GenericSubObjectFieldDataGenerator.writeObjectsData(b, this.context, (CheckedConsumer<XContentBuilder, IOException>)objectWriter);
    }
}

