/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration.fields;

import java.util.Set;
import org.elasticsearch.logsdb.datageneration.FieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.FieldType;
import org.elasticsearch.logsdb.datageneration.datasource.DataSource;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.logsdb.datageneration.fields.DynamicMapping;

public interface PredefinedField {
    public String name();

    public FieldDataGenerator generator(DataSource var1);

    public record WithGenerator(String fieldName, FieldDataGenerator generator) implements PredefinedField
    {
        @Override
        public String name() {
            return this.fieldName;
        }

        @Override
        public FieldDataGenerator generator(DataSource dataSource) {
            return this.generator;
        }
    }

    public record WithType(String fieldName, FieldType fieldType, DynamicMapping dynamicMapping) implements PredefinedField
    {
        @Override
        public String name() {
            return this.fieldName;
        }

        @Override
        public FieldDataGenerator generator(DataSource dataSource) {
            DataSourceResponse.LeafMappingParametersGenerator mappingParametersGenerator = dataSource.get(new DataSourceRequest.LeafMappingParametersGenerator(this.fieldName, this.fieldType, Set.of(), this.dynamicMapping));
            return this.fieldType().generator(this.fieldName, dataSource, mappingParametersGenerator);
        }
    }
}

