/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration.fields;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.logsdb.datageneration.DataGeneratorSpecification;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.logsdb.datageneration.fields.Context;
import org.elasticsearch.logsdb.datageneration.fields.DynamicMapping;
import org.elasticsearch.logsdb.datageneration.fields.GenericSubObjectFieldDataGenerator;
import org.elasticsearch.xcontent.XContentBuilder;

public class TopLevelObjectFieldDataGenerator {
    private final Context context;
    private final Map<String, Object> mappingParameters;
    private final List<GenericSubObjectFieldDataGenerator.ChildField> predefinedFields;
    private final List<GenericSubObjectFieldDataGenerator.ChildField> generatedChildFields;

    public TopLevelObjectFieldDataGenerator(DataGeneratorSpecification specification) {
        DynamicMapping dynamicMapping;
        if (specification.fullyDynamicMapping()) {
            dynamicMapping = DynamicMapping.FORCED;
            this.mappingParameters = Map.of();
        } else {
            this.mappingParameters = new HashMap<String, Object>(specification.dataSource().get(new DataSourceRequest.ObjectMappingParametersGenerator(true, false, ObjectMapper.Subobjects.ENABLED)).mappingGenerator().get());
            this.mappingParameters.remove("enabled");
            dynamicMapping = this.mappingParameters.getOrDefault("dynamic", "true").equals("strict") ? DynamicMapping.FORBIDDEN : DynamicMapping.SUPPORTED;
        }
        ObjectMapper.Subobjects subobjects = ObjectMapper.Subobjects.from((Object)this.mappingParameters.getOrDefault("subobjects", "true"));
        this.context = new Context(specification, dynamicMapping, ObjectMapper.Subobjects.ENABLED);
        GenericSubObjectFieldDataGenerator genericGenerator = new GenericSubObjectFieldDataGenerator(this.context);
        this.predefinedFields = genericGenerator.generateChildFields(specification.predefinedFields());
        this.generatedChildFields = genericGenerator.generateChildFields(dynamicMapping, subobjects);
    }

    public CheckedConsumer<XContentBuilder, IOException> mappingWriter(Map<String, Object> customMappingParameters) {
        return b -> {
            b.startObject();
            Map<String, Object> mergedParameters = Stream.of(this.mappingParameters, customMappingParameters).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (l, r) -> r));
            for (Map.Entry<String, Object> entry : mergedParameters.entrySet()) {
                b.field(entry.getKey(), entry.getValue());
            }
            b.startObject("properties");
            GenericSubObjectFieldDataGenerator.writeChildFieldsMapping(b, this.predefinedFields);
            GenericSubObjectFieldDataGenerator.writeChildFieldsMapping(b, this.generatedChildFields);
            b.endObject();
            b.endObject();
        };
    }

    public CheckedConsumer<XContentBuilder, IOException> fieldValueGenerator(CheckedConsumer<XContentBuilder, IOException> customDocumentModification) {
        CheckedConsumer objectWriter = b -> {
            b.startObject();
            customDocumentModification.accept(b);
            GenericSubObjectFieldDataGenerator.writeChildFieldsData(b, this.predefinedFields);
            GenericSubObjectFieldDataGenerator.writeChildFieldsData(b, this.generatedChildFields);
            b.endObject();
        };
        return b -> GenericSubObjectFieldDataGenerator.writeObjectsData(b, this.context, (CheckedConsumer<XContentBuilder, IOException>)objectWriter);
    }
}

