/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration.fields.leaf;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.logsdb.datageneration.FieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.datasource.DataSource;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.xcontent.XContentBuilder;

public class FloatFieldDataGenerator
implements FieldDataGenerator {
    private final Supplier<Object> valueGenerator;
    private final Map<String, Object> mappingParameters;

    public FloatFieldDataGenerator(String fieldName, DataSource dataSource, DataSourceResponse.LeafMappingParametersGenerator mappingParametersGenerator) {
        DataSourceResponse.FloatGenerator floats = dataSource.get(new DataSourceRequest.FloatGenerator());
        DataSourceResponse.NullWrapper nulls = dataSource.get(new DataSourceRequest.NullWrapper());
        DataSourceResponse.ArrayWrapper arrays = dataSource.get(new DataSourceRequest.ArrayWrapper());
        this.valueGenerator = arrays.wrapper().compose(nulls.wrapper()).apply(() -> floats.generator().get());
        this.mappingParameters = mappingParametersGenerator.mappingGenerator().get();
    }

    @Override
    public CheckedConsumer<XContentBuilder, IOException> mappingWriter() {
        return b -> {
            b.startObject().field("type", "float");
            for (Map.Entry<String, Object> entry : this.mappingParameters.entrySet()) {
                b.field(entry.getKey(), entry.getValue());
            }
            b.endObject();
        };
    }

    @Override
    public CheckedConsumer<XContentBuilder, IOException> fieldValueGenerator() {
        return b -> b.value(this.valueGenerator.get());
    }
}

