/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class MockLog
implements Releasable {
    private static final Map<String, List<MockLog>> mockLogs = new ConcurrentHashMap<String, List<MockLog>>();
    private static final MockAppender appender = new MockAppender();
    private final List<String> loggers;
    private final List<WrappedLoggingExpectation> expectations = new CopyOnWriteArrayList<WrappedLoggingExpectation>();
    private volatile boolean isAlive = true;

    public void close() {
        this.isAlive = false;
        for (String logger : this.loggers) {
            mockLogs.compute(logger, (k, v) -> {
                assert (v != null);
                v.remove(this);
                return v.isEmpty() ? null : v;
            });
        }
        for (WrappedLoggingExpectation expectation : this.expectations) {
            MatcherAssert.assertThat((String)("Method assertMatched() not called on LoggingExpectation instance before release: " + expectation), (Object)expectation.assertMatchedCalled, (Matcher)Matchers.is((Object)true));
        }
    }

    private MockLog(List<String> loggers) {
        this.loggers = loggers;
    }

    public static void init() {
        appender.start();
        Loggers.addAppender((Logger)LogManager.getLogger((String)""), (Appender)appender);
    }

    public void addExpectation(LoggingExpectation expectation) {
        this.expectations.add(new WrappedLoggingExpectation(expectation));
    }

    public void assertAllExpectationsMatched() {
        for (LoggingExpectation loggingExpectation : this.expectations) {
            loggingExpectation.assertMatched();
        }
    }

    public void awaitAllExpectationsMatched() {
        this.awaitAllExpectationsMatched(ESTestCase.SAFE_AWAIT_TIMEOUT);
    }

    void awaitAllExpectationsMatched(TimeValue waitTime) {
        long deadlineNanos = System.nanoTime() + waitTime.nanos();
        long nanosPerMilli = TimeValue.timeValueMillis((long)1L).nanos();
        try {
            for (LoggingExpectation loggingExpectation : this.expectations) {
                long remainingMillis = (deadlineNanos - System.nanoTime() + nanosPerMilli - 1L) / nanosPerMilli;
                MatcherAssert.assertThat((Object)remainingMillis, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
                loggingExpectation.awaitMatched(remainingMillis);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new AssertionError("interrupted", interruptedException);
        }
    }

    public static MockLog capture(Class<?> ... classes) {
        return MockLog.create(Arrays.stream(classes).map(Class::getCanonicalName).toList());
    }

    public static MockLog capture(String ... names) {
        return MockLog.create(Arrays.asList(names));
    }

    private static MockLog create(List<String> loggers) {
        MockLog appender = new MockLog(loggers);
        MockLog.addToMockLogs(appender, loggers);
        return appender;
    }

    private static void addToMockLogs(MockLog mockLog, List<String> loggers) {
        for (String logger : loggers) {
            mockLogs.compute(logger, (k, v) -> {
                if (v == null) {
                    v = new CopyOnWriteArrayList<MockLog>();
                }
                v.add(mockLog);
                return v;
            });
        }
    }

    public static void assertThatLogger(Runnable action, Class<?> loggerOwner, LoggingExpectation ... expectations) {
        try (MockLog mockLog = MockLog.capture(loggerOwner);){
            for (LoggingExpectation expectation : expectations) {
                mockLog.addExpectation(expectation);
            }
            action.run();
            mockLog.assertAllExpectationsMatched();
        }
    }

    public static void awaitLogger(Runnable action, Class<?> loggerOwner, LoggingExpectation ... expectations) {
        try (MockLog mockLog = MockLog.capture(loggerOwner);){
            for (LoggingExpectation expectation : expectations) {
                mockLog.addExpectation(expectation);
            }
            action.run();
            mockLog.awaitAllExpectationsMatched();
        }
    }

    private static class WrappedLoggingExpectation
    implements LoggingExpectation {
        private volatile boolean assertMatchedCalled = false;
        private final LoggingExpectation delegate;

        private WrappedLoggingExpectation(LoggingExpectation delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public void match(LogEvent event) {
            this.delegate.match(event);
        }

        @Override
        public void assertMatched() {
            try {
                this.delegate.assertMatched();
            }
            finally {
                this.assertMatchedCalled = true;
            }
        }

        @Override
        public void awaitMatched(long millis) throws InterruptedException {
            try {
                this.delegate.awaitMatched(millis);
            }
            finally {
                this.assertMatchedCalled = true;
            }
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static class MockAppender
    extends AbstractAppender {
        MockAppender() {
            super("mock", null, null, false, Property.EMPTY_ARRAY);
        }

        public void append(LogEvent event) {
            List<MockLog> appenders = mockLogs.get(event.getLoggerName());
            if (appenders == null) {
                appenders = mockLogs.getOrDefault("", List.of());
            }
            for (MockLog appender : appenders) {
                if (!appender.isAlive) continue;
                for (LoggingExpectation loggingExpectation : appender.expectations) {
                    loggingExpectation.match(event);
                }
            }
        }
    }

    public static interface LoggingExpectation {
        public void match(LogEvent var1);

        public void assertMatched();

        default public void awaitMatched(long millis) throws InterruptedException {
            this.assertMatched();
        }
    }

    public static class PatternSeenEventExpectation
    implements LoggingExpectation {
        private final String name;
        private final String logger;
        private final Level level;
        private final Pattern pattern;
        private final CountDownLatch seenLatch = new CountDownLatch(1);

        public PatternSeenEventExpectation(String name, String logger, Level level, String pattern) {
            this.name = name;
            this.logger = logger;
            this.level = level;
            this.pattern = Pattern.compile(pattern);
        }

        @Override
        public void match(LogEvent event) {
            if (event.getLevel().equals((Object)this.level) && event.getLoggerName().equals(this.logger) && this.pattern.matcher(event.getMessage().getFormattedMessage()).matches()) {
                this.seenLatch.countDown();
            }
        }

        @Override
        public void assertMatched() {
            MatcherAssert.assertThat((String)this.name, (Object)this.seenLatch.getCount(), (Matcher)CoreMatchers.equalTo((Object)0L));
        }

        @Override
        public void awaitMatched(long millis) throws InterruptedException {
            MatcherAssert.assertThat((String)this.name, (Object)this.seenLatch.await(millis, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    public static class ExceptionSeenEventExpectation
    extends SeenEventExpectation {
        private final Class<? extends Exception> clazz;
        private final String exceptionMessage;

        public ExceptionSeenEventExpectation(String name, String logger, Level level, String message, Class<? extends Exception> clazz, String exceptionMessage) {
            super(name, logger, level, message);
            this.clazz = clazz;
            this.exceptionMessage = exceptionMessage;
        }

        @Override
        public boolean innerMatch(LogEvent event) {
            return event.getThrown() != null && event.getThrown().getClass() == this.clazz && event.getThrown().getMessage().equals(this.exceptionMessage);
        }
    }

    public static class EventuallySeenEventExpectation
    extends SeenEventExpectation {
        private volatile boolean expectSeen = false;

        public EventuallySeenEventExpectation(String name, String logger, Level level, String message) {
            super(name, logger, level, message);
        }

        public void setExpectSeen() {
            this.expectSeen = true;
        }

        @Override
        public void assertMatched() {
            if (this.expectSeen) {
                super.assertMatched();
            } else {
                MatcherAssert.assertThat((String)("expected not to see " + this.name + " yet but did"), (Object)this.seenLatch.getCount(), (Matcher)CoreMatchers.equalTo((Object)1L));
            }
        }

        @Override
        public void awaitMatched(long millis) throws InterruptedException {
            if (this.expectSeen) {
                super.awaitMatched(millis);
            } else {
                MatcherAssert.assertThat((String)("expected not to see " + this.name + " yet but did"), (Object)this.seenLatch.getCount(), (Matcher)CoreMatchers.equalTo((Object)1L));
            }
        }
    }

    public static class SeenEventExpectation
    extends AbstractEventExpectation {
        public SeenEventExpectation(String name, String logger, Level level, String message) {
            super(name, logger, level, message);
        }

        @Override
        public void assertMatched() {
            MatcherAssert.assertThat((String)("expected to see " + this.name + " but did not"), (Object)this.seenLatch.getCount(), (Matcher)CoreMatchers.equalTo((Object)0L));
        }

        @Override
        public void awaitMatched(long millis) throws InterruptedException {
            MatcherAssert.assertThat((String)("expected to see " + this.name + " but did not"), (Object)this.seenLatch.await(millis, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    public static class UnseenEventExpectation
    extends AbstractEventExpectation {
        public UnseenEventExpectation(String name, String logger, Level level, String message) {
            super(name, logger, level, message);
        }

        @Override
        public void assertMatched() {
            MatcherAssert.assertThat((String)("expected not to see " + this.name + " but did"), (Object)this.seenLatch.getCount(), (Matcher)CoreMatchers.equalTo((Object)1L));
        }
    }

    public static abstract class AbstractEventExpectation
    implements LoggingExpectation {
        protected final String name;
        protected final String logger;
        protected final Level level;
        protected final String message;
        protected final CountDownLatch seenLatch = new CountDownLatch(1);

        public AbstractEventExpectation(String name, String logger, Level level, String message) {
            this.name = name;
            this.logger = logger;
            this.level = level;
            this.message = message;
        }

        @Override
        public void match(LogEvent event) {
            if (event.getLevel().equals((Object)this.level) && event.getLoggerName().equals(this.logger) && this.innerMatch(event)) {
                if (Regex.isSimpleMatchPattern((String)this.message)) {
                    if (Regex.simpleMatch((String)this.message, (String)event.getMessage().getFormattedMessage())) {
                        this.seenLatch.countDown();
                    }
                } else if (event.getMessage().getFormattedMessage().contains(this.message)) {
                    this.seenLatch.countDown();
                }
            }
        }

        public boolean innerMatch(LogEvent event) {
            return true;
        }
    }
}

