/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.MetadataRolloverService;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.TestShardRoutingRoleStrategies;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.DataStreamAutoShardingEvent;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.DataStreamOptions;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexAliasesService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.WriteLoadForecaster;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettingProviders;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.DataStreamTimestampFieldMapper;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.indices.EmptySystemIndices;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.test.ClusterServiceUtils;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class DataStreamTestHelper {
    private static final Settings.Builder SETTINGS = ESTestCase.settings(IndexVersion.current()).put("index.hidden", true);
    private static final int NUMBER_OF_SHARDS = 1;
    private static final int NUMBER_OF_REPLICAS = 1;

    public static DataStream newInstance(String name, List<Index> indices) {
        return DataStreamTestHelper.newInstance(name, indices, indices.size(), null);
    }

    public static DataStream newInstance(String name, List<Index> indices, List<Index> failureIndices) {
        return DataStreamTestHelper.newInstance(name, indices, (long)indices.size(), null, false, null, failureIndices);
    }

    public static DataStream newInstance(String name, List<Index> indices, long generation, Map<String, Object> metadata) {
        return DataStreamTestHelper.newInstance(name, indices, generation, metadata, false);
    }

    public static DataStream newInstance(String name, List<Index> indices, long generation, Map<String, Object> metadata, boolean replicated) {
        return DataStreamTestHelper.newInstance(name, indices, generation, metadata, replicated, null);
    }

    public static DataStream newInstance(String name, List<Index> indices, long generation, Map<String, Object> metadata, boolean replicated, @Nullable DataStreamLifecycle lifecycle) {
        return DataStreamTestHelper.newInstance(name, indices, generation, metadata, replicated, lifecycle, List.of());
    }

    public static DataStream newInstance(String name, List<Index> indices, long generation, Map<String, Object> metadata, boolean replicated, @Nullable DataStreamLifecycle lifecycle, @Nullable DataStreamAutoShardingEvent autoShardingEvent) {
        return DataStream.builder((String)name, (DataStream.DataStreamIndices)DataStream.DataStreamIndices.backingIndicesBuilder(indices).setAutoShardingEvent(autoShardingEvent).build()).setGeneration(generation).setMetadata(metadata).setReplicated(replicated).setLifecycle(lifecycle).build();
    }

    public static DataStream newInstance(String name, List<Index> indices, long generation, Map<String, Object> metadata, boolean replicated, @Nullable DataStreamLifecycle lifecycle, List<Index> failureStores) {
        return DataStream.builder((String)name, indices).setGeneration(generation).setMetadata(metadata).setReplicated(replicated).setLifecycle(lifecycle).setDataStreamOptions(failureStores.isEmpty() ? DataStreamOptions.EMPTY : DataStreamOptions.FAILURE_STORE_ENABLED).setFailureIndices(DataStream.DataStreamIndices.failureIndicesBuilder(failureStores).build()).build();
    }

    public static String getLegacyDefaultBackingIndexName(String dataStreamName, long generation, long epochMillis, boolean isNewIndexNameFormat) {
        if (isNewIndexNameFormat) {
            return String.format(Locale.ROOT, ".ds-%s-%s-%06d", dataStreamName, DataStream.DATE_FORMATTER.formatMillis(epochMillis), generation);
        }
        return DataStreamTestHelper.getLegacyDefaultBackingIndexName(dataStreamName, generation);
    }

    public static String getLegacyDefaultBackingIndexName(String dataStreamName, long generation) {
        return String.format(Locale.ROOT, ".ds-%s-%06d", dataStreamName, generation);
    }

    public static IndexMetadata.Builder createFirstBackingIndex(String dataStreamName) {
        return DataStreamTestHelper.createBackingIndex(dataStreamName, 1, System.currentTimeMillis());
    }

    public static IndexMetadata.Builder createFirstBackingIndex(String dataStreamName, long epochMillis) {
        return DataStreamTestHelper.createBackingIndex(dataStreamName, 1, epochMillis);
    }

    public static IndexMetadata.Builder createBackingIndex(String dataStreamName, int generation) {
        return DataStreamTestHelper.createBackingIndex(dataStreamName, generation, System.currentTimeMillis());
    }

    public static IndexMetadata.Builder createBackingIndex(String dataStreamName, int generation, long epochMillis) {
        return IndexMetadata.builder((String)DataStream.getDefaultBackingIndexName((String)dataStreamName, (long)generation, (long)epochMillis)).settings(SETTINGS).numberOfShards(1).numberOfReplicas(1);
    }

    public static IndexMetadata.Builder createFirstFailureStore(String dataStreamName) {
        return DataStreamTestHelper.createFailureStore(dataStreamName, 1, System.currentTimeMillis());
    }

    public static IndexMetadata.Builder createFirstFailureStore(String dataStreamName, long epochMillis) {
        return DataStreamTestHelper.createFailureStore(dataStreamName, 1, epochMillis);
    }

    public static IndexMetadata.Builder createFailureStore(String dataStreamName, int generation) {
        return DataStreamTestHelper.createFailureStore(dataStreamName, generation, System.currentTimeMillis());
    }

    public static IndexMetadata.Builder createFailureStore(String dataStreamName, int generation, long epochMillis) {
        return IndexMetadata.builder((String)DataStream.getDefaultFailureStoreName((String)dataStreamName, (long)generation, (long)epochMillis)).settings(SETTINGS).numberOfShards(1).numberOfReplicas(1);
    }

    public static IndexMetadata.Builder getIndexMetadataBuilderForIndex(Index index) {
        return IndexMetadata.builder((String)index.getName()).settings(Settings.builder().put(SETTINGS.build()).put("index.uuid", index.getUUID())).numberOfShards(1).numberOfReplicas(1);
    }

    public static String generateMapping(String timestampFieldName) {
        return String.format(Locale.ROOT, "{\n  \"_doc\":{\n    \"properties\": {\n      \"%s\": {\n        \"type\": \"date\"\n      }\n    }\n  }\n}", timestampFieldName);
    }

    public static String generateTsdbMapping() {
        return "{\n  \"_doc\":{\n    \"properties\": {\n      \"@timestamp\": {\n        \"type\": \"date\"\n      },\n      \"uid\": {\n        \"type\": \"keyword\",\n        \"time_series_dimension\": true\n      }\n    }\n  }\n}";
    }

    public static String generateMapping(String timestampFieldName, String type) {
        return "{\n      \"_data_stream_timestamp\": {\n        \"enabled\": true\n      },      \"properties\": {\n        \"" + timestampFieldName + "\": {\n          \"type\": \"" + type + "\"\n        }\n      }\n    }";
    }

    public static List<Index> randomIndexInstances() {
        return DataStreamTestHelper.randomIndexInstances(0, 128);
    }

    public static List<Index> randomNonEmptyIndexInstances() {
        return DataStreamTestHelper.randomIndexInstances(1, 128);
    }

    public static List<Index> randomIndexInstances(int min, int max) {
        int numIndices = ESTestCase.randomIntBetween(min, max);
        ArrayList<Index> indices = new ArrayList<Index>(numIndices);
        for (int i = 0; i < numIndices; ++i) {
            indices.add(new Index(ESTestCase.randomAlphaOfLength(10).toLowerCase(Locale.ROOT), UUIDs.randomBase64UUID((Random)LuceneTestCase.random())));
        }
        return indices;
    }

    public static DataStream randomInstance() {
        return DataStreamTestHelper.randomInstance(System::currentTimeMillis);
    }

    public static DataStream randomInstance(boolean failureStore) {
        return DataStreamTestHelper.randomInstance(System::currentTimeMillis, failureStore);
    }

    public static DataStream randomInstance(String name) {
        return DataStreamTestHelper.randomInstance(name, System::currentTimeMillis, ESTestCase.randomBoolean());
    }

    public static DataStream randomInstance(LongSupplier timeProvider) {
        return DataStreamTestHelper.randomInstance(timeProvider, ESTestCase.randomBoolean());
    }

    public static DataStream randomInstance(LongSupplier timeProvider, boolean failureStore) {
        String dataStreamName = ESTestCase.randomAlphaOfLength(10).toLowerCase(Locale.ROOT);
        return DataStreamTestHelper.randomInstance(dataStreamName, timeProvider, failureStore);
    }

    public static DataStream randomInstance(String dataStreamName, LongSupplier timeProvider, boolean failureStore) {
        List<Index> indices = DataStreamTestHelper.randomIndexInstances();
        long generation = (long)indices.size() + ESTestCase.randomLongBetween(1L, 128L);
        indices.add(new Index(DataStream.getDefaultBackingIndexName((String)dataStreamName, (long)generation), UUIDs.randomBase64UUID((Random)LuceneTestCase.random())));
        Map<String, String> metadata = null;
        if (ESTestCase.randomBoolean()) {
            metadata = Map.of("key", "value");
        }
        List<Object> failureIndices = List.of();
        generation += ESTestCase.randomLongBetween(1L, 128L);
        if (failureStore) {
            failureIndices = DataStreamTestHelper.randomNonEmptyIndexInstances();
            failureIndices.add(new Index(DataStream.getDefaultFailureStoreName((String)dataStreamName, (long)generation, (long)System.currentTimeMillis()), UUIDs.randomBase64UUID((Random)LuceneTestCase.random())));
        }
        boolean replicated = ESTestCase.randomBoolean();
        return new DataStream(dataStreamName, generation, metadata, ESTestCase.randomBoolean(), replicated, false, timeProvider, ESTestCase.randomBoolean(), (IndexMode)(ESTestCase.randomBoolean() ? IndexMode.STANDARD : null), ESTestCase.randomBoolean() ? DataStreamLifecycle.newBuilder().dataRetention(ESTestCase.randomMillisUpToYear9999()).build() : null, failureStore ? DataStreamOptions.FAILURE_STORE_ENABLED : DataStreamOptions.EMPTY, DataStream.DataStreamIndices.backingIndicesBuilder(indices).setRolloverOnWrite(!replicated && ESTestCase.randomBoolean()).setAutoShardingEvent(ESTestCase.randomBoolean() ? new DataStreamAutoShardingEvent(indices.get(indices.size() - 1).getName(), ESTestCase.randomIntBetween(1, 10), ESTestCase.randomMillisUpToYear9999()) : null).build(), DataStream.DataStreamIndices.failureIndicesBuilder(failureIndices).setRolloverOnWrite(failureStore && !replicated && ESTestCase.randomBoolean()).setAutoShardingEvent(failureStore && ESTestCase.randomBoolean() ? new DataStreamAutoShardingEvent(indices.get(indices.size() - 1).getName(), ESTestCase.randomIntBetween(1, 10), ESTestCase.randomMillisUpToYear9999()) : null).build());
    }

    public static DataStreamAlias randomAliasInstance() {
        List<String> dataStreams = List.of(ESTestCase.generateRandomStringArray(5, 5, false, false));
        return new DataStreamAlias(ESTestCase.randomAlphaOfLength(5), dataStreams, ESTestCase.randomBoolean() ? ESTestCase.randomFrom(dataStreams) : null, ESTestCase.randomBoolean() ? ESTestCase.randomMap(1, 4, () -> new Tuple((Object)"term", Map.of("year", "2022"))) : null);
    }

    @Nullable
    public static DataStreamGlobalRetention randomGlobalRetention() {
        if (ESTestCase.randomBoolean()) {
            return null;
        }
        boolean withDefault = ESTestCase.randomBoolean();
        return new DataStreamGlobalRetention(withDefault ? TimeValue.timeValueDays((long)ESTestCase.randomIntBetween(1, 30)) : null, !withDefault || ESTestCase.randomBoolean() ? TimeValue.timeValueDays((long)ESTestCase.randomIntBetween(31, 100)) : null);
    }

    public static ClusterState getClusterStateWithDataStreams(List<Tuple<String, Integer>> dataStreams, List<String> indexNames) {
        return DataStreamTestHelper.getClusterStateWithDataStreams(dataStreams, indexNames, 1);
    }

    public static ClusterState getClusterStateWithDataStreams(List<Tuple<String, Integer>> dataStreams, List<String> indexNames, int replicas) {
        return DataStreamTestHelper.getClusterStateWithDataStreams(dataStreams, indexNames, System.currentTimeMillis(), Settings.EMPTY, replicas);
    }

    public static ClusterState getClusterStateWithDataStreams(List<Tuple<String, Integer>> dataStreams, List<String> indexNames, long currentTime, Settings settings, int replicas) {
        return DataStreamTestHelper.getClusterStateWithDataStreams(dataStreams, indexNames, currentTime, settings, replicas, false);
    }

    public static ClusterState getClusterStateWithDataStreams(List<Tuple<String, Integer>> dataStreams, List<String> indexNames, long currentTime, Settings settings, int replicas, boolean replicated) {
        return DataStreamTestHelper.getClusterStateWithDataStreams(dataStreams, indexNames, currentTime, settings, replicas, replicated, false);
    }

    public static ClusterState getClusterStateWithDataStreams(List<Tuple<String, Integer>> dataStreams, List<String> indexNames, long currentTime, Settings settings, int replicas, boolean replicated, boolean storeFailures) {
        Metadata.Builder builder = Metadata.builder();
        DataStreamTestHelper.getClusterStateWithDataStreams(builder, dataStreams, indexNames, currentTime, settings, replicas, replicated, storeFailures);
        return ClusterState.builder((ClusterName)new ClusterName("_name")).metadata(builder).build();
    }

    public static void getClusterStateWithDataStreams(Metadata.Builder builder, List<Tuple<String, Integer>> dataStreams, List<String> indexNames, long currentTime, Settings settings, int replicas, boolean replicated, boolean storeFailures) {
        builder.put("template_1", ComposableIndexTemplate.builder().indexPatterns(List.of("*")).dataStreamTemplate(new ComposableIndexTemplate.DataStreamTemplate(false, false, DataStream.isFailureStoreFeatureFlagEnabled() && storeFailures)).build());
        ArrayList allIndices = new ArrayList();
        for (Tuple<String, Integer> dsTuple : dataStreams) {
            ArrayList<IndexMetadata> backingIndices = new ArrayList<IndexMetadata>();
            for (int backingIndexNumber = 1; backingIndexNumber <= (Integer)dsTuple.v2(); ++backingIndexNumber) {
                backingIndices.add(DataStreamTestHelper.createIndexMetadata(DataStream.getDefaultBackingIndexName((String)((String)dsTuple.v1()), (long)backingIndexNumber, (long)currentTime), true, settings, replicas));
            }
            allIndices.addAll(backingIndices);
            ArrayList<IndexMetadata> failureStores = new ArrayList<IndexMetadata>();
            if (DataStream.isFailureStoreFeatureFlagEnabled() && storeFailures) {
                for (int failureStoreNumber = 1; failureStoreNumber <= (Integer)dsTuple.v2(); ++failureStoreNumber) {
                    failureStores.add(DataStreamTestHelper.createIndexMetadata(DataStream.getDefaultFailureStoreName((String)((String)dsTuple.v1()), (long)failureStoreNumber, (long)currentTime), true, settings, replicas));
                }
                allIndices.addAll(failureStores);
            }
            DataStream ds = DataStreamTestHelper.newInstance((String)dsTuple.v1(), backingIndices.stream().map(IndexMetadata::getIndex).collect(Collectors.toList()), (long)((Integer)dsTuple.v2()).intValue(), null, replicated, null, failureStores.stream().map(IndexMetadata::getIndex).collect(Collectors.toList()));
            builder.put(ds);
        }
        for (String indexName : indexNames) {
            allIndices.add(DataStreamTestHelper.createIndexMetadata(indexName, false, settings, replicas));
        }
        for (IndexMetadata index : allIndices) {
            builder.put(index, false);
        }
    }

    public static ClusterState getClusterStateWithDataStream(String dataStream, List<Tuple<Instant, Instant>> timeSlices) {
        Metadata.Builder builder = Metadata.builder();
        DataStreamTestHelper.getClusterStateWithDataStream(builder, dataStream, timeSlices);
        return ClusterState.builder((ClusterName)new ClusterName("_name")).metadata(builder).build();
    }

    public static void getClusterStateWithDataStream(Metadata.Builder builder, String dataStreamName, List<Tuple<Instant, Instant>> timeSlices) {
        ArrayList<IndexMetadata> backingIndices = new ArrayList<IndexMetadata>();
        DataStream existing = builder.dataStream(dataStreamName);
        if (existing != null) {
            for (Index index : existing.getIndices()) {
                backingIndices.add(builder.getSafe(index));
            }
        }
        long generation = existing != null ? existing.getGeneration() + 1L : 1L;
        for (Tuple<Instant, Instant> tuple : timeSlices) {
            Instant start = (Instant)tuple.v1();
            Instant end = (Instant)tuple.v2();
            Settings settings = Settings.builder().put("index.mode", "time_series").put("index.routing_path", "uid").put(IndexSettings.TIME_SERIES_START_TIME.getKey(), DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format((TemporalAccessor)start)).put(IndexSettings.TIME_SERIES_END_TIME.getKey(), DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format((TemporalAccessor)end)).build();
            IndexMetadata im = DataStreamTestHelper.createIndexMetadata(DataStream.getDefaultBackingIndexName((String)dataStreamName, (long)generation, (long)start.toEpochMilli()), true, settings, 0);
            builder.put(im, true);
            backingIndices.add(im);
            ++generation;
        }
        DataStream.Builder dataStreamBuilder = DataStream.builder((String)dataStreamName, backingIndices.stream().map(IndexMetadata::getIndex).collect(Collectors.toList())).setGeneration(generation).setIndexMode(IndexMode.TIME_SERIES);
        if (existing != null) {
            dataStreamBuilder.setMetadata(existing.getMetadata()).setHidden(existing.isHidden()).setReplicated(existing.isReplicated()).setSystem(existing.isSystem()).setAllowCustomRouting(existing.isAllowCustomRouting());
        }
        builder.put(dataStreamBuilder.build());
    }

    private static IndexMetadata createIndexMetadata(String name, boolean hidden, Settings settings, int replicas) {
        Settings.Builder b = Settings.builder().put(settings).put("index.version.created", (VersionId)IndexVersion.current()).put("index.hidden", hidden);
        return IndexMetadata.builder((String)name).settings(b).numberOfShards(1).numberOfReplicas(replicas).build();
    }

    public static String backingIndexPattern(String dataStreamName, long generation) {
        return String.format(Locale.ROOT, "\\.ds-%s-(\\d{4}\\.\\d{2}\\.\\d{2}-)?%06d", dataStreamName, generation);
    }

    public static Matcher<String> backingIndexEqualTo(final String dataStreamName, final int generation) {
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String backingIndexName) {
                if (backingIndexName == null) {
                    return false;
                }
                int indexOfLastDash = backingIndexName.lastIndexOf(45);
                String actualDataStreamName = 1.parseDataStreamName(backingIndexName, indexOfLastDash);
                int actualGeneration = 1.parseGeneration(backingIndexName, indexOfLastDash);
                return actualDataStreamName.equals(dataStreamName) && actualGeneration == generation;
            }

            protected void describeMismatchSafely(String backingIndexName, Description mismatchDescription) {
                int indexOfLastDash = backingIndexName.lastIndexOf(45);
                String dataStreamName2 = 1.parseDataStreamName(backingIndexName, indexOfLastDash);
                int generation2 = 1.parseGeneration(backingIndexName, indexOfLastDash);
                mismatchDescription.appendText(" was data stream name ").appendValue((Object)dataStreamName2).appendText(" and generation ").appendValue((Object)generation2);
            }

            public void describeTo(Description description) {
                description.appendText("expected data stream name ").appendValue((Object)dataStreamName).appendText(" and expected generation ").appendValue((Object)generation);
            }

            private static String parseDataStreamName(String backingIndexName, int indexOfLastDash) {
                return backingIndexName.substring(4, backingIndexName.lastIndexOf(45, indexOfLastDash - 1));
            }

            private static int parseGeneration(String backingIndexName, int indexOfLastDash) {
                return Integer.parseInt(backingIndexName.substring(indexOfLastDash + 1));
            }
        };
    }

    public static MetadataRolloverService getMetadataRolloverService(DataStream dataStream, ThreadPool testThreadPool, Set<IndexSettingProvider> providers, NamedXContentRegistry registry, TelemetryProvider telemetryProvider) throws Exception {
        DateFieldMapper dateFieldMapper = new DateFieldMapper.Builder("@timestamp", DateFieldMapper.Resolution.MILLISECONDS, null, ScriptCompiler.NONE, false, IndexVersion.current()).build(MapperBuilderContext.root((boolean)false, (boolean)true));
        ClusterService clusterService = ClusterServiceUtils.createClusterService(testThreadPool);
        Environment env = (Environment)Mockito.mock(Environment.class);
        Mockito.when((Object)env.sharedDataFile()).thenReturn(null);
        AllocationService allocationService = (AllocationService)Mockito.mock(AllocationService.class);
        Mockito.when((Object)allocationService.reroute((ClusterState)ArgumentMatchers.any(ClusterState.class), (String)ArgumentMatchers.any(String.class), (ActionListener)ArgumentMatchers.any())).then(i -> i.getArguments()[0]);
        Mockito.when((Object)allocationService.getShardRoutingRoleStrategy()).thenReturn((Object)TestShardRoutingRoleStrategies.DEFAULT_ROLE_ONLY);
        MappingLookup mappingLookup = MappingLookup.EMPTY;
        if (dataStream != null) {
            RootObjectMapper.Builder root = new RootObjectMapper.Builder("_doc", ObjectMapper.Defaults.SUBOBJECTS);
            root.add((Mapper.Builder)new DateFieldMapper.Builder("@timestamp", DateFieldMapper.Resolution.MILLISECONDS, DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER, ScriptCompiler.NONE, true, IndexVersion.current()));
            MetadataFieldMapper dtfm = DataStreamTestHelper.getDataStreamTimestampFieldMapper();
            Mapping mapping = new Mapping(root.build(MapperBuilderContext.root((boolean)false, (boolean)true)), new MetadataFieldMapper[]{dtfm}, Collections.emptyMap());
            mappingLookup = MappingLookup.fromMappers((Mapping)mapping, List.of(dtfm, dateFieldMapper), List.of());
        }
        IndicesService indicesService = DataStreamTestHelper.mockIndicesServices(mappingLookup);
        ShardLimitValidator shardLimitValidator = new ShardLimitValidator(Settings.EMPTY, clusterService);
        MetadataCreateIndexService createIndexService = new MetadataCreateIndexService(Settings.EMPTY, clusterService, indicesService, allocationService, shardLimitValidator, env, IndexScopedSettings.DEFAULT_SCOPED_SETTINGS, testThreadPool, null, EmptySystemIndices.INSTANCE, false, new IndexSettingProviders(providers));
        MetadataIndexAliasesService indexAliasesService = new MetadataIndexAliasesService(clusterService, indicesService, registry);
        return new MetadataRolloverService(testThreadPool, createIndexService, indexAliasesService, EmptySystemIndices.INSTANCE, WriteLoadForecaster.DEFAULT, clusterService, telemetryProvider);
    }

    public static MetadataFieldMapper getDataStreamTimestampFieldMapper() {
        HashMap<String, Boolean> fieldsMapping = new HashMap<String, Boolean>();
        fieldsMapping.put("enabled", true);
        MappingParserContext mockedParserContext = (MappingParserContext)Mockito.mock(MappingParserContext.class);
        return DataStreamTimestampFieldMapper.PARSER.parse("field", fieldsMapping, mockedParserContext).build();
    }

    public static IndicesService mockIndicesServices(MappingLookup mappingLookup) throws Exception {
        IndicesService indicesService = (IndicesService)Mockito.mock(IndicesService.class);
        Mockito.when((Object)indicesService.withTempIndexService((IndexMetadata)ArgumentMatchers.any(IndexMetadata.class), (CheckedFunction)ArgumentMatchers.any(CheckedFunction.class))).then(invocationOnMock -> {
            IndexService indexService = (IndexService)Mockito.mock(IndexService.class);
            IndexMetadata indexMetadata = (IndexMetadata)invocationOnMock.getArguments()[0];
            Mockito.when((Object)indexService.index()).thenReturn((Object)indexMetadata.getIndex());
            MapperService mapperService = (MapperService)Mockito.mock(MapperService.class);
            RootObjectMapper root = new RootObjectMapper.Builder("_doc", ObjectMapper.Defaults.SUBOBJECTS).build(MapperBuilderContext.root((boolean)false, (boolean)false));
            Mapping mapping = new Mapping(root, new MetadataFieldMapper[0], null);
            DocumentMapper documentMapper = (DocumentMapper)Mockito.mock(DocumentMapper.class);
            Mockito.when((Object)documentMapper.mapping()).thenReturn((Object)mapping);
            Mockito.when((Object)documentMapper.mappers()).thenReturn((Object)MappingLookup.EMPTY);
            Mockito.when((Object)documentMapper.mappingSource()).thenReturn((Object)mapping.toCompressedXContent());
            Mockito.when((Object)documentMapper.mappers()).thenReturn((Object)mappingLookup);
            RoutingFieldMapper routingFieldMapper = (RoutingFieldMapper)Mockito.mock(RoutingFieldMapper.class);
            Mockito.when((Object)routingFieldMapper.required()).thenReturn((Object)false);
            Mockito.when((Object)documentMapper.routingFieldMapper()).thenReturn((Object)routingFieldMapper);
            Mockito.when((Object)mapperService.documentMapper()).thenReturn((Object)documentMapper);
            Mockito.when((Object)indexService.mapperService()).thenReturn((Object)mapperService);
            Mockito.when((Object)mapperService.mappingLookup()).thenReturn((Object)mappingLookup);
            Mockito.when((Object)indexService.getIndexEventListener()).thenReturn((Object)new IndexEventListener(){});
            Mockito.when((Object)indexService.getIndexSortSupplier()).thenReturn(() -> null);
            return ((CheckedFunction)invocationOnMock.getArguments()[1]).apply((Object)indexService);
        });
        return indicesService;
    }
}

