/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.generators.BiasedNumbers;
import java.util.ArrayList;
import java.util.Random;
import org.apache.lucene.geo.XYCircle;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.tests.util.TestUtil;

public class XShapeTestUtil {
    public static final float CENTER_SCALE_FACTOR = 0.001f;
    private static final float MIN_DIFF = 1.0E-10f;

    public static XYPolygon nextPolygon() {
        if (XShapeTestUtil.random().nextBoolean()) {
            return XShapeTestUtil.surpriseMePolygon();
        }
        if (XShapeTestUtil.random().nextInt(10) == 1) {
            while (true) {
                int gons = TestUtil.nextInt((Random)XShapeTestUtil.random(), (int)4, (int)500);
                try {
                    return XShapeTestUtil.createRegularPolygon(XShapeTestUtil.nextDouble() * (double)0.001f, XShapeTestUtil.nextDouble() * (double)0.001f, XShapeTestUtil.nextRadius(), gons);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                break;
            }
        }
        XYRectangle box = XShapeTestUtil.nextBoxInternal();
        if (XShapeTestUtil.random().nextBoolean()) {
            return XShapeTestUtil.boxPolygon(box);
        }
        return XShapeTestUtil.trianglePolygon(box);
    }

    private static double nextRadius() {
        return XShapeTestUtil.random().nextDouble() * (double)0.001f * 3.4028234663852886E38 + 1.0;
    }

    private static XYPolygon trianglePolygon(XYRectangle box) {
        float[] polyX = new float[4];
        float[] polyY = new float[4];
        polyX[0] = box.minX;
        polyY[0] = box.minY;
        polyX[1] = box.minX;
        polyY[1] = box.maxY;
        polyX[2] = box.maxX;
        polyY[2] = box.maxY;
        polyX[3] = box.minX;
        polyY[3] = box.minY;
        return XShapeTestUtil.validatePolygon(new XYPolygon(polyX, polyY, new XYPolygon[0]));
    }

    public static XYRectangle nextBox() {
        return XShapeTestUtil.nextBoxInternal();
    }

    private static XYRectangle nextBoxInternal() {
        float x0 = XShapeTestUtil.nextFloat() * 0.001f;
        float x1 = XShapeTestUtil.nextFloat() * 0.001f;
        while (Math.abs(x1 - x0) < 1.0E-10f) {
            x1 = XShapeTestUtil.nextFloat() * 0.001f;
        }
        float y0 = XShapeTestUtil.nextFloat() * 0.001f;
        float y1 = XShapeTestUtil.nextFloat() * 0.001f;
        while (Math.abs(y1 - y0) < 1.0E-10f) {
            y1 = XShapeTestUtil.nextFloat() * 0.001f;
        }
        if (x1 < x0) {
            float x = x0;
            x0 = x1;
            x1 = x;
        }
        if (y1 < y0) {
            float y = y0;
            y0 = y1;
            y1 = y;
        }
        return new XYRectangle(x0, x1, y0, y1);
    }

    private static XYPolygon boxPolygon(XYRectangle box) {
        float[] polyX = new float[5];
        float[] polyY = new float[5];
        polyX[0] = box.minX;
        polyY[0] = box.minY;
        polyX[1] = box.minX;
        polyY[1] = box.maxY;
        polyX[2] = box.maxX;
        polyY[2] = box.maxY;
        polyX[3] = box.maxX;
        polyY[3] = box.minY;
        polyX[4] = box.minX;
        polyY[4] = box.minY;
        return XShapeTestUtil.validatePolygon(new XYPolygon(polyX, polyY, new XYPolygon[0]));
    }

    private static XYPolygon validatePolygon(XYPolygon polygon) {
        if (XShapeTestUtil.validPolygon(polygon)) {
            return polygon;
        }
        throw new IllegalArgumentException("Invalid polygon: " + polygon);
    }

    private static XYPolygon surpriseMePolygon() {
        float[] yArray;
        float[] xArray;
        XYPolygon polygon;
        do {
            double centerX = XShapeTestUtil.nextDouble() * (double)0.001f;
            double centerY = XShapeTestUtil.nextDouble() * (double)0.001f;
            double radius = XShapeTestUtil.nextRadius();
            double radiusDelta = XShapeTestUtil.random().nextDouble();
            ArrayList<Float> xList = new ArrayList<Float>();
            ArrayList<Float> yList = new ArrayList<Float>();
            double angle = 0.0;
            while (!((angle += XShapeTestUtil.random().nextDouble() * 40.0) > 360.0)) {
                double len = radius * (1.0 - radiusDelta + radiusDelta * XShapeTestUtil.random().nextDouble());
                double maxX = StrictMath.min(StrictMath.abs(3.4028234663852886E38 - centerX), StrictMath.abs(-3.4028234663852886E38 - centerX));
                double maxY = StrictMath.min(StrictMath.abs(3.4028234663852886E38 - centerY), StrictMath.abs(-3.4028234663852886E38 - centerY));
                len = StrictMath.min(len, StrictMath.min(maxX, maxY));
                float x = (float)(centerX + len * Math.cos(Math.toRadians(angle)));
                float y = (float)(centerY + len * Math.sin(Math.toRadians(angle)));
                xList.add(Float.valueOf(x));
                yList.add(Float.valueOf(y));
            }
            xList.add((Float)xList.get(0));
            yList.add((Float)yList.get(0));
            xArray = new float[xList.size()];
            yArray = new float[yList.size()];
            for (int i = 0; i < xList.size(); ++i) {
                xArray[i] = ((Float)xList.get(i)).floatValue();
                yArray[i] = ((Float)yList.get(i)).floatValue();
            }
        } while (!XShapeTestUtil.validPolygon(polygon = new XYPolygon(xArray, yArray, new XYPolygon[0])));
        return polygon;
    }

    public static XYPolygon createRegularPolygon(double centerX, double centerY, double radius, int gons) {
        double maxX = StrictMath.min(StrictMath.abs(3.4028234663852886E38 - centerX), StrictMath.abs(-3.4028234663852886E38 - centerX));
        double maxY = StrictMath.min(StrictMath.abs(3.4028234663852886E38 - centerY), StrictMath.abs(-3.4028234663852886E38 - centerY));
        radius = StrictMath.min(radius, StrictMath.min(maxX, maxY));
        float[][] result = new float[][]{new float[gons + 1], new float[gons + 1]};
        for (int i = 0; i < gons; ++i) {
            double angle = 360.0 - (double)i * (360.0 / (double)gons);
            double x = Math.cos(StrictMath.toRadians(angle));
            double y = Math.sin(StrictMath.toRadians(angle));
            result[0][i] = (float)(centerY + y * radius);
            result[1][i] = (float)(centerX + x * radius);
        }
        result[0][gons] = result[0][0];
        result[1][gons] = result[1][0];
        return XShapeTestUtil.validatePolygon(new XYPolygon(result[0], result[1], new XYPolygon[0]));
    }

    private static boolean validPolygon(XYPolygon polygon) {
        return !XShapeTestUtil.sameValues(polygon.getPolyX()) && !XShapeTestUtil.sameValues(polygon.getPolyY());
    }

    private static boolean sameValues(float[] values) {
        int consecutiveSame = 0;
        for (int i = 1; i < values.length; ++i) {
            if (!(Math.abs(values[i] - values[i - 1]) <= 1.0E-10f)) continue;
            ++consecutiveSame;
        }
        return consecutiveSame > values.length / 2;
    }

    public static double nextDouble() {
        return BiasedNumbers.randomDoubleBetween((Random)XShapeTestUtil.random(), (double)-3.4028234663852886E38, (double)3.4028234663852886E38);
    }

    public static float nextFloat() {
        return BiasedNumbers.randomFloatBetween((Random)XShapeTestUtil.random(), (float)-3.4028235E38f, (float)Float.MAX_VALUE);
    }

    private static Random random() {
        return RandomizedContext.current().getRandom();
    }

    public static XYCircle nextCircle() {
        float centerX = XShapeTestUtil.nextFloat() * 0.001f;
        float centerY = XShapeTestUtil.nextFloat() * 0.001f;
        float radius = (float)XShapeTestUtil.nextRadius();
        double maxX = StrictMath.min(StrictMath.abs(Float.MAX_VALUE - centerX), StrictMath.abs(-3.4028235E38f - centerX));
        double maxY = StrictMath.min(StrictMath.abs(Float.MAX_VALUE - centerY), StrictMath.abs(-3.4028235E38f - centerY));
        radius = Math.min(radius, (float)maxX);
        radius = Math.min(radius, (float)maxY);
        return new XYCircle(centerX, centerY, radius);
    }
}

