/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.Matchers;

public class RecoveryClusterStateDelayListeners
implements Releasable {
    private final Map<Long, SubscribableListener<Void>> clusterStateBarriers = ConcurrentCollections.newConcurrentMap();
    private final SubscribableListener<Void> startRecoveryListener = new SubscribableListener();
    private final CountDownLatch completeLatch = new CountDownLatch(1);
    private final RefCounted refCounted = AbstractRefCounted.of(this.completeLatch::countDown);
    private final List<Runnable> cleanup = new ArrayList<Runnable>(2);
    private final long initialClusterStateVersion;

    public RecoveryClusterStateDelayListeners(long initialClusterStateVersion) {
        this.initialClusterStateVersion = initialClusterStateVersion;
    }

    public void close() {
        this.refCounted.decRef();
        ESTestCase.safeAwait(this.completeLatch);
        this.cleanup.forEach(Runnable::run);
        this.clusterStateBarriers.values().forEach(l -> l.onResponse(null));
    }

    public void addCleanup(Runnable runnable) {
        this.cleanup.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscribableListener<Void> getClusterStateDelayListener(long clusterStateVersion) {
        ESTestCase.assertThat(clusterStateVersion, Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(this.initialClusterStateVersion)));
        if (this.refCounted.tryIncRef()) {
            try {
                SubscribableListener subscribableListener = this.clusterStateBarriers.computeIfAbsent(clusterStateVersion, ignored -> new SubscribableListener());
                return subscribableListener;
            }
            finally {
                this.refCounted.decRef();
            }
        }
        return SubscribableListener.newSucceeded(null);
    }

    public void onStartRecovery() {
        Thread.yield();
        ESTestCase.assertFalse((boolean)this.startRecoveryListener.isDone());
        this.startRecoveryListener.onResponse(null);
    }

    public void delayUntilRecoveryStart(SubscribableListener<Void> listener) {
        this.startRecoveryListener.addListener(listener);
    }
}

