/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.elasticsearch.logsdb.datageneration.DataGeneratorSpecification;
import org.elasticsearch.logsdb.datageneration.FieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.FieldType;
import org.elasticsearch.logsdb.datageneration.Mapping;
import org.elasticsearch.logsdb.datageneration.Template;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.logsdb.datageneration.fields.PredefinedField;

public class DocumentGenerator {
    private final DataGeneratorSpecification specification;
    private final DataSourceResponse.ObjectArrayGenerator objectArrayGenerator;

    public DocumentGenerator(DataGeneratorSpecification specification) {
        this.specification = specification;
        this.objectArrayGenerator = specification.dataSource().get(new DataSourceRequest.ObjectArrayGenerator());
    }

    public Map<String, Object> generate(Template template, Mapping mapping) {
        TreeMap<String, Object> documentMap = new TreeMap<String, Object>();
        for (PredefinedField predefinedField : this.specification.predefinedFields()) {
            documentMap.put(predefinedField.name(), predefinedField.generator(this.specification.dataSource()).generateValue());
        }
        this.generateFields(documentMap, template.template(), new Context("", mapping.lookup()));
        return documentMap;
    }

    private void generateFields(Map<String, Object> document, Map<String, Template.Entry> template, Context context) {
        for (Map.Entry<String, Template.Entry> entry : template.entrySet()) {
            String fieldName = entry.getKey();
            Template.Entry templateEntry = entry.getValue();
            if (templateEntry instanceof Template.Leaf) {
                Template.Leaf leaf = (Template.Leaf)templateEntry;
                if (leaf.type() == FieldType.UNSIGNED_LONG && context.mappingLookup().get(context.pathTo(fieldName)) == null) continue;
                FieldDataGenerator generator = leaf.type().generator(fieldName, this.specification.dataSource());
                document.put(fieldName, generator.generateValue());
                continue;
            }
            if (!(templateEntry instanceof Template.Object)) continue;
            Template.Object object = (Template.Object)templateEntry;
            Optional<Integer> arrayLength = this.objectArrayGenerator.lengthGenerator().get();
            if (arrayLength.isPresent()) {
                ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>(arrayLength.get());
                document.put(object.name(), children);
                for (int i = 0; i < arrayLength.get(); ++i) {
                    children.add(this.generateObject(object, context));
                }
                continue;
            }
            document.put(object.name(), this.generateObject(object, context));
        }
    }

    private Map<String, Object> generateObject(Template.Object object, Context context) {
        TreeMap<String, Object> children = new TreeMap<String, Object>();
        this.generateFields(children, object.children(), context.stepIntoObject(object.name()));
        return children;
    }

    record Context(String path, Map<String, Map<String, Object>> mappingLookup) {
        Context stepIntoObject(String name) {
            return new Context(this.pathTo(name), this.mappingLookup);
        }

        String pathTo(String leafFieldName) {
            return this.path.isEmpty() ? leafFieldName : this.path + "." + leafFieldName;
        }
    }
}

