/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration.datasource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceHandler;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.logsdb.datageneration.datasource.DefaultMappingParametersHandler;
import org.elasticsearch.logsdb.datageneration.datasource.DefaultObjectGenerationHandler;
import org.elasticsearch.logsdb.datageneration.datasource.DefaultPrimitiveTypesHandler;
import org.elasticsearch.logsdb.datageneration.datasource.DefaultWrappersHandler;

public class DataSource {
    private List<DataSourceHandler> handlers = new ArrayList<DataSourceHandler>();

    public DataSource(Collection<DataSourceHandler> additionalHandlers) {
        this.handlers.addAll(additionalHandlers);
        this.handlers.add(new DefaultPrimitiveTypesHandler());
        this.handlers.add(new DefaultWrappersHandler());
        this.handlers.add(new DefaultObjectGenerationHandler());
        this.handlers.add(new DefaultMappingParametersHandler());
    }

    public <T extends DataSourceResponse> T get(DataSourceRequest<T> request) {
        for (DataSourceHandler handler : this.handlers) {
            T response = request.accept(handler);
            if (response == null) continue;
            return response;
        }
        throw new IllegalStateException("Request is not supported by data source");
    }
}

