/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.test.AbstractNamedWriteableTestCase;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.hamcrest.Matchers;

public abstract class InternalAggregationTestCase<T extends InternalAggregation>
extends AbstractNamedWriteableTestCase<T> {
    public static final int DEFAULT_MAX_BUCKETS = 100000;
    protected static final double TOLERANCE = 1.0E-10;
    private final NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(this.getNamedWriteables());

    public static AggregationReduceContext.Builder emptyReduceContextBuilder() {
        return InternalAggregationTestCase.emptyReduceContextBuilder(AggregatorFactories.builder());
    }

    public static AggregationReduceContext.Builder emptyReduceContextBuilder(final AggregatorFactories.Builder aggs) {
        return new AggregationReduceContext.Builder(){

            public AggregationReduceContext forPartialReduction() {
                return new AggregationReduceContext.ForPartial(BigArrays.NON_RECYCLING_INSTANCE, null, () -> false, aggs, b -> {});
            }

            public AggregationReduceContext forFinalReduction() {
                return new AggregationReduceContext.ForFinal(BigArrays.NON_RECYCLING_INSTANCE, null, () -> false, aggs, b -> {});
            }
        };
    }

    public static AggregationReduceContext.Builder mockReduceContext(final AggregationBuilder agg) {
        return new AggregationReduceContext.Builder(){

            public AggregationReduceContext forPartialReduction() {
                return new AggregationReduceContext.ForPartial(BigArrays.NON_RECYCLING_INSTANCE, null, () -> false, agg, b -> {});
            }

            public AggregationReduceContext forFinalReduction() {
                return new AggregationReduceContext.ForFinal(BigArrays.NON_RECYCLING_INSTANCE, null, () -> false, agg, b -> {}, PipelineAggregator.PipelineTree.EMPTY);
            }
        };
    }

    public static InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        try (AggregatorReducer reducer = aggregations.get(0).getReducer(reduceContext, aggregations.size());){
            for (InternalAggregation aggregation : aggregations) {
                reducer.accept(aggregation);
            }
            InternalAggregation internalAggregation = reducer.get();
            return internalAggregation;
        }
    }

    @Override
    protected final NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }

    protected List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        SearchPlugin plugin = this.registerPlugin();
        SearchModule searchModule = new SearchModule(Settings.EMPTY, plugin == null ? Collections.emptyList() : List.of(plugin));
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>(searchModule.getNamedWriteables());
        if (plugin != null) {
            entries.addAll(((Plugin)plugin).getNamedWriteables());
        }
        return entries;
    }

    protected SearchPlugin registerPlugin() {
        return null;
    }

    protected abstract T createTestInstance(String var1, Map<String, Object> var2);

    protected T createUnmappedInstance(String name, Map<String, Object> metadata) {
        return this.createTestInstance(name, metadata);
    }

    @Override
    protected final Class<T> categoryClass() {
        return InternalAggregation.class;
    }

    protected BuilderAndToReduce<T> randomResultsToReduce(String name, int size) {
        ArrayList<T> inputs = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            T t = InternalAggregationTestCase.randomBoolean() ? this.createUnmappedInstance(name) : this.createTestInstance(name);
            inputs.add(t);
        }
        return new BuilderAndToReduce(this.mockBuilder(inputs), inputs);
    }

    protected final AggregationBuilder mockBuilder(List<? extends InternalAggregation> results) {
        HashMap<String, Object> subNames = new HashMap<String, Object>();
        results.forEach(a -> InternalAggregationTestCase.collectSubBuilderNames(subNames, a));
        return this.mockBuilder(results.get(0).getName(), subNames);
    }

    private AggregationBuilder mockBuilder(String name, Map<String, Object> subNames) {
        MockAggregationBuilder b = new MockAggregationBuilder(name);
        for (Map.Entry<String, Object> s : subNames.entrySet()) {
            Map subSubNames = (Map)s.getValue();
            b.subAggregation(this.mockBuilder(s.getKey(), subSubNames));
        }
        return b;
    }

    private static void collectSubBuilderNames(Map<String, Object> names, InternalAggregation result) {
        result.forEachBucket(ia -> {
            for (InternalAggregation a : ia.copyResults()) {
                Map sub = (Map)names.computeIfAbsent(a.getName(), k -> new HashMap());
                InternalAggregationTestCase.collectSubBuilderNames(sub, a);
            }
        });
    }

    protected boolean supportsOutOfOrderReduce() {
        return true;
    }

    public void testReduceRandom() throws IOException {
        String name = InternalAggregationTestCase.randomAlphaOfLength(5);
        int size = InternalAggregationTestCase.between(1, 200);
        BuilderAndToReduce<T> inputs = this.randomResultsToReduce(name, size);
        InternalAggregationTestCase.assertThat(inputs.toReduce(), Matchers.hasSize((int)size));
        ArrayList<Object> toReduce = new ArrayList<InternalAggregation>();
        toReduce.addAll(inputs.toReduce());
        ScriptService mockScriptService = this.mockScriptService();
        MockBigArrays bigArrays = new MockBigArrays((PageCacheRecycler)new MockPageCacheRecycler(Settings.EMPTY), (CircuitBreakerService)new NoneCircuitBreakerService());
        if (InternalAggregationTestCase.randomBoolean() && toReduce.size() > 1) {
            if (this.supportsOutOfOrderReduce()) {
                Collections.shuffle(toReduce, InternalAggregationTestCase.random());
            }
            int r = InternalAggregationTestCase.randomIntBetween(1, toReduce.size());
            List<InternalAggregation> toPartialReduce = toReduce.subList(0, r);
            AggregationReduceContext.ForPartial context = new AggregationReduceContext.ForPartial((BigArrays)bigArrays, mockScriptService, () -> false, inputs.builder(), b -> {});
            InternalAggregation reduced = InternalAggregationTestCase.reduce(toPartialReduce, (AggregationReduceContext)context);
            int initialBucketCount = 0;
            for (InternalAggregation internalAggregation : toPartialReduce) {
                initialBucketCount += InternalMultiBucketAggregation.countInnerBucket((Aggregation)internalAggregation);
            }
            int reducedBucketCount = InternalMultiBucketAggregation.countInnerBucket((Aggregation)reduced);
            InternalAggregationTestCase.assertThat(reducedBucketCount, Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(initialBucketCount)));
            if (InternalAggregationTestCase.randomBoolean()) {
                reduced = (InternalAggregation)InternalAggregationTestCase.copyNamedWriteable(reduced, this.getNamedWriteableRegistry(), this.categoryClass());
            }
            toReduce = new ArrayList(toReduce.subList(r, toReduce.size()));
            toReduce.add(reduced);
        }
        MultiBucketConsumerService.MultiBucketConsumer bucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(100000, new NoneCircuitBreakerService().getBreaker("request"));
        AggregationReduceContext.ForFinal context = new AggregationReduceContext.ForFinal((BigArrays)bigArrays, mockScriptService, () -> false, inputs.builder(), (IntConsumer)bucketConsumer, PipelineAggregator.PipelineTree.EMPTY);
        InternalAggregation reduced = InternalAggregationTestCase.reduce(toReduce, (AggregationReduceContext)context);
        this.doAssertReducedMultiBucketConsumer((Aggregation)reduced, bucketConsumer);
        this.assertReduced(reduced, inputs.toReduce());
        if (this.supportsSampling()) {
            SamplingContext randomContext = new SamplingContext(InternalAggregationTestCase.randomDoubleBetween(1.0E-8, 0.1, false), InternalAggregationTestCase.randomInt(), InternalAggregationTestCase.randomBoolean() ? null : Integer.valueOf(InternalAggregationTestCase.randomInt()));
            InternalAggregation sampled = reduced.finalizeSampling(randomContext);
            this.assertSampled(sampled, reduced, randomContext);
        }
    }

    protected void doAssertReducedMultiBucketConsumer(Aggregation agg, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
        InternalAggregationTestCase.assertMultiBucketConsumer(agg, bucketConsumer);
    }

    protected ScriptService mockScriptService() {
        return null;
    }

    protected abstract void assertReduced(T var1, List<T> var2);

    protected void assertSampled(T sampled, T reduced, SamplingContext samplingContext) {
        throw new UnsupportedOperationException("aggregation supports sampling but does not implement assertSampled");
    }

    @Override
    public final T createTestInstance() {
        return this.createTestInstance(InternalAggregationTestCase.randomAlphaOfLength(5));
    }

    protected boolean supportsSampling() {
        return false;
    }

    public final Map<String, Object> createTestMetadata() {
        HashMap<String, String> metadata = null;
        if (InternalAggregationTestCase.randomBoolean()) {
            metadata = new HashMap<String, String>();
            int metadataCount = InternalAggregationTestCase.between(0, 10);
            while (metadata.size() < metadataCount) {
                metadata.put(InternalAggregationTestCase.randomAlphaOfLength(5), InternalAggregationTestCase.randomAlphaOfLength(5));
            }
        }
        return metadata;
    }

    private T createTestInstance(String name) {
        return this.createTestInstance(name, this.createTestMetadata());
    }

    protected final T createUnmappedInstance(String name) {
        int metadataCount;
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        int n = metadataCount = InternalAggregationTestCase.randomBoolean() ? 0 : InternalAggregationTestCase.between(1, 10);
        while (metadata.size() < metadataCount) {
            metadata.put(InternalAggregationTestCase.randomAlphaOfLength(5), InternalAggregationTestCase.randomAlphaOfLength(5));
        }
        return this.createUnmappedInstance(name, metadata);
    }

    public T createTestInstanceForXContent() {
        return this.createTestInstance();
    }

    public static DocValueFormat randomNumericDocValueFormat() {
        ArrayList<Supplier<DocValueFormat>> formats = new ArrayList<Supplier<DocValueFormat>>(3);
        formats.add(() -> DocValueFormat.RAW);
        formats.add(() -> new DocValueFormat.Decimal(InternalAggregationTestCase.randomFrom("###.##", "###,###.##")));
        return (DocValueFormat)((Supplier)InternalAggregationTestCase.randomFrom(formats)).get();
    }

    public static DocValueFormat randomDateDocValueFormat() {
        DocValueFormat.DateTime format = new DocValueFormat.DateTime(DateFormatter.forPattern((String)InternalAggregationTestCase.randomDateFormatterPattern()), InternalAggregationTestCase.randomZone(), InternalAggregationTestCase.randomFrom(DateFieldMapper.Resolution.values()));
        if (InternalAggregationTestCase.randomBoolean()) {
            return DocValueFormat.enableFormatSortValues((DocValueFormat)format);
        }
        return format;
    }

    public static void assertMultiBucketConsumer(Aggregation agg, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
        InternalAggregationTestCase.assertMultiBucketConsumer(InternalMultiBucketAggregation.countInnerBucket((Aggregation)agg), bucketConsumer);
    }

    private static void assertMultiBucketConsumer(int innerBucketCount, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
        InternalAggregationTestCase.assertThat(bucketConsumer.getCount(), Matchers.equalTo((Object)innerBucketCount));
    }

    public record BuilderAndToReduce<T>(AggregationBuilder builder, List<T> toReduce) {
    }

    private class MockAggregationBuilder
    extends AbstractAggregationBuilder<MockAggregationBuilder> {
        MockAggregationBuilder(String name) {
            super(name);
        }

        public String getType() {
            throw new UnsupportedOperationException();
        }

        protected void doWriteTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
            throw new UnsupportedOperationException();
        }

        public AggregationBuilder.BucketCardinality bucketCardinality() {
            throw new UnsupportedOperationException();
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.ZERO;
        }
    }
}

