/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.FilePermission;
import java.io.IOException;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.function.Supplier;
import javax.tools.JavaCompiler;
import org.elasticsearch.core.SuppressForbidden;

public final class PrivilegedOperations {
    private static final AccessControlContext context = PrivilegedOperations.getContext();

    private PrivilegedOperations() {
    }

    public static void closeURLClassLoader(URLClassLoader loader) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                loader.close();
                return null;
            }, context, new RuntimePermission("closeClassLoader"));
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof IOException) {
                IOException ioe = (IOException)e;
                throw ioe;
            }
            throw new IOException(e);
        }
    }

    public static Boolean compilationTaskCall(JavaCompiler.CompilationTask compilationTask) {
        return AccessController.doPrivileged(() -> compilationTask.call(), context, new RuntimePermission("createClassLoader"), new RuntimePermission("closeClassLoader"), new RuntimePermission("accessSystemModules"), PrivilegedOperations.newAllFilesReadPermission());
    }

    public static <T> T supplierWithCreateClassLoader(Supplier<T> supplier) {
        return (T)AccessController.doPrivileged(() -> supplier.get(), context, new RuntimePermission("createClassLoader"), new RuntimePermission("closeClassLoader"));
    }

    @SuppressForbidden(reason="need to create file permission")
    private static FilePermission newAllFilesReadPermission() {
        return new FilePermission("<<ALL FILES>>", "read");
    }

    private static AccessControlContext getContext() {
        ProtectionDomain[] pda = new ProtectionDomain[]{new ProtectionDomain(new CodeSource(null, (CodeSigner[])null), new PermissivePermissionCollection())};
        DomainCombiner combiner = (ignoreCurrent, ignoreAssigned) -> pda;
        AccessControlContext acc = new AccessControlContext(AccessController.getContext(), combiner);
        return AccessController.doPrivileged(AccessController::getContext, acc);
    }

    private static final class PermissivePermissionCollection
    extends PermissionCollection {
        private PermissivePermissionCollection() {
        }

        @Override
        public void add(Permission permission) {
        }

        @Override
        public boolean implies(Permission permission) {
            return true;
        }

        @Override
        public Enumeration<Permission> elements() {
            return null;
        }
    }

    public record ClosableURLClassLoader(URLClassLoader classloader) implements AutoCloseable
    {
        @Override
        public void close() throws Exception {
            PrivilegedOperations.closeURLClassLoader(this.classloader);
        }
    }
}

