/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.util.Throwables;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.SingleNodeDisruption;
import org.junit.Assert;

public class BlockClusterStateProcessing
extends SingleNodeDisruption {
    private final AtomicReference<CountDownLatch> disruptionLatch = new AtomicReference();

    public BlockClusterStateProcessing(String disruptedNode, Random random) {
        super(random);
        this.disruptedNode = disruptedNode;
    }

    @Override
    public void startDisrupting() {
        block4: {
            String disruptionNodeCopy = this.disruptedNode;
            if (disruptionNodeCopy == null) {
                return;
            }
            ClusterService clusterService = this.cluster.getInstance(ClusterService.class, disruptionNodeCopy);
            if (clusterService == null) {
                return;
            }
            this.logger.info("delaying cluster state updates on node [{}]", (Object)disruptionNodeCopy);
            Assert.assertTrue((boolean)this.disruptionLatch.compareAndSet(null, new CountDownLatch(1)));
            CountDownLatch started = new CountDownLatch(1);
            clusterService.getClusterApplierService().runOnApplierThread("service_disruption_block", Priority.IMMEDIATE, currentState -> {
                started.countDown();
                CountDownLatch latch = this.disruptionLatch.get();
                Assert.assertNotNull((Object)latch);
                try {
                    this.logger.info("waiting for removal of cluster state update disruption on node [{}]", (Object)disruptionNodeCopy);
                    latch.await();
                    this.logger.info("removing cluster state update disruption on node [{}]", (Object)disruptionNodeCopy);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.logger.error("interrupted during disruption", (Throwable)e);
                    Throwables.rethrow((Throwable)e);
                }
            }, (ActionListener)new ActionListener<Void>(){

                public void onResponse(Void unused) {
                }

                public void onFailure(Exception e) {
                    BlockClusterStateProcessing.this.logger.error("unexpected error during disruption", (Throwable)e);
                    assert (false) : e;
                }
            });
            try {
                started.await();
                this.logger.info("cluster state updates on node [{}] are now being delayed", (Object)disruptionNodeCopy);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.error("interrupted waiting for disruption to start", (Throwable)e);
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public void stopDisrupting() {
        CountDownLatch latch = this.disruptionLatch.get();
        Assert.assertNotNull((Object)latch);
        latch.countDown();
    }

    @Override
    public void removeAndEnsureHealthy(InternalTestCluster cluster) {
        this.removeFromCluster(cluster);
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return TimeValue.timeValueMinutes((long)0L);
    }
}

