/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import io.netty.handler.codec.http.HttpMethod;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.Build;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.node.tasks.list.TransportListTasksAction;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.broadcast.BaseBroadcastResponse;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.WarningsHandler;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.PemUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.FeatureSpecification;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.test.AbstractBroadcastResponseTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.rest.ESRestTestFeatureService;
import org.elasticsearch.test.rest.ObjectPath;
import org.elasticsearch.test.rest.RestTestLegacyFeatures;
import org.elasticsearch.test.rest.TestFeatureService;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;

public abstract class ESRestTestCase
extends ESTestCase {
    public static final String TRUSTSTORE_PATH = "truststore.path";
    public static final String TRUSTSTORE_PASSWORD = "truststore.password";
    public static final String CERTIFICATE_AUTHORITIES = "certificate_authorities";
    public static final String CLIENT_CERT_PATH = "client.cert.path";
    public static final String CLIENT_KEY_PATH = "client.key.path";
    public static final String CLIENT_KEY_PASSWORD = "client.key.password";
    public static final String CLIENT_SOCKET_TIMEOUT = "client.socket.timeout";
    public static final String CLIENT_PATH_PREFIX = "client.path.prefix";
    private static final Pattern SEMANTIC_VERSION_PATTERN = Pattern.compile("^(\\d+\\.\\d+\\.\\d+)\\D?.*");
    private static List<HttpHost> clusterHosts;
    private static RestClient client;
    private static RestClient adminClient;
    private static EnumSet<ProductFeature> availableFeatures;
    private static Set<String> nodesVersions;
    protected static TestFeatureService testFeatureService;
    private static final ConstructingObjectParser<BroadcastResponse, Void> BROADCAST_RESPONSE_PARSER;
    private static final String WAIT_FOR_ACTIVE_SHARDS_DEFAULT_DEPRECATION_MESSAGE = "the default value for the ?wait_for_active_shards parameter will change from '0' to 'index-setting' in version 8; specify '?wait_for_active_shards=index-setting' to adopt the future default behaviour, or '?wait_for_active_shards=0' to preserve today's behaviour";
    static final Pattern CREATE_INDEX_MULTIPLE_MATCHING_TEMPLATES;
    static final Pattern PUT_TEMPLATE_MULTIPLE_MATCHING_TEMPLATES;

    public static Map<String, Object> entityAsMap(Response response) throws IOException {
        return ESRestTestCase.entityAsMap(response.getEntity());
    }

    public static Map<String, Object> entityAsMap(HttpEntity entity) throws IOException {
        XContentType xContentType = XContentType.fromMediaType((String)entity.getContentType().getValue());
        try {
            Map map;
            block9: {
                XContentParser parser = xContentType.xContent().createParser(XContentParserConfiguration.EMPTY.withRegistry(NamedXContentRegistry.EMPTY).withDeprecationHandler(DeprecationHandler.THROW_UNSUPPORTED_OPERATION), entity.getContent());
                try {
                    map = parser.map();
                    if (parser == null) break block9;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return map;
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
    }

    public static List<Object> entityAsList(Response response) throws IOException {
        XContentType xContentType = XContentType.fromMediaType((String)response.getEntity().getContentType().getValue());
        try {
            List list;
            block9: {
                XContentParser parser = xContentType.xContent().createParser(XContentParserConfiguration.EMPTY.withRegistry(NamedXContentRegistry.EMPTY).withDeprecationHandler(DeprecationHandler.THROW_UNSUPPORTED_OPERATION), response.getEntity().getContent());
                try {
                    list = parser.list();
                    if (parser == null) break block9;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return list;
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public static boolean hasXPack() {
        if (availableFeatures == null) {
            throw new IllegalStateException("must be called inside of a rest test case test");
        }
        return availableFeatures.contains((Object)ProductFeature.XPACK);
    }

    protected static Set<String> getCachedNodesVersions() {
        assert (nodesVersions != null);
        return nodesVersions;
    }

    protected static Set<String> readVersionsFromNodesInfo(RestClient adminClient) throws IOException {
        return ESRestTestCase.getNodesInfo(adminClient).values().stream().map(nodeInfo -> nodeInfo.get("version").toString()).collect(Collectors.toSet());
    }

    protected static Map<String, Map<?, ?>> getNodesInfo(RestClient adminClient) throws IOException {
        Map<String, Object> response = ESRestTestCase.entityAsMap(adminClient.performRequest(new Request("GET", "_nodes/plugins")));
        Map nodes = (Map)response.get("nodes");
        return nodes.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> entry.getKey().toString(), entry -> (Map)entry.getValue()));
    }

    protected static Optional<Boolean> clusterHasCapability(String method, String path, Collection<String> parameters, Collection<String> capabilities) throws IOException {
        return ESRestTestCase.clusterHasCapability(adminClient, method, path, parameters, capabilities);
    }

    protected static Optional<Boolean> clusterHasCapability(RestClient client, String method, String path, Collection<String> parameters, Collection<String> capabilities) throws IOException {
        Request request = new Request("GET", "_capabilities");
        request.addParameter("method", method);
        request.addParameter("path", path);
        if (!parameters.isEmpty()) {
            request.addParameter("parameters", String.join((CharSequence)",", parameters));
        }
        if (!capabilities.isEmpty()) {
            request.addParameter("capabilities", String.join((CharSequence)",", capabilities));
        }
        try {
            Map<String, Object> response = ESRestTestCase.entityAsMap(client.performRequest(request).getEntity());
            return Optional.ofNullable((Boolean)response.get("supported"));
        }
        catch (ResponseException responseException) {
            if (responseException.getResponse().getStatusLine().getStatusCode() / 100 == 4) {
                return Optional.empty();
            }
            throw responseException;
        }
    }

    protected static boolean clusterHasFeature(String featureId) {
        return testFeatureService.clusterHasFeature(featureId, false);
    }

    protected static boolean clusterHasFeature(NodeFeature feature) {
        return testFeatureService.clusterHasFeature(feature.id(), false);
    }

    protected static boolean testFeatureServiceInitialized() {
        return testFeatureService != TestFeatureService.ALL_FEATURES;
    }

    @Before
    public void initClient() throws IOException {
        if (client == null) {
            assert (adminClient == null);
            assert (clusterHosts == null);
            assert (availableFeatures == null);
            assert (nodesVersions == null);
            assert (!ESRestTestCase.testFeatureServiceInitialized());
            clusterHosts = this.parseClusterHosts(this.getTestRestCluster());
            this.logger.info("initializing REST clients against {}", clusterHosts);
            client = this.buildClient(this.restClientSettings(), clusterHosts.toArray(new HttpHost[clusterHosts.size()]));
            adminClient = this.buildClient(this.restAdminSettings(), clusterHosts.toArray(new HttpHost[clusterHosts.size()]));
            availableFeatures = EnumSet.of(ProductFeature.LEGACY_TEMPLATES);
            HashSet<String> versions = new HashSet<String>();
            boolean serverless = false;
            for (Map<?, ?> nodeInfo : ESRestTestCase.getNodesInfo(adminClient).values()) {
                String nodeVersion = nodeInfo.get("version").toString();
                versions.add(nodeVersion);
                for (Object module : (List)nodeInfo.get("modules")) {
                    Map moduleInfo = (Map)module;
                    String moduleName = moduleInfo.get("name").toString();
                    if (moduleName.startsWith("x-pack")) {
                        availableFeatures.add(ProductFeature.XPACK);
                    }
                    if (moduleName.equals("x-pack-ilm")) {
                        availableFeatures.add(ProductFeature.ILM);
                        availableFeatures.add(ProductFeature.SLM);
                    }
                    if (moduleName.equals("x-pack-rollup")) {
                        availableFeatures.add(ProductFeature.ROLLUPS);
                    }
                    if (moduleName.equals("x-pack-ccr")) {
                        availableFeatures.add(ProductFeature.CCR);
                    }
                    if (moduleName.equals("x-pack-shutdown")) {
                        availableFeatures.add(ProductFeature.SHUTDOWN);
                    }
                    if (moduleName.equals("searchable-snapshots")) {
                        availableFeatures.add(ProductFeature.SEARCHABLE_SNAPSHOTS);
                    }
                    if (!moduleName.startsWith("serverless-")) continue;
                    serverless = true;
                }
                if (!serverless) continue;
                availableFeatures.removeAll(List.of(ProductFeature.ILM, ProductFeature.SLM, ProductFeature.ROLLUPS, ProductFeature.CCR, ProductFeature.LEGACY_TEMPLATES));
            }
            nodesVersions = Collections.unmodifiableSet(versions);
            Set<Version> semanticNodeVersions = nodesVersions.stream().map(ESRestTestCase::parseLegacyVersion).flatMap(Optional::stream).collect(Collectors.toSet());
            assert (!semanticNodeVersions.isEmpty() || serverless);
            testFeatureService = this.createTestFeatureService(ESRestTestCase.getClusterStateFeatures(adminClient), semanticNodeVersions);
        }
        assert (ESRestTestCase.testFeatureServiceInitialized());
        assert (client != null);
        assert (adminClient != null);
        assert (clusterHosts != null);
        assert (availableFeatures != null);
        assert (nodesVersions != null);
    }

    protected List<FeatureSpecification> additionalTestOnlyHistoricalFeatures() {
        return List.of();
    }

    protected final TestFeatureService createTestFeatureService(Map<String, Set<String>> clusterStateFeatures, Set<Version> semanticNodeVersions) {
        if (!ESRestTestFeatureService.hasFeatureMetadata()) {
            this.logger.warn("This test is running on the legacy test framework; historical features from production code will not be available. You need to port the test to the new test plugins in order to use historical features from production code. If this is a legacy feature used only in tests, you can add it to a test-only FeatureSpecification such as {}.", (Object)RestTestLegacyFeatures.class.getCanonicalName());
        }
        return new ESRestTestFeatureService(this.additionalTestOnlyHistoricalFeatures(), semanticNodeVersions, clusterStateFeatures.values());
    }

    protected static boolean has(ProductFeature feature) {
        return availableFeatures.contains((Object)feature);
    }

    protected List<HttpHost> parseClusterHosts(String hostsString) {
        String[] stringUrls = hostsString.split(",");
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>(stringUrls.length);
        for (String stringUrl : stringUrls) {
            int portSeparator = stringUrl.lastIndexOf(58);
            if (portSeparator < 0) {
                throw new IllegalArgumentException("Illegal cluster url [" + stringUrl + "]");
            }
            String host = stringUrl.substring(0, portSeparator);
            int port = Integer.valueOf(stringUrl.substring(portSeparator + 1));
            hosts.add(this.buildHttpHost(host, port));
        }
        return Collections.unmodifiableList(hosts);
    }

    protected String getTestRestCluster() {
        String cluster = System.getProperty("tests.rest.cluster");
        if (cluster == null) {
            throw new RuntimeException("Must specify [tests.rest.cluster] system property with a comma delimited list of [host:port] to which to send REST requests");
        }
        return cluster;
    }

    protected String getTestReadinessPorts() {
        String ports = System.getProperty("tests.cluster.readiness");
        if (ports == null) {
            throw new RuntimeException("Must specify [tests.rest.cluster.readiness] system property with a comma delimited list to which to send readiness requests");
        }
        return ports;
    }

    public static RequestOptions expectVersionSpecificWarnings(Consumer<VersionSensitiveWarningsHandler> expectationsSetter) {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        VersionSensitiveWarningsHandler warningsHandler = new VersionSensitiveWarningsHandler(ESRestTestCase.getCachedNodesVersions());
        expectationsSetter.accept(warningsHandler);
        builder.setWarningsHandler((WarningsHandler)warningsHandler);
        return builder.build();
    }

    public static RequestOptions expectWarnings(String ... warnings) {
        return ESRestTestCase.expectVersionSpecificWarnings(consumer -> consumer.current(warnings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String basicAuthHeaderValue(String username, SecureString passwd) {
        String string;
        CharBuffer chars = CharBuffer.allocate(username.length() + passwd.length() + 1);
        byte[] charBytes = null;
        try {
            chars.put(username).put(':').put(passwd.getChars());
            charBytes = CharArrays.toUtf8Bytes((char[])chars.array());
            String basicToken = Base64.getEncoder().encodeToString(charBytes);
            string = "Basic " + basicToken;
        }
        catch (Throwable throwable) {
            Arrays.fill(chars.array(), '\u0000');
            if (charBytes != null) {
                Arrays.fill(charBytes, (byte)0);
            }
            throw throwable;
        }
        Arrays.fill(chars.array(), '\u0000');
        if (charBytes != null) {
            Arrays.fill(charBytes, (byte)0);
        }
        return string;
    }

    protected HttpHost buildHttpHost(String host, int port) {
        return new HttpHost(host, port, this.getProtocol());
    }

    @After
    public final void cleanUpCluster() throws Exception {
        if (!this.preserveClusterUponCompletion()) {
            ESRestTestCase.ensureNoInitializingShards();
            this.wipeCluster();
            ESRestTestCase.waitForClusterStateUpdatesToFinish();
            this.checkForUnexpectedlyRecreatedObjects();
            this.logIfThereAreRunningTasks();
        }
    }

    @AfterClass
    public static void closeClients() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{client, adminClient});
        }
        finally {
            clusterHosts = null;
            client = null;
            adminClient = null;
            availableFeatures = null;
            nodesVersions = null;
            testFeatureService = TestFeatureService.ALL_FEATURES;
        }
    }

    protected static RestClient client() {
        return client;
    }

    protected static RestClient adminClient() {
        return adminClient;
    }

    public static void waitForPendingTasks(RestClient restClient) throws Exception {
        ESRestTestCase.waitForPendingTasks(restClient, taskName -> false);
    }

    public static void waitForPendingTasks(RestClient restClient, Predicate<String> taskFilter) throws Exception {
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            block8: {
                try {
                    Request request = new Request("GET", "/_cat/tasks");
                    request.addParameter("detailed", "true");
                    Response response = restClient.performRequest(request);
                    if (response.getStatusLine().getStatusCode() != 200) break block8;
                    try (BufferedReader responseReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));){
                        String line;
                        int activeTasks = 0;
                        StringBuilder tasksListString = new StringBuilder();
                        while ((line = responseReader.readLine()) != null) {
                            String taskName = line.split("\\s+")[0];
                            if (taskName.startsWith(TransportListTasksAction.TYPE.name()) || taskName.startsWith("health-node") || taskFilter.test(taskName)) continue;
                            ++activeTasks;
                            tasksListString.append(line);
                            tasksListString.append('\n');
                        }
                        ESRestTestCase.assertEquals((String)(activeTasks + " active tasks found:\n" + tasksListString), (long)0L, (long)activeTasks);
                    }
                }
                catch (IOException e) {
                    throw new AssertionError("error getting active tasks list", e);
                }
            }
        }), 30L, TimeUnit.SECONDS);
    }

    protected boolean preserveClusterUponCompletion() {
        return false;
    }

    protected boolean preserveIndicesUponCompletion() {
        return false;
    }

    protected boolean preserveSecurityIndicesUponCompletion() {
        return false;
    }

    protected boolean preserveTemplatesUponCompletion() {
        return false;
    }

    protected boolean resetFeatureStates() {
        if (!ESRestTestCase.clusterHasFeature(RestTestLegacyFeatures.FEATURE_STATE_RESET_SUPPORTED)) {
            return false;
        }
        return ESRestTestCase.isMlEnabled() || ESRestTestCase.clusterHasFeature(RestTestLegacyFeatures.ML_STATE_RESET_FALLBACK_ON_DISABLED);
    }

    protected boolean preserveDataStreamsUponCompletion() {
        return false;
    }

    protected boolean preserveClusterSettings() {
        return false;
    }

    protected boolean preserveReposUponCompletion() {
        return false;
    }

    protected boolean preserveSnapshotsUponCompletion() {
        return false;
    }

    protected boolean preserveRollupJobsUponCompletion() {
        return false;
    }

    protected boolean preserveILMPoliciesUponCompletion() {
        return false;
    }

    protected Set<String> preserveILMPolicyIds() {
        return Sets.newHashSet((Object[])new String[]{"ilm-history-ilm-policy", "slm-history-ilm-policy", "watch-history-ilm-policy", "watch-history-ilm-policy-16", "ml-size-based-ilm-policy", "logs", "logs@lifecycle", "metrics", "metrics@lifecycle", "profiling-60-days", "profiling-60-days@lifecycle", "synthetics", "synthetics@lifecycle", "traces@lifecycle", "7-days-default", "7-days@lifecycle", "30-days-default", "30-days@lifecycle", "90-days-default", "90-days@lifecycle", "180-days-default", "180-days@lifecycle", "365-days-default", "365-days@lifecycle", ".fleet-files-ilm-policy", ".fleet-file-data-ilm-policy", ".fleet-actions-results-ilm-policy", ".fleet-file-fromhost-data-ilm-policy", ".fleet-file-fromhost-meta-ilm-policy", ".fleet-file-tohost-data-ilm-policy", ".fleet-file-tohost-meta-ilm-policy", ".deprecation-indexing-ilm-policy", ".monitoring-8-ilm-policy", "behavioral_analytics-events-default_policy", "logs-apm.app_logs-default_policy", "logs-apm.error_logs-default_policy", "metrics-apm.app_metrics-default_policy", "metrics-apm.internal_metrics-default_policy", "metrics-apm.service_destination_10m_metrics-default_policy", "metrics-apm.service_destination_1m_metrics-default_policy", "metrics-apm.service_destination_60m_metrics-default_policy", "metrics-apm.service_summary_10m_metrics-default_policy", "metrics-apm.service_summary_1m_metrics-default_policy", "metrics-apm.service_summary_60m_metrics-default_policy", "metrics-apm.service_transaction_10m_metrics-default_policy", "metrics-apm.service_transaction_1m_metrics-default_policy", "metrics-apm.service_transaction_60m_metrics-default_policy", "metrics-apm.transaction_10m_metrics-default_policy", "metrics-apm.transaction_1m_metrics-default_policy", "metrics-apm.transaction_60m_metrics-default_policy", "traces-apm.rum_traces-default_policy", "traces-apm.sampled_traces-default_policy", "traces-apm.traces-default_policy"});
    }

    protected boolean preserveAutoFollowPatternsUponCompletion() {
        return false;
    }

    protected boolean preserveSLMPoliciesUponCompletion() {
        return false;
    }

    protected boolean preserveSearchableSnapshotsIndicesUponCompletion() {
        return false;
    }

    private void wipeCluster() throws Exception {
        this.waitForClusterUpdates();
        if (ESRestTestCase.has(ProductFeature.ROLLUPS) && !this.preserveRollupJobsUponCompletion()) {
            this.wipeRollupJobs();
            ESRestTestCase.waitForPendingRollupTasks();
        }
        if (ESRestTestCase.has(ProductFeature.SLM) && !this.preserveSLMPoliciesUponCompletion()) {
            ESRestTestCase.deleteAllSLMPolicies();
        }
        if (ESRestTestCase.has(ProductFeature.SEARCHABLE_SNAPSHOTS) && !this.preserveSearchableSnapshotsIndicesUponCompletion()) {
            this.wipeSearchableSnapshotsIndices();
        }
        this.wipeSnapshots();
        if (this.resetFeatureStates()) {
            Request postRequest = new Request("POST", "/_features/_reset");
            ESRestTestCase.adminClient().performRequest(postRequest);
        }
        if (!this.preserveDataStreamsUponCompletion()) {
            ESRestTestCase.wipeDataStreams();
        }
        if (!this.preserveIndicesUponCompletion()) {
            ESRestTestCase.wipeAllIndices(this.preserveSecurityIndicesUponCompletion());
        }
        if (!this.preserveTemplatesUponCompletion()) {
            if (ESRestTestCase.hasXPack()) {
                if (ESRestTestCase.clusterHasFeature(RestTestLegacyFeatures.COMPONENT_TEMPLATE_SUPPORTED)) {
                    try {
                        Request getTemplatesRequest = new Request("GET", "_index_template");
                        Map composableIndexTemplates = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(getTemplatesRequest).getEntity()), (boolean)false);
                        List names = ((List)composableIndexTemplates.get("index_templates")).stream().map(ct -> (String)((Map)ct).get("name")).filter(name -> !ESRestTestCase.isXPackTemplate(name)).collect(Collectors.toList());
                        if (!names.isEmpty()) {
                            if (ESRestTestCase.clusterHasFeature(RestTestLegacyFeatures.DELETE_TEMPLATE_MULTIPLE_NAMES_SUPPORTED)) {
                                try {
                                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_index_template/" + String.join((CharSequence)",", names)));
                                }
                                catch (ResponseException e) {
                                    this.logger.warn(() -> Strings.format((String)"unable to remove multiple composable index templates %s", (Object[])new Object[]{names}), (Throwable)e);
                                }
                            } else {
                                for (String name2 : names) {
                                    try {
                                        ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_index_template/" + name2));
                                    }
                                    catch (ResponseException e) {
                                        this.logger.warn(() -> Strings.format((String)"unable to remove composable index template %s", (Object[])new Object[]{name2}), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logger.debug("ignoring exception removing all composable index templates", (Throwable)e);
                    }
                    try {
                        Request compReq = new Request("GET", "_component_template");
                        String componentTemplates = EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(compReq).getEntity());
                        Map cTemplates = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)componentTemplates, (boolean)false);
                        List names = ((List)cTemplates.get("component_templates")).stream().map(ct -> (String)((Map)ct).get("name")).filter(name -> !ESRestTestCase.isXPackTemplate(name)).collect(Collectors.toList());
                        if (!names.isEmpty()) {
                            if (ESRestTestCase.clusterHasFeature(RestTestLegacyFeatures.DELETE_TEMPLATE_MULTIPLE_NAMES_SUPPORTED)) {
                                try {
                                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_component_template/" + String.join((CharSequence)",", names)));
                                }
                                catch (ResponseException e) {
                                    this.logger.warn(() -> Strings.format((String)"unable to remove multiple component templates %s", (Object[])new Object[]{names}), (Throwable)e);
                                }
                            } else {
                                for (String componentTemplate : names) {
                                    try {
                                        ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_component_template/" + componentTemplate));
                                    }
                                    catch (ResponseException e) {
                                        this.logger.warn(() -> Strings.format((String)"unable to remove component template %s", (Object[])new Object[]{componentTemplate}), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logger.debug("ignoring exception removing all component templates", (Throwable)e);
                    }
                }
                if (ESRestTestCase.has(ProductFeature.LEGACY_TEMPLATES)) {
                    Request getLegacyTemplatesRequest = new Request("GET", "_template");
                    Map legacyTemplates = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(getLegacyTemplatesRequest).getEntity()), (boolean)false);
                    for (String name3 : legacyTemplates.keySet()) {
                        if (ESRestTestCase.isXPackTemplate(name3)) continue;
                        try {
                            ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_template/" + name3));
                        }
                        catch (ResponseException e) {
                            this.logger.debug(() -> Strings.format((String)"unable to remove index template %s", (Object[])new Object[]{name3}), (Throwable)e);
                        }
                    }
                }
            } else {
                this.logger.debug("Clearing all templates");
                if (ESRestTestCase.has(ProductFeature.LEGACY_TEMPLATES)) {
                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_template/*"));
                }
                try {
                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_index_template/*"));
                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_component_template/*"));
                }
                catch (ResponseException responseException) {
                    // empty catch block
                }
            }
        }
        if (!this.preserveClusterSettings()) {
            ESRestTestCase.wipeClusterSettings();
        }
        if (ESRestTestCase.has(ProductFeature.ILM) && !this.preserveILMPoliciesUponCompletion()) {
            ESRestTestCase.deleteAllILMPolicies(this.preserveILMPolicyIds());
        }
        if (ESRestTestCase.has(ProductFeature.CCR) && !this.preserveAutoFollowPatternsUponCompletion()) {
            ESRestTestCase.deleteAllAutoFollowPatterns();
        }
        this.deleteAllNodeShutdownMetadata();
    }

    private void waitForClusterUpdates() throws Exception {
        this.logger.info("Waiting for all cluster updates up to this moment to be processed");
        try {
            ESRestTestCase.assertOK(ESRestTestCase.adminClient().performRequest(new Request("GET", "_cluster/health?wait_for_events=languid")));
        }
        catch (ResponseException e) {
            String pendingTasks;
            if (e.getResponse().getStatusLine().getStatusCode() == 408 && (pendingTasks = ESRestTestCase.getPendingClusterStateTasks()) != null) {
                this.logger.error("Timed out waiting for cluster updates to be processed, {}", (Object)pendingTasks);
            }
            throw e;
        }
    }

    private static String getPendingClusterStateTasks() {
        try {
            Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_cluster/pending_tasks"));
            List tasks = (List)ESRestTestCase.entityAsMap(response).get("tasks");
            if (!tasks.isEmpty()) {
                StringBuilder message = new StringBuilder("there are still running tasks:");
                for (Object task : tasks) {
                    message.append('\n').append(task.toString());
                }
                return message.toString();
            }
        }
        catch (IOException e) {
            ESRestTestCase.fail(e, "Failed to retrieve pending tasks in the cluster during cleanup", new Object[0]);
        }
        return null;
    }

    private void checkForUnexpectedlyRecreatedObjects() throws IOException {
        if (ESRestTestCase.has(ProductFeature.ILM) && !this.preserveILMPoliciesUponCompletion()) {
            Set<String> unexpectedIlmPlicies = ESRestTestCase.getAllUnexpectedIlmPolicies(this.preserveILMPolicyIds());
            ESRestTestCase.assertTrue((String)("Expected no ILM policies after deletions, but found " + String.join((CharSequence)", ", unexpectedIlmPlicies)), (boolean)unexpectedIlmPlicies.isEmpty());
        }
        Set<String> unexpectedTemplates = this.getAllUnexpectedTemplates();
        ESRestTestCase.assertTrue((String)("Expected no templates after deletions, but found " + String.join((CharSequence)", ", unexpectedTemplates)), (boolean)unexpectedTemplates.isEmpty());
    }

    private static Set<String> getAllUnexpectedIlmPolicies(Set<String> exclusions) throws IOException {
        Map<String, Object> policies;
        try {
            Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_ilm/policy"));
            policies = ESRestTestCase.entityAsMap(response);
        }
        catch (ResponseException e) {
            if (RestStatus.METHOD_NOT_ALLOWED.getStatus() == e.getResponse().getStatusLine().getStatusCode() || RestStatus.BAD_REQUEST.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                policies = new HashMap<String, Object>();
            }
            throw e;
        }
        Set<String> unexpectedPolicies = policies.keySet().stream().filter(p -> !exclusions.contains(p)).collect(Collectors.toSet());
        return unexpectedPolicies;
    }

    private Set<String> getAllUnexpectedTemplates() throws IOException {
        HashSet<String> unexpectedTemplates = new HashSet<String>();
        if (!this.preserveDataStreamsUponCompletion() && !this.preserveTemplatesUponCompletion() && ESRestTestCase.has(ProductFeature.XPACK)) {
            if (ESRestTestCase.clusterHasFeature(RestTestLegacyFeatures.COMPONENT_TEMPLATE_SUPPORTED)) {
                Request getTemplatesRequest = new Request("GET", "_index_template");
                Map composableIndexTemplates = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(getTemplatesRequest).getEntity()), (boolean)false);
                unexpectedTemplates.addAll(((List)composableIndexTemplates.get("index_templates")).stream().map(ct -> (String)((Map)ct).get("name")).filter(name -> !ESRestTestCase.isXPackTemplate(name)).collect(Collectors.toSet()));
                Request compReq = new Request("GET", "_component_template");
                String componentTemplates = EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(compReq).getEntity());
                Map cTemplates = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)componentTemplates, (boolean)false);
                ((List)cTemplates.get("component_templates")).stream().map(ct -> (String)((Map)ct).get("name")).filter(name -> !ESRestTestCase.isXPackTemplate(name)).forEach(unexpectedTemplates::add);
            }
            if (ESRestTestCase.has(ProductFeature.LEGACY_TEMPLATES)) {
                Request getLegacyTemplatesRequest = new Request("GET", "_template");
                Map legacyTemplates = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(getLegacyTemplatesRequest).getEntity()), (boolean)false);
                unexpectedTemplates.addAll(legacyTemplates.keySet().stream().filter(template -> !ESRestTestCase.isXPackTemplate(template)).collect(Collectors.toSet()));
            }
        }
        return unexpectedTemplates;
    }

    protected void deleteAllNodeShutdownMetadata() throws IOException {
        List<Object> nodeIds;
        if (!ESRestTestCase.has(ProductFeature.SHUTDOWN)) {
            return;
        }
        Request getShutdownStatus = new Request("GET", "_nodes/shutdown");
        Map<String, Object> statusResponse = ESRestTestCase.responseAsMap(ESRestTestCase.adminClient().performRequest(getShutdownStatus));
        Object nodesResponse = statusResponse.get("nodes");
        if (nodesResponse instanceof List) {
            List nodesArray = (List)nodesResponse;
            nodeIds = nodesArray.stream().map(nodeShutdownMetadata -> (String)nodeShutdownMetadata.get("node_id")).toList();
        } else {
            nodeIds = List.of();
        }
        for (String nodeId : nodeIds) {
            Request deleteRequest = new Request("DELETE", "_nodes/" + nodeId + "/shutdown");
            ESRestTestCase.assertOK(ESRestTestCase.adminClient().performRequest(deleteRequest));
        }
    }

    protected static void wipeAllIndices() throws IOException {
        ESRestTestCase.wipeAllIndices(false);
    }

    protected static void wipeAllIndices(boolean preserveSecurityIndices) throws IOException {
        block9: {
            boolean includeHidden = ESRestTestCase.clusterHasFeature(RestTestLegacyFeatures.HIDDEN_INDICES_SUPPORTED);
            try {
                ArrayList<String> indexPatterns = new ArrayList<String>(List.of("*", "-.ds-ilm-history-*", "-.ds-.slm-history-*", "-.ds-.watcher-history-*"));
                if (preserveSecurityIndices) {
                    indexPatterns.add("-.security-*");
                }
                Request deleteRequest = new Request("DELETE", org.elasticsearch.common.Strings.collectionToCommaDelimitedString(indexPatterns));
                deleteRequest.addParameter("expand_wildcards", "open,closed" + (includeHidden ? ",hidden" : ""));
                Response response = ESRestTestCase.adminClient().performRequest(deleteRequest);
                try (InputStream is = response.getEntity().getContent();){
                    ESRestTestCase.assertTrue((boolean)((Boolean)XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (InputStream)is, (boolean)true).get("acknowledged")));
                }
            }
            catch (ResponseException e) {
                if (e.getResponse().getStatusLine().getStatusCode() == 404) break block9;
                throw e;
            }
        }
    }

    protected static void wipeDataStreams() throws IOException {
        block6: {
            try {
                if (ESRestTestCase.hasXPack()) {
                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_data_stream/*?expand_wildcards=all"));
                }
            }
            catch (ResponseException e) {
                try {
                    if (ESRestTestCase.hasXPack()) {
                        ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_data_stream/*"));
                    }
                }
                catch (ResponseException ee) {
                    int statusCode = ee.getResponse().getStatusLine().getStatusCode();
                    if (statusCode >= 404 && statusCode <= 405) break block6;
                    throw ee;
                }
            }
        }
    }

    protected void wipeSearchableSnapshotsIndices() throws IOException {
        Request request = new Request("GET", "_cluster/state/metadata");
        request.addParameter("filter_path", "metadata.indices.*.settings.index.store.snapshot");
        Response response = ESRestTestCase.adminClient().performRequest(request);
        Map indices = (Map)XContentMapValues.extractValue((String)"metadata.indices", ESRestTestCase.entityAsMap(response));
        if (indices != null) {
            for (String index : indices.keySet()) {
                try {
                    ESRestTestCase.assertAcked("Failed to delete searchable snapshot index [" + index + "]", ESRestTestCase.adminClient().performRequest(new Request("DELETE", index)));
                }
                catch (ResponseException e) {
                    if (ESRestTestCase.isNotFoundResponseException((IOException)((Object)e))) continue;
                    throw e;
                }
            }
        }
    }

    protected void wipeSnapshots() throws IOException {
        for (Map.Entry<String, Object> repo : ESRestTestCase.entityAsMap(adminClient.performRequest(new Request("GET", "/_snapshot/_all"))).entrySet()) {
            String repoName = repo.getKey();
            Map repoSpec = (Map)repo.getValue();
            String repoType = (String)repoSpec.get("type");
            if (!this.preserveSnapshotsUponCompletion() && repoType.equals("fs")) {
                ESRestTestCase.adminClient().performRequest(new Request("DELETE", "/_snapshot/" + repoName + "/*"));
            }
            if (this.preserveReposUponCompletion()) continue;
            this.deleteRepository(repoName);
        }
    }

    protected void deleteRepository(String repoName) throws IOException {
        this.logger.debug("wiping snapshot repository [{}]", (Object)repoName);
        ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_snapshot/" + repoName));
    }

    private static void wipeClusterSettings() throws IOException {
        Map<String, Object> getResponse = ESRestTestCase.entityAsMap(ESRestTestCase.adminClient().performRequest(new Request("GET", "/_cluster/settings")));
        AtomicBoolean mustClear = new AtomicBoolean();
        Request request = ESRestTestCase.newXContentRequest(HttpMethod.PUT, "/_cluster/settings", (clearCommand, params) -> {
            for (Map.Entry entry : getResponse.entrySet()) {
                String type = entry.getKey().toString();
                Map settings = (Map)entry.getValue();
                if (settings.isEmpty()) continue;
                mustClear.set(true);
                clearCommand.startObject(type);
                for (Object key : settings.keySet()) {
                    clearCommand.field(key + ".*").nullValue();
                }
                clearCommand.endObject();
            }
            return clearCommand;
        });
        if (mustClear.get()) {
            request.setOptions(RequestOptions.DEFAULT.toBuilder().setWarningsHandler(warnings -> {
                if (warnings.isEmpty()) {
                    return false;
                }
                if (warnings.size() > 1) {
                    return true;
                }
                return !((String)warnings.get(0)).contains("xpack.monitoring");
            }));
            ESRestTestCase.adminClient().performRequest(request);
        }
    }

    private void wipeRollupJobs() throws IOException {
        Request request;
        String jobId;
        Response response;
        try {
            response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_rollup/job/_all"));
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == RestStatus.NOT_FOUND.getStatus()) {
                return;
            }
            throw e;
        }
        Map<String, Object> jobs = ESRestTestCase.entityAsMap(response);
        List jobConfigs = (List)XContentMapValues.extractValue((String)"jobs", jobs);
        if (jobConfigs == null) {
            return;
        }
        for (Map jobConfig : jobConfigs) {
            jobId = (String)((Map)jobConfig.get("config")).get("id");
            request = new Request("POST", "/_rollup/job/" + jobId + "/_stop");
            ESRestTestCase.setIgnoredErrorResponseCodes(request, RestStatus.NOT_FOUND);
            request.addParameter("wait_for_completion", "true");
            request.addParameter("timeout", "10s");
            this.logger.debug("stopping rollup job [{}]", (Object)jobId);
            ESRestTestCase.adminClient().performRequest(request);
        }
        for (Map jobConfig : jobConfigs) {
            jobId = (String)((Map)jobConfig.get("config")).get("id");
            request = new Request("DELETE", "/_rollup/job/" + jobId);
            ESRestTestCase.setIgnoredErrorResponseCodes(request, RestStatus.NOT_FOUND);
            this.logger.debug("deleting rollup job [{}]", (Object)jobId);
            ESRestTestCase.adminClient().performRequest(request);
        }
    }

    protected void refreshAllIndices() throws IOException {
        boolean includeHidden = ESRestTestCase.clusterHasFeature(RestTestLegacyFeatures.HIDDEN_INDICES_SUPPORTED);
        Request refreshRequest = new Request("POST", "/_refresh");
        refreshRequest.addParameter("expand_wildcards", "open" + (includeHidden ? ",hidden" : ""));
        refreshRequest.setOptions(RequestOptions.DEFAULT.toBuilder().setWarningsHandler(warnings -> {
            if (warnings.isEmpty()) {
                return false;
            }
            if (warnings.size() > 1) {
                return true;
            }
            return !((String)warnings.get(0)).startsWith("this request accesses system indices:");
        }));
        ESRestTestCase.client().performRequest(refreshRequest);
    }

    protected static BroadcastResponse refresh(String index) throws IOException {
        return ESRestTestCase.refresh(ESRestTestCase.client(), index);
    }

    protected static BroadcastResponse refresh(RestClient client, String index) throws IOException {
        Request refreshRequest = new Request("POST", "/" + index + "/_refresh");
        Response response = client.performRequest(refreshRequest);
        try (XContentParser parser = ESRestTestCase.responseAsParser(response);){
            BroadcastResponse broadcastResponse = (BroadcastResponse)BROADCAST_RESPONSE_PARSER.apply(parser, null);
            return broadcastResponse;
        }
    }

    private static void waitForPendingRollupTasks() throws Exception {
        ESRestTestCase.waitForPendingTasks(ESRestTestCase.adminClient(), taskName -> !taskName.startsWith("xpack/rollup/job"));
    }

    private static void deleteAllILMPolicies(Set<String> exclusions) throws IOException {
        Map<String, Object> policies;
        try {
            Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_ilm/policy"));
            policies = ESRestTestCase.entityAsMap(response);
        }
        catch (ResponseException e) {
            if (RestStatus.METHOD_NOT_ALLOWED.getStatus() == e.getResponse().getStatusLine().getStatusCode() || RestStatus.BAD_REQUEST.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                return;
            }
            throw e;
        }
        if (policies == null || policies.isEmpty()) {
            return;
        }
        policies.keySet().stream().filter(p -> !exclusions.contains(p)).forEach(policyName -> {
            try {
                ESRestTestCase.adminClient().performRequest(new Request("DELETE", "/_ilm/policy/" + policyName));
            }
            catch (IOException e) {
                throw new RuntimeException("failed to delete policy: " + policyName, e);
            }
        });
    }

    private static void deleteAllSLMPolicies() throws IOException {
        Map<String, Object> policies;
        try {
            Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_slm/policy"));
            policies = ESRestTestCase.entityAsMap(response);
        }
        catch (ResponseException e) {
            if (RestStatus.METHOD_NOT_ALLOWED.getStatus() == e.getResponse().getStatusLine().getStatusCode() || RestStatus.BAD_REQUEST.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                return;
            }
            throw e;
        }
        if (policies == null || policies.isEmpty()) {
            return;
        }
        for (String policyName : policies.keySet()) {
            ESRestTestCase.adminClient().performRequest(new Request("DELETE", "/_slm/policy/" + policyName));
        }
    }

    private static void deleteAllAutoFollowPatterns() throws IOException {
        List patterns;
        try {
            Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_ccr/auto_follow"));
            patterns = (List)ESRestTestCase.entityAsMap(response).get("patterns");
        }
        catch (ResponseException e) {
            if (RestStatus.METHOD_NOT_ALLOWED.getStatus() == e.getResponse().getStatusLine().getStatusCode() || RestStatus.BAD_REQUEST.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                return;
            }
            throw e;
        }
        if (patterns == null || patterns.isEmpty()) {
            return;
        }
        for (Map pattern : patterns) {
            String patternName = (String)pattern.get("name");
            ESRestTestCase.adminClient().performRequest(new Request("DELETE", "/_ccr/auto_follow/" + patternName));
        }
    }

    private void logIfThereAreRunningTasks() throws IOException {
        Set<String> runningTasks = ESRestTestCase.runningTasks(ESRestTestCase.adminClient().performRequest(new Request("GET", "/_tasks")));
        runningTasks.remove(TransportListTasksAction.TYPE.name());
        runningTasks.remove(TransportListTasksAction.TYPE.name() + "[n]");
        if (runningTasks.isEmpty()) {
            return;
        }
        ArrayList<String> stillRunning = new ArrayList<String>(runningTasks);
        Collections.sort(stillRunning);
        this.logger.info("There are still tasks running after this test that might break subsequent tests {}.", stillRunning);
    }

    private static void waitForClusterStateUpdatesToFinish() throws Exception {
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            String pendingTasks = ESRestTestCase.getPendingClusterStateTasks();
            if (pendingTasks != null) {
                ESRestTestCase.fail((String)pendingTasks);
            }
        }), 30L, TimeUnit.SECONDS);
    }

    protected Settings restClientSettings() {
        Settings.Builder builder = Settings.builder();
        if (System.getProperty("tests.rest.client_path_prefix") != null) {
            builder.put(CLIENT_PATH_PREFIX, System.getProperty("tests.rest.client_path_prefix"));
        }
        if (System.getProperty("tests.rest.cluster.username") != null) {
            if (System.getProperty("tests.rest.cluster.password") == null) {
                throw new IllegalStateException("The 'test.rest.cluster.password' system property must be set.");
            }
            String username = System.getProperty("tests.rest.cluster.username");
            String password = System.getProperty("tests.rest.cluster.password");
            String token = ESRestTestCase.basicAuthHeaderValue(username, new SecureString(password.toCharArray()));
            builder.put("request.headers.Authorization", token);
        }
        if (System.getProperty("tests.rest.project.id") != null) {
            String projectId = System.getProperty("tests.rest.project.id");
            builder.put("request.headers.X-Elastic-Project-Id", projectId);
        }
        return builder.build();
    }

    protected Settings restAdminSettings() {
        return this.restClientSettings();
    }

    protected final List<HttpHost> getClusterHosts() {
        return clusterHosts;
    }

    protected String getProtocol() {
        return "http";
    }

    protected RestClient buildClient(Settings settings, HttpHost[] hosts) throws IOException {
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
        this.configureClient(builder, settings);
        builder.setStrictDeprecationMode(true);
        return builder.build();
    }

    protected void configureClient(RestClientBuilder builder, Settings settings) throws IOException {
        ESRestTestCase.doConfigureClient(builder, settings);
    }

    protected static void doConfigureClient(RestClientBuilder builder, Settings settings) throws IOException {
        SSLIOSessionStrategy sessionStrategy;
        SSLContext sslcontext;
        String truststorePath = settings.get(TRUSTSTORE_PATH);
        String certificateAuthorities = settings.get(CERTIFICATE_AUTHORITIES);
        String clientCertificatePath = settings.get(CLIENT_CERT_PATH);
        if (certificateAuthorities != null && truststorePath != null) {
            throw new IllegalStateException("Cannot set both certificate_authorities and truststore.path. Please configure one of these.");
        }
        if (truststorePath != null) {
            if (ESRestTestCase.inFipsJvm()) {
                throw new IllegalStateException("Keystore " + truststorePath + "cannot be used in FIPS 140 mode. Please configure certificate_authorities with a PEM encoded trusted CA/certificate instead");
            }
            String keystorePass = settings.get(TRUSTSTORE_PASSWORD);
            if (keystorePass == null) {
                throw new IllegalStateException("truststore.path is provided but not truststore.password");
            }
            Path path = PathUtils.get((String)truststorePath, (String[])new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new IllegalStateException("truststore.path is set but points to a non-existing file");
            }
            try {
                String keyStoreType = truststorePath.endsWith(".p12") ? "PKCS12" : "jks";
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    keyStore.load(is, keystorePass.toCharArray());
                }
                sslcontext = SSLContexts.custom().loadTrustMaterial(keyStore, null).build();
                sessionStrategy = new SSLIOSessionStrategy(sslcontext);
                builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy));
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException("Error setting up ssl", e);
            }
        }
        if (certificateAuthorities != null) {
            Path caPath = PathUtils.get((String)certificateAuthorities, (String[])new String[0]);
            if (!Files.exists(caPath, new LinkOption[0])) {
                throw new IllegalStateException("certificate_authorities is set but points to a non-existing file");
            }
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                Certificate caCert = (Certificate)PemUtils.readCertificates(List.of(caPath)).get(0);
                keyStore.setCertificateEntry(caCert.toString(), caCert);
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                if (clientCertificatePath != null) {
                    Path certPath = PathUtils.get((String)clientCertificatePath, (String[])new String[0]);
                    Path keyPath = PathUtils.get((String)Objects.requireNonNull(settings.get(CLIENT_KEY_PATH), "No key provided"), (String[])new String[0]);
                    String password = settings.get(CLIENT_KEY_PASSWORD);
                    char[] passwordChars = password == null ? null : password.toCharArray();
                    PrivateKey key = PemUtils.readPrivateKey((Path)keyPath, () -> passwordChars);
                    Certificate[] clientCertChain = (Certificate[])PemUtils.readCertificates(List.of(certPath)).toArray(Certificate[]::new);
                    keyStore.setKeyEntry("client", key, passwordChars, clientCertChain);
                    sslContextBuilder.loadKeyMaterial(keyStore, passwordChars);
                }
                sslcontext = sslContextBuilder.loadTrustMaterial(keyStore, null).build();
                sessionStrategy = new SSLIOSessionStrategy(sslcontext);
                builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy));
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Error setting up ssl", e);
            }
        } else if (clientCertificatePath != null) {
            throw new IllegalStateException("Client certificates are currently only supported when using a custom CA");
        }
        Map headers = ThreadContext.buildDefaultHeaders((Settings)settings);
        Header[] defaultHeaders = new Header[headers.size()];
        int i = 0;
        for (Map.Entry entry : headers.entrySet()) {
            defaultHeaders[i++] = new BasicHeader((String)entry.getKey(), (String)entry.getValue());
        }
        builder.setDefaultHeaders(defaultHeaders);
        String socketTimeoutString = Objects.requireNonNullElse(settings.get(CLIENT_SOCKET_TIMEOUT), "60s");
        TimeValue socketTimeout = TimeValue.parseTimeValue((String)socketTimeoutString, (String)CLIENT_SOCKET_TIMEOUT);
        builder.setRequestConfigCallback(conf -> conf.setSocketTimeout(Math.toIntExact(socketTimeout.getMillis())));
        if (settings.hasValue(CLIENT_PATH_PREFIX)) {
            builder.setPathPrefix(settings.get(CLIENT_PATH_PREFIX));
        }
    }

    private static Set<String> runningTasks(Response response) throws IOException {
        HashSet<String> runningTasks = new HashSet<String>();
        Map nodes = (Map)ESRestTestCase.entityAsMap(response).get("nodes");
        for (Map.Entry node : nodes.entrySet()) {
            Map nodeInfo = (Map)node.getValue();
            Map nodeTasks = (Map)nodeInfo.get("tasks");
            for (Map.Entry taskAndName : nodeTasks.entrySet()) {
                Map task = (Map)taskAndName.getValue();
                runningTasks.add(task.get("action").toString());
            }
        }
        return runningTasks;
    }

    public static Response assertOK(Response response) {
        ESRestTestCase.assertThat(response.getStatusLine().getStatusCode(), Matchers.anyOf((org.hamcrest.Matcher)Matchers.equalTo((Object)200), (org.hamcrest.Matcher)Matchers.equalTo((Object)201)));
        return response;
    }

    public static void assertOKAndConsume(Response response) {
        try {
            ESRestTestCase.assertOK(response);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public static ObjectPath assertOKAndCreateObjectPath(Response response) throws IOException {
        ESRestTestCase.assertOK(response);
        return ObjectPath.createFromResponse(response);
    }

    public static void assertDocCount(RestClient client, String indexName, long docCount) throws IOException {
        Request countReq = new Request("GET", "/" + indexName + "/_count");
        ObjectPath resp = ObjectPath.createFromResponse(client.performRequest(countReq));
        ESRestTestCase.assertEquals((String)("expected " + docCount + " documents but it was a different number"), (long)docCount, (long)Long.parseLong(resp.evaluate("count").toString()));
    }

    public static void assertAcknowledged(Response response) throws IOException {
        try {
            ESRestTestCase.assertOK(response);
            String jsonBody = EntityUtils.toString((HttpEntity)response.getEntity());
            ESRestTestCase.assertThat(jsonBody, Matchers.containsString((String)"\"acknowledged\":true"));
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    public static void updateClusterSettings(Settings settings) throws IOException {
        ESRestTestCase.updateClusterSettings(ESRestTestCase.client(), settings);
    }

    public static void updateClusterSettings(RestClient client, Settings settings) throws IOException {
        Request request = ESRestTestCase.newXContentRequest(HttpMethod.PUT, "/_cluster/settings", (builder, params) -> {
            builder.startObject("persistent");
            settings.toXContent(builder, params);
            return builder.endObject();
        });
        ESRestTestCase.assertOK(client.performRequest(request));
    }

    @Nullable
    protected String getEnsureGreenTimeout() {
        return null;
    }

    public final void ensureGreen(String index) throws IOException {
        ESRestTestCase.ensureHealth(index, (Request request) -> {
            request.addParameter("wait_for_status", "green");
            request.addParameter("wait_for_no_relocating_shards", "true");
            String ensureGreenTimeout = this.getEnsureGreenTimeout();
            if (ensureGreenTimeout != null) {
                request.addParameter("timeout", ensureGreenTimeout);
            }
            request.addParameter("level", "shards");
        });
    }

    protected static void ensureHealth(Consumer<Request> requestConsumer) throws IOException {
        ESRestTestCase.ensureHealth("", requestConsumer);
    }

    public static void ensureHealth(String index, Consumer<Request> requestConsumer) throws IOException {
        ESRestTestCase.ensureHealth(ESRestTestCase.client(), index, requestConsumer);
    }

    public static void ensureHealth(RestClient restClient, Consumer<Request> requestConsumer) throws IOException {
        ESRestTestCase.ensureHealth(restClient, "", requestConsumer);
    }

    protected static void ensureHealth(RestClient restClient, String index, Consumer<Request> requestConsumer) throws IOException {
        Request request = new Request("GET", "/_cluster/health" + (String)(index.isBlank() ? "" : "/" + index));
        requestConsumer.accept(request);
        try {
            restClient.performRequest(request);
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == 408) {
                try {
                    Response clusterStateResponse = restClient.performRequest(new Request("GET", "/_cluster/state?pretty"));
                    ESRestTestCase.fail((String)("timed out waiting for green state for index [" + index + "] cluster state [" + EntityUtils.toString((HttpEntity)clusterStateResponse.getEntity()) + "]"));
                }
                catch (Exception inner) {
                    e.addSuppressed((Throwable)inner);
                }
            }
            throw e;
        }
    }

    protected static void ensureNoInitializingShards() throws IOException {
        Request request = new Request("GET", "/_cluster/health");
        request.addParameter("wait_for_no_initializing_shards", "true");
        request.addParameter("timeout", "70s");
        request.addParameter("level", "shards");
        ESRestTestCase.adminClient().performRequest(request);
    }

    protected static CreateIndexResponse createIndex(String name) throws IOException {
        return ESRestTestCase.createIndex(name, null, null, null);
    }

    protected static CreateIndexResponse createIndex(String name, Settings settings) throws IOException {
        return ESRestTestCase.createIndex(name, settings, null, null);
    }

    protected static CreateIndexResponse createIndex(RestClient client, String name, Settings settings) throws IOException {
        return ESRestTestCase.createIndex(client, name, settings, null, null);
    }

    protected static CreateIndexResponse createIndex(RestClient client, String name, Settings settings, String mapping) throws IOException {
        return ESRestTestCase.createIndex(client, name, settings, mapping, null);
    }

    protected static CreateIndexResponse createIndex(String name, Settings settings, String mapping) throws IOException {
        return ESRestTestCase.createIndex(name, settings, mapping, null);
    }

    protected static CreateIndexResponse createIndex(String name, Settings settings, String mapping, String aliases) throws IOException {
        return ESRestTestCase.createIndex(ESRestTestCase.client(), name, settings, mapping, aliases);
    }

    public static CreateIndexResponse createIndex(RestClient client, String name, Settings settings, String mapping, String aliases) throws IOException {
        Request request = ESRestTestCase.newXContentRequest(HttpMethod.PUT, "/" + name, (builder, params) -> {
            if (settings != null) {
                builder.startObject("settings");
                settings.toXContent(builder, params);
                builder.endObject();
            }
            if (mapping != null) {
                try (XContentParser mappingParser = XContentType.JSON.xContent().createParser(XContentParserConfiguration.EMPTY, (String)(mapping.trim().startsWith("{") ? mapping : "{" + mapping + "}"));){
                    builder.field("mappings");
                    builder.copyCurrentStructure(mappingParser);
                }
            }
            if (aliases != null) {
                try (XContentParser aliasesParser = XContentType.JSON.xContent().createParser(XContentParserConfiguration.EMPTY, "{" + aliases + "}");){
                    builder.field("aliases");
                    builder.copyCurrentStructure(aliasesParser);
                }
            }
            return builder;
        });
        if (settings != null && !settings.getAsBoolean(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), Boolean.valueOf(true)).booleanValue()) {
            ESRestTestCase.expectSoftDeletesWarning(request, name);
        } else if (ESRestTestCase.isSyntheticSourceConfiguredInMapping(mapping) && ESRestTestCase.minimumIndexVersion().onOrAfter((VersionId)IndexVersions.DEPRECATE_SOURCE_MODE_MAPPER)) {
            request.setOptions(ESRestTestCase.expectVersionSpecificWarnings(v -> v.current("Configuring source mode in mappings is deprecated and will be removed in future versions. Use [index.mapping.source.mode] index setting instead.")));
        }
        Response response = client.performRequest(request);
        try (XContentParser parser = ESRestTestCase.responseAsParser(response);){
            CreateIndexResponse createIndexResponse = CreateIndexResponse.fromXContent((XContentParser)parser);
            return createIndexResponse;
        }
    }

    protected static AcknowledgedResponse deleteIndex(String name) throws IOException {
        return ESRestTestCase.deleteIndex(ESRestTestCase.client(), name);
    }

    protected static AcknowledgedResponse deleteIndex(RestClient restClient, String name) throws IOException {
        Request request = new Request("DELETE", "/" + name);
        Response response = restClient.performRequest(request);
        try (XContentParser parser = ESRestTestCase.responseAsParser(response);){
            AcknowledgedResponse acknowledgedResponse = AcknowledgedResponse.fromXContent((XContentParser)parser);
            return acknowledgedResponse;
        }
    }

    protected static void updateIndexSettings(String index, Settings.Builder settings) throws IOException {
        ESRestTestCase.updateIndexSettings(index, settings.build());
    }

    private static void updateIndexSettings(String index, Settings settings) throws IOException {
        Request request = ESRestTestCase.newXContentRequest(HttpMethod.PUT, "/" + index + "/_settings", (ToXContent)settings);
        ESRestTestCase.assertOK(client.performRequest(request));
    }

    protected static void expectSoftDeletesWarning(Request request, String indexName) throws IOException {
        String expectedWarning = "Creating indices with soft-deletes disabled is deprecated and will be removed in future Elasticsearch versions. Please do not specify value for setting [index.soft_deletes.enabled] of index [" + indexName + "].";
        boolean softDeleteDisabledDeprecated = ESRestTestCase.minimumIndexVersion().onOrAfter((VersionId)IndexVersions.V_7_6_0);
        request.setOptions(ESRestTestCase.expectVersionSpecificWarnings(v -> {
            if (softDeleteDisabledDeprecated) {
                v.current(expectedWarning);
            }
            v.compatible(expectedWarning);
        }));
    }

    protected static boolean isSyntheticSourceConfiguredInMapping(String mapping) {
        Map sourceMapper;
        if (mapping == null) {
            return false;
        }
        Map mappings = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)(mapping.trim().startsWith("{") ? mapping : "{" + mapping + "}"), (boolean)false);
        if (mappings.containsKey("_doc")) {
            mappings = (Map)mappings.get("_doc");
        }
        if ((sourceMapper = (Map)mappings.get("_source")) == null) {
            return false;
        }
        return sourceMapper.get("mode") != null;
    }

    protected static boolean isSyntheticSourceConfiguredInTemplate(String template) {
        if (template == null) {
            return false;
        }
        Map values = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)template, (boolean)false);
        for (Object value : values.values()) {
            Object mode;
            Map sourceMapper;
            Map mappings = (Map)((Map)value).get("mappings");
            if (mappings == null || (sourceMapper = (Map)mappings.get("_source")) == null || (mode = sourceMapper.get("mode")) == null) continue;
            return true;
        }
        return false;
    }

    protected static Map<String, Object> getIndexSettings(String index) throws IOException {
        Request request = new Request("GET", "/" + index + "/_settings");
        request.addParameter("flat_settings", "true");
        Response response = ESRestTestCase.client().performRequest(request);
        try (InputStream is = response.getEntity().getContent();){
            Map map = XContentHelper.convertToMap((XContent)XContentType.fromMediaType((String)response.getEntity().getContentType().getValue()).xContent(), (InputStream)is, (boolean)true);
            return map;
        }
    }

    protected Map<String, Object> getIndexSettingsAsMap(String index) throws IOException {
        Map<String, Object> indexSettings = ESRestTestCase.getIndexSettings(index);
        return (Map)((Map)indexSettings.get(index)).get("settings");
    }

    protected static Map<String, Object> getIndexMapping(String index) throws IOException {
        return ESRestTestCase.entityAsMap(ESRestTestCase.client().performRequest(new Request("GET", "/" + index + "/_mapping")));
    }

    protected Map<String, Object> getIndexMappingAsMap(String index) throws IOException {
        Map<String, Object> indexMapping = ESRestTestCase.getIndexMapping(index);
        return (Map)((Map)indexMapping.get(index)).get("mappings");
    }

    protected static boolean indexExists(String index) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("HEAD", "/" + index));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static void closeIndex(String index) throws IOException {
        Request closeRequest = new Request("POST", "/" + index + "/_close");
        closeRequest.setOptions(ESRestTestCase.expectVersionSpecificWarnings(v -> v.compatible(WAIT_FOR_ACTIVE_SHARDS_DEFAULT_DEPRECATION_MESSAGE)));
        ESRestTestCase.assertOK(ESRestTestCase.client().performRequest(closeRequest));
    }

    protected static void openIndex(String index) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("POST", "/" + index + "/_open"));
        ESRestTestCase.assertThat(response.getStatusLine().getStatusCode(), Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static boolean aliasExists(String alias) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("HEAD", "/_alias/" + alias));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static boolean aliasExists(String index, String alias) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("HEAD", "/" + index + "/_alias/" + alias));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static Map<String, Object> getAlias(String index, String alias) throws IOException {
        Object endpoint = "/_alias";
        if (!org.elasticsearch.common.Strings.isEmpty((CharSequence)index)) {
            endpoint = index + (String)endpoint;
        }
        if (!org.elasticsearch.common.Strings.isEmpty((CharSequence)alias)) {
            endpoint = (String)endpoint + "/" + alias;
        }
        Map<String, Object> getAliasResponse = ESRestTestCase.getAsMap((String)endpoint);
        return (Map)XContentMapValues.extractValue((String)(index + ".aliases." + alias), getAliasResponse);
    }

    protected static Map<String, Object> getAsMap(String endpoint) throws IOException {
        return ESRestTestCase.getAsMap(ESRestTestCase.client(), endpoint, false);
    }

    protected static Map<String, Object> getAsOrderedMap(String endpoint) throws IOException {
        return ESRestTestCase.getAsMap(ESRestTestCase.client(), endpoint, true);
    }

    protected static Map<String, Object> getAsMap(RestClient client, String endpoint) throws IOException {
        return ESRestTestCase.getAsMap(client, endpoint, false);
    }

    private static Map<String, Object> getAsMap(RestClient client, String endpoint, boolean ordered) throws IOException {
        Response response = client.performRequest(new Request("GET", endpoint));
        return ESRestTestCase.responseAsMap(response, ordered);
    }

    protected static Map<String, Object> responseAsMap(Response response) throws IOException {
        return ESRestTestCase.responseAsMap(response, false);
    }

    protected static Map<String, Object> responseAsOrderedMap(Response response) throws IOException {
        return ESRestTestCase.responseAsMap(response, true);
    }

    private static Map<String, Object> responseAsMap(Response response, boolean ordered) throws IOException {
        XContentType entityContentType = XContentType.fromMediaType((String)response.getEntity().getContentType().getValue());
        Map responseEntity = XContentHelper.convertToMap((XContent)entityContentType.xContent(), (InputStream)response.getEntity().getContent(), (boolean)ordered);
        ESRestTestCase.assertNotNull((Object)responseEntity);
        return responseEntity;
    }

    public static XContentParser responseAsParser(Response response) throws IOException {
        return XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)ESRestTestCase.responseAsBytes(response), (XContentType)XContentType.fromMediaType((String)response.getEntity().getContentType().getValue()));
    }

    protected static BytesReference responseAsBytes(Response response) throws IOException {
        return new BytesArray(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
    }

    protected static void registerRepository(String repository, String type, boolean verify, Settings settings) throws IOException {
        ESRestTestCase.registerRepository(ESRestTestCase.client(), repository, type, verify, settings);
    }

    protected static void registerRepository(RestClient restClient, String repository, String type, boolean verify, Settings settings) throws IOException {
        Request request = ESRestTestCase.newXContentRequest(HttpMethod.PUT, "/_snapshot/" + repository, (ToXContent)new PutRepositoryRequest(TEST_REQUEST_TIMEOUT, TEST_REQUEST_TIMEOUT, repository).type(type).settings(settings));
        request.addParameter("verify", Boolean.toString(verify));
        Response response = restClient.performRequest(request);
        ESRestTestCase.assertAcked("Failed to create repository [" + repository + "] of type [" + type + "]: " + response, response);
    }

    protected static void createSnapshot(String repository, String snapshot, boolean waitForCompletion) throws IOException {
        ESRestTestCase.createSnapshot(ESRestTestCase.client(), repository, snapshot, waitForCompletion);
    }

    protected static void createSnapshot(RestClient restClient, String repository, String snapshot, boolean waitForCompletion) throws IOException {
        Request request = new Request("PUT", "_snapshot/" + repository + "/" + snapshot);
        request.addParameter("wait_for_completion", Boolean.toString(waitForCompletion));
        Response response = restClient.performRequest(request);
        ESRestTestCase.assertThat("Failed to create snapshot [" + snapshot + "] in repository [" + repository + "]: " + response, response.getStatusLine().getStatusCode(), Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static void restoreSnapshot(String repository, String snapshot, boolean waitForCompletion) throws IOException {
        Request request = new Request("POST", "_snapshot/" + repository + "/" + snapshot + "/_restore");
        request.addParameter("wait_for_completion", Boolean.toString(waitForCompletion));
        Response response = ESRestTestCase.client().performRequest(request);
        ESRestTestCase.assertThat("Failed to restore snapshot [" + snapshot + "] from repository [" + repository + "]: " + response, response.getStatusLine().getStatusCode(), Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static void deleteSnapshot(String repository, String snapshot, boolean ignoreMissing) throws IOException {
        ESRestTestCase.deleteSnapshot(ESRestTestCase.client(), repository, snapshot, ignoreMissing);
    }

    protected static void deleteSnapshot(RestClient restClient, String repository, String snapshot, boolean ignoreMissing) throws IOException {
        Request request = new Request("DELETE", "_snapshot/" + repository + "/" + snapshot);
        if (ignoreMissing) {
            ESRestTestCase.setIgnoredErrorResponseCodes(request, RestStatus.NOT_FOUND);
        }
        Response response = restClient.performRequest(request);
        ESRestTestCase.assertThat(response.getStatusLine().getStatusCode(), ignoreMissing ? Matchers.anyOf((org.hamcrest.Matcher)Matchers.equalTo((Object)200), (org.hamcrest.Matcher)Matchers.equalTo((Object)404)) : Matchers.equalTo((Object)200));
    }

    private static void assertAcked(String message, Response response) throws IOException {
        int responseStatusCode = response.getStatusLine().getStatusCode();
        ESRestTestCase.assertThat(message + ": expecting response code [200] but got [" + responseStatusCode + "]", responseStatusCode, Matchers.equalTo((Object)RestStatus.OK.getStatus()));
        Map<String, Object> responseAsMap = ESRestTestCase.responseAsMap(response);
        Boolean acknowledged = (Boolean)XContentMapValues.extractValue(responseAsMap, (String[])new String[]{"acknowledged"});
        ESRestTestCase.assertThat(message + ": response is not acknowledged", acknowledged, Matchers.equalTo((Object)Boolean.TRUE));
    }

    protected static boolean isXPackTemplate(String name) {
        if (name.startsWith(".monitoring-")) {
            return true;
        }
        if (name.startsWith(".watch") || name.startsWith(".triggered_watches")) {
            return true;
        }
        if (name.startsWith(".data-frame-")) {
            return true;
        }
        if (name.startsWith(".ml-")) {
            return true;
        }
        if (name.startsWith(".transform-")) {
            return true;
        }
        if (name.startsWith(".deprecation-")) {
            return true;
        }
        if (name.startsWith(".fleet-")) {
            return true;
        }
        if (name.startsWith("behavioral_analytics-")) {
            return true;
        }
        if (name.startsWith("profiling-")) {
            return true;
        }
        if (name.startsWith("elastic-connectors")) {
            return true;
        }
        if (name.contains("@") && !name.endsWith("@custom")) {
            return true;
        }
        if (name.startsWith("apm@") || name.startsWith("apm-") || name.startsWith("traces-apm") || name.startsWith("metrics-apm") || name.startsWith("logs-apm")) {
            return true;
        }
        if (name.startsWith(".slm-history") || name.startsWith("ilm-history")) {
            return true;
        }
        switch (name) {
            case ".watches": 
            case "security_audit_log": 
            case ".async-search": 
            case ".profiling-ilm-lock": 
            case "saml-service-provider": 
            case "logs": 
            case "logs-settings": 
            case "logs-mappings": 
            case "metrics": 
            case "metrics-settings": 
            case "metrics-tsdb-settings": 
            case "metrics-mappings": 
            case "synthetics": 
            case "synthetics-settings": 
            case "synthetics-mappings": 
            case ".snapshot-blob-cache": 
            case "logstash-index-template": 
            case "security-index-template": 
            case "data-streams-mappings": 
            case "search-acl-filter": 
            case ".kibana-reporting": {
                return true;
            }
        }
        return false;
    }

    public void flush(String index, boolean force) throws IOException {
        this.logger.info("flushing index {} force={}", (Object)index, (Object)force);
        Request flushRequest = new Request("POST", "/" + index + "/_flush");
        flushRequest.addParameter("force", Boolean.toString(force));
        flushRequest.addParameter("wait_if_ongoing", "true");
        ESRestTestCase.assertOK(ESRestTestCase.client().performRequest(flushRequest));
    }

    public void assertNoFileBasedRecovery(String indexName, Predicate<String> targetNode) throws IOException {
        Map<String, Object> recoveries = ESRestTestCase.entityAsMap(ESRestTestCase.client().performRequest(new Request("GET", indexName + "/_recovery?detailed=true")));
        List shards = (List)XContentMapValues.extractValue((String)(indexName + ".shards"), recoveries);
        ESRestTestCase.assertNotNull((Object)shards);
        boolean foundReplica = false;
        this.logger.info("index {} recovery stats {}", (Object)indexName, (Object)shards);
        for (Map shard : shards) {
            if (shard.get("primary") != Boolean.FALSE || !targetNode.test((String)XContentMapValues.extractValue((String)"target.name", (Map)shard))) continue;
            List details = (List)XContentMapValues.extractValue((String)"index.files.details", (Map)shard);
            if (details == null) {
                long totalFiles = ((Number)XContentMapValues.extractValue((String)"index.files.total", (Map)shard)).longValue();
                long reusedFiles = ((Number)XContentMapValues.extractValue((String)"index.files.reused", (Map)shard)).longValue();
                this.logger.info("total [{}] reused [{}]", (Object)totalFiles, (Object)reusedFiles);
                ESRestTestCase.assertThat("must reuse all files, recoveries [" + recoveries + "]", totalFiles, Matchers.equalTo((Object)reusedFiles));
            } else {
                ESRestTestCase.assertNotNull((Object)details);
                ESRestTestCase.assertThat(details, Matchers.empty());
            }
            foundReplica = true;
        }
        ESRestTestCase.assertTrue((String)"must find replica", (boolean)foundReplica);
    }

    public void assertEmptyTranslog(String index) throws Exception {
        Map<String, Object> stats = ESRestTestCase.entityAsMap(ESRestTestCase.client().performRequest(new Request("GET", index + "/_stats?level=shards")));
        ESRestTestCase.assertThat(XContentMapValues.extractValue((String)("indices." + index + ".total.translog.uncommitted_operations"), stats), Matchers.equalTo((Object)0));
        ESRestTestCase.assertThat(XContentMapValues.extractValue((String)("indices." + index + ".total.translog.operations"), stats), Matchers.equalTo((Object)0));
    }

    public void ensurePeerRecoveryRetentionLeasesRenewedAndSynced(String index) throws Exception {
        boolean mustHavePRRLs = ESRestTestCase.minimumIndexVersion().onOrAfter((VersionId)IndexVersions.V_7_6_0);
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            Map<String, Object> stats = ESRestTestCase.entityAsMap(ESRestTestCase.client().performRequest(new Request("GET", index + "/_stats?level=shards")));
            Map shards = (Map)XContentMapValues.extractValue((String)("indices." + index + ".shards"), stats);
            for (List shard : shards.values()) {
                for (Map copy : shard) {
                    Integer globalCheckpoint = (Integer)XContentMapValues.extractValue((String)"seq_no.global_checkpoint", (Map)copy);
                    ESRestTestCase.assertThat(XContentMapValues.extractValue((String)"seq_no.max_seq_no", (Map)copy), Matchers.equalTo((Object)globalCheckpoint));
                    ESRestTestCase.assertNotNull((Object)globalCheckpoint);
                    List retentionLeases = (List)XContentMapValues.extractValue((String)"retention_leases.leases", (Map)copy);
                    if (!mustHavePRRLs && retentionLeases == null) continue;
                    ESRestTestCase.assertNotNull((Object)retentionLeases);
                    for (Map retentionLease : retentionLeases) {
                        if (!((String)retentionLease.get("id")).startsWith("peer_recovery/")) continue;
                        ESRestTestCase.assertThat(retentionLease.get("retaining_seq_no"), Matchers.equalTo((Object)(globalCheckpoint + 1)));
                    }
                    if (!mustHavePRRLs) continue;
                    List existingLeaseIds = retentionLeases.stream().map(lease -> (String)lease.get("id")).collect(Collectors.toList());
                    List expectedLeaseIds = shard.stream().map(shr -> (String)XContentMapValues.extractValue((String)"routing.node", (Map)shr)).map(ReplicationTracker::getPeerRecoveryRetentionLeaseId).collect(Collectors.toList());
                    ESRestTestCase.assertThat("not every active copy has established its PPRL", expectedLeaseIds, Matchers.everyItem((org.hamcrest.Matcher)Matchers.in(existingLeaseIds)));
                }
            }
        }), 60L, TimeUnit.SECONDS);
    }

    protected static Map<String, Set<String>> getClusterStateFeatures(RestClient adminClient) throws IOException {
        Request request = new Request("GET", "_cluster/state");
        request.addParameter("filter_path", "nodes_features");
        Response response = adminClient.performRequest(request);
        Map<String, Object> responseData = ESRestTestCase.responseAsMap(response);
        Object object = responseData.get("nodes_features");
        if (object instanceof List) {
            List nodesFeatures = (List)object;
            return nodesFeatures.stream().map(Map.class::cast).collect(Collectors.toUnmodifiableMap(nodeFeatureMap -> nodeFeatureMap.get("node_id").toString(), nodeFeatureMap -> {
                List nodeFeatures = (List)nodeFeatureMap.get("features");
                return new HashSet(nodeFeatures);
            }));
        }
        return Map.of();
    }

    protected static IndexVersion minimumIndexVersion() throws IOException {
        Request request = new Request("GET", "_nodes");
        request.addParameter("filter_path", "nodes.*.version,nodes.*.max_index_version,nodes.*.index_version");
        Response response = ESRestTestCase.adminClient().performRequest(request);
        Map nodes = (Map)ObjectPath.createFromResponse(response).evaluate("nodes");
        IndexVersion minVersion = null;
        for (Map.Entry node : nodes.entrySet()) {
            IndexVersion indexVersion;
            Map nodeData = (Map)node.getValue();
            Object versionStr = nodeData.get("index_version");
            if (versionStr == null) {
                versionStr = nodeData.get("max_index_version");
            }
            IndexVersion indexVersion2 = indexVersion = versionStr != null ? IndexVersion.fromId((int)Integer.parseInt(versionStr.toString())) : IndexVersion.fromId((int)ESRestTestCase.parseLegacyVersion((String)nodeData.get("version")).map(Version::id).orElse(IndexVersions.MINIMUM_COMPATIBLE.id()));
            if (minVersion != null && !minVersion.after((VersionId)indexVersion)) continue;
            minVersion = indexVersion;
        }
        ESRestTestCase.assertNotNull(minVersion);
        return minVersion;
    }

    protected static TransportVersion minimumTransportVersion() throws IOException {
        Response response = client.performRequest(new Request("GET", "_nodes"));
        ObjectPath objectPath = ObjectPath.createFromResponse(response);
        Map nodesAsMap = (Map)objectPath.evaluate("nodes");
        TransportVersion minTransportVersion = null;
        for (String id : nodesAsMap.keySet()) {
            TransportVersion transportVersion = ESRestTestCase.getTransportVersionWithFallback((String)objectPath.evaluate("nodes." + id + ".version"), objectPath.evaluate("nodes." + id + ".transport_version"), () -> TransportVersions.MINIMUM_COMPATIBLE);
            if (minTransportVersion != null && !minTransportVersion.after((VersionId)transportVersion)) continue;
            minTransportVersion = transportVersion;
        }
        ESRestTestCase.assertNotNull(minTransportVersion);
        return minTransportVersion;
    }

    protected static TransportVersion getTransportVersionWithFallback(String versionField, Object transportVersionField, Supplier<TransportVersion> fallbackSupplier) {
        if (transportVersionField instanceof Number) {
            Number transportVersionId = (Number)transportVersionField;
            return TransportVersion.fromId((int)transportVersionId.intValue());
        }
        if (transportVersionField instanceof String) {
            String transportVersionString = (String)transportVersionField;
            return TransportVersion.fromString((String)transportVersionString);
        }
        Optional<Version> version = ESRestTestCase.parseLegacyVersion(versionField);
        assert (version.isPresent());
        if (version.get().before((VersionId)ClusterState.VERSION_INTRODUCING_TRANSPORT_VERSIONS)) {
            return TransportVersion.fromId((int)version.get().id);
        }
        return fallbackSupplier.get();
    }

    public static Optional<Version> parseLegacyVersion(String version) {
        Matcher semanticVersionMatcher = SEMANTIC_VERSION_PATTERN.matcher(version);
        if (semanticVersionMatcher.matches()) {
            return Optional.of(Version.fromString((String)semanticVersionMatcher.group(1)));
        }
        return Optional.empty();
    }

    protected static void waitForActiveLicense(RestClient restClient) throws Exception {
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            Request request = new Request("GET", "/_xpack");
            request.setOptions(RequestOptions.DEFAULT.toBuilder());
            Response response = restClient.performRequest(request);
            ESRestTestCase.assertOK(response);
            try (InputStream is = response.getEntity().getContent();){
                XContentType xContentType = XContentType.fromMediaType((String)response.getEntity().getContentType().getValue());
                Map map = XContentHelper.convertToMap((XContent)xContentType.xContent(), (InputStream)is, (boolean)true);
                ESRestTestCase.assertThat(map, Matchers.notNullValue());
                ESRestTestCase.assertThat("License must exist", map.containsKey("license"), Matchers.equalTo((Object)true));
                Map license = (Map)map.get("license");
                ESRestTestCase.assertThat("Expecting non-null license", license, Matchers.notNullValue());
                ESRestTestCase.assertThat("License status must exist", license.containsKey("status"), Matchers.equalTo((Object)true));
                String status = (String)license.get("status");
                ESRestTestCase.assertThat("Expecting non-null license status", status, Matchers.notNullValue());
                ESRestTestCase.assertThat("Expecting active license", status, Matchers.equalTo((Object)"active"));
            }
        }), 10L, TimeUnit.MINUTES);
    }

    protected static void useIgnoreMultipleMatchingTemplatesWarningsHandler(Request request) throws IOException {
        RequestOptions.Builder options = request.getOptions().toBuilder();
        options.setWarningsHandler(warnings -> {
            if (warnings.size() > 0) {
                boolean matches = warnings.stream().anyMatch(message -> CREATE_INDEX_MULTIPLE_MATCHING_TEMPLATES.matcher((CharSequence)message).matches() || PUT_TEMPLATE_MULTIPLE_MATCHING_TEMPLATES.matcher((CharSequence)message).matches());
                return !matches;
            }
            return false;
        });
        request.setOptions(options);
    }

    protected static boolean isNotFoundResponseException(IOException ioe) {
        if (ioe instanceof ResponseException) {
            Response response = ((ResponseException)((Object)ioe)).getResponse();
            return response.getStatusLine().getStatusCode() == 404;
        }
        return false;
    }

    protected FieldCapabilitiesResponse fieldCaps(List<String> indices, List<String> fields, QueryBuilder indexFilter, String fieldTypes, String fieldFilters) throws IOException {
        return this.fieldCaps(ESRestTestCase.client(), indices, fields, indexFilter, fieldTypes, fieldFilters);
    }

    protected FieldCapabilitiesResponse fieldCaps(RestClient restClient, List<String> indices, List<String> fields, QueryBuilder indexFilter, String fieldTypes, String fieldFilters) throws IOException {
        Request request = new Request("POST", "/_field_caps");
        request.addParameter("index", String.join((CharSequence)",", indices));
        request.addParameter("fields", String.join((CharSequence)",", fields));
        if (fieldTypes != null) {
            request.addParameter("types", fieldTypes);
        }
        if (fieldFilters != null) {
            request.addParameter("filters", fieldFilters);
        }
        if (indexFilter != null) {
            ESRestTestCase.addXContentBody(request, (body, params) -> body.field("index_filter", (ToXContent)indexFilter));
        }
        Response response = restClient.performRequest(request);
        ESRestTestCase.assertOK(response);
        try (XContentParser parser = ESRestTestCase.responseAsParser(response);){
            FieldCapabilitiesResponse fieldCapabilitiesResponse = FieldCapabilitiesResponse.fromXContent((XContentParser)parser);
            return fieldCapabilitiesResponse;
        }
    }

    private static boolean isMlEnabled() {
        try {
            ESRestTestCase.adminClient().performRequest(new Request("GET", "_ml/info"));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void setIgnoredErrorResponseCodes(Request request, RestStatus ... restStatuses) {
        request.addParameter("ignore", Arrays.stream(restStatuses).map(restStatus -> Integer.toString(restStatus.getStatus())).collect(Collectors.joining(",")));
    }

    private static XContentType randomSupportedContentType() {
        if (!ESRestTestCase.clusterHasFeature(RestTestLegacyFeatures.SUPPORTS_TRUE_BINARY_RESPONSES)) {
            return XContentType.JSON;
        }
        if (!ESRestTestCase.clusterHasFeature(RestTestLegacyFeatures.SUPPORTS_VENDOR_XCONTENT_TYPES)) {
            return ESRestTestCase.randomFrom(XContentType.JSON, XContentType.CBOR, XContentType.YAML, XContentType.SMILE);
        }
        return ESRestTestCase.randomFrom(XContentType.values());
    }

    public static void addXContentBody(Request request, ToXContent body) throws IOException {
        XContentType xContentType = ESRestTestCase.randomSupportedContentType();
        BytesReference bodyBytes = XContentHelper.toXContent((ToXContent)body, (XContentType)xContentType, (ToXContent.Params)ToXContent.EMPTY_PARAMS, (boolean)ESRestTestCase.randomBoolean());
        request.setEntity((HttpEntity)new InputStreamEntity((InputStream)bodyBytes.streamInput(), (long)bodyBytes.length(), ContentType.create((String)xContentType.mediaTypeWithoutParameters())));
    }

    public static Request newXContentRequest(HttpMethod method, String endpoint, ToXContent body) throws IOException {
        Request request = new Request(method.name(), endpoint);
        ESRestTestCase.addXContentBody(request, body);
        return request;
    }

    static {
        testFeatureService = TestFeatureService.ALL_FEATURES;
        BROADCAST_RESPONSE_PARSER = new ConstructingObjectParser("broadcast_response", true, arg -> {
            BaseBroadcastResponse response = (BaseBroadcastResponse)arg[0];
            return new BroadcastResponse(response.getTotalShards(), response.getSuccessfulShards(), response.getFailedShards(), Arrays.asList(response.getShardFailures()));
        });
        AbstractBroadcastResponseTestCase.declareBroadcastFields(BROADCAST_RESPONSE_PARSER);
        CREATE_INDEX_MULTIPLE_MATCHING_TEMPLATES = Pattern.compile("^index \\[(.+)\\] matches multiple legacy templates \\[(.+)\\], composable templates will only match a single template$");
        PUT_TEMPLATE_MULTIPLE_MATCHING_TEMPLATES = Pattern.compile("^index template \\[(.+)\\] has index patterns \\[(.+)\\] matching patterns from existing older templates \\[(.+)\\] with patterns \\((.+)\\); this template \\[(.+)\\] will take precedence during new index creation$");
    }

    public static enum ProductFeature {
        XPACK,
        ILM,
        SLM,
        ROLLUPS,
        CCR,
        SHUTDOWN,
        LEGACY_TEMPLATES,
        SEARCHABLE_SNAPSHOTS;

    }

    public static class VersionSensitiveWarningsHandler
    implements WarningsHandler {
        Set<String> requiredSameVersionClusterWarnings = new HashSet<String>();
        Set<String> allowedWarnings = new HashSet<String>();
        private final Set<String> testNodeVersions;

        VersionSensitiveWarningsHandler(Set<String> nodeVersions) {
            this.testNodeVersions = nodeVersions;
        }

        public void current(String ... requiredWarnings) {
            this.requiredSameVersionClusterWarnings.addAll(Arrays.asList(requiredWarnings));
        }

        public void compatible(String ... allowedWarningsToAdd) {
            this.allowedWarnings.addAll(Arrays.asList(allowedWarningsToAdd));
        }

        public boolean warningsShouldFailRequest(List<String> warnings) {
            if (this.isExclusivelyTargetingCurrentVersionCluster()) {
                HashSet<String> actual = new HashSet<String>(warnings);
                return false == this.requiredSameVersionClusterWarnings.equals(actual);
            }
            for (String actualWarning : warnings) {
                if (this.allowedWarnings.contains(actualWarning) || this.requiredSameVersionClusterWarnings.contains(actualWarning)) continue;
                return true;
            }
            return false;
        }

        private boolean isExclusivelyTargetingCurrentVersionCluster() {
            Assert.assertFalse((String)"Node versions running in the cluster are missing", (boolean)this.testNodeVersions.isEmpty());
            return this.testNodeVersions.size() == 1 && this.testNodeVersions.iterator().next().equals(Build.current().version());
        }
    }
}

