/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core;

import java.util.Objects;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.transport.LeakTracker;

public final class ReleasableRef<T extends RefCounted>
implements Releasable {
    private final Releasable closeResource;
    private final T resource;

    private ReleasableRef(T resource) {
        this.resource = (RefCounted)Objects.requireNonNull(resource);
        this.closeResource = LeakTracker.wrap((Releasable)Releasables.assertOnce(() -> resource.decRef()));
    }

    public void close() {
        this.closeResource.close();
    }

    public static <T extends RefCounted> ReleasableRef<T> of(T resource) {
        return new ReleasableRef<T>(resource);
    }

    public T get() {
        assert (this.resource.hasReferences()) : this.resource + " is closed";
        return this.resource;
    }

    public String toString() {
        return "ReleasableRef[" + this.resource + "]";
    }
}

