/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.function.ToLongBiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TotalHitCountCollectorManager;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.MapperTestUtils;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.codec.CodecProvider;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.engine.DocIdSeqNoAndSource;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.IdStoredFieldLoader;
import org.elasticsearch.index.engine.InternalEngine;
import org.elasticsearch.index.engine.InternalTestEngine;
import org.elasticsearch.index.engine.LazySoftDeletesDirectoryReaderWrapper;
import org.elasticsearch.index.engine.LiveVersionMapArchive;
import org.elasticsearch.index.engine.ReadOnlyEngine;
import org.elasticsearch.index.engine.SafeCommitInfo;
import org.elasticsearch.index.engine.TranslogHandler;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.SearcherHelper;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogDeletionPolicy;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.test.DummyShardLock;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.IndexSettingsModule;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.TestThreadPool;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;

public abstract class EngineTestCase
extends ESTestCase {
    protected final ShardId shardId = new ShardId(new Index("index", "_na_"), 0);
    protected final AllocationId allocationId = AllocationId.newInitializing();
    protected static final IndexSettings INDEX_SETTINGS = IndexSettingsModule.newIndexSettings("index", Settings.EMPTY, new Setting[0]);
    protected ThreadPool threadPool;
    protected TranslogHandler translogHandler;
    protected Store store;
    protected Store storeReplica;
    protected InternalEngine engine;
    protected InternalEngine replicaEngine;
    protected IndexSettings defaultSettings;
    protected String codecName;
    protected Path primaryTranslogDir;
    protected Path replicaTranslogDir;
    protected final PrimaryTermSupplier primaryTerm = new PrimaryTermSupplier(1L);
    protected static final BytesReference B_1 = new BytesArray(new byte[]{1});
    protected static final BytesReference B_2 = new BytesArray(new byte[]{2});
    protected static final BytesReference B_3 = new BytesArray(new byte[]{3});
    protected static final BytesArray SOURCE = EngineTestCase.bytesArray("{}");

    protected static void assertVisibleCount(Engine engine, int numDocs) throws IOException {
        EngineTestCase.assertVisibleCount(engine, numDocs, true);
    }

    protected static void assertVisibleCount(Engine engine, int numDocs, boolean refresh) throws IOException {
        if (refresh) {
            engine.refresh("test");
        }
        try (Engine.Searcher searcher = engine.acquireSearcher("test");){
            Integer totalHits = (Integer)searcher.search((Query)new MatchAllDocsQuery(), (CollectorManager)new TotalHitCountCollectorManager());
            EngineTestCase.assertThat(totalHits, Matchers.equalTo((Object)numDocs));
        }
    }

    protected Settings indexSettings() {
        return Settings.builder().put(IndexSettings.INDEX_GC_DELETES_SETTING.getKey(), "1h").put(EngineConfig.INDEX_CODEC_SETTING.getKey(), this.codecName).put("index.version.created", (VersionId)IndexVersion.current()).put(IndexSettings.MAX_REFRESH_LISTENERS_PER_SHARD.getKey(), EngineTestCase.between(10, 10 * (Integer)IndexSettings.MAX_REFRESH_LISTENERS_PER_SHARD.get(Settings.EMPTY))).put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.getKey(), EngineTestCase.between(0, 1000)).build();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.primaryTerm.set(EngineTestCase.randomLongBetween(1L, Long.MAX_VALUE));
        CodecService codecService = EngineTestCase.newCodecService();
        String name = Codec.getDefault().getName();
        this.codecName = Arrays.asList(codecService.availableCodecs()).contains(name) ? name : "default";
        this.defaultSettings = IndexSettingsModule.newIndexSettings("test", this.indexSettings(), new Setting[0]);
        this.threadPool = new TestThreadPool(((Object)((Object)this)).getClass().getName(), new ExecutorBuilder[0]);
        this.store = this.createStore();
        this.storeReplica = this.createStore();
        Lucene.cleanLuceneIndex((Directory)this.store.directory());
        Lucene.cleanLuceneIndex((Directory)this.storeReplica.directory());
        this.primaryTranslogDir = EngineTestCase.createTempDir((String)"translog-primary");
        this.translogHandler = this.createTranslogHandler(this.defaultSettings);
        this.engine = this.createEngine(this.store, this.primaryTranslogDir);
        LiveIndexWriterConfig currentIndexWriterConfig = this.engine.getCurrentIndexWriterConfig();
        EngineTestCase.assertEquals((Object)this.engine.config().getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        EngineTestCase.assertEquals((Object)currentIndexWriterConfig.getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        EngineTestCase.assertEquals((Object)this.engine.getLiveVersionMap().getArchive(), (Object)LiveVersionMapArchive.NOOP_ARCHIVE);
        if (EngineTestCase.randomBoolean()) {
            this.engine.config().setEnableGcDeletes(false);
        }
        this.replicaTranslogDir = EngineTestCase.createTempDir((String)"translog-replica");
        this.replicaEngine = this.createEngine(this.storeReplica, this.replicaTranslogDir);
        currentIndexWriterConfig = this.replicaEngine.getCurrentIndexWriterConfig();
        EngineTestCase.assertEquals((Object)this.replicaEngine.config().getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        EngineTestCase.assertEquals((Object)currentIndexWriterConfig.getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        if (EngineTestCase.randomBoolean()) {
            this.engine.config().setEnableGcDeletes(false);
        }
    }

    public static EngineConfig copy(EngineConfig config, LongSupplier globalCheckpointSupplier) {
        return new EngineConfig(config.getShardId(), config.getThreadPool(), config.getIndexSettings(), config.getWarmer(), config.getStore(), config.getMergePolicy(), config.getAnalyzer(), config.getSimilarity(), config.getCodecProvider(), config.getEventListener(), config.getQueryCache(), config.getQueryCachingPolicy(), config.getTranslogConfig(), config.getFlushMergesAfter(), config.getExternalRefreshListener(), Collections.emptyList(), config.getIndexSort(), config.getCircuitBreakerService(), globalCheckpointSupplier, config.retentionLeasesSupplier(), config.getPrimaryTermSupplier(), config.getSnapshotCommitSupplier(), config.getLeafSorter(), config.getRelativeTimeInNanosSupplier(), config.getIndexCommitListener(), config.isPromotableToPrimary(), config.getMapperService());
    }

    public EngineConfig copy(EngineConfig config, Analyzer analyzer) {
        return new EngineConfig(config.getShardId(), config.getThreadPool(), config.getIndexSettings(), config.getWarmer(), config.getStore(), config.getMergePolicy(), analyzer, config.getSimilarity(), config.getCodecProvider(), config.getEventListener(), config.getQueryCache(), config.getQueryCachingPolicy(), config.getTranslogConfig(), config.getFlushMergesAfter(), config.getExternalRefreshListener(), Collections.emptyList(), config.getIndexSort(), config.getCircuitBreakerService(), config.getGlobalCheckpointSupplier(), config.retentionLeasesSupplier(), config.getPrimaryTermSupplier(), config.getSnapshotCommitSupplier(), config.getLeafSorter(), config.getRelativeTimeInNanosSupplier(), config.getIndexCommitListener(), config.isPromotableToPrimary(), config.getMapperService());
    }

    public EngineConfig copy(EngineConfig config, MergePolicy mergePolicy) {
        return new EngineConfig(config.getShardId(), config.getThreadPool(), config.getIndexSettings(), config.getWarmer(), config.getStore(), mergePolicy, config.getAnalyzer(), config.getSimilarity(), config.getCodecProvider(), config.getEventListener(), config.getQueryCache(), config.getQueryCachingPolicy(), config.getTranslogConfig(), config.getFlushMergesAfter(), config.getExternalRefreshListener(), Collections.emptyList(), config.getIndexSort(), config.getCircuitBreakerService(), config.getGlobalCheckpointSupplier(), config.retentionLeasesSupplier(), config.getPrimaryTermSupplier(), config.getSnapshotCommitSupplier(), config.getLeafSorter(), config.getRelativeTimeInNanosSupplier(), config.getIndexCommitListener(), config.isPromotableToPrimary(), config.getMapperService());
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        try {
            if (this.engine != null && !this.engine.isClosed.get()) {
                this.engine.getTranslog().getDeletionPolicy().assertNoOpenTranslogRefs();
                EngineTestCase.assertNoInFlightDocuments((Engine)this.engine);
                EngineTestCase.assertConsistentHistoryBetweenTranslogAndLuceneIndex((Engine)this.engine);
                EngineTestCase.assertMaxSeqNoInCommitUserData((Engine)this.engine);
                EngineTestCase.assertAtMostOneLuceneDocumentPerSequenceNumber((Engine)this.engine);
            }
            if (this.replicaEngine != null && !this.replicaEngine.isClosed.get()) {
                this.replicaEngine.getTranslog().getDeletionPolicy().assertNoOpenTranslogRefs();
                EngineTestCase.assertNoInFlightDocuments((Engine)this.replicaEngine);
                EngineTestCase.assertConsistentHistoryBetweenTranslogAndLuceneIndex((Engine)this.replicaEngine);
                EngineTestCase.assertMaxSeqNoInCommitUserData((Engine)this.replicaEngine);
                EngineTestCase.assertAtMostOneLuceneDocumentPerSequenceNumber((Engine)this.replicaEngine);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{this.replicaEngine, this.storeReplica, this.engine, this.store, () -> EngineTestCase.terminate(this.threadPool)});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{this.replicaEngine, this.storeReplica, this.engine, this.store, () -> EngineTestCase.terminate(this.threadPool)});
    }

    protected static LuceneDocument testDocumentWithTextField() {
        return EngineTestCase.testDocumentWithTextField("test");
    }

    protected static LuceneDocument testDocumentWithTextField(String value) {
        LuceneDocument document = EngineTestCase.testDocument();
        document.add((IndexableField)new TextField("value", value, Field.Store.YES));
        return document;
    }

    protected static LuceneDocument testDocument() {
        return new LuceneDocument();
    }

    public static ParsedDocument createParsedDoc(String id, String routing) {
        return EngineTestCase.testParsedDocument(id, routing, EngineTestCase.testDocumentWithTextField(), (BytesReference)new BytesArray("{ \"value\" : \"test\" }"), null, false);
    }

    public static ParsedDocument createParsedDoc(String id, String routing, boolean recoverySource) {
        return EngineTestCase.testParsedDocument(id, routing, EngineTestCase.testDocumentWithTextField(), (BytesReference)new BytesArray("{ \"value\" : \"test\" }"), null, recoverySource);
    }

    protected ParsedDocument testParsedDocument(String id, String routing, LuceneDocument document, BytesReference source, Mapping mappingUpdate) {
        return EngineTestCase.testParsedDocument(id, routing, document, source, mappingUpdate, false);
    }

    protected static ParsedDocument testParsedDocument(String id, String routing, LuceneDocument document, BytesReference source, Mapping mappingUpdate, boolean recoverySource) {
        StringField idField = new StringField("_id", Uid.encodeId((String)id), Field.Store.YES);
        NumericDocValuesField versionField = new NumericDocValuesField("_version", 0L);
        SeqNoFieldMapper.SequenceIDFields seqID = SeqNoFieldMapper.SequenceIDFields.emptySeqID();
        document.add((IndexableField)idField);
        document.add((IndexableField)versionField);
        seqID.addFields(document);
        BytesRef ref = source.toBytesRef();
        if (recoverySource) {
            document.add((IndexableField)new StoredField("_recovery_source", ref.bytes, ref.offset, ref.length));
            document.add((IndexableField)new NumericDocValuesField("_recovery_source", 1L));
        } else {
            document.add((IndexableField)new StoredField("_source", ref.bytes, ref.offset, ref.length));
        }
        return new ParsedDocument((Field)versionField, seqID, id, routing, Arrays.asList(document), source, XContentType.JSON, mappingUpdate, ParsedDocument.DocumentSize.UNKNOWN);
    }

    public static CheckedBiFunction<String, Integer, ParsedDocument, IOException> nestedParsedDocFactory() throws Exception {
        MapperService mapperService = EngineTestCase.createMapperService();
        String nestedMapping = Strings.toString((XContentBuilder)XContentFactory.jsonBuilder().startObject().startObject("type").startObject("properties").startObject("nested_field").field("type", "nested").endObject().endObject().endObject().endObject());
        DocumentMapper nestedMapper = mapperService.merge("type", new CompressedXContent(nestedMapping), MapperService.MergeReason.MAPPING_UPDATE);
        return (docId, nestedFieldValues) -> {
            XContentBuilder source = XContentFactory.jsonBuilder().startObject().field("field", "value");
            if (nestedFieldValues > 0) {
                XContentBuilder nestedField = source.startObject("nested_field");
                for (int i = 0; i < nestedFieldValues; ++i) {
                    nestedField.field("field-" + i, "value-" + i);
                }
                source.endObject();
            }
            source.endObject();
            return nestedMapper.parse(new SourceToParse(docId, BytesReference.bytes((XContentBuilder)source), XContentType.JSON));
        };
    }

    protected Store createStore() throws IOException {
        return this.createStore((Directory)EngineTestCase.newDirectory());
    }

    protected Store createStore(Directory directory) throws IOException {
        return this.createStore(INDEX_SETTINGS, directory);
    }

    protected Store createStore(IndexSettings indexSettings, Directory directory) throws IOException {
        return new Store(this.shardId, indexSettings, directory, (ShardLock)new DummyShardLock(this.shardId));
    }

    protected Translog createTranslog(LongSupplier primaryTermSupplier) throws IOException {
        return this.createTranslog(this.primaryTranslogDir, primaryTermSupplier);
    }

    protected Translog createTranslog(Path translogPath, LongSupplier primaryTermSupplier) throws IOException {
        TranslogConfig translogConfig = new TranslogConfig(this.shardId, translogPath, INDEX_SETTINGS, BigArrays.NON_RECYCLING_INSTANCE);
        String translogUUID = Translog.createEmptyTranslog((Path)translogPath, (long)-1L, (ShardId)this.shardId, (long)primaryTermSupplier.getAsLong());
        return new Translog(translogConfig, translogUUID, new TranslogDeletionPolicy(), () -> -1L, primaryTermSupplier, seqNo -> {});
    }

    protected TranslogHandler createTranslogHandler(IndexSettings indexSettings) {
        return new TranslogHandler(this.xContentRegistry(), indexSettings);
    }

    protected InternalEngine createEngine(Store store, Path translogPath) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null);
    }

    protected InternalEngine createEngine(Store store, Path translogPath, LongSupplier globalCheckpointSupplier) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, null, globalCheckpointSupplier);
    }

    protected InternalEngine createEngine(Store store, Path translogPath, BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, localCheckpointTrackerSupplier, null);
    }

    protected InternalEngine createEngine(Store store, Path translogPath, BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, localCheckpointTrackerSupplier, null, seqNoForOperation);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, null);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, indexWriterFactory, null, null);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable LongSupplier globalCheckpointSupplier) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, indexWriterFactory, localCheckpointTrackerSupplier, null, null, globalCheckpointSupplier);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable LongSupplier globalCheckpointSupplier, @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, indexWriterFactory, localCheckpointTrackerSupplier, seqNoForOperation, null, globalCheckpointSupplier);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation, @Nullable Sort indexSort, @Nullable LongSupplier globalCheckpointSupplier) throws IOException {
        EngineConfig config = this.config(indexSettings, store, translogPath, mergePolicy, null, indexSort, globalCheckpointSupplier);
        return this.createEngine(indexWriterFactory, localCheckpointTrackerSupplier, seqNoForOperation, config);
    }

    protected InternalEngine createEngine(EngineConfig config) throws IOException {
        return this.createEngine(null, null, null, config);
    }

    protected InternalEngine createEngine(@Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation, EngineConfig config) throws IOException {
        Store store = config.getStore();
        Directory directory = store.directory();
        if (!Lucene.indexExists((Directory)directory)) {
            store.createEmpty();
            String translogUuid = Translog.createEmptyTranslog((Path)config.getTranslogConfig().getTranslogPath(), (long)-1L, (ShardId)this.shardId, (long)this.primaryTerm.get());
            store.associateIndexWithNewTranslog(translogUuid);
        }
        InternalEngine internalEngine = EngineTestCase.createInternalEngine(indexWriterFactory, localCheckpointTrackerSupplier, seqNoForOperation, config);
        EngineTestCase.recoverFromTranslog((Engine)internalEngine, this.translogHandler, Long.MAX_VALUE);
        return internalEngine;
    }

    public static InternalEngine createEngine(EngineConfig engineConfig, int maxDocs) {
        return new InternalEngine(engineConfig, maxDocs, LocalCheckpointTracker::new);
    }

    public static long generateNewSeqNo(Engine engine) {
        assert (engine instanceof InternalEngine) : "expected InternalEngine, got: " + engine.getClass();
        InternalEngine internalEngine = (InternalEngine)engine;
        return internalEngine.getLocalCheckpointTracker().generateSeqNo();
    }

    public static InternalEngine createInternalEngine(final @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, final @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation, EngineConfig config) {
        if (localCheckpointTrackerSupplier == null) {
            return new InternalTestEngine(config){

                protected IndexWriter createWriter(Directory directory, IndexWriterConfig iwc) throws IOException {
                    return indexWriterFactory != null ? indexWriterFactory.createWriter(directory, iwc) : super.createWriter(directory, iwc);
                }

                protected long doGenerateSeqNoForOperation(Engine.Operation operation) {
                    return seqNoForOperation != null ? seqNoForOperation.applyAsLong(this, operation) : super.doGenerateSeqNoForOperation(operation);
                }
            };
        }
        return new InternalTestEngine(config, 0x7FFFFF7F, localCheckpointTrackerSupplier){

            protected IndexWriter createWriter(Directory directory, IndexWriterConfig iwc) throws IOException {
                return indexWriterFactory != null ? indexWriterFactory.createWriter(directory, iwc) : super.createWriter(directory, iwc);
            }

            protected long doGenerateSeqNoForOperation(Engine.Operation operation) {
                return seqNoForOperation != null ? seqNoForOperation.applyAsLong(this, operation) : super.doGenerateSeqNoForOperation(operation);
            }
        };
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener refreshListener) {
        return this.config(indexSettings, store, translogPath, mergePolicy, refreshListener, null, () -> -1L);
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener refreshListener, Sort indexSort, LongSupplier globalCheckpointSupplier) {
        return this.config(indexSettings, store, translogPath, mergePolicy, refreshListener, indexSort, globalCheckpointSupplier, globalCheckpointSupplier == null ? null : () -> RetentionLeases.EMPTY);
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener refreshListener, Sort indexSort, LongSupplier globalCheckpointSupplier, Supplier<RetentionLeases> retentionLeasesSupplier) {
        return this.config(indexSettings, store, translogPath, mergePolicy, refreshListener, null, indexSort, globalCheckpointSupplier, retentionLeasesSupplier, (CircuitBreakerService)new NoneCircuitBreakerService(), null);
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener externalRefreshListener, ReferenceManager.RefreshListener internalRefreshListener, Sort indexSort, @Nullable LongSupplier maybeGlobalCheckpointSupplier, CircuitBreakerService breakerService) {
        return this.config(indexSettings, store, translogPath, mergePolicy, externalRefreshListener, internalRefreshListener, indexSort, maybeGlobalCheckpointSupplier, maybeGlobalCheckpointSupplier == null ? null : () -> RetentionLeases.EMPTY, breakerService, null);
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener externalRefreshListener, ReferenceManager.RefreshListener internalRefreshListener, Sort indexSort, @Nullable LongSupplier maybeGlobalCheckpointSupplier, @Nullable Supplier<RetentionLeases> maybeRetentionLeasesSupplier, CircuitBreakerService breakerService, @Nullable Engine.IndexCommitListener indexCommitListener) {
        Supplier<RetentionLeases> retentionLeasesSupplier;
        LongSupplier globalCheckpointSupplier;
        List<Object> intRefreshListenerList;
        IndexWriterConfig iwc = EngineTestCase.newIndexWriterConfig();
        TranslogConfig translogConfig = new TranslogConfig(this.shardId, translogPath, indexSettings, BigArrays.NON_RECYCLING_INSTANCE);
        Engine.EventListener eventListener = new Engine.EventListener(){};
        List<Object> extRefreshListenerList = externalRefreshListener == null ? Collections.emptyList() : Collections.singletonList(externalRefreshListener);
        List<Object> list = intRefreshListenerList = internalRefreshListener == null ? Collections.emptyList() : Collections.singletonList(internalRefreshListener);
        if (maybeGlobalCheckpointSupplier == null) {
            assert (maybeRetentionLeasesSupplier == null);
            ReplicationTracker replicationTracker = new ReplicationTracker(this.shardId, this.allocationId.getId(), indexSettings, EngineTestCase.randomNonNegativeLong(), -1L, update -> {}, () -> 0L, (leases, listener) -> listener.onResponse((Object)new ReplicationResponse()), () -> SafeCommitInfo.EMPTY);
            globalCheckpointSupplier = replicationTracker;
            retentionLeasesSupplier = () -> ((ReplicationTracker)replicationTracker).getRetentionLeases();
        } else {
            assert (maybeRetentionLeasesSupplier != null);
            globalCheckpointSupplier = maybeGlobalCheckpointSupplier;
            retentionLeasesSupplier = maybeRetentionLeasesSupplier;
        }
        return new EngineConfig(this.shardId, this.threadPool, indexSettings, null, store, mergePolicy, iwc.getAnalyzer(), iwc.getSimilarity(), (CodecProvider)EngineTestCase.newCodecService(), eventListener, IndexSearcher.getDefaultQueryCache(), IndexSearcher.getDefaultQueryCachingPolicy(), translogConfig, TimeValue.timeValueMinutes((long)5L), extRefreshListenerList, intRefreshListenerList, indexSort, breakerService, globalCheckpointSupplier, retentionLeasesSupplier, (LongSupplier)this.primaryTerm, IndexModule.DEFAULT_SNAPSHOT_COMMIT_SUPPLIER, null, this::relativeTimeInNanos, indexCommitListener, true, null);
    }

    protected EngineConfig config(EngineConfig config, Store store, Path translogPath) {
        IndexSettings indexSettings = IndexSettingsModule.newIndexSettings("test", Settings.builder().put(config.getIndexSettings().getSettings()).put(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), true).build(), new Setting[0]);
        TranslogConfig translogConfig = new TranslogConfig(this.shardId, translogPath, indexSettings, BigArrays.NON_RECYCLING_INSTANCE);
        return new EngineConfig(config.getShardId(), config.getThreadPool(), indexSettings, config.getWarmer(), store, config.getMergePolicy(), config.getAnalyzer(), config.getSimilarity(), (CodecProvider)EngineTestCase.newCodecService(), config.getEventListener(), config.getQueryCache(), config.getQueryCachingPolicy(), translogConfig, config.getFlushMergesAfter(), config.getExternalRefreshListener(), config.getInternalRefreshListener(), config.getIndexSort(), config.getCircuitBreakerService(), config.getGlobalCheckpointSupplier(), config.retentionLeasesSupplier(), config.getPrimaryTermSupplier(), config.getSnapshotCommitSupplier(), config.getLeafSorter(), config.getRelativeTimeInNanosSupplier(), config.getIndexCommitListener(), config.isPromotableToPrimary(), config.getMapperService());
    }

    protected EngineConfig noOpConfig(IndexSettings indexSettings, Store store, Path translogPath) {
        return this.noOpConfig(indexSettings, store, translogPath, null);
    }

    protected EngineConfig noOpConfig(IndexSettings indexSettings, Store store, Path translogPath, LongSupplier globalCheckpointSupplier) {
        return this.config(indexSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, null, globalCheckpointSupplier);
    }

    protected static BytesArray bytesArray(String string) {
        return new BytesArray(string.getBytes(Charset.defaultCharset()));
    }

    public static BytesRef newUid(ParsedDocument doc) {
        return Uid.encodeId((String)doc.id());
    }

    protected Engine.Get newGet(boolean realtime, ParsedDocument doc) {
        return new Engine.Get(realtime, realtime, doc.id());
    }

    protected Engine.Index indexForDoc(ParsedDocument doc) {
        return new Engine.Index(EngineTestCase.newUid(doc), this.primaryTerm.get(), doc);
    }

    protected Engine.Index replicaIndexForDoc(ParsedDocument doc, long version, long seqNo, boolean isRetry) {
        return new Engine.Index(EngineTestCase.newUid(doc), doc, seqNo, this.primaryTerm.get(), version, null, Engine.Operation.Origin.REPLICA, System.nanoTime(), -1L, isRetry, -2L, 0L);
    }

    protected Engine.Delete replicaDeleteForDoc(String id, long version, long seqNo, long startTime) {
        return new Engine.Delete(id, Uid.encodeId((String)id), seqNo, 1L, version, null, Engine.Operation.Origin.REPLICA, startTime, -2L, 0L);
    }

    protected static void assertVisibleCount(InternalEngine engine, int numDocs) throws IOException {
        EngineTestCase.assertVisibleCount(engine, numDocs, true);
    }

    protected static void assertVisibleCount(InternalEngine engine, int numDocs, boolean refresh) throws IOException {
        if (refresh) {
            engine.refresh("test");
        }
        try (Engine.Searcher searcher = engine.acquireSearcher("test");){
            Integer totalHits = (Integer)searcher.search((Query)new MatchAllDocsQuery(), (CollectorManager)new TotalHitCountCollectorManager());
            EngineTestCase.assertThat(totalHits, Matchers.equalTo((Object)numDocs));
        }
    }

    public static List<Engine.Operation> generateSingleDocHistory(boolean forReplica, VersionType versionType, long primaryTerm, int minOpCount, int maxOpCount, String docId) {
        int numOfOps = EngineTestCase.randomIntBetween(minOpCount, maxOpCount);
        ArrayList<Engine.Operation> ops = new ArrayList<Engine.Operation>();
        BytesRef id = Uid.encodeId((String)docId);
        boolean startWithSeqNo = false;
        String valuePrefix = (forReplica ? "r_" : "p_") + docId + "_";
        boolean incrementTermWhenIntroducingSeqNo = EngineTestCase.randomBoolean();
        for (int i = 0; i < numOfOps; ++i) {
            long version;
            switch (versionType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INTERNAL: {
                    long l;
                    if (forReplica) {
                        l = i;
                        break;
                    }
                    l = -3L;
                    break;
                }
                case EXTERNAL: {
                    long l = i;
                    break;
                }
                case EXTERNAL_GTE: {
                    long l = version = EngineTestCase.randomBoolean() ? (long)Math.max(i - 1, 0) : (long)i;
                }
            }
            Object op = EngineTestCase.randomBoolean() ? new Engine.Index(id, EngineTestCase.testParsedDocument(docId, null, EngineTestCase.testDocumentWithTextField(valuePrefix + i), (BytesReference)SOURCE, null, false), forReplica && i >= 0 ? (long)(i * 2) : -2L, forReplica && i >= 0 && incrementTermWhenIntroducingSeqNo ? primaryTerm + 1L : primaryTerm, version, forReplica ? null : versionType, forReplica ? Engine.Operation.Origin.REPLICA : Engine.Operation.Origin.PRIMARY, System.currentTimeMillis(), -1L, false, -2L, 0L) : new Engine.Delete(docId, id, forReplica && i >= 0 ? (long)(i * 2) : -2L, forReplica && i >= 0 && incrementTermWhenIntroducingSeqNo ? primaryTerm + 1L : primaryTerm, version, forReplica ? null : versionType, forReplica ? Engine.Operation.Origin.REPLICA : Engine.Operation.Origin.PRIMARY, System.currentTimeMillis(), -2L, 0L);
            ops.add((Engine.Operation)op);
        }
        return ops;
    }

    public List<Engine.Operation> generateHistoryOnReplica(int numOps, boolean allowGapInSeqNo, boolean allowDuplicate, boolean includeNestedDocs) throws Exception {
        return this.generateHistoryOnReplica(numOps, 0L, allowGapInSeqNo, allowDuplicate, includeNestedDocs);
    }

    public List<Engine.Operation> generateHistoryOnReplica(int numOps, long startingSeqNo, boolean allowGapInSeqNo, boolean allowDuplicate, boolean includeNestedDocs) throws Exception {
        long seqNo = startingSeqNo;
        int maxIdValue = EngineTestCase.randomInt(numOps * 2);
        ArrayList<Engine.Operation> operations = new ArrayList<Engine.Operation>(numOps);
        CheckedBiFunction<String, Integer, ParsedDocument, IOException> nestedParsedDocFactory = EngineTestCase.nestedParsedDocFactory();
        for (int i = 0; i < numOps; ++i) {
            String id = Integer.toString(EngineTestCase.randomInt(maxIdValue));
            Engine.Operation.TYPE opType = EngineTestCase.randomFrom(Engine.Operation.TYPE.values());
            boolean isNestedDoc = includeNestedDocs && opType == Engine.Operation.TYPE.INDEX && EngineTestCase.randomBoolean();
            int nestedValues = EngineTestCase.between(0, 3);
            long startTime = this.threadPool.relativeTimeInNanos();
            int copies = allowDuplicate && EngineTestCase.rarely() ? EngineTestCase.between(2, 4) : 1;
            block6: for (int copy = 0; copy < copies; ++copy) {
                ParsedDocument doc = isNestedDoc ? (ParsedDocument)nestedParsedDocFactory.apply((Object)id, (Object)nestedValues) : EngineTestCase.createParsedDoc(id, null);
                switch (opType) {
                    case INDEX: {
                        operations.add((Engine.Operation)new Engine.Index(EngineTestCase.newUid(doc), doc, seqNo, this.primaryTerm.get(), (long)i, null, EngineTestCase.randomFrom(Engine.Operation.Origin.REPLICA, Engine.Operation.Origin.PEER_RECOVERY), startTime, -1L, true, -2L, 0L));
                        continue block6;
                    }
                    case DELETE: {
                        operations.add((Engine.Operation)new Engine.Delete(doc.id(), EngineTestCase.newUid(doc), seqNo, this.primaryTerm.get(), (long)i, null, EngineTestCase.randomFrom(Engine.Operation.Origin.REPLICA, Engine.Operation.Origin.PEER_RECOVERY), startTime, -2L, 0L));
                        continue block6;
                    }
                    case NO_OP: {
                        operations.add((Engine.Operation)new Engine.NoOp(seqNo, this.primaryTerm.get(), EngineTestCase.randomFrom(Engine.Operation.Origin.REPLICA, Engine.Operation.Origin.PEER_RECOVERY), startTime, "test-" + i));
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Unknown operation type [" + opType + "]");
                    }
                }
            }
            ++seqNo;
            if (!allowGapInSeqNo || !EngineTestCase.rarely()) continue;
            ++seqNo;
        }
        Randomness.shuffle(operations);
        return operations;
    }

    public static void assertOpsOnReplica(List<Engine.Operation> ops, InternalEngine replicaEngine, boolean shuffleOps, Logger logger) throws IOException {
        String lastFieldValue;
        Engine.Operation lastOp = ops.get(ops.size() - 1);
        if (lastOp instanceof Engine.Index) {
            Engine.Index index = (Engine.Index)lastOp;
            lastFieldValue = ((LuceneDocument)index.docs().get(0)).get("value");
        } else {
            lastFieldValue = null;
        }
        if (shuffleOps) {
            int firstOpWithSeqNo;
            for (firstOpWithSeqNo = 0; firstOpWithSeqNo < ops.size() && ops.get(firstOpWithSeqNo).seqNo() < 0L; ++firstOpWithSeqNo) {
            }
            Collections.shuffle(ops.subList(0, firstOpWithSeqNo), EngineTestCase.random());
            Collections.shuffle(ops.subList(firstOpWithSeqNo, ops.size()), EngineTestCase.random());
        }
        boolean firstOp = true;
        for (Engine.Operation op : ops) {
            logger.info("performing [{}], v [{}], seq# [{}], term [{}]", (Object)Character.valueOf(op.operationType().name().charAt(0)), (Object)op.version(), (Object)op.seqNo(), (Object)op.primaryTerm());
            if (op instanceof Engine.Index) {
                result = replicaEngine.index((Engine.Index)op);
                EngineTestCase.assertThat(result.isCreated(), Matchers.equalTo((Object)firstOp));
                EngineTestCase.assertThat(result.getVersion(), Matchers.equalTo((Object)op.version()));
                EngineTestCase.assertThat(result.getResultType(), Matchers.equalTo((Object)Engine.Result.Type.SUCCESS));
            } else {
                result = replicaEngine.delete((Engine.Delete)op);
                EngineTestCase.assertThat(result.isFound(), Matchers.equalTo((Object)(!firstOp ? 1 : 0)));
                EngineTestCase.assertThat(result.getVersion(), Matchers.equalTo((Object)op.version()));
                EngineTestCase.assertThat(result.getResultType(), Matchers.equalTo((Object)Engine.Result.Type.SUCCESS));
            }
            if (EngineTestCase.randomBoolean()) {
                replicaEngine.refresh("test");
            }
            if (EngineTestCase.randomBoolean()) {
                replicaEngine.flush();
                replicaEngine.refresh("test");
            }
            firstOp = false;
        }
        EngineTestCase.assertVisibleCount(replicaEngine, lastFieldValue == null ? 0 : 1);
        if (lastFieldValue != null) {
            try (Engine.Searcher searcher = replicaEngine.acquireSearcher("test");){
                Integer totalHits = (Integer)searcher.search((Query)new TermQuery(new Term("value", lastFieldValue)), (CollectorManager)new TotalHitCountCollectorManager());
                EngineTestCase.assertThat(totalHits, Matchers.equalTo((Object)1));
            }
        }
    }

    public static void concurrentlyApplyOps(List<Engine.Operation> ops, InternalEngine engine) throws InterruptedException {
        int threadCount = EngineTestCase.randomIntBetween(3, 5);
        AtomicInteger offset = new AtomicInteger(-1);
        EngineTestCase.startInParallel(threadCount, i -> {
            int docOffset;
            while ((docOffset = offset.incrementAndGet()) < ops.size()) {
                try {
                    EngineTestCase.applyOperation((Engine)engine, (Engine.Operation)ops.get(docOffset));
                    if ((docOffset + 1) % 4 == 0) {
                        engine.refresh("test");
                    }
                    if (!EngineTestCase.rarely()) continue;
                    engine.flush();
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
        });
    }

    public static void applyOperations(Engine engine, List<Engine.Operation> operations) throws IOException {
        for (Engine.Operation operation : operations) {
            EngineTestCase.applyOperation(engine, operation);
            if (EngineTestCase.randomInt(100) < 10) {
                engine.refresh("test");
            }
            if (!EngineTestCase.rarely()) continue;
            engine.flush();
        }
    }

    public static Engine.Result applyOperation(Engine engine, Engine.Operation operation) throws IOException {
        Engine.IndexResult result = switch (operation.operationType()) {
            default -> throw new IncompatibleClassChangeError();
            case Engine.Operation.TYPE.INDEX -> engine.index((Engine.Index)operation);
            case Engine.Operation.TYPE.DELETE -> engine.delete((Engine.Delete)operation);
            case Engine.Operation.TYPE.NO_OP -> engine.noOp((Engine.NoOp)operation);
        };
        return result;
    }

    public static List<DocIdSeqNoAndSource> getDocIds(Engine engine, boolean refresh) throws IOException {
        if (refresh) {
            engine.refresh("test_get_doc_ids");
        }
        try (Engine.Searcher searcher = engine.acquireSearcher("test_get_doc_ids", Engine.SearcherScope.INTERNAL);){
            ArrayList<DocIdSeqNoAndSource> docs = new ArrayList<DocIdSeqNoAndSource>();
            for (LeafReaderContext leafContext : searcher.getIndexReader().leaves()) {
                LeafReader reader = leafContext.reader();
                NumericDocValues seqNoDocValues = reader.getNumericDocValues("_seq_no");
                NumericDocValues primaryTermDocValues = reader.getNumericDocValues("_primary_term");
                NumericDocValues versionDocValues = reader.getNumericDocValues("_version");
                Bits liveDocs = reader.getLiveDocs();
                StoredFields storedFields = reader.storedFields();
                for (int i = 0; i < reader.maxDoc(); ++i) {
                    if (liveDocs != null && !liveDocs.get(i) || !primaryTermDocValues.advanceExact(i)) continue;
                    long primaryTerm = primaryTermDocValues.longValue();
                    Document doc = storedFields.document(i, Set.of("_id", "_source"));
                    BytesRef binaryID = doc.getBinaryValue("_id");
                    String id = Uid.decodeId((byte[])Arrays.copyOfRange(binaryID.bytes, binaryID.offset, binaryID.offset + binaryID.length));
                    BytesRef source = doc.getBinaryValue("_source");
                    if (!seqNoDocValues.advanceExact(i)) {
                        throw new AssertionError((Object)("seqNoDocValues not found for doc[" + i + "] id[" + id + "]"));
                    }
                    long seqNo = seqNoDocValues.longValue();
                    if (!versionDocValues.advanceExact(i)) {
                        throw new AssertionError((Object)("versionDocValues not found for doc[" + i + "] id[" + id + "]"));
                    }
                    long version = versionDocValues.longValue();
                    docs.add(new DocIdSeqNoAndSource(id, source, seqNo, primaryTerm, version));
                }
            }
            docs.sort(Comparator.comparingLong(DocIdSeqNoAndSource::seqNo).thenComparingLong(DocIdSeqNoAndSource::primaryTerm).thenComparing(DocIdSeqNoAndSource::id));
            ArrayList<DocIdSeqNoAndSource> arrayList = docs;
            return arrayList;
        }
    }

    public static List<Translog.Operation> readAllOperationsInLucene(Engine engine) throws IOException {
        ArrayList<Translog.Operation> operations = new ArrayList<Translog.Operation>();
        try (Translog.Snapshot snapshot = engine.newChangesSnapshot("test", 0L, Long.MAX_VALUE, false, EngineTestCase.randomBoolean(), EngineTestCase.randomBoolean());){
            Translog.Operation op;
            while ((op = snapshot.next()) != null) {
                operations.add(op);
            }
        }
        return operations;
    }

    public static void assertConsistentHistoryBetweenTranslogAndLuceneIndex(Engine engine) throws IOException {
        long minSeqNoToRetain;
        if (!(engine instanceof InternalEngine)) {
            return;
        }
        ArrayList<Translog.Operation> translogOps = new ArrayList<Translog.Operation>();
        try (Translog.Snapshot snapshot = EngineTestCase.getTranslog(engine).newSnapshot();){
            Translog.Operation op;
            while ((op = snapshot.next()) != null) {
                translogOps.add(op);
            }
        }
        Map luceneOps = EngineTestCase.readAllOperationsInLucene(engine).stream().collect(Collectors.toMap(Translog.Operation::seqNo, Function.identity()));
        long maxSeqNo = ((InternalEngine)engine).getLocalCheckpointTracker().getMaxSeqNo();
        for (Translog.Operation op : translogOps) {
            EngineTestCase.assertThat("translog operation [" + op + "] > max_seq_no[" + maxSeqNo + "]", op.seqNo(), Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(maxSeqNo)));
        }
        for (Translog.Operation op : luceneOps.values()) {
            EngineTestCase.assertThat("lucene operation [" + op + "] > max_seq_no[" + maxSeqNo + "]", op.seqNo(), Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(maxSeqNo)));
        }
        long globalCheckpoint = EngineTestCase.getTranslog(engine).getLastSyncedGlobalCheckpoint();
        long retainedOps = engine.config().getIndexSettings().getSoftDeleteRetentionOperations();
        if (engine.config().getIndexSettings().isSoftDeleteEnabled()) {
            try (Engine.IndexCommitRef safeCommit = engine.acquireSafeIndexCommit();){
                long seqNoForRecovery = Long.parseLong((String)safeCommit.getIndexCommit().getUserData().get("local_checkpoint")) + 1L;
                minSeqNoToRetain = Math.min(seqNoForRecovery, globalCheckpoint + 1L - retainedOps);
            }
        } else {
            minSeqNoToRetain = engine.getMinRetainedSeqNo();
        }
        for (Translog.Operation translogOp : translogOps) {
            Translog.Operation luceneOp = (Translog.Operation)luceneOps.get(translogOp.seqNo());
            if (luceneOp == null) {
                if (minSeqNoToRetain > translogOp.seqNo()) continue;
                EngineTestCase.fail((String)("Operation not found seq# [" + translogOp.seqNo() + "], global checkpoint [" + globalCheckpoint + "], retention policy [" + retainedOps + "], maxSeqNo [" + maxSeqNo + "], translog op [" + translogOp + "]"));
            }
            EngineTestCase.assertThat(luceneOp, Matchers.notNullValue());
            EngineTestCase.assertThat(luceneOp.toString(), luceneOp.primaryTerm(), Matchers.equalTo((Object)translogOp.primaryTerm()));
            EngineTestCase.assertThat(luceneOp.opType(), Matchers.equalTo((Object)translogOp.opType()));
            if (luceneOp.opType() != Translog.Operation.Type.INDEX) continue;
            EngineTestCase.assertThat(((Translog.Index)luceneOp).source(), Matchers.equalTo((Object)((Translog.Index)translogOp).source()));
        }
    }

    public static void assertMaxSeqNoInCommitUserData(Engine engine) throws Exception {
        List commits = DirectoryReader.listCommits((Directory)engine.store.directory());
        for (IndexCommit commit : commits) {
            DirectoryReader reader = DirectoryReader.open((IndexCommit)commit);
            try {
                EngineTestCase.assertThat(Long.parseLong((String)commit.getUserData().get("max_seq_no")), Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(EngineTestCase.maxSeqNosInReader(reader))));
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
    }

    public static void assertAtMostOneLuceneDocumentPerSequenceNumber(Engine engine) throws IOException {
        if (engine instanceof InternalEngine) {
            try {
                engine.refresh("test");
                try (Engine.Searcher searcher = engine.acquireSearcher("test");){
                    EngineTestCase.assertAtMostOneLuceneDocumentPerSequenceNumber(engine.config().getIndexSettings(), searcher.getDirectoryReader());
                }
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
    }

    public static void assertAtMostOneLuceneDocumentPerSequenceNumber(IndexSettings indexSettings, DirectoryReader reader) throws IOException {
        HashSet<Long> seqNos = new HashSet<Long>();
        DirectoryReader wrappedReader = indexSettings.isSoftDeleteEnabled() ? Lucene.wrapAllDocsLive((DirectoryReader)reader) : reader;
        for (LeafReaderContext leaf : wrappedReader.leaves()) {
            int docId;
            NumericDocValues primaryTermDocValues = leaf.reader().getNumericDocValues("_primary_term");
            NumericDocValues seqNoDocValues = leaf.reader().getNumericDocValues("_seq_no");
            while ((docId = seqNoDocValues.nextDoc()) != Integer.MAX_VALUE) {
                EngineTestCase.assertTrue((boolean)seqNoDocValues.advanceExact(docId));
                long seqNo = seqNoDocValues.longValue();
                EngineTestCase.assertThat(seqNo, Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
                if (!primaryTermDocValues.advanceExact(docId) || seqNos.add(seqNo)) continue;
                IdStoredFieldLoader idLoader = new IdStoredFieldLoader(leaf.reader());
                throw new AssertionError((Object)("found multiple documents for seq=" + seqNo + " id=" + idLoader.id(docId)));
            }
        }
    }

    public static MapperService createMapperService() throws IOException {
        IndexMetadata indexMetadata = IndexMetadata.builder((String)"test").settings(EngineTestCase.indexSettings(1, 1).put("index.version.created", (VersionId)IndexVersion.current())).putMapping("{\"properties\": {}}").build();
        MapperService mapperService = MapperTestUtils.newMapperService(new NamedXContentRegistry(ClusterModule.getNamedXWriteables()), EngineTestCase.createTempDir(), Settings.EMPTY, "test");
        mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_UPDATE);
        return mapperService;
    }

    public static MappingLookup mappingLookup() {
        try {
            return EngineTestCase.createMapperService().mappingLookup();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Translog getTranslog(Engine engine) {
        assert (engine instanceof InternalEngine) : "only InternalEngines have translogs, got: " + engine.getClass();
        InternalEngine internalEngine = (InternalEngine)engine;
        return internalEngine.getTranslog();
    }

    public static void waitForOpsToComplete(InternalEngine engine, long seqNo) throws Exception {
        EngineTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> EngineTestCase.assertThat(engine.getLocalCheckpointTracker().getProcessedCheckpoint(), Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(seqNo)))));
    }

    public static boolean hasAcquiredIndexCommitsForTesting(Engine engine) {
        assert (engine instanceof InternalEngine) : "only InternalEngines have snapshotted commits, got: " + engine.getClass();
        InternalEngine internalEngine = (InternalEngine)engine;
        return internalEngine.hasAcquiredIndexCommitsForTesting();
    }

    static long maxSeqNosInReader(DirectoryReader reader) throws IOException {
        long maxSeqNo = -1L;
        for (LeafReaderContext leaf : reader.leaves()) {
            NumericDocValues seqNoDocValues = leaf.reader().getNumericDocValues("_seq_no");
            while (seqNoDocValues.nextDoc() != Integer.MAX_VALUE) {
                maxSeqNo = SequenceNumbers.max((long)maxSeqNo, (long)seqNoDocValues.longValue());
            }
        }
        return maxSeqNo;
    }

    public static long getNumVersionLookups(Engine engine) {
        return ((InternalEngine)engine).getNumVersionLookups();
    }

    public static long getInFlightDocCount(Engine engine) {
        if (engine instanceof InternalEngine) {
            return ((InternalEngine)engine).getInFlightDocCount();
        }
        return 0L;
    }

    public static void assertNoInFlightDocuments(Engine engine) throws Exception {
        EngineTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> EngineTestCase.assertThat(EngineTestCase.getInFlightDocCount(engine), Matchers.equalTo((Object)0L))));
    }

    public static CheckedFunction<DirectoryReader, DirectoryReader, IOException> randomReaderWrapper() {
        if (EngineTestCase.randomBoolean()) {
            return reader -> reader;
        }
        return reader -> new MatchingDirectoryReader((DirectoryReader)reader, (Query)new MatchAllDocsQuery());
    }

    public static Function<Engine.Searcher, Engine.Searcher> randomSearcherWrapper() {
        if (EngineTestCase.randomBoolean()) {
            return Function.identity();
        }
        CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper = EngineTestCase.randomReaderWrapper();
        return searcher -> SearcherHelper.wrapSearcher(searcher, readerWrapper);
    }

    public static void checkNoSoftDeletesLoaded(ReadOnlyEngine readOnlyEngine) {
        if (!readOnlyEngine.lazilyLoadSoftDeletes) {
            throw new IllegalStateException("method should only be called when lazily loading soft-deletes is enabled");
        }
        try (Engine.Searcher searcher = readOnlyEngine.acquireSearcher("soft-deletes-check", Engine.SearcherScope.INTERNAL);){
            for (LeafReaderContext ctx : searcher.getIndexReader().getContext().leaves()) {
                LazySoftDeletesDirectoryReaderWrapper.LazyBits lazyBits = EngineTestCase.lazyBits(ctx.reader());
                if (lazyBits == null || !lazyBits.initialized()) continue;
                throw new IllegalStateException("soft-deletes loaded");
            }
        }
    }

    @Nullable
    private static LazySoftDeletesDirectoryReaderWrapper.LazyBits lazyBits(LeafReader reader) {
        if (reader instanceof LazySoftDeletesDirectoryReaderWrapper.LazySoftDeletesFilterLeafReader) {
            return ((LazySoftDeletesDirectoryReaderWrapper.LazySoftDeletesFilterLeafReader)reader).getLiveDocs();
        }
        if (reader instanceof LazySoftDeletesDirectoryReaderWrapper.LazySoftDeletesFilterCodecReader) {
            return ((LazySoftDeletesDirectoryReaderWrapper.LazySoftDeletesFilterCodecReader)reader).getLiveDocs();
        }
        if (reader instanceof FilterLeafReader) {
            FilterLeafReader fReader = (FilterLeafReader)reader;
            return EngineTestCase.lazyBits(FilterLeafReader.unwrap((LeafReader)fReader));
        }
        if (reader instanceof FilterCodecReader) {
            FilterCodecReader fReader = (FilterCodecReader)reader;
            return EngineTestCase.lazyBits((LeafReader)FilterCodecReader.unwrap((CodecReader)fReader));
        }
        if (reader instanceof SegmentReader) {
            return null;
        }
        throw new IllegalStateException("Can not extract lazy bits from given index reader [" + reader + "]");
    }

    protected static CodecService newCodecService() {
        return new CodecService(null, BigArrays.NON_RECYCLING_INSTANCE);
    }

    protected long relativeTimeInNanos() {
        return System.nanoTime();
    }

    public static void recoverFromTranslog(Engine engine, Engine.TranslogRecoveryRunner translogRecoveryRunner, long recoverUpToSeqNo) throws IOException {
        PlainActionFuture future = new PlainActionFuture();
        engine.recoverFromTranslog(translogRecoveryRunner, recoverUpToSeqNo, (ActionListener)future);
        try {
            future.get(30L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException ioException = (IOException)throwable;
                throw ioException;
            }
            throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            EngineTestCase.fail(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            EngineTestCase.fail(e);
        }
        catch (TimeoutException e) {
            EngineTestCase.fail(e);
        }
    }

    public static void ensureOpen(Engine engine) {
        engine.ensureOpen();
    }

    public static final class PrimaryTermSupplier
    implements LongSupplier {
        private final AtomicLong term;

        PrimaryTermSupplier(long initialTerm) {
            this.term = new AtomicLong(initialTerm);
        }

        public long get() {
            return this.term.get();
        }

        public void set(long newTerm) {
            this.term.set(newTerm);
        }

        @Override
        public long getAsLong() {
            return this.get();
        }
    }

    @FunctionalInterface
    public static interface IndexWriterFactory {
        public IndexWriter createWriter(Directory var1, IndexWriterConfig var2) throws IOException;
    }

    public static final class MatchingDirectoryReader
    extends FilterDirectoryReader {
        private final Query query;

        public MatchingDirectoryReader(DirectoryReader in, final Query query) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(final LeafReader leaf) {
                    try {
                        IndexSearcher searcher = new IndexSearcher((IndexReader)leaf);
                        searcher.setQueryCache(null);
                        Weight weight = searcher.createWeight(query, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                        Scorer scorer = weight.scorer(leaf.getContext());
                        DocIdSetIterator iterator = scorer != null ? scorer.iterator() : null;
                        final FixedBitSet liveDocs = new FixedBitSet(leaf.maxDoc());
                        if (iterator != null) {
                            int docId = iterator.nextDoc();
                            while (docId != Integer.MAX_VALUE) {
                                if (leaf.getLiveDocs() == null || leaf.getLiveDocs().get(docId)) {
                                    liveDocs.set(docId);
                                }
                                docId = iterator.nextDoc();
                            }
                        }
                        return new FilterLeafReader(leaf){

                            public Bits getLiveDocs() {
                                return liveDocs;
                            }

                            public IndexReader.CacheHelper getCoreCacheHelper() {
                                return leaf.getCoreCacheHelper();
                            }

                            public IndexReader.CacheHelper getReaderCacheHelper() {
                                return null;
                            }
                        };
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
            this.query = query;
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new MatchingDirectoryReader(in, this.query);
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }
}

