/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Map;
import java.util.function.BiFunction;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.InternalEngine;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;

class InternalTestEngine
extends InternalEngine {
    private final Map<String, Long> idToMaxSeqNo = ConcurrentCollections.newConcurrentMap();

    InternalTestEngine(EngineConfig engineConfig) {
        super(engineConfig);
    }

    InternalTestEngine(EngineConfig engineConfig, int maxDocs, BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier) {
        super(engineConfig, maxDocs, localCheckpointTrackerSupplier);
    }

    public Engine.IndexResult index(Engine.Index index) throws IOException {
        if (index.seqNo() != -2L) {
            this.idToMaxSeqNo.compute(index.id(), (id, existing) -> {
                if (existing == null) {
                    return index.seqNo();
                }
                long maxSeqNo = Math.max(index.seqNo(), existing);
                this.advanceMaxSeqNoOfUpdatesOrDeletes(maxSeqNo);
                return maxSeqNo;
            });
        }
        return super.index(index);
    }

    public Engine.DeleteResult delete(Engine.Delete delete) throws IOException {
        if (delete.seqNo() != -2L) {
            long maxSeqNo = this.idToMaxSeqNo.compute(delete.id(), (id, existing) -> {
                if (existing == null) {
                    return delete.seqNo();
                }
                return Math.max(delete.seqNo(), existing);
            });
            this.advanceMaxSeqNoOfUpdatesOrDeletes(maxSeqNo);
        }
        return super.delete(delete);
    }
}

