/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.BlockLoader;
import org.junit.Assert;

public class TestBlock
implements BlockLoader.Block {
    private final List<Object> values;

    public static BlockLoader.BlockFactory factory(final int pageSize) {
        return new BlockLoader.BlockFactory(){

            public BlockLoader.BooleanBuilder booleansFromDocValues(int expectedCount) {
                return this.booleans(expectedCount);
            }

            public BlockLoader.BooleanBuilder booleans(int expectedCount) {
                class BooleansBuilder
                extends Builder
                implements BlockLoader.BooleanBuilder {
                    BooleansBuilder() {
                    }

                    public BooleansBuilder appendBoolean(boolean value) {
                        this.add(value);
                        return this;
                    }
                }
                return new BooleansBuilder();
            }

            public BlockLoader.BytesRefBuilder bytesRefsFromDocValues(int expectedCount) {
                return this.bytesRefs(expectedCount);
            }

            public BlockLoader.BytesRefBuilder bytesRefs(int expectedCount) {
                class BytesRefsBuilder
                extends Builder
                implements BlockLoader.BytesRefBuilder {
                    BytesRefsBuilder() {
                    }

                    public BytesRefsBuilder appendBytesRef(BytesRef value) {
                        this.add(BytesRef.deepCopyOf((BytesRef)value));
                        return this;
                    }
                }
                return new BytesRefsBuilder();
            }

            public BlockLoader.DoubleBuilder doublesFromDocValues(int expectedCount) {
                return this.doubles(expectedCount);
            }

            public BlockLoader.DoubleBuilder doubles(int expectedCount) {
                class DoublesBuilder
                extends Builder
                implements BlockLoader.DoubleBuilder {
                    DoublesBuilder() {
                    }

                    public DoublesBuilder appendDouble(double value) {
                        this.add(value);
                        return this;
                    }
                }
                return new DoublesBuilder();
            }

            public BlockLoader.IntBuilder intsFromDocValues(int expectedCount) {
                return this.ints(expectedCount);
            }

            public BlockLoader.IntBuilder ints(int expectedCount) {
                class IntsBuilder
                extends Builder
                implements BlockLoader.IntBuilder {
                    IntsBuilder() {
                    }

                    public IntsBuilder appendInt(int value) {
                        this.add(value);
                        return this;
                    }
                }
                return new IntsBuilder();
            }

            public BlockLoader.LongBuilder longsFromDocValues(int expectedCount) {
                return this.longs(expectedCount);
            }

            public BlockLoader.LongBuilder longs(int expectedCount) {
                class LongsBuilder
                extends Builder
                implements BlockLoader.LongBuilder {
                    LongsBuilder() {
                    }

                    public LongsBuilder appendLong(long value) {
                        this.add(value);
                        return this;
                    }
                }
                return new LongsBuilder();
            }

            public BlockLoader.Builder nulls(int expectedCount) {
                return this.longs(expectedCount);
            }

            public BlockLoader.Block constantNulls() {
                BlockLoader.LongBuilder builder = this.longs(pageSize);
                for (int i = 0; i < pageSize; ++i) {
                    builder.appendNull();
                }
                return builder.build();
            }

            public BlockLoader.Block constantBytes(BytesRef value) {
                BlockLoader.BytesRefBuilder builder = this.bytesRefs(pageSize);
                for (int i = 0; i < pageSize; ++i) {
                    builder.appendBytesRef(value);
                }
                return builder.build();
            }

            public BlockLoader.SingletonOrdinalsBuilder singletonOrdinalsBuilder(final SortedDocValues ordinals, int count) {
                class SingletonOrdsBuilder
                extends Builder
                implements BlockLoader.SingletonOrdinalsBuilder {
                    SingletonOrdsBuilder() {
                    }

                    public SingletonOrdsBuilder appendOrd(int value) {
                        try {
                            this.add(ordinals.lookupOrd(value));
                            return this;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                }
                return new SingletonOrdsBuilder();
            }
        };
    }

    public static final BlockLoader.Docs docs(final int ... docs) {
        return new BlockLoader.Docs(){

            public int count() {
                return docs.length;
            }

            public int get(int i) {
                return docs[i];
            }
        };
    }

    public static final BlockLoader.Docs docs(final LeafReaderContext ctx) {
        return new BlockLoader.Docs(){

            public int count() {
                return ctx.reader().numDocs();
            }

            public int get(int i) {
                return i;
            }
        };
    }

    private TestBlock(List<Object> values) {
        this.values = values;
    }

    public Object get(int i) {
        return this.values.get(i);
    }

    public int size() {
        return this.values.size();
    }

    public void close() {
    }

    private static abstract class Builder
    implements BlockLoader.Builder {
        private final List<Object> values = new ArrayList<Object>();
        private List<Object> currentPosition = null;

        private Builder() {
        }

        public Builder appendNull() {
            Assert.assertNull(this.currentPosition);
            this.values.add(null);
            return this;
        }

        public Builder beginPositionEntry() {
            Assert.assertNull(this.currentPosition);
            this.currentPosition = new ArrayList<Object>();
            this.values.add(this.currentPosition);
            return this;
        }

        public Builder endPositionEntry() {
            Assert.assertNotNull(this.currentPosition);
            this.currentPosition = null;
            return this;
        }

        protected void add(Object value) {
            (this.currentPosition == null ? this.values : this.currentPosition).add(value);
        }

        public TestBlock build() {
            return new TestBlock(this.values);
        }

        public void close() {
        }
    }
}

