/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.ingest.IngestCtxMap;
import org.elasticsearch.ingest.IngestDocMetadata;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.TestIngestCtxMetadata;
import org.elasticsearch.script.Metadata;
import org.elasticsearch.test.ESTestCase;

public class TestIngestDocument {
    public static final long DEFAULT_VERSION = 12345L;
    private static String VERSION = IngestDocument.Metadata.VERSION.getFieldName();

    public static IngestDocument withNullableVersion(Map<String, Object> sourceAndMetadata) {
        return TestIngestDocument.ofIngestWithNullableVersion(sourceAndMetadata, new HashMap<String, Object>());
    }

    public static IngestDocument ofIngestWithNullableVersion(Map<String, Object> sourceAndMetadata, Map<String, Object> ingestMetadata) {
        HashMap<String, Object> source = new HashMap<String, Object>(sourceAndMetadata);
        Map metadata = Maps.newHashMapWithExpectedSize((int)IngestDocument.Metadata.values().length);
        for (IngestDocument.Metadata m : IngestDocument.Metadata.values()) {
            String key = m.getFieldName();
            if (!sourceAndMetadata.containsKey(key)) continue;
            metadata.put(key, source.remove(key));
        }
        return new IngestDocument(new IngestCtxMap(source, (IngestDocMetadata)TestIngestCtxMetadata.withNullableVersion(metadata)), ingestMetadata);
    }

    public static IngestDocument withDefaultVersion(Map<String, Object> sourceAndMetadata) {
        if (!sourceAndMetadata.containsKey(VERSION)) {
            sourceAndMetadata = new HashMap<String, Object>(sourceAndMetadata);
            sourceAndMetadata.put(VERSION, 12345L);
        }
        return new IngestDocument(sourceAndMetadata, new HashMap());
    }

    public static IngestDocument ofMetadataWithValidator(Map<String, Object> metadata, Map<String, Metadata.FieldProperty<?>> properties) {
        return new IngestDocument(new IngestCtxMap(new HashMap(), (IngestDocMetadata)new TestIngestCtxMetadata(metadata, properties)), new HashMap());
    }

    public static IngestDocument emptyIngestDocument() {
        HashMap<String, Long> sourceAndMetadata = new HashMap<String, Long>();
        sourceAndMetadata.put(VERSION, 12345L);
        return new IngestDocument(sourceAndMetadata, new HashMap());
    }

    public static Tuple<String, Object> randomMetadata() {
        IngestDocument.Metadata metadata = ESTestCase.randomFrom(IngestDocument.Metadata.values());
        String string = metadata.getFieldName();
        return new Tuple((Object)string, (Object)(switch (metadata) {
            case IngestDocument.Metadata.VERSION, IngestDocument.Metadata.IF_SEQ_NO, IngestDocument.Metadata.IF_PRIMARY_TERM -> ESTestCase.randomIntBetween(0, 124);
            case IngestDocument.Metadata.VERSION_TYPE -> VersionType.toString((VersionType)ESTestCase.randomFrom(VersionType.values()));
            case IngestDocument.Metadata.DYNAMIC_TEMPLATES -> Map.of(ESTestCase.randomAlphaOfLengthBetween(5, 10), ESTestCase.randomAlphaOfLengthBetween(5, 10));
            default -> ESTestCase.randomAlphaOfLengthBetween(5, 10);
        }));
    }

    public static long randomVersion() {
        return ESTestCase.randomLongBetween(-4L, Long.MAX_VALUE);
    }
}

