/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.injection.guice.Module;
import org.elasticsearch.injection.guice.spi.Element;
import org.elasticsearch.injection.guice.spi.Elements;
import org.elasticsearch.injection.guice.spi.InstanceBinding;
import org.elasticsearch.injection.guice.spi.ProviderInstanceBinding;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.LambdaMatchers;

public abstract class ModuleTestCase
extends ESTestCase {
    public static <T> void assertInstanceBinding(Module module, Class<T> to, Predicate<T> tester) {
        ModuleTestCase.assertInstanceBindingWithAnnotation(module, to, tester, null);
    }

    private static <T> void assertInstanceBindingWithAnnotation(Module module, Class<T> to, Predicate<T> tester, Class<? extends Annotation> annotation) {
        List elements = Elements.getElements((Module[])new Module[]{module});
        for (Element element : elements) {
            ProviderInstanceBinding binding;
            if (element instanceof InstanceBinding) {
                InstanceBinding binding2 = (InstanceBinding)element;
                if (!to.equals(binding2.getKey().getTypeLiteral().getType()) || annotation != null && !annotation.equals(binding2.getKey().getAnnotationType())) continue;
                ModuleTestCase.assertThat(tester, LambdaMatchers.trueWith(to.cast(binding2.getInstance())));
                return;
            }
            if (!(element instanceof ProviderInstanceBinding) || !to.equals((binding = (ProviderInstanceBinding)element).getKey().getTypeLiteral().getType())) continue;
            ModuleTestCase.assertThat(tester, LambdaMatchers.trueWith(to.cast(binding.getProviderInstance().get())));
            return;
        }
        StringBuilder s = new StringBuilder();
        for (Element element : elements) {
            s.append(element).append("\n");
        }
        ModuleTestCase.fail((String)("Did not find any instance binding to " + to.getName() + ". Found these bindings:\n" + s));
    }
}

