/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration;

import org.elasticsearch.logsdb.datageneration.FieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.datasource.DataSource;
import org.elasticsearch.logsdb.datageneration.fields.leaf.ByteFieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.fields.leaf.DoubleFieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.fields.leaf.FloatFieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.fields.leaf.HalfFloatFieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.fields.leaf.IntegerFieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.fields.leaf.KeywordFieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.fields.leaf.LongFieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.fields.leaf.ScaledFloatFieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.fields.leaf.ShortFieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.fields.leaf.UnsignedLongFieldDataGenerator;

public enum FieldType {
    KEYWORD("keyword"),
    LONG("long"),
    UNSIGNED_LONG("unsigned_long"),
    INTEGER("integer"),
    SHORT("short"),
    BYTE("byte"),
    DOUBLE("double"),
    FLOAT("float"),
    HALF_FLOAT("half_float"),
    SCALED_FLOAT("scaled_float");

    private final String name;

    private FieldType(String name) {
        this.name = name;
    }

    public FieldDataGenerator generator(String fieldName, DataSource dataSource) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case KEYWORD -> new KeywordFieldDataGenerator(fieldName, dataSource);
            case LONG -> new LongFieldDataGenerator(fieldName, dataSource);
            case UNSIGNED_LONG -> new UnsignedLongFieldDataGenerator(fieldName, dataSource);
            case INTEGER -> new IntegerFieldDataGenerator(fieldName, dataSource);
            case SHORT -> new ShortFieldDataGenerator(fieldName, dataSource);
            case BYTE -> new ByteFieldDataGenerator(fieldName, dataSource);
            case DOUBLE -> new DoubleFieldDataGenerator(fieldName, dataSource);
            case FLOAT -> new FloatFieldDataGenerator(fieldName, dataSource);
            case HALF_FLOAT -> new HalfFloatFieldDataGenerator(fieldName, dataSource);
            case SCALED_FLOAT -> new ScaledFloatFieldDataGenerator(fieldName, dataSource);
        };
    }

    public String toString() {
        return this.name;
    }
}

