/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration.datasource;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.logsdb.datageneration.FieldType;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceHandler;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.logsdb.datageneration.fields.DynamicMapping;
import org.elasticsearch.test.ESTestCase;

public class DefaultMappingParametersHandler
implements DataSourceHandler {
    @Override
    public DataSourceResponse.LeafMappingParametersGenerator handle(DataSourceRequest.LeafMappingParametersGenerator request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("store", ESTestCase.randomBoolean());
        map.put("index", ESTestCase.randomBoolean());
        map.put("doc_values", ESTestCase.randomBoolean());
        if (ESTestCase.randomBoolean()) {
            map.put("synthetic_source_keep", ESTestCase.randomFrom("none", "arrays", "all"));
        }
        return new DataSourceResponse.LeafMappingParametersGenerator(switch (request.fieldType()) {
            default -> throw new IncompatibleClassChangeError();
            case FieldType.KEYWORD -> this.keywordMapping(request, map);
            case FieldType.LONG, FieldType.INTEGER, FieldType.SHORT, FieldType.BYTE, FieldType.DOUBLE, FieldType.FLOAT, FieldType.HALF_FLOAT, FieldType.UNSIGNED_LONG -> this.plain(map);
            case FieldType.SCALED_FLOAT -> this.scaledFloatMapping(map);
        });
    }

    private Supplier<Map<String, Object>> plain(Map<String, Object> injected) {
        return () -> injected;
    }

    private Supplier<Map<String, Object>> keywordMapping(DataSourceRequest.LeafMappingParametersGenerator request, Map<String, Object> injected) {
        return () -> {
            Set options;
            if (request.dynamicMapping() != DynamicMapping.FORBIDDEN && ESTestCase.randomDouble() <= 0.05 && !(options = request.eligibleCopyToFields().stream().filter(f -> !f.equals(request.fieldName())).collect(Collectors.toSet())).isEmpty()) {
                injected.put("copy_to", ESTestCase.randomFrom(options));
            }
            return injected;
        };
    }

    private Supplier<Map<String, Object>> scaledFloatMapping(Map<String, Object> injected) {
        return () -> {
            injected.put("scaling_factor", ESTestCase.randomFrom(10, 1000, 100000, 100.5));
            return injected;
        };
    }

    @Override
    public DataSourceResponse.ObjectMappingParametersGenerator handle(DataSourceRequest.ObjectMappingParametersGenerator request) {
        if (request.isNested()) {
            assert (request.parentSubobjects() != ObjectMapper.Subobjects.DISABLED);
            return new DataSourceResponse.ObjectMappingParametersGenerator(() -> {
                HashMap<String, String> parameters = new HashMap<String, String>();
                if (ESTestCase.randomBoolean()) {
                    parameters.put("dynamic", ESTestCase.randomFrom("true", "false", "strict"));
                }
                if (ESTestCase.randomBoolean()) {
                    parameters.put("synthetic_source_keep", "all");
                }
                return parameters;
            });
        }
        return new DataSourceResponse.ObjectMappingParametersGenerator(() -> {
            HashMap<String, String> parameters = new HashMap<String, String>();
            ObjectMapper.Subobjects subobjects = ESTestCase.randomValueOtherThan(ObjectMapper.Subobjects.AUTO, () -> ESTestCase.randomFrom(ObjectMapper.Subobjects.values()));
            if (request.parentSubobjects() == ObjectMapper.Subobjects.DISABLED || subobjects == ObjectMapper.Subobjects.DISABLED) {
                if (ESTestCase.randomBoolean()) {
                    parameters.put("enabled", "true");
                }
                return parameters;
            }
            if (ESTestCase.randomBoolean()) {
                parameters.put("subobjects", subobjects.toString());
            }
            if (ESTestCase.randomBoolean()) {
                parameters.put("dynamic", ESTestCase.randomFrom("true", "false", "strict", "runtime"));
            }
            if (ESTestCase.randomBoolean()) {
                parameters.put("enabled", ESTestCase.randomFrom("true", "false"));
            }
            if (ESTestCase.randomBoolean()) {
                String value = request.isRoot() ? ESTestCase.randomFrom("none", "arrays") : ESTestCase.randomFrom("none", "arrays", "all");
                parameters.put("synthetic_source_keep", value);
            }
            return parameters;
        });
    }
}

