/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.geo;

import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.RequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.common.geo.GeometryNormalizer;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.geo.GeometryTestUtils;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.index.query.AbstractGeometryQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.geo.SpatialQueryBuilders;
import org.elasticsearch.test.ESSingleNodeTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class BasePointShapeQueryTestCase<T extends AbstractGeometryQueryBuilder<T>>
extends ESSingleNodeTestCase {
    protected static final String defaultFieldName = "geo";
    protected static final String defaultIndexName = "test";

    protected abstract SpatialQueryBuilders<T> queryBuilder();

    protected abstract String fieldTypeName();

    protected abstract void createMapping(String var1, String var2, Settings var3) throws Exception;

    protected void createMapping(String indexName, String fieldName) throws Exception {
        this.createMapping(indexName, fieldName, Settings.EMPTY);
    }

    public void testNullShape() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        this.prepareIndex(defaultIndexName).setId("aNullshape").setSource("{\"geo\": null}", XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        GetResponse result = (GetResponse)this.client().prepareGet(defaultIndexName, "aNullshape").get();
        BasePointShapeQueryTestCase.assertThat(result.getField("location"), Matchers.nullValue());
    }

    public void testIndexPointsFilterRectangle() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        this.prepareIndex(defaultIndexName).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 1").field(defaultFieldName, "POINT(-30 -30)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        this.prepareIndex(defaultIndexName).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 2").field(defaultFieldName, "POINT(-45 -50)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        Rectangle geometry = new Rectangle(-45.0, 45.0, 45.0, -45.0);
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)geometry).relation(ShapeRelation.INTERSECTS)), response -> {
            BasePointShapeQueryTestCase.assertThat(response.getHits().getTotalHits().value, Matchers.equalTo((Object)1L));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getHits().length, Matchers.equalTo((Object)1));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getAt(0).getId(), Matchers.equalTo((Object)"1"));
        });
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery(this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)geometry)), response -> {
            BasePointShapeQueryTestCase.assertThat(response.getHits().getTotalHits().value, Matchers.equalTo((Object)1L));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getHits().length, Matchers.equalTo((Object)1));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getAt(0).getId(), Matchers.equalTo((Object)"1"));
        });
    }

    public void testIndexPointsCircle() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        this.prepareIndex(defaultIndexName).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 1").field(defaultFieldName, "POINT(-30 -30)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        this.prepareIndex(defaultIndexName).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 2").field(defaultFieldName, "POINT(-45 -50)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        Circle geometry = new Circle(-30.0, -30.0, 100.0);
        try {
            ((SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)geometry).relation(ShapeRelation.INTERSECTS)).get()).decRef();
        }
        catch (Exception e) {
            BasePointShapeQueryTestCase.assertThat(e.getCause().getMessage(), Matchers.containsString((String)("failed to create query: " + ShapeType.CIRCLE + " geometry is not supported")));
        }
    }

    public void testIndexPointsPolygon() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        this.prepareIndex(defaultIndexName).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(-30 -30)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        this.prepareIndex(defaultIndexName).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(-45 -50)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        Polygon polygon = new Polygon(new LinearRing(new double[]{-35.0, -35.0, -25.0, -25.0, -35.0}, new double[]{-35.0, -25.0, -25.0, -35.0, -35.0}));
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)polygon).relation(ShapeRelation.INTERSECTS)), response -> {
            SearchHits searchHits = response.getHits();
            BasePointShapeQueryTestCase.assertThat(searchHits.getTotalHits().value, Matchers.equalTo((Object)1L));
            BasePointShapeQueryTestCase.assertThat(searchHits.getAt(0).getId(), Matchers.equalTo((Object)"1"));
        });
    }

    public void testIndexPointsMultiPolygon() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        this.prepareIndex(defaultIndexName).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 1").field(defaultFieldName, "POINT(-30 -30)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        this.prepareIndex(defaultIndexName).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 2").field(defaultFieldName, "POINT(-40 -40)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        this.prepareIndex(defaultIndexName).setId("3").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 3").field(defaultFieldName, "POINT(-50 -50)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        Polygon encloseDocument1Cb = new Polygon(new LinearRing(new double[]{-35.0, -35.0, -25.0, -25.0, -35.0}, new double[]{-35.0, -25.0, -25.0, -35.0, -35.0}));
        Polygon encloseDocument2Cb = new Polygon(new LinearRing(new double[]{-55.0, -55.0, -45.0, -45.0, -55.0}, new double[]{-55.0, -45.0, -45.0, -55.0, -55.0}));
        MultiPolygon multiPolygon = new MultiPolygon(List.of(encloseDocument1Cb, encloseDocument2Cb));
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)multiPolygon).relation(ShapeRelation.INTERSECTS)), response -> {
            BasePointShapeQueryTestCase.assertThat(response.getHits().getTotalHits().value, Matchers.equalTo((Object)2L));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getHits().length, Matchers.equalTo((Object)2));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getAt(0).getId(), Matchers.not((Matcher)Matchers.equalTo((Object)"2")));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getAt(1).getId(), Matchers.not((Matcher)Matchers.equalTo((Object)"2")));
        });
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)multiPolygon).relation(ShapeRelation.WITHIN)), response -> {
            BasePointShapeQueryTestCase.assertThat(response.getHits().getTotalHits().value, Matchers.equalTo((Object)2L));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getHits().length, Matchers.equalTo((Object)2));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getAt(0).getId(), Matchers.not((Matcher)Matchers.equalTo((Object)"2")));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getAt(1).getId(), Matchers.not((Matcher)Matchers.equalTo((Object)"2")));
        });
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)multiPolygon).relation(ShapeRelation.DISJOINT)), response -> {
            BasePointShapeQueryTestCase.assertThat(response.getHits().getTotalHits().value, Matchers.equalTo((Object)1L));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getHits().length, Matchers.equalTo((Object)1));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getAt(0).getId(), Matchers.equalTo((Object)"2"));
        });
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)multiPolygon).relation(ShapeRelation.CONTAINS)), response -> {
            BasePointShapeQueryTestCase.assertThat(response.getHits().getTotalHits().value, Matchers.equalTo((Object)0L));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getHits().length, Matchers.equalTo((Object)0));
        });
    }

    public void testIndexPointsRectangle() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        this.prepareIndex(defaultIndexName).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 1").field(defaultFieldName, "POINT(-30 -30)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        this.prepareIndex(defaultIndexName).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 2").field(defaultFieldName, "POINT(-45 -50)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        Rectangle rectangle = new Rectangle(-50.0, -40.0, -45.0, -55.0);
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)rectangle).relation(ShapeRelation.INTERSECTS)), response -> {
            BasePointShapeQueryTestCase.assertThat(response.getHits().getTotalHits().value, Matchers.equalTo((Object)1L));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getHits().length, Matchers.equalTo((Object)1));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getAt(0).getId(), Matchers.equalTo((Object)"2"));
        });
    }

    public void testIndexPointsIndexedRectangle() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        this.prepareIndex(defaultIndexName).setId("point1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(-30 -30)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        this.prepareIndex(defaultIndexName).setId("point2").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(-45 -50)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        String indexedShapeIndex = "indexed_query_shapes";
        String indexedShapePath = "shape";
        String queryShapesMapping = Strings.toString((XContentBuilder)XContentFactory.jsonBuilder().startObject().startObject("properties").startObject(indexedShapePath).field("type", this.fieldTypeName()).endObject().endObject().endObject());
        this.client().admin().indices().prepareCreate(indexedShapeIndex).setMapping(queryShapesMapping).get();
        this.ensureGreen(new String[0]);
        this.prepareIndex(indexedShapeIndex).setId("shape1").setSource(XContentFactory.jsonBuilder().startObject().field(indexedShapePath, "BBOX(-50, -40, -45, -55)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        this.prepareIndex(indexedShapeIndex).setId("shape2").setSource(XContentFactory.jsonBuilder().startObject().field(indexedShapePath, "BBOX(-60, -50, -50, -60)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, "shape1").relation(ShapeRelation.INTERSECTS).indexedShapeIndex(indexedShapeIndex).indexedShapePath(indexedShapePath)), response -> {
            BasePointShapeQueryTestCase.assertThat(response.getHits().getTotalHits().value, Matchers.equalTo((Object)1L));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getHits().length, Matchers.equalTo((Object)1));
            BasePointShapeQueryTestCase.assertThat(response.getHits().getAt(0).getId(), Matchers.equalTo((Object)"point2"));
        });
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, "shape2").relation(ShapeRelation.INTERSECTS).indexedShapeIndex(indexedShapeIndex).indexedShapePath(indexedShapePath)), 0L);
    }

    public void testWithInQueryLine() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        Line line = new Line(new double[]{-25.0, -35.0}, new double[]{-25.0, -35.0});
        try {
            ((SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)line).relation(ShapeRelation.WITHIN)).get()).decRef();
        }
        catch (SearchPhaseExecutionException e) {
            BasePointShapeQueryTestCase.assertThat(e.getCause().getMessage(), Matchers.containsString((String)"Field [geo] found an unsupported shape Line"));
        }
    }

    public void testQueryWithinMultiLine() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        Line lsb1 = new Line(new double[]{-35.0, -25.0}, new double[]{-35.0, -25.0});
        Line lsb2 = new Line(new double[]{-15.0, -5.0}, new double[]{-15.0, -5.0});
        MultiLine multiline = new MultiLine(List.of(lsb1, lsb2));
        try {
            ((SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)multiline).relation(ShapeRelation.WITHIN)).get()).decRef();
        }
        catch (SearchPhaseExecutionException e) {
            BasePointShapeQueryTestCase.assertThat(e.getCause().getMessage(), Matchers.containsString((String)"Field [geo] found an unsupported shape Line"));
        }
    }

    public void testQueryLinearRing() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        LinearRing linearRing = new LinearRing(new double[]{-25.0, -35.0, -25.0}, new double[]{-25.0, -35.0, -25.0});
        IllegalArgumentException ex = (IllegalArgumentException)BasePointShapeQueryTestCase.expectThrows(IllegalArgumentException.class, () -> this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)linearRing));
        BasePointShapeQueryTestCase.assertThat(ex.getMessage(), CoreMatchers.containsString((String)"[LINEARRING] geometries are not supported"));
        ex = (IllegalArgumentException)BasePointShapeQueryTestCase.expectThrows(IllegalArgumentException.class, () -> this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)new GeometryCollection(List.of(linearRing))));
        BasePointShapeQueryTestCase.assertThat(ex.getMessage(), CoreMatchers.containsString((String)"[LINEARRING] geometries are not supported"));
    }

    public void testQueryPoint() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        this.prepareIndex(defaultIndexName).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(-35 -25)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        Point point = new Point(-35.0, -25.0);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setQuery(this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)point)), 1L);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)point).relation(ShapeRelation.WITHIN)), 1L);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)point).relation(ShapeRelation.CONTAINS)), 1L);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)point).relation(ShapeRelation.DISJOINT)), 0L);
    }

    public void testQueryMultiPoint() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        this.prepareIndex(defaultIndexName).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, "POINT(-35 -25)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        MultiPoint multiPoint = new MultiPoint(List.of(new Point(-35.0, -25.0), new Point(-15.0, -5.0)));
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setQuery(this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)multiPoint)), 1L);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)multiPoint).relation(ShapeRelation.WITHIN)), 1L);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)multiPoint).relation(ShapeRelation.CONTAINS)), 0L);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)multiPoint).relation(ShapeRelation.DISJOINT)), 0L);
    }

    public void testQueryPointFromGeoJSON() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        String doc1 = "{\n  \"geo\": {\n    \"coordinates\": [ -35, -25.0 ],\n    \"type\": \"Point\"\n  }\n}";
        this.client().index((IndexRequest)new IndexRequest(defaultIndexName).id("1").source(doc1, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        Point point = new Point(-35.0, -25.0);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setQuery(this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)point)), 1L);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)point).relation(ShapeRelation.WITHIN)), 1L);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)point).relation(ShapeRelation.CONTAINS)), 1L);
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)point).relation(ShapeRelation.DISJOINT)), 0L);
    }

    protected Object[] samplePointDataMultiFormat(Point pointA, Point pointB, Point pointC, Point pointD) {
        String wktA = WellKnownText.toWKT((Geometry)pointA);
        String wktB = WellKnownText.toWKT((Geometry)pointB);
        Map geojsonC = GeoJson.toMap((Geometry)pointC);
        Map geojsonD = GeoJson.toMap((Geometry)pointD);
        return new Object[]{wktA, wktB, geojsonC, geojsonD};
    }

    public void testQueryPointFromMultiPoint() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        Point pointA = new Point(-45.0, -35.0);
        Point pointB = new Point(-35.0, -25.0);
        Point pointC = new Point(35.0, 25.0);
        Point pointD = new Point(45.0, 35.0);
        Object[] points = this.samplePointDataMultiFormat(pointA, pointB, pointC, pointD);
        this.prepareIndex(defaultIndexName).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, (Object)points).endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).get();
        Point pointInvalid = new Point(-35.0, -35.0);
        for (Point point : new Point[]{pointA, pointB, pointC, pointD, pointInvalid}) {
            int expectedDocs = point.equals((Object)pointInvalid) ? 0 : 1;
            int disjointDocs = point.equals((Object)pointInvalid) ? 1 : 0;
            ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setTrackTotalHits(true).setQuery(this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)point)), expectedDocs);
            ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setTrackTotalHits(true).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)point).relation(ShapeRelation.WITHIN)), 0L);
            ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setTrackTotalHits(true).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)point).relation(ShapeRelation.CONTAINS)), expectedDocs);
            ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setTrackTotalHits(true).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)point).relation(ShapeRelation.DISJOINT)), disjointDocs);
        }
    }

    public void testIndexPointsFromLine() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        Line line = BasePointShapeQueryTestCase.randomValueOtherThanMany(l -> GeometryNormalizer.needsNormalize((Orientation)Orientation.CCW, (Geometry)l) || this.ignoreLons(l.getLons()), () -> GeometryTestUtils.randomLine(false));
        for (int i = 0; i < line.length(); ++i) {
            Point point = new Point(line.getLon(i), line.getLat(i));
            this.prepareIndex(defaultIndexName).setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, WellKnownText.toWKT((Geometry)point)).endObject()).get();
        }
        this.client().admin().indices().prepareRefresh(new String[]{defaultIndexName}).get();
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setTrackTotalHits(true).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)line).relation(ShapeRelation.INTERSECTS)), line.length());
    }

    public void testIndexPointsFromPolygon() throws Exception {
        this.createMapping(defaultIndexName, defaultFieldName);
        this.ensureGreen(new String[0]);
        Polygon polygon = BasePointShapeQueryTestCase.randomValueOtherThanMany(p -> GeometryNormalizer.needsNormalize((Orientation)Orientation.CCW, (Geometry)p) || this.ignoreLons(p.getPolygon().getLons()), () -> GeometryTestUtils.randomPolygon(false));
        LinearRing linearRing = polygon.getPolygon();
        for (int i = 0; i < linearRing.length(); ++i) {
            Point point = new Point(linearRing.getLon(i), linearRing.getLat(i));
            this.prepareIndex(defaultIndexName).setSource(XContentFactory.jsonBuilder().startObject().field(defaultFieldName, WellKnownText.toWKT((Geometry)point)).endObject()).get();
        }
        this.client().admin().indices().prepareRefresh(new String[]{defaultIndexName}).get();
        ElasticsearchAssertions.assertHitCountAndNoFailures(this.client().prepareSearch(new String[]{defaultIndexName}).setTrackTotalHits(true).setQuery((QueryBuilder)this.queryBuilder().shapeQuery(defaultFieldName, (Geometry)polygon).relation(ShapeRelation.INTERSECTS)), linearRing.length());
    }

    protected boolean ignoreLons(double[] lons) {
        return false;
    }
}

