/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.test.AbstractBuilderTestCase;
import org.elasticsearch.test.EqualsHashCodeTestUtils;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentGenerator;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonStringEncoder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class AbstractQueryTestCase<QB extends AbstractQueryBuilder<QB>>
extends AbstractBuilderTestCase {
    private static final int NUMBER_OF_TESTQUERIES = 20;

    public final QB createTestQueryBuilder() {
        return this.createTestQueryBuilder(this.supportsBoost(), this.supportsQueryName());
    }

    public final QB createTestQueryBuilder(boolean supportsBoost, boolean supportsQueryName) {
        QB query = this.doCreateTestQueryBuilder();
        if (supportsBoost && AbstractQueryTestCase.randomBoolean()) {
            query.boost(2.0f / (float)AbstractQueryTestCase.randomIntBetween(1, 20));
        }
        if (supportsQueryName && AbstractQueryTestCase.randomBoolean()) {
            query.queryName(AbstractQueryTestCase.createUniqueRandomName());
        }
        return query;
    }

    protected abstract QB doCreateTestQueryBuilder();

    protected QB createQueryWithInnerQuery(QueryBuilder queryBuilder) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaxNestedDepth() throws IOException {
        AbstractQueryBuilder query = null;
        try {
            query = (AbstractQueryBuilder)this.createQueryWithInnerQuery((QueryBuilder)new MatchAllQueryBuilder());
        }
        catch (UnsupportedOperationException e) {
            AbstractQueryTestCase.assumeNoException((String)"Runs only for queries that support nesting", (Exception)e);
        }
        int maxDepth = AbstractQueryTestCase.randomIntBetween(3, 5);
        AbstractQueryBuilder.setMaxNestedDepth((int)maxDepth);
        try {
            for (int i = 1; i < maxDepth - 1; ++i) {
                query = (AbstractQueryBuilder)this.createQueryWithInnerQuery((QueryBuilder)query);
            }
            this.parseQuery(Strings.toString(query));
            String expectedMessage = "The nested depth of the query exceeds the maximum nested depth for queries set in [" + SearchModule.INDICES_MAX_NESTED_DEPTH_SETTING.getKey() + "]";
            AbstractQueryBuilder q = query;
            Exception exception = (Exception)AbstractQueryTestCase.expectThrows(Exception.class, () -> this.parseQuery(Strings.toString(this.createQueryWithInnerQuery((QueryBuilder)q))));
            while (exception.getCause() != null) {
                AbstractQueryTestCase.assertThat(exception.getCause(), Matchers.either((Matcher)Matchers.instanceOf(IllegalArgumentException.class)).or(Matchers.instanceOf(ParsingException.class)));
                exception = (Exception)exception.getCause();
            }
            AbstractQueryTestCase.assertEquals((Object)expectedMessage, (Object)exception.getMessage());
        }
        finally {
            AbstractQueryBuilder.setMaxNestedDepth((int)((Integer)SearchModule.INDICES_MAX_NESTED_DEPTH_SETTING.getDefault(Settings.EMPTY)));
        }
    }

    public void testNegativeBoosts() {
        Object testQuery = this.createTestQueryBuilder();
        IllegalArgumentException exc = (IllegalArgumentException)AbstractQueryTestCase.expectThrows(IllegalArgumentException.class, () -> testQuery.boost(-0.5f));
        AbstractQueryTestCase.assertThat(exc.getMessage(), Matchers.containsString((String)"negative [boost]"));
    }

    public void testFromXContent() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            QB testQuery = this.createTestQueryBuilder();
            XContentType xContentType = AbstractQueryTestCase.randomFrom(XContentType.values());
            BytesReference shuffledXContent = this.toShuffledXContent((ToXContent)testQuery, xContentType, ToXContent.EMPTY_PARAMS, AbstractQueryTestCase.randomBoolean(), this.shuffleProtectedFields());
            try (XContentParser parser = this.createParser(xContentType.xContent(), shuffledXContent);){
                this.assertParsedQuery(parser, (QueryBuilder)testQuery);
            }
            for (Map.Entry<String, QB> alternateVersion : this.getAlternateVersions().entrySet()) {
                String queryAsString = alternateVersion.getKey();
                XContentParser parser = this.createParser(JsonXContent.jsonXContent, queryAsString);
                try {
                    this.assertParsedQuery(parser, (QueryBuilder)alternateVersion.getValue());
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
        }
    }

    protected String[] shuffleProtectedFields() {
        return Strings.EMPTY_ARRAY;
    }

    public void testUnknownField() throws IOException {
        QB testQuery;
        String marker = "#marker#";
        while ((testQuery = this.createTestQueryBuilder()).toString().contains(marker)) {
        }
        testQuery.queryName(marker);
        String queryAsString = testQuery.toString().replace("\"" + marker + "\"", "\"" + marker + "\", \"bogusField\" : \"someValue\"");
        try {
            this.parseQuery(queryAsString);
            AbstractQueryTestCase.fail((String)"expected ParsingException or XContentParsingException");
        }
        catch (ParsingException | XContentParseException e) {
            AbstractQueryTestCase.assertThat(e.getMessage(), Matchers.containsString((String)"bogusField"));
        }
    }

    public void testUnknownObjectException() throws IOException {
        HashSet<String> candidates = new HashSet<String>();
        candidates.add(this.createTestQueryBuilder().toString());
        candidates.addAll(this.getAlternateVersions().keySet());
        List<Tuple<String, String>> testQueries = AbstractQueryTestCase.alterateQueries(candidates, this.getObjectsHoldingArbitraryContent());
        for (Tuple<String, String> testQuery : testQueries) {
            String expectedException = (String)testQuery.v2();
            try {
                this.parseQuery((String)testQuery.v1());
                if (expectedException == null) continue;
                AbstractQueryTestCase.fail((String)("some parsing exception expected for query: " + testQuery));
            }
            catch (ElasticsearchParseException | ParsingException | XContentParseException e) {
                if (expectedException == null) {
                    throw new AssertionError("unexpected exception when parsing query:\n" + testQuery, e);
                }
            }
            catch (IllegalArgumentException e) {
                if (expectedException == null) {
                    throw new AssertionError("unexpected exception when parsing query:\n" + testQuery, e);
                }
                AbstractQueryTestCase.assertThat(e.getMessage(), Matchers.containsString((String)expectedException));
            }
        }
    }

    static List<Tuple<String, String>> alterateQueries(Set<String> queries, Map<String, String> arbitraryMarkers) throws IOException {
        ArrayList<Tuple<String, String>> results = new ArrayList<Tuple<String, String>>();
        boolean hasArbitraryContent = arbitraryMarkers != null && !arbitraryMarkers.isEmpty();
        block12: for (String query : queries) {
            int mutation = 0;
            while (true) {
                String exception = "unknown field [newField]";
                BytesStreamOutput out = new BytesStreamOutput();
                XContentGenerator generator = XContentType.JSON.xContent().createGenerator((OutputStream)out);
                try {
                    XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, query);
                    try {
                        XContentParser.Token token;
                        int objectIndex = -1;
                        LinkedList<String> levels = new LinkedList<String>();
                        block14: while ((token = parser.nextToken()) != null) {
                            if (token == XContentParser.Token.START_ARRAY) {
                                levels.addLast(parser.currentName());
                            } else if (token == XContentParser.Token.START_OBJECT) {
                                levels.addLast(parser.currentName());
                                if (++objectIndex == mutation) {
                                    generator.writeStartObject();
                                    generator.writeFieldName("newField");
                                    generator.copyCurrentStructure(parser);
                                    generator.writeEndObject();
                                    if (!hasArbitraryContent) continue;
                                    for (String marker : arbitraryMarkers.keySet()) {
                                        if (!levels.contains(marker)) continue;
                                        exception = arbitraryMarkers.get(marker);
                                        continue block14;
                                    }
                                    continue;
                                }
                            } else if (token == XContentParser.Token.END_OBJECT || token == XContentParser.Token.END_ARRAY) {
                                levels.removeLast();
                            }
                            generator.copyCurrentEvent(parser);
                        }
                        if (objectIndex < mutation) continue block12;
                        ++mutation;
                    }
                    finally {
                        if (parser == null) continue block12;
                        parser.close();
                        continue block12;
                    }
                }
                finally {
                    if (generator == null) continue block12;
                    generator.close();
                    continue block12;
                }
                results.add((Tuple<String, String>)new Tuple((Object)out.bytes().utf8ToString(), (Object)exception));
            }
        }
        return results;
    }

    protected Map<String, String> getObjectsHoldingArbitraryContent() {
        return Collections.emptyMap();
    }

    public final void testQueryWrappedInArray() {
        QB queryBuilder = this.createTestQueryBuilder();
        String queryName = queryBuilder.getName();
        String validQuery = queryBuilder.toString();
        this.queryWrappedInArrayTest(queryName, validQuery);
        for (String query : this.getAlternateVersions().keySet()) {
            this.queryWrappedInArrayTest(queryName, query);
        }
    }

    private void queryWrappedInArrayTest(String queryName, String validQuery) {
        int endArrayPosition;
        int insertionPosition;
        int i = validQuery.indexOf("\"" + queryName + "\"");
        AbstractQueryTestCase.assertThat(i, Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        for (insertionPosition = i; insertionPosition < validQuery.length() && validQuery.charAt(insertionPosition) != ':'; ++insertionPosition) {
        }
        ++insertionPosition;
        for (endArrayPosition = validQuery.length() - 1; endArrayPosition >= 0 && validQuery.charAt(endArrayPosition) != '}'; --endArrayPosition) {
        }
        String testQuery = validQuery.substring(0, insertionPosition) + "[" + validQuery.substring(insertionPosition, endArrayPosition) + "]" + validQuery.substring(endArrayPosition);
        ParsingException e = (ParsingException)AbstractQueryTestCase.expectThrows(ParsingException.class, () -> this.parseQuery(testQuery));
        AbstractQueryTestCase.assertEquals((Object)("[" + queryName + "] query malformed, no start_object after query name"), (Object)e.getMessage());
    }

    protected Map<String, QB> getAlternateVersions() {
        return Collections.emptyMap();
    }

    protected void assertParsedQuery(String queryAsString, QueryBuilder expectedQuery) throws IOException {
        QueryBuilder newQuery = this.parseQuery(queryAsString);
        AbstractQueryTestCase.assertNotSame((Object)newQuery, (Object)expectedQuery);
        AbstractQueryTestCase.assertEquals((Object)expectedQuery, (Object)newQuery);
        AbstractQueryTestCase.assertEquals((long)expectedQuery.hashCode(), (long)newQuery.hashCode());
    }

    private void assertParsedQuery(XContentParser parser, QueryBuilder expectedQuery) throws IOException {
        QueryBuilder newQuery = this.parseQuery(parser);
        AbstractQueryTestCase.assertNotSame((Object)newQuery, (Object)expectedQuery);
        AbstractQueryTestCase.assertEquals((Object)expectedQuery, (Object)newQuery);
        AbstractQueryTestCase.assertEquals((long)expectedQuery.hashCode(), (long)newQuery.hashCode());
    }

    protected QueryBuilder parseQuery(AbstractQueryBuilder<?> builder) throws IOException {
        BytesReference bytes = XContentHelper.toXContent(builder, (XContentType)XContentType.JSON, (boolean)false);
        try (XContentParser parser = this.createParser(JsonXContent.jsonXContent, bytes);){
            QueryBuilder queryBuilder = this.parseQuery(parser);
            return queryBuilder;
        }
    }

    protected QueryBuilder parseQuery(String queryAsString) throws IOException {
        try (XContentParser parser = this.createParser(JsonXContent.jsonXContent, queryAsString);){
            QueryBuilder queryBuilder = this.parseQuery(parser);
            return queryBuilder;
        }
    }

    protected QueryBuilder parseQuery(XContentParser parser) throws IOException {
        QueryBuilder parseInnerQueryBuilder = AbstractQueryBuilder.parseTopLevelQuery((XContentParser)parser);
        AbstractQueryTestCase.assertNull((Object)parser.nextToken());
        return parseInnerQueryBuilder;
    }

    protected boolean builderGeneratesCacheableQueries() {
        return true;
    }

    public void testToQuery() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            SearchExecutionContext context = AbstractQueryTestCase.createSearchExecutionContext();
            assert (context.isCacheable());
            context.setAllowUnmappedFields(true);
            QB firstQuery = this.createTestQueryBuilder();
            QB controlQuery = this.copyQuery(firstQuery);
            QueryBuilder rewritten = this.rewriteQuery(firstQuery, AbstractQueryTestCase.createQueryRewriteContext(), new SearchExecutionContext(context));
            Query firstLuceneQuery = rewritten.toQuery(context);
            AbstractQueryTestCase.assertNotNull((String)"toQuery should not return null", (Object)firstLuceneQuery);
            this.assertLuceneQuery(firstQuery, firstLuceneQuery, context);
            AbstractQueryTestCase.assertEquals((String)("query is not equal to its copy after calling toQuery, firstQuery: " + firstQuery + ", secondQuery: " + controlQuery), firstQuery, controlQuery);
            AbstractQueryTestCase.assertEquals((String)("equals is not symmetric after calling toQuery, firstQuery: " + firstQuery + ", secondQuery: " + controlQuery), controlQuery, firstQuery);
            AbstractQueryTestCase.assertThat("query copy's hashcode is different from original hashcode after calling toQuery, firstQuery: " + firstQuery + ", secondQuery: " + controlQuery, controlQuery.hashCode(), CoreMatchers.equalTo((Object)firstQuery.hashCode()));
            QB secondQuery = this.copyQuery(firstQuery);
            if (AbstractQueryTestCase.randomBoolean()) {
                secondQuery.queryName((String)(secondQuery.queryName() == null ? AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 30) : secondQuery.queryName() + AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10)));
            }
            context = new SearchExecutionContext(context);
            Query secondLuceneQuery = this.rewriteQuery(secondQuery, AbstractQueryTestCase.createQueryRewriteContext(), new SearchExecutionContext(context)).toQuery(context);
            AbstractQueryTestCase.assertNotNull((String)"toQuery should not return null", (Object)secondLuceneQuery);
            this.assertLuceneQuery(secondQuery, secondLuceneQuery, context);
            if (this.builderGeneratesCacheableQueries()) {
                AbstractQueryTestCase.assertEquals((String)"two equivalent query builders lead to different lucene queries hashcode", (long)secondLuceneQuery.hashCode(), (long)firstLuceneQuery.hashCode());
                AbstractQueryTestCase.assertEquals((String)"two equivalent query builders lead to different lucene queries", (Object)this.rewrite(secondLuceneQuery), (Object)this.rewrite(firstLuceneQuery));
            }
            if (!this.supportsBoost() || firstLuceneQuery instanceof MatchNoDocsQuery) continue;
            secondQuery.boost(firstQuery.boost() + 1.0f + AbstractQueryTestCase.randomFloat());
            Query thirdLuceneQuery = this.rewriteQuery(secondQuery, AbstractQueryTestCase.createQueryRewriteContext(), new SearchExecutionContext(context)).toQuery(context);
            AbstractQueryTestCase.assertNotEquals((String)"modifying the boost doesn't affect the corresponding lucene query", (Object)this.rewrite(firstLuceneQuery), (Object)this.rewrite(thirdLuceneQuery));
        }
    }

    protected QueryBuilder rewriteQuery(QB queryBuilder, SearchExecutionContext shardRewriteContext) throws IOException {
        QueryBuilder rewritten = this.rewriteAndFetch((QueryBuilder)queryBuilder, (QueryRewriteContext)shardRewriteContext);
        this.assertSerialization(rewritten);
        return rewritten;
    }

    protected QueryBuilder rewriteQuery(QB queryBuilder, QueryRewriteContext coordinatorRewriteContext, SearchExecutionContext shardRewriteContext) throws IOException {
        QueryBuilder rewritten = this.rewriteAndFetch((QueryBuilder)queryBuilder, coordinatorRewriteContext);
        this.assertSerialization(rewritten);
        rewritten = this.rewriteAndFetch(rewritten, (QueryRewriteContext)shardRewriteContext);
        this.assertSerialization(rewritten);
        return rewritten;
    }

    protected boolean supportsBoost() {
        return true;
    }

    protected boolean supportsQueryName() {
        return true;
    }

    protected void assertLuceneQuery(QB queryBuilder, Query query, SearchExecutionContext context) throws IOException {
        if (queryBuilder.queryName() != null && !(query instanceof MatchNoDocsQuery)) {
            Query namedQuery = (Query)context.copyNamedQueries().get(queryBuilder.queryName());
            AbstractQueryTestCase.assertThat(namedQuery, CoreMatchers.equalTo((Object)query));
        }
        if (query != null && queryBuilder.boost() != 1.0f) {
            AbstractQueryTestCase.assertThat(query, Matchers.either((Matcher)Matchers.instanceOf(BoostQuery.class)).or(Matchers.instanceOf(MatchNoDocsQuery.class)));
            if (query instanceof BoostQuery) {
                BoostQuery boostQuery = (BoostQuery)query;
                if (!(boostQuery.getQuery() instanceof MatchNoDocsQuery)) {
                    AbstractQueryTestCase.assertThat(Float.valueOf(boostQuery.getBoost()), CoreMatchers.equalTo((Object)Float.valueOf(queryBuilder.boost())));
                }
                query = boostQuery.getQuery();
            }
        }
        this.doAssertLuceneQuery(queryBuilder, query, context);
    }

    protected abstract void doAssertLuceneQuery(QB var1, Query var2, SearchExecutionContext var3) throws IOException;

    protected void assertTermOrBoostQuery(Query query, String field, String value, float fieldBoost) {
        if (fieldBoost != 1.0f) {
            AbstractQueryTestCase.assertThat(query, Matchers.instanceOf(BoostQuery.class));
            BoostQuery boostQuery = (BoostQuery)query;
            AbstractQueryTestCase.assertThat(Float.valueOf(boostQuery.getBoost()), CoreMatchers.equalTo((Object)Float.valueOf(fieldBoost)));
            query = boostQuery.getQuery();
        }
        this.assertTermQuery(query, field, value);
    }

    protected void assertTermQuery(Query query, String field, String value) {
        AbstractQueryTestCase.assertThat(query, Matchers.instanceOf(TermQuery.class));
        TermQuery termQuery = (TermQuery)query;
        String expectedFieldName = AbstractQueryTestCase.expectedFieldName(field);
        AbstractQueryTestCase.assertThat(termQuery.getTerm().field(), CoreMatchers.equalTo((Object)expectedFieldName));
        AbstractQueryTestCase.assertThat(termQuery.getTerm().text().toLowerCase(Locale.ROOT), CoreMatchers.equalTo((Object)value.toLowerCase(Locale.ROOT)));
    }

    public void testSerialization() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            QB testQuery = this.createTestQueryBuilder();
            this.assertSerialization((QueryBuilder)testQuery);
        }
    }

    protected QueryBuilder assertSerialization(QueryBuilder testQuery) throws IOException {
        return this.assertSerialization(testQuery, TransportVersion.current());
    }

    protected QueryBuilder assertSerialization(QueryBuilder testQuery, TransportVersion version) throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            QueryBuilder queryBuilder;
            output.setTransportVersion(version);
            output.writeNamedWriteable((NamedWriteable)testQuery);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), this.namedWriteableRegistry());){
                in.setTransportVersion(version);
                QueryBuilder deserializedQuery = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
                AbstractQueryTestCase.assertEquals((Object)testQuery, (Object)deserializedQuery);
                AbstractQueryTestCase.assertEquals((long)testQuery.hashCode(), (long)deserializedQuery.hashCode());
                AbstractQueryTestCase.assertNotSame((Object)testQuery, (Object)deserializedQuery);
                queryBuilder = deserializedQuery;
            }
            return queryBuilder;
        }
    }

    public void testEqualsAndHashcode() {
        for (int runs = 0; runs < 20; ++runs) {
            EqualsHashCodeTestUtils.checkEqualsAndHashCode(this.createTestQueryBuilder(), this::copyQuery, this::mutateInstance);
        }
    }

    public QB mutateInstance(QB instance) throws IOException {
        return this.changeNameOrBoost(instance);
    }

    public void testValidOutput() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            QB testQuery = this.createTestQueryBuilder();
            XContentType xContentType = XContentType.JSON;
            String toString = Strings.toString(testQuery);
            try (XContentParser parser = this.createParser(xContentType.xContent(), toString);){
                this.assertParsedQuery(parser, (QueryBuilder)testQuery);
            }
            BytesReference bytes = XContentHelper.toXContent(testQuery, (XContentType)xContentType, (boolean)false);
            try (XContentParser parser = this.createParser(xContentType.xContent(), bytes);){
                this.assertParsedQuery(parser, (QueryBuilder)testQuery);
                continue;
            }
        }
    }

    protected QB changeNameOrBoost(QB original) throws IOException {
        QB secondQuery = this.copyQuery(original);
        if (AbstractQueryTestCase.randomBoolean()) {
            secondQuery.queryName((String)(secondQuery.queryName() == null ? AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 30) : secondQuery.queryName() + AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10)));
        } else {
            secondQuery.boost(original.boost() + 1.0f + AbstractQueryTestCase.randomFloat());
        }
        return secondQuery;
    }

    protected QB copyQuery(QB query) throws IOException {
        Writeable.Reader reader = this.namedWriteableRegistry().getReader(QueryBuilder.class, query.getWriteableName());
        return (QB)((AbstractQueryBuilder)AbstractQueryTestCase.copyWriteable(query, this.namedWriteableRegistry(), reader));
    }

    protected static Object getRandomValueForFieldName(String fieldName) {
        return switch (fieldName) {
            case "mapped_string", "mapped_string_alias" -> {
                if (AbstractQueryTestCase.rarely()) {
                    JsonStringEncoder encoder = JsonStringEncoder.getInstance();
                    yield new String(encoder.quoteAsString(AbstractQueryTestCase.randomUnicodeOfLength(10)));
                }
                yield AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10);
            }
            case "mapped_int", "mapped_int_field_alias" -> AbstractQueryTestCase.randomIntBetween(0, 10);
            case "mapped_double" -> 1.0 + AbstractQueryTestCase.randomDouble() * 9.0;
            case "mapped_boolean" -> AbstractQueryTestCase.randomBoolean();
            case "mapped_date" -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis()), ZoneOffset.UTC).toString();
            case "mapped_date_nanos" -> Instant.now().toString();
            default -> AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10);
        };
    }

    protected static String getRandomQueryText() {
        int terms = AbstractQueryTestCase.randomIntBetween(0, 3);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < terms; ++i) {
            builder.append(AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10)).append(" ");
        }
        return builder.toString().trim();
    }

    protected static String getRandomFieldName() {
        if (AbstractQueryTestCase.randomBoolean()) {
            return AbstractQueryTestCase.randomAlphaOfLengthBetween(1, 10);
        }
        return AbstractQueryTestCase.randomFrom(MAPPED_LEAF_FIELD_NAMES);
    }

    protected static String getRandomRewriteMethod() {
        Object rewrite = AbstractQueryTestCase.randomBoolean() ? AbstractQueryTestCase.randomFrom(QueryParsers.CONSTANT_SCORE, QueryParsers.SCORING_BOOLEAN, QueryParsers.CONSTANT_SCORE_BOOLEAN, QueryParsers.CONSTANT_SCORE_BLENDED).getPreferredName() : AbstractQueryTestCase.randomFrom(QueryParsers.TOP_TERMS, QueryParsers.TOP_TERMS_BOOST, QueryParsers.TOP_TERMS_BLENDED_FREQS).getPreferredName() + "1";
        return rewrite;
    }

    protected static Fuzziness randomFuzziness(String fieldName) {
        switch (fieldName) {
            case "mapped_int": 
            case "mapped_int_field_alias": 
            case "mapped_double": 
            case "mapped_date": 
            case "mapped_date_nanos": {
                return Fuzziness.fromEdits((int)AbstractQueryTestCase.randomIntBetween(0, 2));
            }
        }
        if (AbstractQueryTestCase.randomBoolean()) {
            return Fuzziness.fromEdits((int)AbstractQueryTestCase.randomIntBetween(0, 2));
        }
        return Fuzziness.AUTO;
    }

    protected static String randomAnalyzer() {
        return AbstractQueryTestCase.randomFrom("simple", "standard", "keyword", "whitespace");
    }

    protected static String randomMinimumShouldMatch() {
        return AbstractQueryTestCase.randomFrom("1", "-1", "75%", "-25%", "2<75%", "2<-25%");
    }

    public static void checkGeneratedJson(String expected, QueryBuilder source) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
        source.toXContent(builder, ToXContent.EMPTY_PARAMS);
        AbstractQueryTestCase.assertEquals((String)AbstractQueryTestCase.msg(expected, Strings.toString((XContentBuilder)builder)), (Object)expected.replaceAll("\\s+", ""), (Object)Strings.toString((XContentBuilder)builder).replaceAll("\\s+", ""));
    }

    private static String msg(String left, String right) {
        int size = Math.min(left.length(), right.length());
        StringBuilder builder = new StringBuilder("size: " + left.length() + " vs. " + right.length());
        builder.append(" content: <<");
        for (int i = 0; i < size; ++i) {
            if (left.charAt(i) != right.charAt(i)) {
                builder.append(">> ").append("until offset: ").append(i).append(" [").append(left.charAt(i)).append(" vs.").append(right.charAt(i)).append("] [").append((int)left.charAt(i)).append(" vs.").append((int)right.charAt(i)).append(']');
                return builder.toString();
            }
            builder.append(left.charAt(i));
        }
        if (left.length() != right.length()) {
            int leftEnd = Math.max(size, left.length()) - 1;
            int rightEnd = Math.max(size, right.length()) - 1;
            builder.append(">> ").append("until offset: ").append(size).append(" [").append(left.charAt(leftEnd)).append(" vs.").append(right.charAt(rightEnd)).append("] [").append((int)left.charAt(leftEnd)).append(" vs.").append((int)right.charAt(rightEnd)).append(']');
            return builder.toString();
        }
        return "";
    }

    public void testMustRewrite() throws IOException {
        SearchExecutionContext context = AbstractQueryTestCase.createSearchExecutionContext();
        context.setAllowUnmappedFields(true);
        QB queryBuilder = this.createTestQueryBuilder();
        queryBuilder.toQuery(context);
    }

    protected Query rewrite(Query query) throws IOException {
        return query;
    }

    protected QueryBuilder rewriteAndFetch(QueryBuilder builder, QueryRewriteContext context) {
        PlainActionFuture future = new PlainActionFuture();
        Rewriteable.rewriteAndFetch((Rewriteable)builder, (QueryRewriteContext)context, (ActionListener)future);
        return (QueryBuilder)future.actionGet();
    }

    public boolean isTextField(String fieldName) {
        return fieldName.equals("mapped_string") || fieldName.equals("mapped_string_alias");
    }

    public void testCacheability() throws IOException {
        QB queryBuilder = this.createTestQueryBuilder();
        SearchExecutionContext context = AbstractQueryTestCase.createSearchExecutionContext();
        QueryBuilder rewriteQuery = this.rewriteQuery(queryBuilder, AbstractQueryTestCase.createQueryRewriteContext(), new SearchExecutionContext(context));
        AbstractQueryTestCase.assertNotNull((Object)rewriteQuery.toQuery(context));
        AbstractQueryTestCase.assertTrue((String)("query should be cacheable: " + queryBuilder.toString()), (boolean)context.isCacheable());
    }
}

