/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.ssl.KeyStoreUtil;
import org.elasticsearch.test.ESTestCase;
import org.junit.Assert;
import org.junit.rules.ExternalResource;

public class TestTrustStore
extends ExternalResource {
    private final CheckedSupplier<InputStream, IOException> pemStreamSupplier;
    private Path trustStorePath;

    public TestTrustStore(CheckedSupplier<InputStream, IOException> pemStreamSupplier) {
        this.pemStreamSupplier = pemStreamSupplier;
    }

    public Path getTrustStorePath() {
        Assert.assertFalse((String)"Tests in FIPS mode cannot supply a custom trust store", (boolean)ESTestCase.inFipsJvm());
        return Objects.requireNonNullElseGet(this.trustStorePath, () -> (Path)ESTestCase.fail(null, "trust store not created", new Object[0]));
    }

    protected void before() {
        Path tmpDir = LuceneTestCase.createTempDir();
        Path tmpTrustStorePath = tmpDir.resolve("trust-store.jks");
        try (InputStream pemStream = (InputStream)this.pemStreamSupplier.get();
             OutputStream jksStream = Files.newOutputStream(tmpTrustStorePath, new OpenOption[0]);){
            List<Certificate> certificates = CertificateFactory.getInstance("X.509").generateCertificates(pemStream).stream().map(i -> i).toList();
            KeyStore trustStore = KeyStoreUtil.buildTrustStore(certificates, (String)"jks");
            trustStore.store(jksStream, new char[0]);
            this.trustStorePath = tmpTrustStorePath;
        }
        catch (Exception e) {
            throw new AssertionError("unexpected", e);
        }
    }

    protected void after() {
        Assert.assertTrue((String)(this.trustStorePath + " should still exist at teardown"), (boolean)Files.exists(this.trustStorePath, new LinkOption[0]));
    }
}

