/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.hamcrest;

import java.util.Optional;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class OptionalMatchers {
    public static Matcher<Optional<?>> isEmpty() {
        return new IsEmptyMatcher();
    }

    public static Matcher<Optional<?>> isPresent() {
        return new IsPresentMatcher(Matchers.anything());
    }

    public static <T> Matcher<Optional<? extends T>> isPresentWith(T contents) {
        return new IsPresentMatcher(Matchers.equalTo(contents));
    }

    public static <T> Matcher<Optional<? extends T>> isPresentWith(Matcher<? super T> contents) {
        return new IsPresentMatcher<T>(contents);
    }

    private static class IsEmptyMatcher
    extends TypeSafeMatcher<Optional<?>> {
        private IsEmptyMatcher() {
        }

        protected boolean matchesSafely(Optional<?> item) {
            return item.isEmpty();
        }

        protected void describeMismatchSafely(Optional<?> item, Description mismatchDescription) {
            mismatchDescription.appendText("a non-empty optional ").appendValue(item.get());
        }

        public void describeTo(Description description) {
            description.appendText("an empty optional");
        }
    }

    private static class IsPresentMatcher<T>
    extends BaseMatcher<Optional<? extends T>> {
        private final Matcher<? super T> contents;

        private IsPresentMatcher(Matcher<? super T> contents) {
            this.contents = contents;
        }

        public boolean matches(Object actual) {
            Optional opt = (Optional)actual;
            return opt.isPresent() && this.contents.matches(opt.get());
        }

        public void describeTo(Description description) {
            description.appendText("a non-empty optional ").appendDescriptionOf(this.contents);
        }

        public void describeMismatch(Object item, Description description) {
            Optional opt = (Optional)item;
            if (opt.isEmpty()) {
                description.appendText("an empty optional");
                return;
            }
            description.appendText("an optional ");
            this.contents.describeMismatch(opt.get(), description);
        }
    }
}

