/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.jar;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public final class JarUtils {
    private JarUtils() {
    }

    public static Path createJar(Path dir, String name, Manifest manifest, String ... files) throws IOException {
        Path jarpath = dir.resolve(name);
        UncheckedIOFunction<OutputStream, JarOutputStream> jarOutFunc = manifest == null ? os -> new JarOutputStream((OutputStream)os) : os -> new JarOutputStream((OutputStream)os, manifest);
        try (OutputStream os2 = Files.newOutputStream(jarpath, StandardOpenOption.CREATE);
             JarOutputStream out = jarOutFunc.apply(os2);){
            for (String file : files) {
                out.putNextEntry(new JarEntry(file));
            }
        }
        return jarpath;
    }

    public static void createJarWithEntries(Path jarfile, Map<String, byte[]> entries) throws IOException {
        try (OutputStream out = Files.newOutputStream(jarfile, new OpenOption[0]);
             JarOutputStream jos = new JarOutputStream(out);){
            for (Map.Entry<String, byte[]> entry : entries.entrySet()) {
                String name = entry.getKey();
                jos.putNextEntry(new JarEntry(name));
                ByteArrayInputStream bais = new ByteArrayInputStream(entry.getValue());
                bais.transferTo(jos);
                jos.closeEntry();
            }
        }
    }

    public static void createJarWithEntriesUTF(Path jarfile, Map<String, String> entries) throws IOException {
        Map<String, byte[]> map = entries.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, v -> ((String)v.getValue()).getBytes(StandardCharsets.UTF_8)));
        JarUtils.createJarWithEntries(jarfile, map);
    }

    @FunctionalInterface
    static interface UncheckedIOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

