/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Releasable;
import org.junit.Assert;

public class ClusterStateTaskExecutorUtils {
    private ClusterStateTaskExecutorUtils() {
        throw new UnsupportedOperationException("utils class, do not instantiate");
    }

    public static <T extends ClusterStateTaskListener> ClusterState executeAndAssertSuccessful(ClusterState originalState, ClusterStateTaskExecutor<T> executor, Iterable<T> tasks) throws Exception {
        return ClusterStateTaskExecutorUtils.executeHandlingResults(originalState, executor, tasks, task -> {}, (task, e) -> {
            throw new AssertionError(e);
        });
    }

    public static <T extends ClusterStateTaskListener> ClusterState executeAndThrowFirstFailure(ClusterState originalState, ClusterStateTaskExecutor<T> executor, Iterable<T> tasks) throws Exception {
        return ClusterStateTaskExecutorUtils.executeHandlingResults(originalState, executor, tasks, task -> {}, (task, e) -> {
            throw e;
        });
    }

    public static <T extends ClusterStateTaskListener> ClusterState executeIgnoringFailures(ClusterState originalState, ClusterStateTaskExecutor<T> executor, Iterable<T> tasks) throws Exception {
        return ClusterStateTaskExecutorUtils.executeHandlingResults(originalState, executor, tasks, task -> {}, (task, e) -> {});
    }

    public static <T extends ClusterStateTaskListener> ClusterState executeHandlingResults(ClusterState originalState, ClusterStateTaskExecutor<T> executor, Iterable<T> tasks, CheckedConsumer<T, Exception> onTaskSuccess, CheckedBiConsumer<T, Exception, Exception> onTaskFailure) throws Exception {
        List<ClusterStateTaskExecutor.TaskContext> taskContexts = StreamSupport.stream(tasks.spliterator(), false).map(TestTaskContext::new).toList();
        ClusterState resultingState = executor.execute(new ClusterStateTaskExecutor.BatchExecutionContext(originalState, taskContexts, () -> null));
        Assert.assertNotNull((Object)resultingState);
        for (ClusterStateTaskExecutor.TaskContext taskContext : taskContexts) {
            TestTaskContext testTaskContext = (TestTaskContext)taskContext;
            Assert.assertFalse((String)(taskContext + " should have completed"), (boolean)testTaskContext.incomplete());
            if (testTaskContext.succeeded()) {
                onTaskSuccess.accept(testTaskContext.getTask());
                continue;
            }
            onTaskFailure.accept(testTaskContext.getTask(), (Object)testTaskContext.getFailure());
        }
        return resultingState;
    }

    private static class TestTaskContext<T extends ClusterStateTaskListener>
    implements ClusterStateTaskExecutor.TaskContext<T> {
        private final T task;
        private Exception failure;
        private boolean succeeded;

        TestTaskContext(T task) {
            this.task = task;
        }

        public T getTask() {
            return this.task;
        }

        boolean incomplete() {
            return !this.succeeded && this.failure == null;
        }

        boolean succeeded() {
            return this.succeeded;
        }

        Exception getFailure() {
            assert (this.failure != null);
            return this.failure;
        }

        public void onFailure(Exception failure) {
            assert (this.incomplete());
            assert (failure != null);
            this.failure = failure;
        }

        public void success(Runnable onPublishSuccess, ClusterStateAckListener clusterStateAckListener) {
            assert (this.incomplete());
            assert (onPublishSuccess != null);
            assert (clusterStateAckListener != null);
            assert (this.task == clusterStateAckListener || !(this.task instanceof ClusterStateAckListener));
            this.succeeded = true;
        }

        public void success(Runnable onPublishSuccess) {
            assert (this.incomplete());
            assert (onPublishSuccess != null);
            assert (!(this.task instanceof ClusterStateAckListener));
            this.succeeded = true;
        }

        public void success(Consumer<ClusterState> publishedStateListener, ClusterStateAckListener clusterStateAckListener) {
            assert (this.incomplete());
            assert (publishedStateListener != null);
            assert (clusterStateAckListener != null);
            assert (this.task == clusterStateAckListener || !(this.task instanceof ClusterStateAckListener));
            this.succeeded = true;
        }

        public void success(Consumer<ClusterState> publishedStateListener) {
            assert (this.incomplete());
            assert (publishedStateListener != null);
            assert (!(this.task instanceof ClusterStateAckListener));
            this.succeeded = true;
        }

        public Releasable captureResponseHeaders() {
            return () -> {};
        }

        public String toString() {
            return "TestTaskContext[" + this.task + "]";
        }
    }
}

