/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.MockEngineFactoryPlugin;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.node.RecoverySettingsChunkSizePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalSettingsPlugin;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.test.store.MockFSIndexStore;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.test.transport.StubbableTransport;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public abstract class AbstractIndexRecoveryIntegTestCase
extends ESIntegTestCase {
    private static final String REPO_NAME = "test-repo-1";
    private static final String SNAP_NAME = "test-snap-1";

    @Override
    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return Arrays.asList(MockTransportService.TestPlugin.class, MockFSIndexStore.TestPlugin.class, RecoverySettingsChunkSizePlugin.class, InternalSettingsPlugin.class, MockEngineFactoryPlugin.class);
    }

    @Override
    protected void beforeIndexDeletion() throws Exception {
        super.beforeIndexDeletion();
        AbstractIndexRecoveryIntegTestCase.internalCluster().assertConsistentHistoryBetweenTranslogAndLuceneIndex();
        AbstractIndexRecoveryIntegTestCase.internalCluster().assertSeqNos();
        AbstractIndexRecoveryIntegTestCase.internalCluster().assertSameDocIdsOnShards();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTransientErrorsDuringRecoveryAreRetried(String recoveryActionToBlock) throws Exception {
        int i;
        String indexName = "test";
        Settings nodeSettings = Settings.builder().put(RecoverySettings.INDICES_RECOVERY_RETRY_DELAY_NETWORK_SETTING.getKey(), "100ms").put(NodeConnectionsService.CLUSTER_NODE_RECONNECT_INTERVAL_SETTING.getKey(), "500ms").put(RecoverySettings.INDICES_RECOVERY_INTERNAL_ACTION_TIMEOUT_SETTING.getKey(), "10s").build();
        AbstractIndexRecoveryIntegTestCase.internalCluster().startNode(nodeSettings);
        String blueNodeName = AbstractIndexRecoveryIntegTestCase.internalCluster().startNode(Settings.builder().put("node.attr.color", "blue").put(nodeSettings).build());
        String redNodeName = AbstractIndexRecoveryIntegTestCase.internalCluster().startNode(Settings.builder().put("node.attr.color", "red").put(nodeSettings).build());
        ClusterHealthResponse response = (ClusterHealthResponse)AbstractIndexRecoveryIntegTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForNodes(">=3").get();
        AbstractIndexRecoveryIntegTestCase.assertThat((Object)response.isTimedOut(), (Matcher)Matchers.is((Object)false));
        AbstractIndexRecoveryIntegTestCase.client().admin().indices().prepareCreate("test").setSettings(Settings.builder().put(IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "color", "blue").put("index.number_of_shards", 1).put("index.number_of_replicas", 0)).get();
        ArrayList<IndexRequestBuilder> requests = new ArrayList<IndexRequestBuilder>();
        int numDocs = AbstractIndexRecoveryIntegTestCase.scaledRandomIntBetween(100, 8000);
        int threeFourths = (int)((double)numDocs * 0.75);
        for (i = 0; i < threeFourths; ++i) {
            requests.add(AbstractIndexRecoveryIntegTestCase.client().prepareIndex("test").setSource("{}", XContentType.JSON));
        }
        this.indexRandom(true, requests);
        this.flush("test");
        requests.clear();
        for (i = threeFourths; i < numDocs; ++i) {
            requests.add(AbstractIndexRecoveryIntegTestCase.client().prepareIndex("test").setSource("{}", XContentType.JSON));
        }
        this.indexRandom(true, requests);
        this.ensureSearchable("test");
        ClusterStateResponse stateResponse = (ClusterStateResponse)AbstractIndexRecoveryIntegTestCase.client().admin().cluster().prepareState().get();
        String blueNodeId = AbstractIndexRecoveryIntegTestCase.internalCluster().getInstance(ClusterService.class, blueNodeName).localNode().getId();
        AbstractIndexRecoveryIntegTestCase.assertFalse((boolean)stateResponse.getState().getRoutingNodes().node(blueNodeId).isEmpty());
        SearchResponse searchResponse = (SearchResponse)AbstractIndexRecoveryIntegTestCase.client().prepareSearch(new String[]{"test"}).get();
        ElasticsearchAssertions.assertHitCount(searchResponse, numDocs);
        this.logger.info("--> will temporarily interrupt recovery action between blue & red on [{}]", (Object)recoveryActionToBlock);
        if (recoveryActionToBlock.equals("internal:index/shard/recovery/restore_file_from_snapshot")) {
            this.createSnapshotThatCanBeUsedDuringRecovery("test");
        }
        MockTransportService blueTransportService = (MockTransportService)AbstractIndexRecoveryIntegTestCase.internalCluster().getInstance(TransportService.class, blueNodeName);
        MockTransportService redTransportService = (MockTransportService)AbstractIndexRecoveryIntegTestCase.internalCluster().getInstance(TransportService.class, redNodeName);
        AtomicBoolean recoveryStarted = new AtomicBoolean(false);
        AtomicBoolean finalizeReceived = new AtomicBoolean(false);
        SingleStartEnforcer validator = new SingleStartEnforcer("test", recoveryStarted, finalizeReceived);
        redTransportService.addSendBehavior(blueTransportService, (connection, requestId, action, request, options) -> {
            validator.accept(action, request);
            connection.sendRequest(requestId, action, request, options);
        });
        Runnable connectionBreaker = () -> {
            this.logger.info("--> closing connections from source node to target node");
            blueTransportService.disconnectFromNode(redTransportService.getLocalDiscoNode());
            if (AbstractIndexRecoveryIntegTestCase.randomBoolean()) {
                this.logger.info("--> closing connections from target node to source node");
                redTransportService.disconnectFromNode(blueTransportService.getLocalDiscoNode());
            }
        };
        TransientReceiveRejected handlingBehavior = new TransientReceiveRejected(recoveryActionToBlock, finalizeReceived, recoveryStarted, connectionBreaker);
        redTransportService.addRequestHandlingBehavior(recoveryActionToBlock, handlingBehavior);
        try {
            this.logger.info("--> starting recovery from blue to red");
            AbstractIndexRecoveryIntegTestCase.client().admin().indices().prepareUpdateSettings(new String[]{"test"}).setSettings(Settings.builder().put(IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "color", "red,blue").put("index.number_of_replicas", 1)).get();
            this.ensureGreen(new String[0]);
            if (recoveryActionToBlock.equals("internal:index/shard/recovery/restore_file_from_snapshot")) {
                AbstractIndexRecoveryIntegTestCase.assertThat((Object)handlingBehavior.blocksRemaining.get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
            }
            searchResponse = (SearchResponse)AbstractIndexRecoveryIntegTestCase.client(redNodeName).prepareSearch(new String[]{"test"}).setPreference("_local").get();
            ElasticsearchAssertions.assertHitCount(searchResponse, numDocs);
        }
        finally {
            blueTransportService.clearAllRules();
            redTransportService.clearAllRules();
        }
    }

    public void checkDisconnectsWhileRecovering(String recoveryActionToBlock) throws Exception {
        String indexName = "test";
        Settings nodeSettings = Settings.builder().put(RecoverySettings.INDICES_RECOVERY_RETRY_DELAY_NETWORK_SETTING.getKey(), "100ms").put(RecoverySettings.INDICES_RECOVERY_INTERNAL_ACTION_TIMEOUT_SETTING.getKey(), "1s").put(NodeConnectionsService.CLUSTER_NODE_RECONNECT_INTERVAL_SETTING.getKey(), "1s").build();
        AbstractIndexRecoveryIntegTestCase.internalCluster().startNode(nodeSettings);
        String blueNodeName = AbstractIndexRecoveryIntegTestCase.internalCluster().startNode(Settings.builder().put("node.attr.color", "blue").put(nodeSettings).build());
        String redNodeName = AbstractIndexRecoveryIntegTestCase.internalCluster().startNode(Settings.builder().put("node.attr.color", "red").put(nodeSettings).build());
        ClusterHealthResponse response = (ClusterHealthResponse)AbstractIndexRecoveryIntegTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForNodes(">=3").get();
        AbstractIndexRecoveryIntegTestCase.assertThat((Object)response.isTimedOut(), (Matcher)Matchers.is((Object)false));
        AbstractIndexRecoveryIntegTestCase.client().admin().indices().prepareCreate("test").setSettings(Settings.builder().put(IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "color", "blue").put("index.number_of_shards", 1).put("index.number_of_replicas", 0)).get();
        ArrayList<IndexRequestBuilder> requests = new ArrayList<IndexRequestBuilder>();
        int numDocs = AbstractIndexRecoveryIntegTestCase.scaledRandomIntBetween(25, 250);
        for (int i = 0; i < numDocs; ++i) {
            requests.add(AbstractIndexRecoveryIntegTestCase.client().prepareIndex("test").setSource("{}", XContentType.JSON));
        }
        this.indexRandom(true, requests);
        this.ensureSearchable("test");
        ClusterStateResponse stateResponse = (ClusterStateResponse)AbstractIndexRecoveryIntegTestCase.client().admin().cluster().prepareState().get();
        String blueNodeId = AbstractIndexRecoveryIntegTestCase.internalCluster().getInstance(ClusterService.class, blueNodeName).localNode().getId();
        AbstractIndexRecoveryIntegTestCase.assertFalse((boolean)stateResponse.getState().getRoutingNodes().node(blueNodeId).isEmpty());
        SearchResponse searchResponse = (SearchResponse)AbstractIndexRecoveryIntegTestCase.client().prepareSearch(new String[]{"test"}).get();
        ElasticsearchAssertions.assertHitCount(searchResponse, numDocs);
        boolean dropRequests = AbstractIndexRecoveryIntegTestCase.randomBoolean();
        this.logger.info("--> will {} between blue & red on [{}]", (Object)(dropRequests ? "drop requests" : "break connection"), (Object)recoveryActionToBlock);
        if (recoveryActionToBlock.equals("internal:index/shard/recovery/restore_file_from_snapshot")) {
            this.createSnapshotThatCanBeUsedDuringRecovery("test");
        }
        MockTransportService blueMockTransportService = (MockTransportService)AbstractIndexRecoveryIntegTestCase.internalCluster().getInstance(TransportService.class, blueNodeName);
        MockTransportService redMockTransportService = (MockTransportService)AbstractIndexRecoveryIntegTestCase.internalCluster().getInstance(TransportService.class, redNodeName);
        TransportService redTransportService = AbstractIndexRecoveryIntegTestCase.internalCluster().getInstance(TransportService.class, redNodeName);
        TransportService blueTransportService = AbstractIndexRecoveryIntegTestCase.internalCluster().getInstance(TransportService.class, blueNodeName);
        CountDownLatch requestFailed = new CountDownLatch(1);
        if (AbstractIndexRecoveryIntegTestCase.randomBoolean()) {
            StubbableTransport.SendRequestBehavior sendRequestBehavior = (connection, requestId, action, request, options) -> {
                if (recoveryActionToBlock.equals(action) || requestFailed.getCount() == 0L) {
                    requestFailed.countDown();
                    this.logger.info("--> preventing {} request by throwing ConnectTransportException", (Object)action);
                    throw new ConnectTransportException(connection.getNode(), "DISCONNECT: prevented " + action + " request");
                }
                connection.sendRequest(requestId, action, request, options);
            };
            blueMockTransportService.addSendBehavior(redTransportService, sendRequestBehavior);
            redMockTransportService.addSendBehavior(blueTransportService, sendRequestBehavior);
        } else {
            blueMockTransportService.addRequestHandlingBehavior(recoveryActionToBlock, (handler, request, channel, task) -> {
                this.logger.info("--> preventing {} response by closing response channel", (Object)recoveryActionToBlock);
                requestFailed.countDown();
                redMockTransportService.disconnectFromNode(blueMockTransportService.getLocalDiscoNode());
                handler.messageReceived(request, channel, task);
            });
            redMockTransportService.addRequestHandlingBehavior(recoveryActionToBlock, (handler, request, channel, task) -> {
                this.logger.info("--> preventing {} response by closing response channel", (Object)recoveryActionToBlock);
                requestFailed.countDown();
                blueMockTransportService.disconnectFromNode(redMockTransportService.getLocalDiscoNode());
                handler.messageReceived(request, channel, task);
            });
        }
        this.logger.info("--> starting recovery from blue to red");
        AbstractIndexRecoveryIntegTestCase.client().admin().indices().prepareUpdateSettings(new String[]{"test"}).setSettings(Settings.builder().put(IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "color", "red,blue").put("index.number_of_replicas", 1)).get();
        requestFailed.await();
        this.logger.info("--> clearing rules to allow recovery to proceed");
        blueMockTransportService.clearAllRules();
        redMockTransportService.clearAllRules();
        this.ensureGreen(new String[0]);
        searchResponse = (SearchResponse)AbstractIndexRecoveryIntegTestCase.client(redNodeName).prepareSearch(new String[]{"test"}).setPreference("_local").get();
        ElasticsearchAssertions.assertHitCount(searchResponse, numDocs);
    }

    public void checkDisconnectsDuringRecovery(boolean useSnapshotBasedRecoveries) throws Exception {
        boolean primaryRelocation = AbstractIndexRecoveryIntegTestCase.randomBoolean();
        String indexName = "test";
        Settings nodeSettings = Settings.builder().put(RecoverySettings.INDICES_RECOVERY_RETRY_DELAY_NETWORK_SETTING.getKey(), TimeValue.timeValueMillis((long)AbstractIndexRecoveryIntegTestCase.randomIntBetween(0, 100))).build();
        final TimeValue disconnectAfterDelay = TimeValue.timeValueMillis((long)AbstractIndexRecoveryIntegTestCase.randomIntBetween(0, 100));
        String masterNodeName = AbstractIndexRecoveryIntegTestCase.internalCluster().startMasterOnlyNode(nodeSettings);
        final String blueNodeName = AbstractIndexRecoveryIntegTestCase.internalCluster().startNode(Settings.builder().put("node.attr.color", "blue").put(nodeSettings).build());
        String redNodeName = AbstractIndexRecoveryIntegTestCase.internalCluster().startNode(Settings.builder().put("node.attr.color", "red").put(nodeSettings).build());
        AbstractIndexRecoveryIntegTestCase.client().admin().indices().prepareCreate("test").setSettings(Settings.builder().put(IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "color", "blue").put("index.number_of_shards", 1).put("index.number_of_replicas", 0)).get();
        ArrayList<IndexRequestBuilder> requests = new ArrayList<IndexRequestBuilder>();
        int numDocs = AbstractIndexRecoveryIntegTestCase.scaledRandomIntBetween(25, 250);
        for (int i = 0; i < numDocs; ++i) {
            requests.add(AbstractIndexRecoveryIntegTestCase.client().prepareIndex("test").setSource("{}", XContentType.JSON));
        }
        this.indexRandom(true, requests);
        this.ensureSearchable("test");
        ElasticsearchAssertions.assertHitCount((SearchResponse)AbstractIndexRecoveryIntegTestCase.client().prepareSearch(new String[]{"test"}).get(), numDocs);
        if (useSnapshotBasedRecoveries) {
            this.createSnapshotThatCanBeUsedDuringRecovery("test");
        }
        MockTransportService masterTransportService = (MockTransportService)AbstractIndexRecoveryIntegTestCase.internalCluster().getInstance(TransportService.class, masterNodeName);
        MockTransportService blueMockTransportService = (MockTransportService)AbstractIndexRecoveryIntegTestCase.internalCluster().getInstance(TransportService.class, blueNodeName);
        MockTransportService redMockTransportService = (MockTransportService)AbstractIndexRecoveryIntegTestCase.internalCluster().getInstance(TransportService.class, redNodeName);
        redMockTransportService.addSendBehavior(blueMockTransportService, new StubbableTransport.SendRequestBehavior(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public void sendRequest(Transport.Connection connection, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException {
                AbstractIndexRecoveryIntegTestCase.this.logger.info("--> sending request {} on {}", (Object)action, (Object)connection.getNode());
                if ("internal:index/shard/recovery/start_recovery".equals(action) && this.count.incrementAndGet() == 1) {
                    try {
                        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> Assert.assertThat((String)"Expected there to be some initializing shards", (Object)((ClusterStateResponse)((ClusterStateRequestBuilder)ESIntegTestCase.client(blueNodeName).admin().cluster().prepareState().setLocal(true)).get()).getState().getRoutingTable().index("test").shard(0).getAllInitializingShards(), (Matcher)Matchers.not((Matcher)Matchers.empty()))));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    connection.sendRequest(requestId, action, request, options);
                    try {
                        Thread.sleep(disconnectAfterDelay.millis());
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    throw new ConnectTransportException(connection.getNode(), "DISCONNECT: simulation disconnect after successfully sending " + action + " request");
                }
                connection.sendRequest(requestId, action, request, options);
            }
        });
        AtomicBoolean finalized = new AtomicBoolean();
        blueMockTransportService.addSendBehavior(redMockTransportService, (connection, requestId, action, request, options) -> {
            this.logger.info("--> sending request {} on {}", (Object)action, (Object)connection.getNode());
            if (action.equals("internal:index/shard/recovery/finalize")) {
                finalized.set(true);
            }
            connection.sendRequest(requestId, action, request, options);
        });
        for (MockTransportService mockTransportService : Arrays.asList(redMockTransportService, blueMockTransportService)) {
            mockTransportService.addSendBehavior(masterTransportService, (connection, requestId, action, request, options) -> {
                this.logger.info("--> sending request {} on {}", (Object)action, (Object)connection.getNode());
                if (!(primaryRelocation && finalized.get())) {
                    AbstractIndexRecoveryIntegTestCase.assertNotEquals((Object)action, (Object)"internal:cluster/shard/failure");
                }
                connection.sendRequest(requestId, action, request, options);
            });
        }
        if (primaryRelocation) {
            this.logger.info("--> starting primary relocation recovery from blue to red");
            AbstractIndexRecoveryIntegTestCase.client().admin().indices().prepareUpdateSettings(new String[]{"test"}).setSettings(Settings.builder().put(IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "color", "red")).get();
            this.ensureGreen(new String[0]);
            AbstractIndexRecoveryIntegTestCase.client().admin().indices().prepareRefresh(new String[]{"test"}).get();
        } else {
            this.logger.info("--> starting replica recovery from blue to red");
            AbstractIndexRecoveryIntegTestCase.client().admin().indices().prepareUpdateSettings(new String[]{"test"}).setSettings(Settings.builder().put(IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "color", "red,blue").put("index.number_of_replicas", 1)).get();
            this.ensureGreen(new String[0]);
        }
        for (int i = 0; i < 10; ++i) {
            ElasticsearchAssertions.assertHitCount((SearchResponse)AbstractIndexRecoveryIntegTestCase.client().prepareSearch(new String[]{"test"}).get(), numDocs);
        }
    }

    private void createSnapshotThatCanBeUsedDuringRecovery(String indexName) throws Exception {
        AbstractIndexRecoveryIntegTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            ShardStats stats = ((IndicesStatsResponse)AbstractIndexRecoveryIntegTestCase.client().admin().indices().prepareStats(new String[]{indexName}).clear().get()).asMap().entrySet().stream().filter(e -> ((ShardRouting)e.getKey()).shardId().getId() == 0).map(Map.Entry::getValue).findFirst().orElse(null);
            AbstractIndexRecoveryIntegTestCase.assertThat((Object)stats, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            AbstractIndexRecoveryIntegTestCase.assertThat((Object)stats.getSeqNoStats(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            AbstractIndexRecoveryIntegTestCase.assertThat((String)Strings.toString((ToXContent)stats.getSeqNoStats()), (Object)stats.getSeqNoStats().getMaxSeqNo(), (Matcher)Matchers.equalTo((Object)stats.getSeqNoStats().getGlobalCheckpoint()));
        }), 60L, TimeUnit.SECONDS);
        ForceMergeResponse forceMergeResponse = (ForceMergeResponse)AbstractIndexRecoveryIntegTestCase.client().admin().indices().prepareForceMerge(new String[]{indexName}).setFlush(AbstractIndexRecoveryIntegTestCase.randomBoolean()).get();
        AbstractIndexRecoveryIntegTestCase.assertThat((Object)forceMergeResponse.getTotalShards(), (Matcher)Matchers.equalTo((Object)forceMergeResponse.getSuccessfulShards()));
        ElasticsearchAssertions.assertAcked((AcknowledgedResponse)AbstractIndexRecoveryIntegTestCase.client().admin().cluster().preparePutRepository(REPO_NAME).setType("fs").setSettings(Settings.builder().put("location", AbstractIndexRecoveryIntegTestCase.randomRepoPath()).put(BlobStoreRepository.USE_FOR_PEER_RECOVERY_SETTING.getKey(), true).put("compress", false)).get());
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)AbstractIndexRecoveryIntegTestCase.client().admin().cluster().prepareCreateSnapshot(REPO_NAME, SNAP_NAME).setWaitForCompletion(true).setIndices(new String[]{indexName}).get();
        AbstractIndexRecoveryIntegTestCase.assertThat((Object)createSnapshotResponse.getSnapshotInfo().successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        AbstractIndexRecoveryIntegTestCase.assertThat((Object)createSnapshotResponse.getSnapshotInfo().successfulShards(), (Matcher)Matchers.equalTo((Object)createSnapshotResponse.getSnapshotInfo().totalShards()));
        AbstractIndexRecoveryIntegTestCase.assertThat((Object)((SnapshotInfo)((GetSnapshotsResponse)AbstractIndexRecoveryIntegTestCase.client().admin().cluster().prepareGetSnapshots(new String[]{REPO_NAME}).setSnapshots(new String[]{SNAP_NAME}).get()).getSnapshots().get(0)).state(), (Matcher)Matchers.equalTo((Object)SnapshotState.SUCCESS));
    }

    private class SingleStartEnforcer
    implements BiConsumer<String, TransportRequest> {
        private final AtomicBoolean recoveryStarted;
        private final AtomicBoolean finalizeReceived;
        private final String indexName;

        private SingleStartEnforcer(String indexName, AtomicBoolean recoveryStarted, AtomicBoolean finalizeReceived) {
            this.indexName = indexName;
            this.recoveryStarted = recoveryStarted;
            this.finalizeReceived = finalizeReceived;
        }

        @Override
        public void accept(String action, TransportRequest request) {
            if ("internal:index/shard/recovery/start_recovery".equals(action)) {
                StartRecoveryRequest startRecoveryRequest = (StartRecoveryRequest)request;
                ShardId shardId = startRecoveryRequest.shardId();
                AbstractIndexRecoveryIntegTestCase.this.logger.info("--> attempting to send start_recovery request for shard: " + shardId);
                if (this.indexName.equals(shardId.getIndexName()) && this.recoveryStarted.get() && !this.finalizeReceived.get()) {
                    throw new IllegalStateException("Recovery cannot be started twice");
                }
            }
        }
    }

    private class TransientReceiveRejected
    implements StubbableTransport.RequestHandlingBehavior<TransportRequest> {
        private final String actionName;
        private final AtomicBoolean recoveryStarted;
        private final AtomicBoolean finalizeReceived;
        private final Runnable connectionBreaker;
        private final AtomicInteger blocksRemaining;

        private TransientReceiveRejected(String actionName, AtomicBoolean recoveryStarted, AtomicBoolean finalizeReceived, Runnable connectionBreaker) {
            this.actionName = actionName;
            this.recoveryStarted = recoveryStarted;
            this.finalizeReceived = finalizeReceived;
            this.connectionBreaker = connectionBreaker;
            this.blocksRemaining = new AtomicInteger(ESTestCase.randomIntBetween(1, 3));
        }

        @Override
        public void messageReceived(TransportRequestHandler<TransportRequest> handler, TransportRequest request, TransportChannel channel, Task task) throws Exception {
            this.recoveryStarted.set(true);
            if (this.actionName.equals("internal:index/shard/recovery/finalize")) {
                this.finalizeReceived.set(true);
            }
            if (this.blocksRemaining.getAndUpdate(i -> i == 0 ? 0 : i - 1) != 0) {
                String rejected = "rejected";
                String circuit = "circuit";
                String network = "network";
                String reason = ESTestCase.randomFrom(rejected, circuit, network);
                if (reason.equals(rejected)) {
                    AbstractIndexRecoveryIntegTestCase.this.logger.info("--> preventing {} response by throwing exception", (Object)this.actionName);
                    throw new EsRejectedExecutionException();
                }
                if (reason.equals(circuit)) {
                    AbstractIndexRecoveryIntegTestCase.this.logger.info("--> preventing {} response by throwing exception", (Object)this.actionName);
                    throw new CircuitBreakingException("Broken", CircuitBreaker.Durability.PERMANENT);
                }
                if (reason.equals(network)) {
                    AbstractIndexRecoveryIntegTestCase.this.logger.info("--> preventing {} response by breaking connection", (Object)this.actionName);
                    this.connectionBreaker.run();
                } else {
                    throw new AssertionError((Object)("Unknown failure reason: " + reason));
                }
            }
            handler.messageReceived(request, channel, task);
        }
    }
}

