/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryResponse;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.blobstore.BlobStoreTestUtil;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.test.ESSingleNodeTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class AbstractThirdPartyRepositoryTestCase
extends ESSingleNodeTestCase {
    @Override
    protected Settings nodeSettings() {
        return Settings.builder().put(super.nodeSettings()).setSecureSettings(this.credentials()).build();
    }

    protected abstract SecureSettings credentials();

    protected abstract void createRepository(String var1);

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createRepository("test-repo");
        this.deleteAndAssertEmpty(this.getRepository().basePath());
    }

    @Override
    public void tearDown() throws Exception {
        this.deleteAndAssertEmpty(this.getRepository().basePath());
        this.client().admin().cluster().prepareDeleteRepository("test-repo").get();
        super.tearDown();
    }

    private void deleteAndAssertEmpty(BlobPath path) {
        BlobStoreRepository repo = this.getRepository();
        PlainActionFuture future = PlainActionFuture.newFuture();
        repo.threadPool().generic().execute((Runnable)ActionRunnable.run((ActionListener)future, () -> repo.blobStore().blobContainer(path).delete()));
        future.actionGet();
        BlobPath parent = path.parent();
        if (parent == null) {
            this.assertChildren(path, Collections.emptyList());
        } else {
            AbstractThirdPartyRepositoryTestCase.assertThat(this.listChildren(parent), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{(String)path.parts().get(path.parts().size() - 1)})));
        }
    }

    public void testCreateSnapshot() {
        this.createIndex("test-idx-1");
        this.createIndex("test-idx-2");
        this.createIndex("test-idx-3");
        this.ensureGreen(new String[0]);
        this.logger.info("--> indexing some data");
        for (int i = 0; i < 100; ++i) {
            this.client().prepareIndex("test-idx-1").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
            this.client().prepareIndex("test-idx-2").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
            this.client().prepareIndex("test-idx-3").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
        }
        this.client().admin().indices().prepareRefresh(new String[0]).get();
        String snapshotName = "test-snap-" + System.currentTimeMillis();
        this.logger.info("--> snapshot");
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.client().admin().cluster().prepareCreateSnapshot("test-repo", snapshotName).setWaitForCompletion(true).setIndices(new String[]{"test-idx-*", "-test-idx-3"}).get();
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)createSnapshotResponse.getSnapshotInfo().successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)createSnapshotResponse.getSnapshotInfo().successfulShards(), (Matcher)Matchers.equalTo((Object)createSnapshotResponse.getSnapshotInfo().totalShards()));
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)((SnapshotInfo)((GetSnapshotsResponse)this.client().admin().cluster().prepareGetSnapshots(new String[]{"test-repo"}).setSnapshots(new String[]{snapshotName}).get()).getSnapshots().get(0)).state(), (Matcher)Matchers.equalTo((Object)SnapshotState.SUCCESS));
        AbstractThirdPartyRepositoryTestCase.assertTrue((boolean)((AcknowledgedResponse)this.client().admin().cluster().prepareDeleteSnapshot("test-repo", new String[]{snapshotName}).get()).isAcknowledged());
    }

    public void testListChildren() throws Exception {
        BlobStoreRepository repo = this.getRepository();
        PlainActionFuture future = PlainActionFuture.newFuture();
        ExecutorService genericExec = repo.threadPool().generic();
        int testBlobLen = AbstractThirdPartyRepositoryTestCase.randomIntBetween(1, 100);
        genericExec.execute((Runnable)ActionRunnable.run((ActionListener)future, () -> {
            BlobStore blobStore = repo.blobStore();
            blobStore.blobContainer(repo.basePath().add("foo")).writeBlob("nested-blob", (InputStream)new ByteArrayInputStream(AbstractThirdPartyRepositoryTestCase.randomByteArrayOfLength(testBlobLen)), (long)testBlobLen, false);
            blobStore.blobContainer(repo.basePath().add("foo").add("nested")).writeBlob("bar", (InputStream)new ByteArrayInputStream(AbstractThirdPartyRepositoryTestCase.randomByteArrayOfLength(testBlobLen)), (long)testBlobLen, false);
            blobStore.blobContainer(repo.basePath().add("foo").add("nested2")).writeBlob("blub", (InputStream)new ByteArrayInputStream(AbstractThirdPartyRepositoryTestCase.randomByteArrayOfLength(testBlobLen)), (long)testBlobLen, false);
        }));
        future.actionGet();
        this.assertChildren(repo.basePath(), Collections.singleton("foo"));
        BlobStoreTestUtil.assertBlobsByPrefix(repo, repo.basePath(), "fo", Collections.emptyMap());
        this.assertChildren(repo.basePath().add("foo"), List.of("nested", "nested2"));
        BlobStoreTestUtil.assertBlobsByPrefix(repo, repo.basePath().add("foo"), "nest", Collections.singletonMap("nested-blob", new BlobMetadata("nested-blob", (long)testBlobLen)));
        this.assertChildren(repo.basePath().add("foo").add("nested"), Collections.emptyList());
        if (AbstractThirdPartyRepositoryTestCase.randomBoolean()) {
            this.deleteAndAssertEmpty(repo.basePath());
        } else {
            this.deleteAndAssertEmpty(repo.basePath().add("foo"));
        }
    }

    public void testCleanup() throws Exception {
        this.createIndex("test-idx-1");
        this.createIndex("test-idx-2");
        this.createIndex("test-idx-3");
        this.ensureGreen(new String[0]);
        this.logger.info("--> indexing some data");
        for (int i = 0; i < 100; ++i) {
            this.client().prepareIndex("test-idx-1").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
            this.client().prepareIndex("test-idx-2").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
            this.client().prepareIndex("test-idx-3").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
        }
        this.client().admin().indices().prepareRefresh(new String[0]).get();
        String snapshotName = "test-snap-" + System.currentTimeMillis();
        this.logger.info("--> snapshot");
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.client().admin().cluster().prepareCreateSnapshot("test-repo", snapshotName).setWaitForCompletion(true).setIndices(new String[]{"test-idx-*", "-test-idx-3"}).get();
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)createSnapshotResponse.getSnapshotInfo().successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)createSnapshotResponse.getSnapshotInfo().successfulShards(), (Matcher)Matchers.equalTo((Object)createSnapshotResponse.getSnapshotInfo().totalShards()));
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)((SnapshotInfo)((GetSnapshotsResponse)this.client().admin().cluster().prepareGetSnapshots(new String[]{"test-repo"}).setSnapshots(new String[]{snapshotName}).get()).getSnapshots().get(0)).state(), (Matcher)Matchers.equalTo((Object)SnapshotState.SUCCESS));
        BlobStoreRepository repo = (BlobStoreRepository)this.getInstanceFromNode(RepositoriesService.class).repository("test-repo");
        ExecutorService genericExec = repo.threadPool().executor("generic");
        this.logger.info("--> creating a dangling index folder");
        this.createDanglingIndex(repo, genericExec);
        this.logger.info("--> deleting a snapshot to trigger repository cleanup");
        this.client().admin().cluster().deleteSnapshot(new DeleteSnapshotRequest("test-repo", new String[]{snapshotName})).actionGet();
        BlobStoreTestUtil.assertConsistency(repo);
        this.logger.info("--> Create dangling index");
        this.createDanglingIndex(repo, genericExec);
        this.logger.info("--> Execute repository cleanup");
        CleanupRepositoryResponse response = (CleanupRepositoryResponse)this.client().admin().cluster().prepareCleanupRepository("test-repo").get();
        this.assertCleanupResponse(response, 3L, 1L);
    }

    protected void assertCleanupResponse(CleanupRepositoryResponse response, long bytes, long blobs) {
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)response.result().blobs(), (Matcher)Matchers.equalTo((Object)3L));
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)response.result().bytes(), (Matcher)Matchers.equalTo((Object)9L));
    }

    private void createDanglingIndex(BlobStoreRepository repo, Executor genericExec) throws Exception {
        PlainActionFuture future = PlainActionFuture.newFuture();
        genericExec.execute((Runnable)ActionRunnable.run((ActionListener)future, () -> {
            BlobStore blobStore = repo.blobStore();
            blobStore.blobContainer(repo.basePath().add("indices").add("foo")).writeBlob("bar", (InputStream)new ByteArrayInputStream(new byte[3]), 3L, false);
            for (String prefix : Arrays.asList("snap-", "meta-")) {
                blobStore.blobContainer(repo.basePath()).writeBlob(prefix + "foo.dat", (InputStream)new ByteArrayInputStream(new byte[3]), 3L, false);
            }
        }));
        future.get();
        PlainActionFuture corruptionFuture = PlainActionFuture.newFuture();
        genericExec.execute((Runnable)ActionRunnable.supply((ActionListener)corruptionFuture, () -> {
            BlobStore blobStore = repo.blobStore();
            return blobStore.blobContainer(repo.basePath().add("indices")).children().containsKey("foo") && blobStore.blobContainer(repo.basePath().add("indices").add("foo")).blobExists("bar") && blobStore.blobContainer(repo.basePath()).blobExists("meta-foo.dat") && blobStore.blobContainer(repo.basePath()).blobExists("snap-foo.dat");
        }));
        AbstractThirdPartyRepositoryTestCase.assertTrue((boolean)((Boolean)corruptionFuture.get()));
    }

    private void assertChildren(BlobPath path, Collection<String> children) {
        this.listChildren(path);
        Set<String> foundChildren = this.listChildren(path);
        if (children.isEmpty()) {
            AbstractThirdPartyRepositoryTestCase.assertThat(foundChildren, (Matcher)Matchers.empty());
        } else {
            AbstractThirdPartyRepositoryTestCase.assertThat(foundChildren, (Matcher)Matchers.containsInAnyOrder((Object[])children.toArray(Strings.EMPTY_ARRAY)));
        }
    }

    private Set<String> listChildren(BlobPath path) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        BlobStoreRepository repository = this.getRepository();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.supply((ActionListener)future, () -> repository.blobStore().blobContainer(path).children().keySet()));
        return (Set)future.actionGet();
    }

    protected BlobStoreRepository getRepository() {
        return (BlobStoreRepository)this.getInstanceFromNode(RepositoriesService.class).repository("test-repo");
    }
}

