/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorTestCase;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoGrid;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoGridAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGrid;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGridBucket;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.support.AggregationInspectionHelper;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class GeoGridAggregatorTestCase<T extends InternalGeoGridBucket>
extends AggregatorTestCase {
    private static final String FIELD_NAME = "location";

    protected abstract int randomPrecision();

    protected abstract String hashAsString(double var1, double var3, int var5);

    protected abstract GeoGridAggregationBuilder createBuilder(String var1);

    protected abstract Point randomPoint();

    protected abstract GeoBoundingBox randomBBox();

    protected abstract Rectangle getTile(double var1, double var3, int var5);

    @Override
    protected AggregationBuilder createAggBuilderForTypeTest(MappedFieldType fieldType, String fieldName) {
        return this.createBuilder("foo").field(fieldName);
    }

    @Override
    protected List<ValuesSourceType> getSupportedValuesSourceTypes() {
        return List.of(CoreValuesSourceType.GEOPOINT);
    }

    public void testNoDocs() throws IOException {
        this.testCase((Query)new MatchAllDocsQuery(), FIELD_NAME, this.randomPrecision(), null, (InternalGeoGrid<T> geoGrid) -> GeoGridAggregatorTestCase.assertEquals((long)0L, (long)geoGrid.getBuckets().size()), (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> {}));
    }

    public void testUnmapped() throws IOException {
        this.testCase((Query)new MatchAllDocsQuery(), "wrong_field", this.randomPrecision(), null, (InternalGeoGrid<T> geoGrid) -> GeoGridAggregatorTestCase.assertEquals((long)0L, (long)geoGrid.getBuckets().size()), (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument(Collections.singleton(new LatLonDocValuesField(FIELD_NAME, 10.0, 10.0)))));
    }

    public void testUnmappedMissing() throws IOException {
        GeoGridAggregationBuilder builder = (GeoGridAggregationBuilder)((GeoGridAggregationBuilder)this.createBuilder("_name").field("wrong_field")).missing((Object)"53.69437,6.475031");
        this.testCase((Query)new MatchAllDocsQuery(), this.randomPrecision(), null, (InternalGeoGrid<T> geoGrid) -> GeoGridAggregatorTestCase.assertEquals((long)1L, (long)geoGrid.getBuckets().size()), (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument(Collections.singleton(new LatLonDocValuesField(FIELD_NAME, 10.0, 10.0)))), builder);
    }

    public void testSingletonDocs() throws IOException {
        this.testWithSeveralDocs(() -> true, null);
    }

    public void testBoundedSingletonDocs() throws IOException {
        this.testWithSeveralDocs(() -> true, this.randomBBox());
    }

    public void testMultiValuedDocs() throws IOException {
        this.testWithSeveralDocs(LuceneTestCase::rarely, null);
    }

    public void testBoundedMultiValuedDocs() throws IOException {
        this.testWithSeveralDocs(LuceneTestCase::rarely, this.randomBBox());
    }

    private void testWithSeveralDocs(BooleanSupplier supplier, GeoBoundingBox bbox) throws IOException {
        int precision = this.randomPrecision();
        int numPoints = GeoGridAggregatorTestCase.randomIntBetween(8, 128);
        HashMap expectedCountPerGeoHash = new HashMap();
        this.testCase((Query)new MatchAllDocsQuery(), FIELD_NAME, precision, bbox, (InternalGeoGrid<T> geoHashGrid) -> {
            GeoGridAggregatorTestCase.assertEquals((long)expectedCountPerGeoHash.size(), (long)geoHashGrid.getBuckets().size());
            for (GeoGrid.Bucket bucket : geoHashGrid.getBuckets()) {
                GeoGridAggregatorTestCase.assertEquals((long)((Integer)expectedCountPerGeoHash.get(bucket.getKeyAsString())).intValue(), (long)bucket.getDocCount());
            }
            if (bbox == null) {
                GeoGridAggregatorTestCase.assertTrue((boolean)AggregationInspectionHelper.hasValue((InternalGeoGrid)geoHashGrid));
            }
        }, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> {
            ArrayList<LatLonDocValuesField> points = new ArrayList<LatLonDocValuesField>();
            HashSet<String> distinctHashesPerDoc = new HashSet<String>();
            for (int pointId = 0; pointId < numPoints; ++pointId) {
                double[] latLng = this.randomLatLng();
                points.add(new LatLonDocValuesField(FIELD_NAME, latLng[0], latLng[1]));
                String hash = this.hashAsString(latLng[1], latLng[0], precision);
                Rectangle bin = this.getTile(latLng[1], latLng[0], precision);
                if (this.intersectsBounds(bin, bbox) || this.validPoint(latLng[1], latLng[0], bbox)) {
                    if (!distinctHashesPerDoc.contains(hash)) {
                        expectedCountPerGeoHash.put(hash, expectedCountPerGeoHash.getOrDefault(hash, 0) + 1);
                    }
                    distinctHashesPerDoc.add(hash);
                }
                if (!supplier.getAsBoolean()) continue;
                iw.addDocument(points);
                points.clear();
                distinctHashesPerDoc.clear();
            }
            if (points.size() != 0) {
                iw.addDocument(points);
            }
        }));
    }

    public void testSingletonDocsAsSubAgg() throws IOException {
        this.testWithSeveralDocsAsSubAgg(() -> true, null);
    }

    public void testBoundedSingletonDocsAsSubAgg() throws IOException {
        this.testWithSeveralDocsAsSubAgg(() -> true, this.randomBBox());
    }

    public void testMultiValuedDocsAsSubAgg() throws IOException {
        this.testWithSeveralDocsAsSubAgg(LuceneTestCase::rarely, null);
    }

    public void testBoundedMultiValuedDocsAsSubAgg() throws IOException {
        this.testWithSeveralDocsAsSubAgg(LuceneTestCase::rarely, this.randomBBox());
    }

    private void testWithSeveralDocsAsSubAgg(BooleanSupplier supplier, GeoBoundingBox bbox) throws IOException {
        int precision = this.randomPrecision();
        int numPoints = GeoGridAggregatorTestCase.randomIntBetween(8, 128);
        TreeMap expectedCountPerTPerGeoHash = new TreeMap();
        TermsAggregationBuilder aggregationBuilder = ((TermsAggregationBuilder)new TermsAggregationBuilder("t").field("t")).size(numPoints);
        GeoGridAggregationBuilder gridBuilder = ((GeoGridAggregationBuilder)this.createBuilder("gg").field(FIELD_NAME)).precision(precision);
        if (bbox != null) {
            gridBuilder.setGeoBoundingBox(bbox);
        }
        aggregationBuilder.subAggregation((AggregationBuilder)gridBuilder);
        this.testCase(aggregationBuilder, (Query)new MatchAllDocsQuery(), (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> {
            ArrayList<Object> fields = new ArrayList<Object>();
            HashSet<String> distinctHashesPerDoc = new HashSet<String>();
            String t = GeoGridAggregatorTestCase.randomAlphaOfLength(1);
            for (int pointId = 0; pointId < numPoints; ++pointId) {
                Map expectedCountPerGeoHash = expectedCountPerTPerGeoHash.computeIfAbsent(t, k -> new TreeMap());
                double[] latLng = this.randomLatLng();
                fields.add(new LatLonDocValuesField(FIELD_NAME, latLng[0], latLng[1]));
                String hash = this.hashAsString(latLng[1], latLng[0], precision);
                if (!distinctHashesPerDoc.contains(hash) && (this.intersectsBounds(this.getTile(latLng[1], latLng[0], precision), bbox) || this.validPoint(latLng[1], latLng[0], bbox))) {
                    expectedCountPerGeoHash.put(hash, expectedCountPerGeoHash.getOrDefault(hash, 0L) + 1L);
                    distinctHashesPerDoc.add(hash);
                }
                if (!supplier.getAsBoolean()) continue;
                fields.add(new SortedSetDocValuesField("t", new BytesRef((CharSequence)t)));
                fields.add(new Field("t", new BytesRef((CharSequence)t), (IndexableFieldType)KeywordFieldMapper.Defaults.FIELD_TYPE));
                iw.addDocument(fields);
                fields.clear();
                distinctHashesPerDoc.clear();
                t = GeoGridAggregatorTestCase.randomAlphaOfLength(1);
            }
            if (fields.size() != 0) {
                fields.add(new SortedSetDocValuesField("t", new BytesRef((CharSequence)t)));
                fields.add(new Field("t", new BytesRef((CharSequence)t), (IndexableFieldType)KeywordFieldMapper.Defaults.FIELD_TYPE));
                iw.addDocument(fields);
            }
        }), (V terms) -> {
            TreeMap actual = new TreeMap();
            for (StringTerms.Bucket tb : ((StringTerms)terms).getBuckets()) {
                InternalGeoGrid gg = (InternalGeoGrid)tb.getAggregations().get("gg");
                TreeMap<String, Long> sub = new TreeMap<String, Long>();
                for (InternalGeoGridBucket ggb : gg.getBuckets()) {
                    sub.put(ggb.getKeyAsString(), ggb.getDocCount());
                }
                actual.put(tb.getKeyAsString(), sub);
            }
            GeoGridAggregatorTestCase.assertThat(actual, (Matcher)Matchers.equalTo((Object)expectedCountPerTPerGeoHash));
        }, new MappedFieldType[]{this.keywordField("t"), this.geoPointField(FIELD_NAME)});
    }

    private double[] randomLatLng() {
        Point point = this.randomPoint();
        double lon = GeoEncodingUtils.decodeLongitude((int)GeoEncodingUtils.encodeLongitude((double)point.getLon()));
        double lat = GeoEncodingUtils.decodeLatitude((int)GeoEncodingUtils.encodeLatitude((double)point.getLat()));
        return new double[]{lat, lon};
    }

    private boolean validPoint(double x, double y, GeoBoundingBox bbox) {
        if (bbox == null) {
            return true;
        }
        if (bbox.top() > y && bbox.bottom() < y) {
            boolean crossesDateline;
            boolean bl = crossesDateline = bbox.left() > bbox.right();
            if (crossesDateline) {
                return bbox.left() < x || bbox.right() > x;
            }
            return bbox.left() < x && bbox.right() > x;
        }
        return false;
    }

    private boolean intersectsBounds(Rectangle pointTile, GeoBoundingBox bbox) {
        if (bbox == null) {
            return true;
        }
        if (pointTile.getMinX() > pointTile.getMaxX()) {
            Rectangle right = new Rectangle(pointTile.getMinX(), 180.0, pointTile.getMaxY(), pointTile.getMinY());
            Rectangle left = new Rectangle(-180.0, pointTile.getMaxX(), pointTile.getMaxY(), pointTile.getMinY());
            return this.intersectsBounds(left, bbox) || this.intersectsBounds(right, bbox);
        }
        if (bbox.top() > pointTile.getMinY() && bbox.bottom() < pointTile.getMaxY()) {
            boolean crossesDateline;
            boolean bl = crossesDateline = bbox.left() > bbox.right();
            if (crossesDateline) {
                return bbox.left() < pointTile.getMaxX() || bbox.right() > pointTile.getMinX();
            }
            return bbox.left() < pointTile.getMaxX() && bbox.right() > pointTile.getMinX();
        }
        return false;
    }

    protected void testCase(Query query, String field, int precision, GeoBoundingBox geoBoundingBox, Consumer<InternalGeoGrid<T>> verify, CheckedConsumer<RandomIndexWriter, IOException> buildIndex) throws IOException {
        this.testCase(query, precision, geoBoundingBox, verify, buildIndex, (GeoGridAggregationBuilder)this.createBuilder("_name").field(field));
    }

    private void testCase(Query query, int precision, GeoBoundingBox geoBoundingBox, Consumer<InternalGeoGrid<T>> verify, CheckedConsumer<RandomIndexWriter, IOException> buildIndex, GeoGridAggregationBuilder aggregationBuilder) throws IOException {
        BaseDirectoryWrapper directory = GeoGridAggregatorTestCase.newDirectory();
        RandomIndexWriter indexWriter = new RandomIndexWriter(GeoGridAggregatorTestCase.random(), (Directory)directory);
        buildIndex.accept((Object)indexWriter);
        indexWriter.close();
        DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
        IndexSearcher indexSearcher = GeoGridAggregatorTestCase.newSearcher((IndexReader)indexReader, (boolean)true, (boolean)true);
        aggregationBuilder.precision(precision);
        if (geoBoundingBox != null) {
            aggregationBuilder.setGeoBoundingBox(geoBoundingBox);
            GeoGridAggregatorTestCase.assertThat((Object)aggregationBuilder.geoBoundingBox(), (Matcher)Matchers.equalTo((Object)geoBoundingBox));
        }
        GeoPointFieldMapper.GeoPointFieldType fieldType = new GeoPointFieldMapper.GeoPointFieldType(aggregationBuilder.field());
        Object aggregator = this.createAggregator((AggregationBuilder)aggregationBuilder, indexSearcher, new MappedFieldType[]{fieldType});
        aggregator.preCollection();
        indexSearcher.search(query, aggregator.asCollector());
        aggregator.postCollection();
        InternalGeoGrid topLevel = (InternalGeoGrid)aggregator.buildTopLevel();
        verify.accept(topLevel);
        indexReader.close();
        directory.close();
    }

    @Override
    public void doAssertReducedMultiBucketConsumer(Aggregation agg, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
    }
}

