/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.geo;

import java.io.IOException;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.geo.GeometryTestUtils;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.index.query.GeoBoundingBoxQueryBuilder;
import org.elasticsearch.index.query.GeoValidationMethod;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.test.AbstractQueryTestCase;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class GeoBoundingBoxQueryBuilderTestCase
extends AbstractQueryTestCase<GeoBoundingBoxQueryBuilder> {
    private static final Double[] brokenDoubles = new Double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};

    protected abstract String getFieldName();

    @Override
    protected GeoBoundingBoxQueryBuilder doCreateTestQueryBuilder() {
        String fieldName = this.getFieldName();
        GeoBoundingBoxQueryBuilder builder = new GeoBoundingBoxQueryBuilder(fieldName);
        Rectangle box = GeoBoundingBoxQueryBuilderTestCase.randomValueOtherThanMany(r -> Math.abs(r.getMaxX() - r.getMinX()) < 0.1 || Math.abs(r.getMaxY() - r.getMinY()) < 0.1, GeometryTestUtils::randomRectangle);
        if (GeoBoundingBoxQueryBuilderTestCase.randomBoolean()) {
            int path = GeoBoundingBoxQueryBuilderTestCase.randomIntBetween(0, 2);
            switch (path) {
                case 0: {
                    builder.setCorners(new GeoPoint(box.getMaxY(), box.getMinX()), new GeoPoint(box.getMinY(), box.getMaxX()));
                    break;
                }
                case 1: {
                    builder.setCorners(Geohash.stringEncode((double)box.getMinX(), (double)box.getMaxY()), Geohash.stringEncode((double)box.getMaxX(), (double)box.getMinY()));
                    break;
                }
                default: {
                    builder.setCorners(box.getMaxY(), box.getMinX(), box.getMinY(), box.getMaxX());
                    break;
                }
            }
        } else if (GeoBoundingBoxQueryBuilderTestCase.randomBoolean()) {
            builder.setCornersOGC(new GeoPoint(box.getMinY(), box.getMinX()), new GeoPoint(box.getMaxY(), box.getMaxX()));
        } else {
            builder.setCornersOGC(Geohash.stringEncode((double)box.getMinX(), (double)box.getMinY()), Geohash.stringEncode((double)box.getMaxX(), (double)box.getMaxY()));
        }
        if (GeoBoundingBoxQueryBuilderTestCase.randomBoolean()) {
            builder.setValidationMethod(GeoBoundingBoxQueryBuilderTestCase.randomFrom(GeoValidationMethod.values()));
        }
        if (GeoBoundingBoxQueryBuilderTestCase.randomBoolean()) {
            builder.ignoreUnmapped(GeoBoundingBoxQueryBuilderTestCase.randomBoolean());
        }
        return builder;
    }

    public void testValidationNullFieldname() {
        IllegalArgumentException e = (IllegalArgumentException)GeoBoundingBoxQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> new GeoBoundingBoxQueryBuilder((String)null));
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((Object)"Field name must not be empty.", (Object)e.getMessage());
    }

    public void testExceptionOnMissingTypes() {
        SearchExecutionContext context = GeoBoundingBoxQueryBuilderTestCase.createShardContextWithNoType();
        GeoBoundingBoxQueryBuilder qb = (GeoBoundingBoxQueryBuilder)this.createTestQueryBuilder();
        qb.ignoreUnmapped(false);
        QueryShardException e = (QueryShardException)GeoBoundingBoxQueryBuilderTestCase.expectThrows(QueryShardException.class, () -> qb.toQuery(context));
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((Object)("failed to find geo field [" + qb.fieldName() + "]"), (Object)e.getMessage());
    }

    public void testBrokenCoordinateCannotBeSet() {
        PointTester[] testers = new PointTester[]{new TopTester(), new LeftTester(), new BottomTester(), new RightTester()};
        GeoBoundingBoxQueryBuilder builder = (GeoBoundingBoxQueryBuilder)this.createTestQueryBuilder();
        builder.setValidationMethod(GeoValidationMethod.STRICT);
        for (PointTester tester : testers) {
            GeoBoundingBoxQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> tester.invalidateCoordinate(builder, true));
        }
    }

    public void testBrokenCoordinateCanBeSetWithIgnoreMalformed() {
        PointTester[] testers = new PointTester[]{new TopTester(), new LeftTester(), new BottomTester(), new RightTester()};
        GeoBoundingBoxQueryBuilder builder = (GeoBoundingBoxQueryBuilder)this.createTestQueryBuilder();
        builder.setValidationMethod(GeoValidationMethod.IGNORE_MALFORMED);
        for (PointTester tester : testers) {
            tester.invalidateCoordinate(builder, true);
        }
    }

    public void testTopBottomCannotBeFlipped() {
        GeoBoundingBoxQueryBuilder builder = (GeoBoundingBoxQueryBuilder)this.createTestQueryBuilder();
        double top = builder.topLeft().getLat();
        double left = builder.topLeft().getLon();
        double bottom = builder.bottomRight().getLat();
        double right = builder.bottomRight().getLon();
        GeoBoundingBoxQueryBuilderTestCase.assumeTrue((String)"top should not be equal to bottom for flip check", (top != bottom ? 1 : 0) != 0);
        this.logger.info("top: {} bottom: {}", (Object)top, (Object)bottom);
        builder.setValidationMethod(GeoValidationMethod.STRICT);
        IllegalArgumentException e = (IllegalArgumentException)GeoBoundingBoxQueryBuilderTestCase.expectThrows(IllegalArgumentException.class, () -> builder.setCorners(bottom, left, top, right));
        GeoBoundingBoxQueryBuilderTestCase.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"top is below bottom corner:"));
    }

    public void testTopBottomCanBeFlippedOnIgnoreMalformed() {
        GeoBoundingBoxQueryBuilder builder = (GeoBoundingBoxQueryBuilder)this.createTestQueryBuilder();
        double top = builder.topLeft().getLat();
        double left = builder.topLeft().getLon();
        double bottom = builder.bottomRight().getLat();
        double right = builder.bottomRight().getLon();
        GeoBoundingBoxQueryBuilderTestCase.assumeTrue((String)"top should not be equal to bottom for flip check", (top != bottom ? 1 : 0) != 0);
        builder.setValidationMethod(GeoValidationMethod.IGNORE_MALFORMED).setCorners(bottom, left, top, right);
    }

    public void testLeftRightCanBeFlipped() {
        GeoBoundingBoxQueryBuilder builder = (GeoBoundingBoxQueryBuilder)this.createTestQueryBuilder();
        double top = builder.topLeft().getLat();
        double left = builder.topLeft().getLon();
        double bottom = builder.bottomRight().getLat();
        double right = builder.bottomRight().getLon();
        builder.setValidationMethod(GeoValidationMethod.IGNORE_MALFORMED).setCorners(top, right, bottom, left);
        builder.setValidationMethod(GeoValidationMethod.STRICT).setCorners(top, right, bottom, left);
    }

    public void testTopAndBottomCanBeEqual() {
        GeoBoundingBoxQueryBuilder builder = (GeoBoundingBoxQueryBuilder)this.createTestQueryBuilder();
        double topBottom = builder.topLeft().getLat();
        double left = builder.topLeft().getLon();
        double right = builder.bottomRight().getLon();
        builder.setValidationMethod(GeoValidationMethod.STRICT).setCorners(topBottom, left, topBottom, right);
        builder.setValidationMethod(GeoValidationMethod.IGNORE_MALFORMED).setCorners(topBottom, left, topBottom, right);
    }

    public void testLeftAndRightCanBeEqual() {
        GeoBoundingBoxQueryBuilder builder = (GeoBoundingBoxQueryBuilder)this.createTestQueryBuilder();
        double top = builder.topLeft().getLat();
        double leftRight = builder.topLeft().getLon();
        double bottom = builder.bottomRight().getLat();
        builder.setValidationMethod(GeoValidationMethod.STRICT).setCorners(top, leftRight, bottom, leftRight);
        builder.setValidationMethod(GeoValidationMethod.IGNORE_MALFORMED).setCorners(top, leftRight, bottom, leftRight);
    }

    public void testTopBottomAndLeftRightCanBeEqual() {
        GeoBoundingBoxQueryBuilder builder = (GeoBoundingBoxQueryBuilder)this.createTestQueryBuilder();
        double topBottom = builder.topLeft().getLat();
        double leftRight = builder.topLeft().getLon();
        builder.setValidationMethod(GeoValidationMethod.STRICT).setCorners(topBottom, leftRight, topBottom, leftRight);
        builder.setValidationMethod(GeoValidationMethod.IGNORE_MALFORMED).setCorners(topBottom, leftRight, topBottom, leftRight);
    }

    public void testStrictnessDefault() {
        GeoBoundingBoxQueryBuilderTestCase.assertFalse((String)"Someone changed the default for coordinate validation - were the docs changed as well?", (boolean)GeoValidationMethod.DEFAULT_LENIENT_PARSING);
    }

    public void testParsingAndToQueryGeoJSON() throws IOException {
        String query = "{\n    \"geo_bounding_box\":{\n        \"%s\":{\n            \"top_left\":{\n              \"type\":\"Point\",\n              \"coordinates\":[-70, 40]\n            },\n            \"bottom_right\":{\n              \"type\":\"Point\",\n              \"coordinates\":[-80, 30]\n            }\n        }\n    }\n}\n".formatted("mapped_geo_point");
        this.assertGeoBoundingBoxQuery(query);
    }

    public void testParsingAndToQueryWKT() throws IOException {
        String query = "{\n    \"geo_bounding_box\":{\n        \"%s\":{\n            \"top_left\":\"POINT(-70 40)\",\n            \"bottom_right\":\"POINT(-80 30)\"\n        }\n    }\n}\n".formatted("mapped_geo_point");
        this.assertGeoBoundingBoxQuery(query);
    }

    public void testParsingAndToQuery1() throws IOException {
        String query = "{\n    \"geo_bounding_box\":{\n        \"%s\":{\n            \"top_left\":[-70, 40],\n            \"bottom_right\":[-80, 30]\n        }\n    }\n}\n".formatted("mapped_geo_point");
        this.assertGeoBoundingBoxQuery(query);
    }

    public void testParsingAndToQuery2() throws IOException {
        String query = "{\n    \"geo_bounding_box\":{\n        \"%s\":{\n            \"top_left\":{\n                \"lat\":40,\n                \"lon\":-70\n            },\n            \"bottom_right\":{\n                \"lat\":30,\n                \"lon\":-80\n            }\n        }\n    }\n}\n".formatted("mapped_geo_point");
        this.assertGeoBoundingBoxQuery(query);
    }

    public void testParsingAndToQuery3() throws IOException {
        String query = "{\n    \"geo_bounding_box\":{\n        \"%s\":{\n            \"top_left\":\"40, -70\",\n            \"bottom_right\":\"30, -80\"\n        }\n    }\n}\n".formatted("mapped_geo_point");
        this.assertGeoBoundingBoxQuery(query);
    }

    public void testParsingAndToQuery4() throws IOException {
        String query = "{\n    \"geo_bounding_box\":{\n        \"%s\":{\n            \"top_left\":\"drn5x1g8cu2y\",\n            \"bottom_right\":\"30, -80\"\n        }\n    }\n}\n".formatted("mapped_geo_point");
        this.assertGeoBoundingBoxQuery(query);
    }

    public void testParsingAndToQuery5() throws IOException {
        String query = "{\n    \"geo_bounding_box\":{\n        \"%s\":{\n            \"top_right\":\"40, -80\",\n            \"bottom_left\":\"30, -70\"\n        }\n    }\n}\n".formatted("mapped_geo_point");
        this.assertGeoBoundingBoxQuery(query);
    }

    public void testParsingAndToQuery6() throws IOException {
        String query = "{\n    \"geo_bounding_box\":{\n        \"%s\":{\n            \"right\": -80,\n            \"top\": 40,\n            \"left\": -70,\n            \"bottom\": 30\n        }\n    }\n}\n".formatted("mapped_geo_point");
        this.assertGeoBoundingBoxQuery(query);
    }

    private void assertGeoBoundingBoxQuery(String query) throws IOException {
        SearchExecutionContext searchExecutionContext = GeoBoundingBoxQueryBuilderTestCase.createSearchExecutionContext();
        this.parseQuery(query).toQuery(searchExecutionContext);
    }

    public void testFromJson() throws IOException {
        String json = "{\n  \"geo_bounding_box\" : {\n    \"pin.location\" : {\n      \"top_left\" : [ -74.1, 40.73 ],\n      \"bottom_right\" : [ -71.12, 40.01 ]\n    },\n    \"validation_method\" : \"STRICT\",\n    \"ignore_unmapped\" : false,\n    \"boost\" : 1.0\n  }\n}";
        GeoBoundingBoxQueryBuilder parsed = (GeoBoundingBoxQueryBuilder)this.parseQuery(json);
        GeoBoundingBoxQueryBuilderTestCase.checkGeneratedJson(json, (QueryBuilder)parsed);
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)json, (Object)"pin.location", (Object)parsed.fieldName());
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)json, (double)-74.1, (double)parsed.topLeft().getLon(), (double)1.0E-4);
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)json, (double)40.73, (double)parsed.topLeft().getLat(), (double)1.0E-4);
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)json, (double)-71.12, (double)parsed.bottomRight().getLon(), (double)1.0E-4);
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)json, (double)40.01, (double)parsed.bottomRight().getLat(), (double)1.0E-4);
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)json, (double)1.0, (double)parsed.boost(), (double)1.0E-4);
    }

    public void testFromWKT() throws IOException {
        String wkt = "{\n  \"geo_bounding_box\" : {\n    \"pin.location\" : {\n      \"wkt\" : \"BBOX (-74.1, -71.12, 40.73, 40.01)\"\n    },\n    \"validation_method\" : \"STRICT\",\n    \"ignore_unmapped\" : false,\n    \"boost\" : 1.0\n  }\n}";
        String expectedJson = "{\n  \"geo_bounding_box\" : {\n    \"pin.location\" : {\n      \"top_left\" : [ -74.1, 40.73 ],\n      \"bottom_right\" : [ -71.12, 40.01 ]\n    },\n    \"validation_method\" : \"STRICT\",\n    \"ignore_unmapped\" : false,\n    \"boost\" : 1.0\n  }\n}";
        GeoBoundingBoxQueryBuilder parsed = (GeoBoundingBoxQueryBuilder)this.parseQuery(wkt);
        GeoBoundingBoxQueryBuilderTestCase.checkGeneratedJson(expectedJson, (QueryBuilder)parsed);
        double delta = 0.0;
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)expectedJson, (Object)"pin.location", (Object)parsed.fieldName());
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)expectedJson, (double)-74.1, (double)parsed.topLeft().getLon(), (double)delta);
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)expectedJson, (double)40.73, (double)parsed.topLeft().getLat(), (double)delta);
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)expectedJson, (double)-71.12, (double)parsed.bottomRight().getLon(), (double)delta);
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)expectedJson, (double)40.01, (double)parsed.bottomRight().getLat(), (double)delta);
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)expectedJson, (double)1.0, (double)parsed.boost(), (double)delta);
    }

    public void testFromGeohash() throws IOException {
        String json = "{\n  \"geo_bounding_box\" : {\n    \"pin.location\" : {\n      \"top_left\" : \"dr\",\n      \"bottom_right\" : \"dq\"\n    },\n    \"validation_method\" : \"STRICT\",\n    \"ignore_unmapped\" : false,\n    \"boost\" : 1.0\n  }\n}";
        String expectedJson = "{\n  \"geo_bounding_box\" : {\n    \"pin.location\" : {\n      \"top_left\" : [ -78.75, 45.0 ],\n      \"bottom_right\" : [ -67.5, 33.75 ]\n    },\n    \"validation_method\" : \"STRICT\",\n    \"ignore_unmapped\" : false,\n    \"boost\" : 1.0\n  }\n}";
        GeoBoundingBoxQueryBuilder parsed = (GeoBoundingBoxQueryBuilder)this.parseQuery(json);
        GeoBoundingBoxQueryBuilderTestCase.checkGeneratedJson(expectedJson, (QueryBuilder)parsed);
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)json, (Object)"pin.location", (Object)parsed.fieldName());
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)json, (double)-78.75, (double)parsed.topLeft().getLon(), (double)1.0E-4);
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)json, (double)45.0, (double)parsed.topLeft().getLat(), (double)1.0E-4);
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)json, (double)-67.5, (double)parsed.bottomRight().getLon(), (double)1.0E-4);
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)json, (double)33.75, (double)parsed.bottomRight().getLat(), (double)1.0E-4);
        GeoBoundingBoxQueryBuilderTestCase.assertEquals((String)json, (double)1.0, (double)parsed.boost(), (double)1.0E-4);
    }

    public void testMalformedGeohashes() {
        String jsonGeohashAndWkt = "{\n  \"geo_bounding_box\" : {\n    \"pin.location\" : {\n      \"top_left\" : [ -78.75, 45.0 ],\n      \"wkt\" : \"BBOX (-74.1, -71.12, 40.73, 40.01)\"\n    },\n    \"validation_method\" : \"STRICT\",\n    \"ignore_unmapped\" : false,\n    \"boost\" : 1.0\n  }\n}";
        ElasticsearchParseException e1 = (ElasticsearchParseException)GeoBoundingBoxQueryBuilderTestCase.expectThrows(ElasticsearchParseException.class, () -> this.parseQuery(jsonGeohashAndWkt));
        GeoBoundingBoxQueryBuilderTestCase.assertThat((Object)e1.getMessage(), (Matcher)CoreMatchers.containsString((String)"Conflicting definition found using well-known text and explicit corners."));
    }

    public void testHonorsCoercion() throws IOException {
        String query = "{\n  \"geo_bounding_box\": {\n    \"validation_method\": \"COERCE\",\n    \"%s\": {\n      \"top_left\": {\n        \"lat\": -15.5,\n        \"lon\": 176.5\n      },\n      \"bottom_right\": {\n        \"lat\": -19.6,\n        \"lon\": 181\n      }\n    }\n  }\n}\n".formatted("mapped_geo_point");
        this.assertGeoBoundingBoxQuery(query);
    }

    @Override
    public void testMustRewrite() throws IOException {
        super.testMustRewrite();
    }

    public void testIgnoreUnmapped() throws IOException {
        GeoBoundingBoxQueryBuilder queryBuilder = new GeoBoundingBoxQueryBuilder("unmapped").setCorners(1.0, 0.0, 0.0, 1.0);
        queryBuilder.ignoreUnmapped(true);
        SearchExecutionContext searchExecutionContext = GeoBoundingBoxQueryBuilderTestCase.createSearchExecutionContext();
        Query query = queryBuilder.toQuery(searchExecutionContext);
        GeoBoundingBoxQueryBuilderTestCase.assertThat((Object)query, (Matcher)CoreMatchers.notNullValue());
        GeoBoundingBoxQueryBuilderTestCase.assertThat((Object)query, (Matcher)CoreMatchers.instanceOf(MatchNoDocsQuery.class));
        GeoBoundingBoxQueryBuilder failingQueryBuilder = new GeoBoundingBoxQueryBuilder("unmapped").setCorners(1.0, 0.0, 0.0, 1.0);
        failingQueryBuilder.ignoreUnmapped(false);
        QueryShardException e = (QueryShardException)GeoBoundingBoxQueryBuilderTestCase.expectThrows(QueryShardException.class, () -> failingQueryBuilder.toQuery(searchExecutionContext));
        GeoBoundingBoxQueryBuilderTestCase.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"failed to find geo field [unmapped]"));
    }

    protected static abstract class PointTester {
        private final double brokenCoordinate = ESTestCase.randomFrom(brokenDoubles);
        public final double invalidCoordinate;

        protected PointTester(double invalidCoodinate) {
            this.invalidCoordinate = invalidCoodinate;
        }

        public void invalidateCoordinate(GeoBoundingBoxQueryBuilder qb, boolean useBrokenDouble) {
            if (useBrokenDouble) {
                this.fillIn(this.brokenCoordinate, qb);
            } else {
                this.fillIn(this.invalidCoordinate, qb);
            }
        }

        protected abstract void fillIn(double var1, GeoBoundingBoxQueryBuilder var3);
    }

    protected static class TopTester
    extends PointTester {
        public TopTester() {
            super(ESTestCase.randomDoubleBetween(90.0, Double.MAX_VALUE, false));
        }

        @Override
        public void fillIn(double coordinate, GeoBoundingBoxQueryBuilder qb) {
            qb.setCorners(coordinate, qb.topLeft().getLon(), qb.bottomRight().getLat(), qb.bottomRight().getLon());
        }
    }

    protected static class LeftTester
    extends PointTester {
        public LeftTester() {
            super(ESTestCase.randomDoubleBetween(-1.7976931348623157E308, -180.0, true));
        }

        @Override
        public void fillIn(double coordinate, GeoBoundingBoxQueryBuilder qb) {
            qb.setCorners(qb.topLeft().getLat(), coordinate, qb.bottomRight().getLat(), qb.bottomRight().getLon());
        }
    }

    protected static class BottomTester
    extends PointTester {
        public BottomTester() {
            super(ESTestCase.randomDoubleBetween(-1.7976931348623157E308, -90.0, false));
        }

        @Override
        public void fillIn(double coordinate, GeoBoundingBoxQueryBuilder qb) {
            qb.setCorners(qb.topLeft().getLat(), qb.topLeft().getLon(), coordinate, qb.bottomRight().getLon());
        }
    }

    protected static class RightTester
    extends PointTester {
        public RightTester() {
            super(ESTestCase.randomDoubleBetween(180.0, Double.MAX_VALUE, true));
        }

        @Override
        public void fillIn(double coordinate, GeoBoundingBoxQueryBuilder qb) {
            qb.setCorners(qb.topLeft().getLat(), qb.topLeft().getLon(), qb.bottomRight().getLat(), coordinate);
        }
    }
}

