/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.geo;

import java.io.ByteArrayOutputStream;
import org.apache.lucene.util.SloppyMath;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.geo.BaseShapeIntegTestCase;
import org.elasticsearch.search.geo.SpatialQueryBuilders;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class GeoShapeIntegTestCase
extends BaseShapeIntegTestCase<GeoShapeQueryBuilder> {
    private final SpatialQueryBuilders<GeoShapeQueryBuilder> geoShapeQueryBuilder = SpatialQueryBuilders.GEO;

    @Override
    protected SpatialQueryBuilders<GeoShapeQueryBuilder> queryBuilder() {
        return this.geoShapeQueryBuilder;
    }

    @Override
    protected String getFieldTypeName() {
        return "geo_point";
    }

    public void testIndexPolygonDateLine() throws Exception {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject("shape");
        this.getGeoShapeMapping(mapping);
        mapping.endObject().endObject().endObject();
        ElasticsearchAssertions.assertAcked((CreateIndexResponse)GeoShapeIntegTestCase.client().admin().indices().prepareCreate("test").setSettings(GeoShapeIntegTestCase.settings(this.randomSupportedVersion()).build()).setMapping(mapping).get());
        this.ensureGreen(new String[0]);
        String source = "{\n  \"shape\": \"POLYGON((179 0, -179 0, -179 2, 179 2, 179 0))\"\n}";
        this.indexRandom(true, GeoShapeIntegTestCase.client().prepareIndex("test").setId("0").setSource(source, XContentType.JSON));
        SearchResponse searchResponse = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"shape", (Geometry)new Point(-179.75, 1.0))).get();
        GeoShapeIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"shape", (Geometry)new Point(90.0, 1.0))).get();
        GeoShapeIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)0L));
        searchResponse = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"shape", (Geometry)new Point(-180.0, 1.0))).get();
        GeoShapeIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        searchResponse = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[]{"test"}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)"shape", (Geometry)new Point(180.0, 1.0))).get();
        GeoShapeIntegTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
    }

    @Override
    protected void doDistanceAndBoundingBoxTest(String key) {
        SearchResponse world = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).addStoredField("pin").setQuery((QueryBuilder)QueryBuilders.geoBoundingBoxQuery((String)"pin").setCorners(90.0, -179.99999, -90.0, 179.99999)).get();
        ElasticsearchAssertions.assertHitCount(world, 53L);
        SearchResponse distance = (SearchResponse)GeoShapeIntegTestCase.client().prepareSearch(new String[0]).addStoredField("pin").setQuery((QueryBuilder)QueryBuilders.geoDistanceQuery((String)"pin").distance("425km").point(51.11, 9.851)).get();
        ElasticsearchAssertions.assertHitCount(distance, 5L);
        GeoPoint point = new GeoPoint();
        for (SearchHit hit : distance.getHits()) {
            String name = hit.getId();
            point.resetFromString((String)((DocumentField)hit.getFields().get("pin")).getValue());
            double dist = this.distance(point.getLat(), point.getLon(), 51.11, 9.851);
            GeoShapeIntegTestCase.assertThat((String)("distance to '" + name + "'"), (Object)dist, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(425000.0)));
            GeoShapeIntegTestCase.assertThat((Object)name, (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)"CZ"), (Matcher)Matchers.equalTo((Object)"DE"), (Matcher)Matchers.equalTo((Object)"BE"), (Matcher)Matchers.equalTo((Object)"NL"), (Matcher)Matchers.equalTo((Object)"LU")));
            if (!key.equals(name)) continue;
            GeoShapeIntegTestCase.assertThat((Object)dist, (Matcher)Matchers.closeTo((double)0.0, (double)0.1));
        }
    }

    @Override
    protected byte[] convertTestData(ByteArrayOutputStream out) {
        return out.toByteArray();
    }

    private double distance(double lat1, double lon1, double lat2, double lon2) {
        return SloppyMath.haversinMeters((double)lat1, (double)lon1, (double)lat2, (double)lon2);
    }
}

