/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.FilePermission;
import java.io.IOException;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.function.Supplier;
import javax.tools.JavaCompiler;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.secure_sm.SecureSM;

public final class PrivilegedOperations {
    private static final AccessControlContext context = PrivilegedOperations.getContext();

    private PrivilegedOperations() {
    }

    public static void closeURLClassLoader(URLClassLoader loader) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                loader.close();
                return null;
            }, context, new RuntimePermission("closeClassLoader"));
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof IOException) {
                IOException ioe = (IOException)e;
                throw ioe;
            }
            throw new IOException(e);
        }
    }

    public static Boolean compilationTaskCall(JavaCompiler.CompilationTask compilationTask) {
        return AccessController.doPrivileged(() -> compilationTask.call(), context, new RuntimePermission("createClassLoader"), new RuntimePermission("closeClassLoader"), new RuntimePermission("accessSystemModules"), PrivilegedOperations.newAllFilesReadPermission());
    }

    public static <T> T supplierWithCreateClassLoader(Supplier<T> supplier) {
        return (T)AccessController.doPrivileged(() -> supplier.get(), context, new RuntimePermission("createClassLoader"), new RuntimePermission("closeClassLoader"));
    }

    @SuppressForbidden(reason="need to create file permission")
    private static FilePermission newAllFilesReadPermission() {
        return new FilePermission("<<ALL FILES>>", "read");
    }

    private static AccessControlContext getContext() {
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[1];
        protectionDomainArray[0] = PrivilegedOperations.privilegedCall(SecureSM.class::getProtectionDomain);
        ProtectionDomain[] pda = protectionDomainArray;
        DomainCombiner combiner = (ignoreCurrent, ignoreAssigned) -> pda;
        AccessControlContext acc = new AccessControlContext(AccessController.getContext(), combiner);
        return AccessController.doPrivileged(AccessController::getContext, acc);
    }

    private static <T> T privilegedCall(Supplier<T> supplier) {
        return (T)AccessController.doPrivileged(supplier::get, context);
    }
}

