/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.hamcrest;

import java.lang.module.ModuleDescriptor;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ModuleDescriptorMatchers {
    private ModuleDescriptorMatchers() {
    }

    public static Matcher<ModuleDescriptor.Exports> exportsOf(String pkg) {
        return new ExportsMatcher(pkg, Set.of());
    }

    public static Matcher<ModuleDescriptor.Exports> exportsOf(String pkg, Set<String> targets) {
        return new ExportsMatcher(pkg, targets);
    }

    public static Matcher<ModuleDescriptor.Opens> opensOf(String pkg) {
        return new OpensMatcher(pkg, Set.of());
    }

    public static Matcher<ModuleDescriptor.Opens> opensOf(String pkg, Set<String> targets) {
        return new OpensMatcher(pkg, targets);
    }

    public static Matcher<ModuleDescriptor.Requires> requiresOf(String mn) {
        return new RequiresNameMatcher(mn);
    }

    public static Matcher<ModuleDescriptor.Provides> providesOf(String service, List<String> provides) {
        return new ProvidesMatcher(service, provides);
    }

    static class ExportsMatcher
    extends TypeSafeMatcher<ModuleDescriptor.Exports> {
        private final String source;
        private final Set<String> targets;

        ExportsMatcher(String source, Set<String> targets) {
            this.source = source;
            this.targets = Set.copyOf(targets);
        }

        protected boolean matchesSafely(ModuleDescriptor.Exports item) {
            return item != null && Objects.equals(item.source(), this.source) && Objects.equals(item.targets(), this.targets);
        }

        public void describeTo(Description description) {
            description.appendText("Exports[%s]".formatted(ExportsMatcher.exportsToString(this.source, this.targets)));
        }

        protected void describeMismatchSafely(ModuleDescriptor.Exports item, Description mismatchDescription) {
            this.describeTo(mismatchDescription);
            if (item == null) {
                mismatchDescription.appendText("was null");
            } else {
                mismatchDescription.appendText(", actual Exports[%s]".formatted(ExportsMatcher.exportsToString(item)));
            }
        }

        private static String exportsToString(String source, Set<String> targets) {
            if (targets.isEmpty()) {
                return source;
            }
            return source + " to " + targets;
        }

        private static String exportsToString(ModuleDescriptor.Exports exports) {
            if (exports.targets().isEmpty()) {
                return exports.source();
            }
            return exports.source() + " to " + exports.targets();
        }
    }

    static class OpensMatcher
    extends TypeSafeMatcher<ModuleDescriptor.Opens> {
        private final String source;
        private final Set<String> targets;

        OpensMatcher(String source, Set<String> targets) {
            this.source = source;
            this.targets = Set.copyOf(targets);
        }

        protected boolean matchesSafely(ModuleDescriptor.Opens item) {
            return item != null && Objects.equals(item.source(), this.source) && Objects.equals(item.targets(), this.targets);
        }

        public void describeTo(Description description) {
            description.appendText("Opens[%s]".formatted(OpensMatcher.opensToString(this.source, this.targets)));
        }

        protected void describeMismatchSafely(ModuleDescriptor.Opens item, Description mismatchDescription) {
            this.describeTo(mismatchDescription);
            if (item == null) {
                mismatchDescription.appendText("was null");
            } else {
                mismatchDescription.appendText(", actual Opens[%s]".formatted(OpensMatcher.opensToString(item)));
            }
        }

        private static String opensToString(String source, Set<String> targets) {
            if (targets.isEmpty()) {
                return source;
            }
            return source + " to " + targets;
        }

        private static String opensToString(ModuleDescriptor.Opens opens) {
            if (opens.targets().isEmpty()) {
                return opens.source();
            }
            return opens.source() + " to " + opens.targets();
        }
    }

    static class RequiresNameMatcher
    extends TypeSafeMatcher<ModuleDescriptor.Requires> {
        private final String mn;

        RequiresNameMatcher(String mn) {
            this.mn = mn;
        }

        protected boolean matchesSafely(ModuleDescriptor.Requires item) {
            return item != null && Objects.equals(item.name(), this.mn);
        }

        public void describeTo(Description description) {
            description.appendText("Requires with name " + this.mn);
        }

        protected void describeMismatchSafely(ModuleDescriptor.Requires item, Description mismatchDescription) {
            this.describeTo(mismatchDescription);
            if (item == null) {
                mismatchDescription.appendText("was null");
            } else {
                mismatchDescription.appendText(", actual Requires with name " + item);
            }
        }
    }

    static class ProvidesMatcher
    extends TypeSafeMatcher<ModuleDescriptor.Provides> {
        private final String service;
        private final List<String> providers;

        ProvidesMatcher(String service, List<String> providers) {
            this.service = service;
            this.providers = List.copyOf(providers);
        }

        protected boolean matchesSafely(ModuleDescriptor.Provides item) {
            return item != null && item.service().equals(this.service) && item.providers().equals(this.providers);
        }

        public void describeTo(Description description) {
            description.appendText("Provides[%s]".formatted(ProvidesMatcher.providesToString(this.service, this.providers)));
        }

        protected void describeMismatchSafely(ModuleDescriptor.Provides item, Description mismatchDescription) {
            this.describeTo(mismatchDescription);
            if (item == null) {
                mismatchDescription.appendText("was null");
            } else {
                mismatchDescription.appendText(", actual Provides[%s]".formatted(item));
            }
        }

        private static String providesToString(String service, List<String> provides) {
            return service + " with " + provides;
        }
    }
}

