/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.readiness;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.readiness.ReadinessService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

public interface ReadinessClientProbe {
    public static final Logger probeLogger = LogManager.getLogger(ReadinessClientProbe.class);

    default public void tcpReadinessProbeTrue(ReadinessService readinessService) throws Exception {
        this.tcpReadinessProbeTrue(readinessService.boundAddress().publishAddress().getPort());
    }

    @SuppressForbidden(reason="Intentional socket open")
    default public boolean channelConnect(SocketChannel channel, InetSocketAddress socketAddress) throws IOException {
        return channel.connect(socketAddress);
    }

    @SuppressForbidden(reason="Intentional socket open")
    default public void tcpReadinessProbeTrue(Integer port) throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), (int)port);
        try (SocketChannel channel = SocketChannel.open(StandardProtocolFamily.INET);){
            AccessController.doPrivileged(() -> {
                try {
                    this.channelConnect(channel, socketAddress);
                }
                catch (IOException e) {
                    Assert.fail((String)"Shouldn't reach here");
                }
                return null;
            });
        }
    }

    default public void tcpReadinessProbeFalse(ReadinessService readinessService) throws Exception {
        this.tcpReadinessProbeFalse(readinessService.boundAddress().publishAddress().getPort());
    }

    @SuppressForbidden(reason="Intentional socket open")
    default public void tcpReadinessProbeFalse(Integer port) throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), (int)port);
        try (SocketChannel channel = SocketChannel.open(StandardProtocolFamily.INET);){
            AccessController.doPrivileged(() -> {
                String message = ((IOException)LuceneTestCase.expectThrows(IOException.class, () -> {
                    boolean result = this.channelConnect(channel, socketAddress);
                    probeLogger.info("No exception on channel connect, connection success [{}]", (Object)result);
                })).getMessage();
                MatcherAssert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"Connection refused"));
                return null;
            });
        }
    }
}

