/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.transport;

import java.io.IOException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.test.transport.FakeTransport;
import org.elasticsearch.test.transport.StubbableConnectionManager;
import org.elasticsearch.test.transport.StubbableTransport;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.tracing.Tracer;
import org.elasticsearch.transport.CloseableConnection;
import org.elasticsearch.transport.ClusterConnectionManager;
import org.elasticsearch.transport.ConnectionManager;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class MockTransport
extends StubbableTransport {
    private TransportMessageListener listener;
    private ConcurrentMap<Long, Tuple<DiscoveryNode, String>> requests = new ConcurrentHashMap<Long, Tuple<DiscoveryNode, String>>();

    public TransportService createTransportService(Settings settings, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders) {
        StubbableConnectionManager connectionManager = new StubbableConnectionManager((ConnectionManager)new ClusterConnectionManager(settings, (Transport)this, threadPool.getThreadContext()));
        connectionManager.setDefaultNodeConnectedBehavior((cm, node) -> false);
        connectionManager.setDefaultGetConnectionBehavior((cm, discoveryNode) -> this.createConnection(discoveryNode));
        return new TransportService(settings, (Transport)this, threadPool, interceptor, localNodeFactory, clusterSettings, (ConnectionManager)connectionManager, new TaskManager(settings, threadPool, taskHeaders), Tracer.NOOP);
    }

    public MockTransport() {
        super(new FakeTransport());
        this.setDefaultConnectBehavior((transport, discoveryNode, profile, actionListener) -> actionListener.onResponse((Object)this.createConnection(discoveryNode)));
    }

    public <Response extends TransportResponse> void handleResponse(long requestId, Response response) {
        TransportResponseHandler transportResponseHandler = this.getResponseHandlers().onResponseReceived(requestId, this.listener);
        if (transportResponseHandler != null) {
            TransportResponse deliveredResponse;
            try (BytesStreamOutput output = new BytesStreamOutput();){
                response.writeTo((StreamOutput)output);
                deliveredResponse = (TransportResponse)transportResponseHandler.read((StreamInput)new NamedWriteableAwareStreamInput(output.bytes().streamInput(), this.writeableRegistry()));
            }
            catch (IOException | UnsupportedOperationException e) {
                throw new AssertionError("failed to serialize/deserialize response " + response, e);
            }
            transportResponseHandler.handleResponse(deliveredResponse);
        }
    }

    public void handleLocalError(long requestId, Throwable t) {
        Tuple request = (Tuple)this.requests.get(requestId);
        assert (request != null);
        this.handleError(requestId, (TransportException)new SendRequestTransportException((DiscoveryNode)request.v1(), (String)request.v2(), t));
    }

    public void handleRemoteError(long requestId, Throwable t) {
        RemoteTransportException remoteException;
        if (LuceneTestCase.rarely((Random)Randomness.get())) {
            remoteException = new RemoteTransportException("remote failure, coming from local node", t);
        } else {
            try (BytesStreamOutput output = new BytesStreamOutput();){
                output.writeException(t);
                remoteException = new RemoteTransportException("remote failure", (Throwable)output.bytes().streamInput().readException());
            }
            catch (IOException ioException) {
                throw new AssertionError("failed to serialize/deserialize supplied exception " + t, ioException);
            }
        }
        this.handleError(requestId, (TransportException)remoteException);
    }

    public void handleError(long requestId, TransportException e) {
        TransportResponseHandler transportResponseHandler = this.getResponseHandlers().onResponseReceived(requestId, this.listener);
        if (transportResponseHandler != null) {
            transportResponseHandler.handleException(e);
        }
    }

    public Transport.Connection createConnection(final DiscoveryNode node) {
        return new CloseableConnection(){

            public DiscoveryNode getNode() {
                return node;
            }

            public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws TransportException {
                MockTransport.this.requests.put(requestId, (Tuple<DiscoveryNode, String>)Tuple.tuple((Object)node, (Object)action));
                MockTransport.this.onSendRequest(requestId, action, request, node);
            }
        };
    }

    protected void onSendRequest(long requestId, String action, TransportRequest request, DiscoveryNode node) {
    }

    @Override
    public void setMessageListener(TransportMessageListener messageListener) {
        if (this.listener != null) {
            throw new IllegalStateException("listener already set");
        }
        this.listener = messageListener;
        super.setMessageListener(messageListener);
    }

    protected NamedWriteableRegistry writeableRegistry() {
        return new NamedWriteableRegistry(ClusterModule.getNamedWriteables());
    }
}

