/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.client.NoOpNodeClient;
import org.elasticsearch.test.rest.FakeRestChannel;
import org.elasticsearch.tracing.Tracer;
import org.elasticsearch.usage.UsageService;
import org.junit.After;
import org.junit.Before;

public abstract class RestActionTestCase
extends ESTestCase {
    private RestController controller;
    protected VerifyingClient verifyingClient;

    @Before
    public void setUpController() {
        this.verifyingClient = new VerifyingClient(this.getTestName());
        this.controller = new RestController(Collections.emptySet(), null, (NodeClient)this.verifyingClient, (CircuitBreakerService)new NoneCircuitBreakerService(), new UsageService(), Tracer.NOOP);
    }

    @After
    public void tearDownController() {
        this.verifyingClient.close();
    }

    protected RestController controller() {
        return this.controller;
    }

    protected void dispatchRequest(RestRequest request) {
        FakeRestChannel channel = new FakeRestChannel(request, false, 1);
        ThreadContext threadContext = this.verifyingClient.threadPool().getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            this.controller.dispatchRequest(request, (RestChannel)channel, threadContext);
        }
    }

    public static class VerifyingClient
    extends NoOpNodeClient {
        AtomicReference<BiFunction<ActionType<?>, ActionRequest, ActionResponse>> executeVerifier = new AtomicReference();
        AtomicReference<BiFunction<ActionType<?>, ActionRequest, ActionResponse>> executeLocallyVerifier = new AtomicReference();
        private static final AtomicLong taskIdGenerator = new AtomicLong(0L);

        public VerifyingClient(String testName) {
            super(testName);
            this.reset();
        }

        @Override
        public String getLocalNodeId() {
            return "test_node_id";
        }

        public void reset() {
            this.executeVerifier.set((arg1, arg2) -> {
                throw new AssertionError();
            });
            this.executeLocallyVerifier.set((arg1, arg2) -> {
                throw new AssertionError();
            });
        }

        public <R extends ActionResponse> void setExecuteVerifier(BiFunction<ActionType<R>, ActionRequest, R> verifier) {
            BiFunction<ActionType<R>, ActionRequest, R> dropTypeInfo;
            BiFunction<ActionType<R>, ActionRequest, R> pasteGenerics = dropTypeInfo = verifier;
            this.executeVerifier.set(pasteGenerics);
        }

        @Override
        public <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
            ActionResponse response = this.executeVerifier.get().apply(action, request);
            listener.onResponse((Object)response);
        }

        public void setExecuteLocallyVerifier(BiFunction<ActionType<?>, ActionRequest, ActionResponse> verifier) {
            this.executeLocallyVerifier.set(verifier);
        }

        @Override
        public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, ActionListener<Response> listener) {
            ActionResponse response = this.executeLocallyVerifier.get().apply(action, request);
            listener.onResponse((Object)response);
            return request.createTask(taskIdGenerator.incrementAndGet(), "transport", action.name(), request.getParentTask(), Collections.emptyMap());
        }
    }
}

